/*
 * Decompiled with CFR 0.152.
 */
package client.gui.dialog;

import client.gui.InnerStellarMap;
import client.gui.SpringLayoutHelper;
import common.Planet;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class PlanetSearchDialog
extends JDialog
implements ActionListener {
    private final InnerStellarMap map;
    private final Collection planets;
    private final TreeSet planetNames;
    private JList matchingPlanetsList;
    private JScrollPane scrollPane;
    private JTextField nameField;
    private final JButton okayButton = new JButton("OK");
    private final JButton cancelButton = new JButton("Cancel");
    private final String okayCommand = "Okay";

    public PlanetSearchDialog(InnerStellarMap map, Collection planets) {
        super(new JFrame(), "Planet Search", true);
        this.map = map;
        this.planets = planets;
        this.planetNames = new TreeSet();
        Iterator it = planets.iterator();
        while (it.hasNext()) {
            this.planetNames.add(((Planet)it.next()).getName());
        }
        final Object[] allPlanetNames = this.planetNames.toArray();
        this.matchingPlanetsList = new JList<Object>(allPlanetNames);
        this.matchingPlanetsList.setVisibleRowCount(20);
        this.matchingPlanetsList.setSelectionMode(0);
        this.nameField = new JTextField();
        this.nameField.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                new Thread(){

                    public void run() {
                        String text = PlanetSearchDialog.this.nameField.getText();
                        if (text == null || text.equals("")) {
                            PlanetSearchDialog.this.matchingPlanetsList.setListData(allPlanetNames);
                            return;
                        }
                        ArrayList<String> possiblePlanets = new ArrayList<String>();
                        text = text.toLowerCase();
                        for (String curPlanet : PlanetSearchDialog.this.planetNames) {
                            if (curPlanet.toLowerCase().indexOf(text) == -1) continue;
                            possiblePlanets.add(curPlanet);
                        }
                        PlanetSearchDialog.this.matchingPlanetsList.setListData(possiblePlanets.toArray());
                        boolean shouldContinue = true;
                        int element = 0;
                        Iterator it = possiblePlanets.iterator();
                        while (it.hasNext() && shouldContinue) {
                            String name = (String)it.next();
                            if (name.toLowerCase().startsWith(text)) {
                                PlanetSearchDialog.this.matchingPlanetsList.setSelectedIndex(element);
                                shouldContinue = false;
                            }
                            ++element;
                        }
                        if (shouldContinue) {
                            PlanetSearchDialog.this.matchingPlanetsList.setSelectedIndex(0);
                        }
                    }
                }.start();
            }
        });
        this.scrollPane = new JScrollPane(this.matchingPlanetsList);
        this.scrollPane.setAlignmentX(0.0f);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.okayButton.setActionCommand("Okay");
        this.okayButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        JPanel springPanel = new JPanel(new SpringLayout());
        springPanel.add(this.nameField);
        springPanel.add(this.scrollPane);
        SpringLayoutHelper.setupSpringGrid(springPanel, 2, 1);
        JPanel buttonFlow = new JPanel();
        buttonFlow.add(this.okayButton);
        buttonFlow.add(this.cancelButton);
        JPanel generalLayout = new JPanel();
        generalLayout.setLayout(new BoxLayout(generalLayout, 1));
        generalLayout.add(springPanel);
        generalLayout.add(buttonFlow);
        this.getContentPane().add(generalLayout);
        this.pack();
        this.checkMinimumSize();
        this.setResizable(true);
        this.getRootPane().setDefaultButton(this.okayButton);
        this.setLocationRelativeTo(null);
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals("Okay")) {
            String selectedPlanet = (String)this.matchingPlanetsList.getSelectedValue();
            if (selectedPlanet == null) {
                selectedPlanet = this.nameField.getText();
            }
            if (selectedPlanet == null || selectedPlanet.equals("")) {
                return;
            }
            if (this.matchingPlanetsList.getModel().getSize() == 1) {
                selectedPlanet = (String)this.matchingPlanetsList.getModel().getElementAt(0);
            }
            for (Planet planet : this.planets) {
                if (!selectedPlanet.equals(planet.getName())) continue;
                this.map.setSelectedPlanet(planet);
                this.map.activate(planet, true);
                this.map.saveMapSelection(planet);
                this.dispose();
                return;
            }
            JOptionPane.showMessageDialog(null, "Unknown Planet");
        }
        this.dispose();
    }

    private void checkMinimumSize() {
        Dimension curDim = this.getSize();
        int height = 0;
        int width = 0;
        boolean shouldRedraw = false;
        if (curDim.getWidth() < 300.0) {
            width = 300;
            shouldRedraw = true;
        } else {
            width = (int)curDim.getWidth();
        }
        if (curDim.getHeight() < 300.0) {
            height = 300;
            shouldRedraw = true;
        } else {
            height = (int)curDim.getHeight();
        }
        if (shouldRedraw) {
            this.setSize(new Dimension(width, height));
        }
    }
}

