/*
 * Decompiled with CFR 0.152.
 */
package client.protocol;

import client.MWClient;
import client.protocol.ConnectionHandlerLocal;
import client.protocol.IConnectionHandler;
import client.protocol.IConnectionListener;
import java.io.BufferedReader;
import java.io.IOException;

class ReaderThread
extends Thread {
    private boolean keepGoing = true;
    private BufferedReader _in;
    private IConnectionListener _listener;
    private IConnectionHandler _connectionHandler;

    ReaderThread(BufferedReader in, IConnectionHandler handler) {
        super("ConnectionHandler$ReaderThread");
        this._in = in;
        this._connectionHandler = handler;
    }

    public void setListener(IConnectionListener listener) {
        this._listener = listener;
    }

    public void run() {
        block4: {
            try {
                String newLine;
                while (this.keepGoing && (newLine = this._in.readLine()) != null) {
                    if (this._listener != null) {
                        ConnectionHandlerLocal.DEBUG("< " + newLine);
                        this._listener.incomingMessage(newLine);
                        continue;
                    }
                    MWClient.mwClientLog.clientErrLog("no listener: " + newLine);
                }
                MWClient.mwClientLog.clientErrLog("ReaderThread: stopping gracefully.");
            }
            catch (IOException e) {
                if (!this.keepGoing) break block4;
                MWClient.mwClientLog.clientErrLog(e);
                this.keepGoing = false;
                this._connectionHandler.shutdown(true);
            }
        }
    }

    void pleaseStop() {
        this.keepGoing = false;
    }
}

