/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.Unit;
import common.dataFiles.ArmyData;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Army {
    ArmyData myData;

    public Army() {
        this.myData = new ArmyData();
    }

    public Army(ArmyData data) {
        this.myData = data;
    }

    public int getAmountOfUnits() {
        return this.getMyData().getUnits().size();
    }

    public boolean isLocked() {
        return this.getMyData().isLocked();
    }

    public void setLocked(boolean locked) {
        this.getMyData().setLocked(locked);
    }

    public int getBV() {
        int toReturn = this.getMyData().getBV();
        if (toReturn < 0) {
            return 0;
        }
        return toReturn;
    }

    public void setBV(int bv) {
        this.getMyData().setBV(bv);
    }

    public int getLowerLimiter() {
        return this.getMyData().getLowerLimiter();
    }

    public void setLowerLimiter(int lowerLimit) {
        this.getMyData().setLowerLimiter(lowerLimit);
    }

    public String getName() {
        return this.getMyData().getName();
    }

    public void setName(String name) {
        this.getMyData().setName(name);
    }

    public Vector<Unit> getUnits() {
        return this.getMyData().getUnits();
    }

    public int getUpperLimiter() {
        return this.getMyData().getUpperLimiter();
    }

    public void setUpperLimiter(int upperLimit) {
        this.getMyData().setUpperLimiter(upperLimit);
    }

    public int getID() {
        return this.getMyData().getId();
    }

    public Unit getUnit(int id) {
        Vector<Unit> v = this.getUnits();
        for (int i = 0; i < v.size(); ++i) {
            Unit unit = v.elementAt(i);
            if (unit.getId() != id) continue;
            return unit;
        }
        return null;
    }

    public void setID(int id) {
        this.getMyData().setId(id);
    }

    public String toString(boolean toClient, String delimiter) {
        StringBuffer result = new StringBuffer();
        result.append(this.getID());
        result.append(delimiter);
        if (toClient) {
            result.append(this.getBV());
            result.append(delimiter);
            result.append(this.isLocked());
            result.append(delimiter);
        }
        result.append(this.getName());
        result.append(delimiter);
        result.append(this.getLowerLimiter());
        result.append(delimiter);
        result.append(this.getUpperLimiter());
        result.append(delimiter);
        result.append(this.getUnits().size());
        result.append(delimiter);
        Vector<Unit> en = this.getUnits();
        for (int i = 0; i < en.size(); ++i) {
            Unit unit = en.elementAt(i);
            result.append(unit.getId());
            result.append(delimiter);
        }
        result.append(delimiter);
        if (this.getC3Network().size() > 0) {
            result.append(this.getC3Network().size());
            result.append(delimiter);
            Enumeration c3Key = this.getC3Network().keys();
            Enumeration c3Net = this.getC3Network().elements();
            while (c3Key.hasMoreElements()) {
                result.append(c3Key.nextElement());
                result.append(delimiter);
                result.append(c3Net.nextElement());
                result.append(delimiter);
            }
        }
        return result.toString();
    }

    public boolean hasMoreInfantryThanElse() {
        int infcount = 0;
        int elsecount = 0;
        Enumeration<Unit> en = this.getUnits().elements();
        while (en.hasMoreElements()) {
            Unit unit = en.nextElement();
            if (unit.getType() == 2) {
                ++infcount;
                continue;
            }
            ++elsecount;
        }
        return infcount > elsecount;
    }

    public ArmyData getMyData() {
        return this.myData;
    }

    public Hashtable getC3Network() {
        return this.getMyData().getC3Network();
    }

    public void setC3Network(Hashtable network) {
        this.getMyData().setC3Network(network);
    }

    public void removeUnitFromC3Network(int id) {
        if (this.getC3Network().get(new Integer(id)) != null) {
            this.getC3Network().remove(new Integer(id));
            return;
        }
        Enumeration c3Key = this.getC3Network().keys();
        Enumeration c3Unit = this.getC3Network().elements();
        while (c3Key.hasMoreElements()) {
            Integer slave = (Integer)c3Key.nextElement();
            Integer master = (Integer)c3Unit.nextElement();
            if (master != id) continue;
            this.getC3Network().remove(slave);
        }
    }
}

