/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.CampaignData;
import common.persistence.MMNetSerializable;
import common.persistence.TreeReader;
import common.persistence.TreeWriter;
import common.util.BinReader;
import common.util.BinWriter;
import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;

public final class PlanetEnvironment
implements MMNetSerializable {
    private int id = -1;
    private String Name = "";
    private int CraterProb = 0;
    private int CraterMinNum = 0;
    private int CraterMaxNum = 0;
    private int CraterMinRadius = 0;
    private int CraterMaxRadius = 0;
    private int Hillyness = 100;
    private int HillElevationRange = 3;
    private int HillInvertProb = 0;
    private int WaterMinSpots = 3;
    private int WaterMaxSpots = 8;
    private int WaterMinHexes = 2;
    private int WaterMaxHexes = 10;
    private int WaterDeepProb = 20;
    private int ForestMinSpots = 4;
    private int ForestMaxSpots = 8;
    private int ForestMinHexes = 2;
    private int ForestMaxHexes = 6;
    private int ForestHeavyProb = 20;
    private int RoughMinSpots = 0;
    private int RoughMaxSpots = 5;
    private int RoughMinHexes = 1;
    private int RoughMaxHexes = 2;
    private int SwampMinSpots = 0;
    private int SwampMaxSpots = 0;
    private int SwampMinHexes = 0;
    private int SwampMaxHexes = 0;
    private int PavementMinSpots = 0;
    private int PavementMaxSpots = 0;
    private int PavementMinHexes = 0;
    private int PavementMaxHexes = 0;
    private int IceMinSpots = 0;
    private int IceMaxSpots = 0;
    private int IceMinHexes = 0;
    private int IceMaxHexes = 0;
    private int RubbleMinSpots = 0;
    private int RubbleMaxSpots = 0;
    private int RubbleMinHexes = 0;
    private int RubbleMaxHexes = 0;
    private int FortifiedMinSpots = 0;
    private int FortifiedMaxSpots = 0;
    private int FortifiedMinHexes = 0;
    private int FortifiedMaxHexes = 0;
    private int MinBuildings = 0;
    private int MaxBuildings = 0;
    private int MinCF = 0;
    private int MaxCF = 0;
    private int MinFloors = 0;
    private int MaxFloors = 0;
    private String BuildingTypes = "1,2,3,4";
    private int fxMod = 0;
    private int probForestFire = 0;
    private int probFreeze = 0;
    private int probFlood = 0;
    private int probDrought = 0;
    private String Theme = "";
    private int RoadProb = 25;
    private int RiverProb = 25;
    private int Algorithm = 0;

    public PlanetEnvironment() {
    }

    public PlanetEnvironment(String s) {
        StringTokenizer ST = new StringTokenizer(s, "$");
        ST.nextToken();
        this.Name = ST.nextToken();
        this.CraterProb = Integer.parseInt(ST.nextToken());
        this.CraterMinNum = Integer.parseInt(ST.nextToken());
        this.CraterMaxNum = Integer.parseInt(ST.nextToken());
        this.CraterMinRadius = Integer.parseInt(ST.nextToken());
        this.CraterMaxRadius = Integer.parseInt(ST.nextToken());
        this.Hillyness = Integer.parseInt(ST.nextToken());
        this.HillElevationRange = Integer.parseInt(ST.nextToken());
        this.HillInvertProb = Integer.parseInt(ST.nextToken());
        this.WaterMinSpots = Integer.parseInt(ST.nextToken());
        this.WaterMaxSpots = Integer.parseInt(ST.nextToken());
        this.WaterMinHexes = Integer.parseInt(ST.nextToken());
        this.WaterMaxHexes = Integer.parseInt(ST.nextToken());
        this.WaterDeepProb = Integer.parseInt(ST.nextToken());
        this.ForestMinSpots = Integer.parseInt(ST.nextToken());
        this.ForestMaxSpots = Integer.parseInt(ST.nextToken());
        this.ForestMinHexes = Integer.parseInt(ST.nextToken());
        this.ForestMaxHexes = Integer.parseInt(ST.nextToken());
        this.ForestHeavyProb = Integer.parseInt(ST.nextToken());
        this.RoughMinSpots = Integer.parseInt(ST.nextToken());
        this.RoughMaxSpots = Integer.parseInt(ST.nextToken());
        this.RoughMinHexes = Integer.parseInt(ST.nextToken());
        this.RoughMaxHexes = Integer.parseInt(ST.nextToken());
        this.RoadProb = Integer.parseInt(ST.nextToken());
        this.RiverProb = Integer.parseInt(ST.nextToken());
        this.Algorithm = Integer.parseInt(ST.nextToken());
        if (ST.hasMoreTokens()) {
            this.id = Integer.parseInt(ST.nextToken());
        }
        if (ST.hasMoreTokens()) {
            this.SwampMinSpots = Integer.parseInt(ST.nextToken());
        }
        if (ST.hasMoreTokens()) {
            this.SwampMaxSpots = Integer.parseInt(ST.nextToken());
        }
        if (ST.hasMoreTokens()) {
            this.SwampMinHexes = Integer.parseInt(ST.nextToken());
        }
        if (ST.hasMoreTokens()) {
            this.SwampMaxHexes = Integer.parseInt(ST.nextToken());
        }
        if (ST.hasMoreTokens()) {
            this.PavementMinSpots = Integer.parseInt(ST.nextToken());
        }
        if (ST.hasMoreTokens()) {
            this.PavementMaxSpots = Integer.parseInt(ST.nextToken());
        }
        if (ST.hasMoreTokens()) {
            this.PavementMinHexes = Integer.parseInt(ST.nextToken());
        }
        if (ST.hasMoreTokens()) {
            this.PavementMaxHexes = Integer.parseInt(ST.nextToken());
        }
        if (ST.hasMoreTokens()) {
            this.fxMod = Integer.parseInt(ST.nextToken());
        }
        if (ST.hasMoreTokens()) {
            this.probForestFire = Integer.parseInt(ST.nextToken());
        }
        if (ST.hasMoreTokens()) {
            this.probFreeze = Integer.parseInt(ST.nextToken());
        }
        if (ST.hasMoreTokens()) {
            this.probFlood = Integer.parseInt(ST.nextToken());
        }
        if (ST.hasMoreTokens()) {
            this.probDrought = Integer.parseInt(ST.nextToken());
        }
        if (ST.hasMoreTokens()) {
            this.Theme = ST.nextToken();
        }
        if (ST.hasMoreTokens()) {
            this.IceMinSpots = Integer.parseInt(ST.nextToken());
        }
        if (ST.hasMoreTokens()) {
            this.IceMaxSpots = Integer.parseInt(ST.nextToken());
        }
        if (ST.hasMoreTokens()) {
            this.IceMinHexes = Integer.parseInt(ST.nextToken());
        }
        if (ST.hasMoreTokens()) {
            this.IceMaxHexes = Integer.parseInt(ST.nextToken());
        }
        if (ST.hasMoreTokens()) {
            this.RubbleMinSpots = Integer.parseInt(ST.nextToken());
        }
        if (ST.hasMoreTokens()) {
            this.RubbleMaxSpots = Integer.parseInt(ST.nextToken());
        }
        if (ST.hasMoreTokens()) {
            this.RubbleMinHexes = Integer.parseInt(ST.nextToken());
        }
        if (ST.hasMoreTokens()) {
            this.RubbleMaxHexes = Integer.parseInt(ST.nextToken());
        }
        if (ST.hasMoreTokens()) {
            this.FortifiedMinSpots = Integer.parseInt(ST.nextToken());
        }
        if (ST.hasMoreTokens()) {
            this.FortifiedMaxSpots = Integer.parseInt(ST.nextToken());
        }
        if (ST.hasMoreTokens()) {
            this.FortifiedMinHexes = Integer.parseInt(ST.nextToken());
        }
        if (ST.hasMoreTokens()) {
            this.FortifiedMaxHexes = Integer.parseInt(ST.nextToken());
        }
        if (ST.hasMoreTokens()) {
            this.MinBuildings = Integer.parseInt(ST.nextToken());
        }
        if (ST.hasMoreTokens()) {
            this.MaxBuildings = Integer.parseInt(ST.nextToken());
        }
        if (ST.hasMoreTokens()) {
            this.MinCF = Integer.parseInt(ST.nextToken());
        }
        if (ST.hasMoreTokens()) {
            this.MaxCF = Integer.parseInt(ST.nextToken());
        }
        if (ST.hasMoreTokens()) {
            this.MinFloors = Integer.parseInt(ST.nextToken());
        }
        if (ST.hasMoreTokens()) {
            this.MaxFloors = Integer.parseInt(ST.nextToken());
        }
        if (ST.hasMoreTokens()) {
            this.BuildingTypes = ST.nextToken();
        }
    }

    public String toDescription() {
        String result = "";
        int water = (this.WaterMaxSpots + this.WaterMinSpots) / 2 * (this.WaterMinHexes + this.WaterMaxSpots) / 2 + this.RiverProb / 10;
        int rough = (this.RoughMaxSpots + this.RoughMinSpots) / 2 * (this.RoughMinHexes + this.RoughMaxSpots) / 2;
        int forest = (this.ForestMaxSpots + this.ForestMinSpots) / 2 * (this.ForestMinHexes + this.ForestMaxSpots) / 2;
        int swamp = (this.SwampMaxSpots + this.SwampMinSpots) / 2 * (this.SwampMinHexes + this.SwampMaxSpots) / 2;
        int pavement = (this.PavementMaxSpots + this.PavementMinSpots) / 2 * (this.PavementMinHexes + this.PavementMaxSpots) / 2;
        result = result + "The landscape is ";
        if (this.Hillyness < 200) {
            result = result + "plain";
        }
        if (this.Hillyness < 500 && this.Hillyness >= 200) {
            result = result + "uneven";
        }
        if (this.Hillyness >= 500 && this.Hillyness <= 800) {
            result = result + "hilly";
        }
        if (this.Hillyness > 800) {
            result = result + "mountainous";
        }
        if (this.CraterProb == 0) {
            result = result + ". <br> ";
            if (rough > 0) {
                result = result + "Through tectonic activity of this continent, rough terrain is appearing";
                result = rough > 8 ? result + " everywhere" : result + " sometimes";
            }
        } else {
            int avgCraterSize;
            if (this.CraterProb < 30) {
                result = result + ", which is seldom coverd with";
            }
            if (this.CraterProb >= 30 && this.CraterProb < 60) {
                result = result + ", which is covered with";
            }
            if (this.CraterProb >= 60) {
                result = result + ", often coverd with";
            }
            if ((avgCraterSize = (this.CraterMinRadius + this.CraterMaxRadius) / 2) < 4) {
                result = result + " small craters";
            }
            if (avgCraterSize >= 4 && avgCraterSize < 7) {
                result = result + " craters ";
            }
            if (avgCraterSize >= 7) {
                result = result + " large craters";
            }
            if (rough > 0) {
                result = result + ". Another remaing of the ancient meteorid impacts is the rough terrain appearing";
                result = rough > 8 ? result + " everywhere" : result + " sometimes";
            }
        }
        result = result + ". <br>";
        result = result + "Most facitlities on this continent are lying";
        if (forest > 50) {
            result = result + " deep in the ";
            result = result + (this.ForestHeavyProb < 30 ? "woods" : "jungle");
            if (water > 20) {
                result = result + " mixed up with much water, because of heavy rain due too monsoon period";
            }
            result = result + ".";
        } else {
            result = water > 20 ? result + " close to the coast." : (water < 3 ? (forest < 15 ? result + " in the desert. So dont expect vegetation for cover or water for cooling." : result + " in an area moderatly forested.") : result + " in an area famous for its agriculture.");
        }
        return result;
    }

    public String toImageDescription() {
        String result = "";
        int water = (this.WaterMaxSpots + this.WaterMinSpots) / 2 * (this.WaterMinHexes + this.WaterMaxSpots) / 2 + this.RiverProb / 10;
        int rough = (this.RoughMaxSpots + this.RoughMinSpots) / 2 * (this.RoughMinHexes + this.RoughMaxSpots) / 2;
        int forest = (this.ForestMaxSpots + this.ForestMinSpots) / 2 * (this.ForestMinHexes + this.ForestMaxSpots) / 2;
        int swamp = (this.SwampMaxSpots + this.SwampMinSpots) / 2 * (this.SwampMinHexes + this.SwampMaxSpots) / 2;
        int pavement = (this.PavementMaxSpots + this.PavementMinSpots) / 2 * (this.PavementMinHexes + this.PavementMaxSpots) / 2;
        if (this.Hillyness < 200) {
            result = result + "<img src=\"data/images/hill0.gif\">";
        }
        if (this.Hillyness < 500 && this.Hillyness >= 200) {
            result = result + "<img src=\"data/images/hill1.gif\">";
        }
        if (this.Hillyness >= 500 && this.Hillyness <= 800) {
            result = result + "<img src=\"data/images/hill2.gif\">";
        }
        if (this.Hillyness > 800) {
            result = result + "<img src=\"data/images/hill3.gif\">";
        }
        if (rough > 8) {
            result = result + "<img src=\"data/images/roug1.gif\">";
        }
        if (this.CraterProb > 30) {
            result = result + "<img src=\"data/images/crtr1.gif\">";
        }
        if (forest > 15 && forest < 30) {
            result = result + "<img src=\"data/images/wood1.gif\">";
        } else if (forest >= 30 && forest < 50) {
            result = result + "<img src=\"data/images/wood2.gif\">";
        } else if (forest >= 50) {
            result = result + "<img src=\"data/images/wood3.gif\">";
        }
        if (water > 5 && water < 20) {
            result = result + "<img src=\"data/images/watr1.gif\">";
        } else if (water >= 20) {
            result = result + "<img src=\"data/images/watr2.gif\">";
        }
        if (this.getRiverProb() > 50) {
            result = result + "<img src=\"data/images/rivr1.gif\">";
        }
        if (this.getRoadProb() > 50) {
            result = result + "<img src=\"data/images/road1.gif\">";
        }
        return result;
    }

    public String toImageAbsolutePathDescription() {
        String result = "";
        int water = (this.WaterMaxSpots + this.WaterMinSpots) / 2 * (this.WaterMinHexes + this.WaterMaxSpots) / 2 + this.RiverProb / 10;
        int rough = (this.RoughMaxSpots + this.RoughMinSpots) / 2 * (this.RoughMinHexes + this.RoughMaxSpots) / 2;
        int forest = (this.ForestMaxSpots + this.ForestMinSpots) / 2 * (this.ForestMinHexes + this.ForestMaxSpots) / 2;
        int swamp = (this.SwampMaxSpots + this.SwampMinSpots) / 2 * (this.SwampMinHexes + this.SwampMaxSpots) / 2;
        int pavement = (this.PavementMaxSpots + this.PavementMinSpots) / 2 * (this.PavementMinHexes + this.PavementMaxSpots) / 2;
        String path = "file:///" + new File(".").getAbsolutePath();
        if (this.Hillyness < 200) {
            result = result + "<img src=\"" + path + "/data/images/hill0.gif\">";
        }
        if (this.Hillyness < 500 && this.Hillyness >= 200) {
            result = result + "<img src=\"" + path + "/data/images/hill1.gif\">";
        }
        if (this.Hillyness >= 500 && this.Hillyness <= 800) {
            result = result + "<img src=\"" + path + "/data/images/hill2.gif\">";
        }
        if (this.Hillyness > 800) {
            result = result + "<img src=\"" + path + "/data/images/hill3.gif\">";
        }
        if (rough > 8) {
            result = result + "<img src=\"" + path + "/data/images/roug1.gif\">";
        }
        if (this.CraterProb > 30) {
            result = result + "<img src=\"" + path + "/data/images/crtr1.gif\">";
        }
        if (forest > 15 && forest < 30) {
            result = result + "<img src=\"" + path + "/data/images/wood1.gif\">";
        } else if (forest >= 30 && forest < 50) {
            result = result + "<img src=\"" + path + "/data/images/wood2.gif\">";
        } else if (forest >= 50) {
            result = result + "<img src=\"" + path + "/data/images/wood3.gif\">";
        }
        if (water > 5 && water < 20) {
            result = result + "<img src=\"" + path + "/data/images/watr1.gif\">";
        } else if (water >= 20) {
            result = result + "<img src=\"" + path + "/data/images/watr2.gif\">";
        }
        if (this.getRiverProb() > 50) {
            result = result + "<img src=\"" + path + "/data/images/rivr1.gif\">";
        }
        if (this.getRoadProb() > 50) {
            result = result + "<img src=\"" + path + "/data/images/road1.gif\">";
        }
        return result;
    }

    public String toString() {
        String result = "PE$";
        result = result + this.Name + "$";
        result = result + this.CraterProb + "$";
        result = result + this.CraterMinNum + "$";
        result = result + this.CraterMaxNum + "$";
        result = result + this.CraterMinRadius + "$";
        result = result + this.CraterMaxRadius + "$";
        result = result + this.Hillyness + "$";
        result = result + this.HillElevationRange + "$";
        result = result + this.HillInvertProb + "$";
        result = result + this.WaterMinSpots + "$";
        result = result + this.WaterMaxSpots + "$";
        result = result + this.WaterMinHexes + "$";
        result = result + this.WaterMaxHexes + "$";
        result = result + this.WaterDeepProb + "$";
        result = result + this.ForestMinSpots + "$";
        result = result + this.ForestMaxSpots + "$";
        result = result + this.ForestMinHexes + "$";
        result = result + this.ForestMaxHexes + "$";
        result = result + this.ForestHeavyProb + "$";
        result = result + this.RoughMinSpots + "$";
        result = result + this.RoughMaxSpots + "$";
        result = result + this.RoughMinHexes + "$";
        result = result + this.RoughMaxHexes + "$";
        result = result + this.RoadProb + "$";
        result = result + this.RiverProb + "$";
        result = result + this.Algorithm + "$";
        result = result + this.id + "$";
        result = result + this.SwampMinSpots + "$";
        result = result + this.SwampMaxSpots + "$";
        result = result + this.SwampMinHexes + "$";
        result = result + this.SwampMaxHexes + "$";
        result = result + this.PavementMinSpots + "$";
        result = result + this.PavementMaxSpots + "$";
        result = result + this.PavementMinHexes + "$";
        result = result + this.PavementMaxHexes + "$";
        result = result + this.fxMod + "$";
        result = result + this.probForestFire + "$";
        result = result + this.probFreeze + "$";
        result = result + this.probFlood + "$";
        result = result + this.probDrought + "$";
        result = result + this.Theme + "$";
        result = result + this.IceMinSpots + "$";
        result = result + this.IceMaxSpots + "$";
        result = result + this.IceMinHexes + "$";
        result = result + this.IceMaxHexes + "$";
        result = result + this.RubbleMinSpots + "$";
        result = result + this.RubbleMaxSpots + "$";
        result = result + this.RubbleMinHexes + "$";
        result = result + this.RubbleMaxHexes + "$";
        result = result + this.FortifiedMinSpots + "$";
        result = result + this.FortifiedMaxSpots + "$";
        result = result + this.FortifiedMinHexes + "$";
        result = result + this.FortifiedMaxHexes + "$";
        result = result + this.MinBuildings + "$";
        result = result + this.MaxBuildings + "$";
        result = result + this.MinCF + "$";
        result = result + this.MaxCF + "$";
        result = result + this.MinFloors + "$";
        result = result + this.MaxFloors + "$";
        result = result + this.BuildingTypes + "$";
        return result;
    }

    public int getWaterMinSpots() {
        return this.WaterMinSpots;
    }

    public int getWaterMinHexes() {
        return this.WaterMinHexes;
    }

    public int getWaterMaxHexes() {
        return this.WaterMaxHexes;
    }

    public int getWaterMaxSpots() {
        return this.WaterMaxSpots;
    }

    public int getWaterDeepProb() {
        return this.WaterDeepProb;
    }

    public int getRoughMinSpots() {
        return this.RoughMinSpots;
    }

    public int getRoughMinHexes() {
        return this.RoughMinHexes;
    }

    public int getRoughMaxSpots() {
        return this.RoughMaxSpots;
    }

    public int getRoughMaxHexes() {
        return this.RoughMaxHexes;
    }

    public int getSwampMinSpots() {
        return this.SwampMinSpots;
    }

    public int getSwampMinHexes() {
        return this.SwampMinHexes;
    }

    public int getSwampMaxSpots() {
        return this.SwampMaxSpots;
    }

    public int getSwampMaxHexes() {
        return this.SwampMaxHexes;
    }

    public int getPavementMinSpots() {
        return this.PavementMinSpots;
    }

    public int getPavementMinHexes() {
        return this.PavementMinHexes;
    }

    public int getPavementMaxSpots() {
        return this.PavementMaxSpots;
    }

    public int getPavementMaxHexes() {
        return this.PavementMaxHexes;
    }

    public int getIceMinSpots() {
        return this.IceMinSpots;
    }

    public int getIceMinHexes() {
        return this.IceMinHexes;
    }

    public int getIceMaxSpots() {
        return this.IceMaxSpots;
    }

    public int getIceMaxHexes() {
        return this.IceMaxHexes;
    }

    public int getRubbleMinSpots() {
        return this.RubbleMinSpots;
    }

    public int getRubbleMinHexes() {
        return this.RubbleMinHexes;
    }

    public int getRubbleMaxSpots() {
        return this.RubbleMaxSpots;
    }

    public int getRubbleMaxHexes() {
        return this.RubbleMaxHexes;
    }

    public int getFortifiedMinSpots() {
        return this.FortifiedMinSpots;
    }

    public int getFortifiedMinHexes() {
        return this.FortifiedMinHexes;
    }

    public int getFortifiedMaxSpots() {
        return this.FortifiedMaxSpots;
    }

    public int getFortifiedMaxHexes() {
        return this.FortifiedMaxHexes;
    }

    public int getMaxBuildings() {
        return this.MaxBuildings;
    }

    public int getMinBuildings() {
        return this.MinBuildings;
    }

    public int getMaxCF() {
        return this.MaxCF;
    }

    public int getMinCF() {
        return this.MinCF;
    }

    public int getMaxFloors() {
        return this.MaxFloors;
    }

    public int getMinFloors() {
        return this.MinFloors;
    }

    public String getBuildingTypes() {
        return this.BuildingTypes;
    }

    public int getRoadProb() {
        return this.RoadProb;
    }

    public int getRiverProb() {
        return this.RiverProb;
    }

    public int getHillyness() {
        return this.Hillyness;
    }

    public int getForestMinSpots() {
        return this.ForestMinSpots;
    }

    public int getHillElevationRange() {
        return this.HillElevationRange;
    }

    public int getForestMinHexes() {
        return this.ForestMinHexes;
    }

    public int getForestMaxSpots() {
        return this.ForestMaxSpots;
    }

    public int getForestMaxHexes() {
        return this.ForestMaxHexes;
    }

    public int getForestHeavyProb() {
        return this.ForestHeavyProb;
    }

    public int getCraterProb() {
        return this.CraterProb;
    }

    public int getCraterMinRadius() {
        return this.CraterMinRadius;
    }

    public int getCraterMaxRadius() {
        return this.CraterMaxRadius;
    }

    public int getCraterMinNum() {
        return this.CraterMinNum;
    }

    public int getCraterMaxNum() {
        return this.CraterMaxNum;
    }

    public int getAlgorithm() {
        return this.Algorithm;
    }

    public void setAlgorithm(int Algorithm) {
        this.Algorithm = Algorithm;
    }

    public void setCraterMaxNum(int CraterMaxNum) {
        this.CraterMaxNum = CraterMaxNum;
    }

    public void setCraterMaxRadius(int CraterMaxRadius) {
        this.CraterMaxRadius = CraterMaxRadius;
    }

    public void setCraterMinNum(int CraterMinNum) {
        this.CraterMinNum = CraterMinNum;
    }

    public void setCraterMinRadius(int CraterMinRadius) {
        this.CraterMinRadius = CraterMinRadius;
    }

    public void setCraterProb(int CraterProb) {
        this.CraterProb = CraterProb;
    }

    public void setForestHeavyProb(int ForestHeavyProb) {
        this.ForestHeavyProb = ForestHeavyProb;
    }

    public void setForestMaxHexes(int ForestMaxHexes) {
        this.ForestMaxHexes = ForestMaxHexes;
    }

    public void setForestMaxSpots(int ForestMaxSpots) {
        this.ForestMaxSpots = ForestMaxSpots;
    }

    public void setForestMinHexes(int ForestMinHexes) {
        this.ForestMinHexes = ForestMinHexes;
    }

    public void setForestMinSpots(int ForestMinSpots) {
        this.ForestMinSpots = ForestMinSpots;
    }

    public void setHillElevationRange(int HillElevationRange) {
        this.HillElevationRange = HillElevationRange;
    }

    public void setHillyness(int Hillyness) {
        this.Hillyness = Hillyness;
    }

    public void setRoadProb(int RoadProb) {
        this.RoadProb = RoadProb;
    }

    public void setRiverProb(int RiverProb) {
        this.RiverProb = RiverProb;
    }

    public void setRoughMaxHexes(int RoughMaxHexes) {
        this.RoughMaxHexes = RoughMaxHexes;
    }

    public void setRoughMaxSpots(int RoughMaxSpots) {
        this.RoughMaxSpots = RoughMaxSpots;
    }

    public void setRoughMinSpots(int RoughMinSpots) {
        this.RoughMinSpots = RoughMinSpots;
    }

    public void setRoughMinHexes(int RoughMinHexes) {
        this.RoughMinHexes = RoughMinHexes;
    }

    public void setWaterDeepProb(int WaterDeepProb) {
        this.WaterDeepProb = WaterDeepProb;
    }

    public void setWaterMaxHexes(int WaterMaxHexes) {
        this.WaterMaxHexes = WaterMaxHexes;
    }

    public void setWaterMaxSpots(int WaterMaxSpots) {
        this.WaterMaxSpots = WaterMaxSpots;
    }

    public void setWaterMinHexes(int WaterMinHexes) {
        this.WaterMinHexes = WaterMinHexes;
    }

    public void setWaterMinSpots(int WaterMinSpots) {
        this.WaterMinSpots = WaterMinSpots;
    }

    public int getHillInvertProb() {
        return this.HillInvertProb;
    }

    public void setHillInvertProb(int HillInvertProb) {
        this.HillInvertProb = HillInvertProb;
    }

    public void setSwampMaxHexes(int SwampMaxHexes) {
        this.SwampMaxHexes = SwampMaxHexes;
    }

    public void setSwampMaxSpots(int SwampMaxSpots) {
        this.SwampMaxSpots = SwampMaxSpots;
    }

    public void setSwampMinSpots(int SwampMinSpots) {
        this.SwampMinSpots = SwampMinSpots;
    }

    public void setSwampMinHexes(int SwampMinHexes) {
        this.SwampMinHexes = SwampMinHexes;
    }

    public void setPavementMaxHexes(int PavementMaxHexes) {
        this.PavementMaxHexes = PavementMaxHexes;
    }

    public void setPavementMaxSpots(int PavementMaxSpots) {
        this.PavementMaxSpots = PavementMaxSpots;
    }

    public void setPavementMinSpots(int PavementMinSpots) {
        this.PavementMinSpots = PavementMinSpots;
    }

    public void setPavementMinHexes(int PavementMinHexes) {
        this.PavementMinHexes = PavementMinHexes;
    }

    public void setIceMaxHexes(int IceMaxHexes) {
        this.IceMaxHexes = IceMaxHexes;
    }

    public void setIceMaxSpots(int IceMaxSpots) {
        this.IceMaxSpots = IceMaxSpots;
    }

    public void setIceMinSpots(int IceMinSpots) {
        this.IceMinSpots = IceMinSpots;
    }

    public void setIceMinHexes(int IceMinHexes) {
        this.IceMinHexes = IceMinHexes;
    }

    public void setRubbleMaxHexes(int RubbleMaxHexes) {
        this.RubbleMaxHexes = RubbleMaxHexes;
    }

    public void setRubbleMaxSpots(int RubbleMaxSpots) {
        this.RubbleMaxSpots = RubbleMaxSpots;
    }

    public void setRubbleMinSpots(int RubbleMinSpots) {
        this.RubbleMinSpots = RubbleMinSpots;
    }

    public void setRubbleMinHexes(int RubbleMinHexes) {
        this.RubbleMinHexes = RubbleMinHexes;
    }

    public void setFortifiedMaxHexes(int FortifiedMaxHexes) {
        this.FortifiedMaxHexes = FortifiedMaxHexes;
    }

    public void setFortifiedMaxSpots(int FortifiedMaxSpots) {
        this.FortifiedMaxSpots = FortifiedMaxSpots;
    }

    public void setFortifiedMinSpots(int FortifiedMinSpots) {
        this.FortifiedMinSpots = FortifiedMinSpots;
    }

    public void setFortifiedMinHexes(int FortifiedMinHexes) {
        this.FortifiedMinHexes = FortifiedMinHexes;
    }

    public void setMaxBuildings(int Buildings2) {
        this.MaxBuildings = Buildings2;
    }

    public void setMinBuildings(int Buildings2) {
        this.MinBuildings = Buildings2;
    }

    public void setMaxCF(int CF) {
        this.MaxCF = CF;
    }

    public void setMinCF(int CF) {
        this.MinCF = CF;
    }

    public void setMinFloors(int Floors) {
        this.MinFloors = Floors;
    }

    public void setMaxFloors(int Floors) {
        this.MaxFloors = Floors;
    }

    public void setBuildingTypes(String types) {
        this.BuildingTypes = types;
    }

    public void setFxMod(int mod) {
        this.fxMod = mod;
    }

    public void setProbForestFire(int prob) {
        this.probForestFire = prob;
    }

    public void setProbFreeze(int prob) {
        this.probFreeze = prob;
    }

    public void setProbFlood(int prob) {
        this.probFlood = prob;
    }

    public void setProbDrought(int prob) {
        this.probDrought = prob;
    }

    public int getFxMod() {
        return this.fxMod;
    }

    public int getProbForestFire() {
        return this.probForestFire;
    }

    public int getProbFreeze() {
        return this.probFreeze;
    }

    public int getProbFlood() {
        return this.probFlood;
    }

    public int getProbDrought() {
        return this.probDrought;
    }

    public void binOut(BinWriter out) throws IOException {
        out.println(this.id, "id");
        out.println(this.Name, "name");
        out.println(this.CraterProb, "CraterProb");
        out.println(this.CraterMinNum, "CraterMinNum");
        out.println(this.CraterMaxNum, "CraterMaxNum");
        out.println(this.CraterMinRadius, "CraterMinRadius");
        out.println(this.CraterMaxRadius, "CraterMaxRadius");
        out.println(this.Hillyness, "Hillyness");
        out.println(this.HillElevationRange, "HillElevationRange");
        out.println(this.HillInvertProb, "HillInvertProb");
        out.println(this.WaterMinSpots, "WaterMinSpots");
        out.println(this.WaterMaxSpots, "WaterMaxSpots");
        out.println(this.WaterMinHexes, "WaterMinHexes");
        out.println(this.WaterMaxHexes, "WaterMaxHexes");
        out.println(this.WaterDeepProb, "WaterDeepProb");
        out.println(this.ForestMinSpots, "ForestMinSpots");
        out.println(this.ForestMaxSpots, "ForestMaxSpots");
        out.println(this.ForestMinHexes, "ForestMinHexes");
        out.println(this.ForestMaxHexes, "ForestMaxHexes");
        out.println(this.ForestHeavyProb, "ForestHeavyProb");
        out.println(this.RoughMinSpots, "RoughMinSpots");
        out.println(this.RoughMaxSpots, "RoughMaxSpots");
        out.println(this.RoughMinHexes, "RoughMinHexes");
        out.println(this.RoughMaxHexes, "RoughMaxHexes");
        out.println(this.SwampMinSpots, "SwampMinSpots");
        out.println(this.SwampMaxSpots, "SwampMaxSpots");
        out.println(this.SwampMinHexes, "SwampMinHexes");
        out.println(this.SwampMaxHexes, "SwampMaxHexes");
        out.println(this.PavementMinSpots, "PavementMinSpots");
        out.println(this.PavementMaxSpots, "PavementMaxSpots");
        out.println(this.PavementMinHexes, "PavementMinHexes");
        out.println(this.PavementMaxHexes, "PavementMaxHexes");
        out.println(this.fxMod, "fxMod");
        out.println(this.probForestFire, "probForestFire");
        out.println(this.probFreeze, "probFreeze");
        out.println(this.probFlood, "probFlood");
        out.println(this.probDrought, "probDrought");
        out.println(this.RoadProb, "RoadProb");
        out.println(this.RiverProb, "RiverProb");
        out.println(this.Algorithm, "Algorithm");
        out.println(this.Theme, "Theme");
        out.println(this.IceMinSpots, "IceMinSpots");
        out.println(this.IceMaxSpots, "IceMaxSpots");
        out.println(this.IceMinHexes, "IceMinHexes");
        out.println(this.IceMaxHexes, "IceMaxHexes");
        out.println(this.RubbleMinSpots, "RubbleMinSpots");
        out.println(this.RubbleMaxSpots, "RubbleMaxSpots");
        out.println(this.RubbleMinHexes, "RubbleMinHexes");
        out.println(this.RubbleMaxHexes, "RubbleMaxHexes");
        out.println(this.FortifiedMinSpots, "FortifiedMinSpots");
        out.println(this.FortifiedMaxSpots, "FortifiedMaxSpots");
        out.println(this.FortifiedMinHexes, "FortifiedMinHexes");
        out.println(this.FortifiedMaxHexes, "FortifiedMaxHexes");
        out.println(this.MinBuildings, "MinBuildings");
        out.println(this.MaxBuildings, "MaxBuildings");
        out.println(this.MinCF, "MinCF");
        out.println(this.MaxCF, "MaxCF");
        out.println(this.MinFloors, "MinFloors");
        out.println(this.MaxFloors, "MaxFloors");
        out.println(this.BuildingTypes, "BuildingTypes");
    }

    public void binOut(TreeWriter out) {
        out.write(this.id, "id");
        out.write(this.id, "name");
        out.write(this.CraterProb, "CraterProb");
        out.write(this.CraterMinNum, "CraterMinNum");
        out.write(this.CraterMaxNum, "CraterMaxNum");
        out.write(this.CraterMinRadius, "CraterMinRadius");
        out.write(this.CraterMaxRadius, "CraterMaxRadius");
        out.write(this.Hillyness, "Hillyness");
        out.write(this.HillElevationRange, "HillElevationRange");
        out.write(this.HillInvertProb, "HillInvertProb");
        out.write(this.WaterMinSpots, "WaterMinSpots");
        out.write(this.WaterMaxSpots, "WaterMaxSpots");
        out.write(this.WaterMinHexes, "WaterMinHexes");
        out.write(this.WaterMaxHexes, "WaterMaxHexes");
        out.write(this.WaterDeepProb, "WaterDeepProb");
        out.write(this.ForestMinSpots, "ForestMinSpots");
        out.write(this.ForestMaxSpots, "ForestMaxSpots");
        out.write(this.ForestMinHexes, "ForestMinHexes");
        out.write(this.ForestMaxHexes, "ForestMaxHexes");
        out.write(this.ForestHeavyProb, "ForestHeavyProb");
        out.write(this.RoughMinSpots, "RoughMinSpots");
        out.write(this.RoughMaxSpots, "RoughMaxSpots");
        out.write(this.RoughMinHexes, "RoughMinHexes");
        out.write(this.RoughMaxHexes, "RoughMaxHexes");
        out.write(this.SwampMinSpots, "SwampMinSpots");
        out.write(this.SwampMaxSpots, "SwampMaxSpots");
        out.write(this.SwampMinHexes, "SwampMinHexes");
        out.write(this.SwampMaxHexes, "SwampMaxHexes");
        out.write(this.PavementMinSpots, "PavementMinSpots");
        out.write(this.PavementMaxSpots, "PavementMaxSpots");
        out.write(this.PavementMinHexes, "PavementMinHexes");
        out.write(this.PavementMaxHexes, "PavementMaxHexes");
        out.write(this.fxMod, "fxMod");
        out.write(this.probForestFire, "probForestFire");
        out.write(this.probFreeze, "probFreeze");
        out.write(this.probFlood, "probFlood");
        out.write(this.probDrought, "probDrought");
        out.write(this.RoadProb, "RoadProb");
        out.write(this.RiverProb, "RiverProb");
        out.write(this.Algorithm, "Algorithm");
        out.write(this.Theme, "Theme");
        out.write(this.IceMinSpots, "IceMinSpots");
        out.write(this.IceMaxSpots, "IceMaxSpots");
        out.write(this.IceMinHexes, "IceMinHexes");
        out.write(this.IceMaxHexes, "IceMaxHexes");
        out.write(this.RubbleMinSpots, "RubbleMinSpots");
        out.write(this.RubbleMaxSpots, "RubbleMaxSpots");
        out.write(this.RubbleMinHexes, "RubbleMinHexes");
        out.write(this.RubbleMaxHexes, "RubbleMaxHexes");
        out.write(this.FortifiedMinSpots, "FortifiedMinSpots");
        out.write(this.FortifiedMaxSpots, "FortifiedMaxSpots");
        out.write(this.FortifiedMinHexes, "FortifiedMinHexes");
        out.write(this.FortifiedMaxHexes, "FortifiedMaxHexes");
        out.write(this.MinBuildings, "MinBuildings");
        out.write(this.MaxBuildings, "MaxBuildings");
        out.write(this.MinCF, "MinCF");
        out.write(this.MaxCF, "MaxCF");
        out.write(this.MinFloors, "MinFloors");
        out.write(this.MaxFloors, "MaxFloors");
        out.write(this.BuildingTypes, "BuildingTypes");
    }

    public void binIn(BinReader in, CampaignData data) throws IOException {
        this.id = in.readInt("id");
        this.Name = in.readLine("name");
        this.CraterProb = in.readInt("CraterProb");
        this.CraterMinNum = in.readInt("CraterMinNum");
        this.CraterMaxNum = in.readInt("CraterMaxNum");
        this.CraterMinRadius = in.readInt("CraterMinRadius");
        this.CraterMaxRadius = in.readInt("CraterMaxRadius");
        this.Hillyness = in.readInt("Hillyness");
        this.HillElevationRange = in.readInt("HillElevationRange");
        this.HillInvertProb = in.readInt("HillInvertProb");
        this.WaterMinSpots = in.readInt("WaterMinSpots");
        this.WaterMaxSpots = in.readInt("WaterMaxSpots");
        this.WaterMinHexes = in.readInt("WaterMinHexes");
        this.WaterMaxHexes = in.readInt("WaterMaxHexes");
        this.WaterDeepProb = in.readInt("WaterDeepProb");
        this.ForestMinSpots = in.readInt("ForestMinSpots");
        this.ForestMaxSpots = in.readInt("ForestMaxSpots");
        this.ForestMinHexes = in.readInt("ForestMinHexes");
        this.ForestMaxHexes = in.readInt("ForestMaxHexes");
        this.ForestHeavyProb = in.readInt("ForestHeavyProb");
        this.RoughMinSpots = in.readInt("RoughMinSpots");
        this.RoughMaxSpots = in.readInt("RoughMaxSpots");
        this.RoughMinHexes = in.readInt("RoughMinHexes");
        this.RoughMaxHexes = in.readInt("RoughMaxHexes");
        this.SwampMinSpots = in.readInt("SwampMinSpots");
        this.SwampMaxSpots = in.readInt("SwampMaxSpots");
        this.SwampMinHexes = in.readInt("SwampMinHexes");
        this.SwampMaxHexes = in.readInt("SwampMaxHexes");
        this.PavementMinSpots = in.readInt("PavementMinSpots");
        this.PavementMaxSpots = in.readInt("PavementMaxSpots");
        this.PavementMinHexes = in.readInt("PavementMinHexes");
        this.PavementMaxHexes = in.readInt("PavementMaxHexes");
        this.fxMod = in.readInt("fxMod");
        this.probForestFire = in.readInt("probForestFire");
        this.probFreeze = in.readInt("probFreeze");
        this.probFlood = in.readInt("probFlood");
        this.probDrought = in.readInt("probDrought");
        this.RoadProb = in.readInt("RoadProb");
        this.RiverProb = in.readInt("RiverProb");
        this.Algorithm = in.readInt("Algorithm");
        this.Theme = in.readLine("Theme");
        this.IceMinSpots = in.readInt("IceMinSpots");
        this.IceMaxSpots = in.readInt("IceMaxSpots");
        this.IceMinHexes = in.readInt("IceMinHexes");
        this.IceMaxHexes = in.readInt("IceMaxHexes");
        this.RubbleMinSpots = in.readInt("RubbleMinSpots");
        this.RubbleMaxSpots = in.readInt("RubbleMaxSpots");
        this.RubbleMinHexes = in.readInt("RubbleMinHexes");
        this.RubbleMaxHexes = in.readInt("RubbleMaxHexes");
        this.FortifiedMinSpots = in.readInt("FortifiedMinSpots");
        this.FortifiedMaxSpots = in.readInt("FortifiedMaxSpots");
        this.FortifiedMinHexes = in.readInt("FortifiedMinHexes");
        this.FortifiedMaxHexes = in.readInt("FortifiedMaxHexes");
        this.MinBuildings = in.readInt("MinBuildings");
        this.MaxBuildings = in.readInt("MaxBuildings");
        this.MinCF = in.readInt("MinCF");
        this.MaxCF = in.readInt("MaxCF");
        this.MinFloors = in.readInt("MinFloors");
        this.MaxFloors = in.readInt("MaxFloors");
        this.BuildingTypes = in.readLine("BuildingTypes");
    }

    public void binIn(TreeReader in, CampaignData data) throws IOException {
        this.id = in.readInt("id");
        this.Name = in.readString("name");
        this.CraterProb = in.readInt("CraterProb");
        this.CraterMinNum = in.readInt("CraterMinNum");
        this.CraterMaxNum = in.readInt("CraterMaxNum");
        this.CraterMinRadius = in.readInt("CraterMinRadius");
        this.CraterMaxRadius = in.readInt("CraterMaxRadius");
        this.Hillyness = in.readInt("Hillyness");
        this.HillElevationRange = in.readInt("HillElevationRange");
        this.HillInvertProb = in.readInt("HillInvertProb");
        this.WaterMinSpots = in.readInt("WaterMinSpots");
        this.WaterMaxSpots = in.readInt("WaterMaxSpots");
        this.WaterMinHexes = in.readInt("WaterMinHexes");
        this.WaterMaxHexes = in.readInt("WaterMaxHexes");
        this.WaterDeepProb = in.readInt("WaterDeepProb");
        this.ForestMinSpots = in.readInt("ForestMinSpots");
        this.ForestMaxSpots = in.readInt("ForestMaxSpots");
        this.ForestMinHexes = in.readInt("ForestMinHexes");
        this.ForestMaxHexes = in.readInt("ForestMaxHexes");
        this.ForestHeavyProb = in.readInt("ForestHeavyProb");
        this.RoughMinSpots = in.readInt("RoughMinSpots");
        this.RoughMaxSpots = in.readInt("RoughMaxSpots");
        this.RoughMinHexes = in.readInt("RoughMinHexes");
        this.RoughMaxHexes = in.readInt("RoughMaxHexes");
        this.SwampMinSpots = in.readInt("SwampMinSpots");
        this.SwampMaxSpots = in.readInt("SwampMaxSpots");
        this.SwampMinHexes = in.readInt("SwampMinHexes");
        this.SwampMaxHexes = in.readInt("SwampMaxHexes");
        this.PavementMinSpots = in.readInt("PavementMinSpots");
        this.PavementMaxSpots = in.readInt("PavementMaxSpots");
        this.PavementMinHexes = in.readInt("PavementMinHexes");
        this.PavementMaxHexes = in.readInt("PavementMaxHexes");
        this.fxMod = in.readInt("fxMod");
        this.probForestFire = in.readInt("probForestFire");
        this.probFreeze = in.readInt("probFreeze");
        this.probFlood = in.readInt("probFlood");
        this.probDrought = in.readInt("probDrought");
        this.RoadProb = in.readInt("RoadProb");
        this.RiverProb = in.readInt("RiverProb");
        this.Algorithm = in.readInt("Algorithm");
        this.Theme = in.readString("Theme");
        this.IceMinSpots = in.readInt("IceMinSpots");
        this.IceMaxSpots = in.readInt("IceMaxSpots");
        this.IceMinHexes = in.readInt("IceMinHexes");
        this.IceMaxHexes = in.readInt("IceMaxHexes");
        this.RubbleMinSpots = in.readInt("RubbleMinSpots");
        this.RubbleMaxSpots = in.readInt("RubbleMaxSpots");
        this.RubbleMinHexes = in.readInt("RubbleMinHexes");
        this.RubbleMaxHexes = in.readInt("RubbleMaxHexes");
        this.FortifiedMinSpots = in.readInt("FortifiedMinSpots");
        this.FortifiedMaxSpots = in.readInt("FortifiedMaxSpots");
        this.FortifiedMinHexes = in.readInt("FortifiedMinHexes");
        this.FortifiedMaxHexes = in.readInt("FortifiedMaxHexes");
        this.MinBuildings = in.readInt("MinBuildings");
        this.MaxBuildings = in.readInt("MaxBuildings");
        this.MinCF = in.readInt("MinCF");
        this.MaxCF = in.readInt("MaxCF");
        this.MinFloors = in.readInt("MinFloors");
        this.MaxFloors = in.readInt("MaxFloors");
        this.BuildingTypes = in.readString("BuildingTypes");
    }

    public boolean equivalent(PlanetEnvironment other) {
        return this.CraterProb == other.CraterProb && this.CraterMinNum == other.CraterMinNum && this.CraterMaxNum == other.CraterMaxNum && this.CraterMinRadius == other.CraterMinRadius && this.CraterMaxRadius == other.CraterMaxRadius && this.Hillyness == other.Hillyness && this.HillElevationRange == other.HillElevationRange && this.HillInvertProb == other.HillInvertProb && this.WaterMinSpots == other.WaterMinSpots && this.WaterMaxSpots == other.WaterMaxSpots && this.WaterMinHexes == other.WaterMinHexes && this.WaterMaxHexes == other.WaterMaxHexes && this.WaterDeepProb == other.WaterDeepProb && this.ForestMinSpots == other.ForestMinSpots && this.ForestMaxSpots == other.ForestMaxSpots && this.ForestMinHexes == other.ForestMinHexes && this.ForestMaxHexes == other.ForestMaxHexes && this.ForestHeavyProb == other.ForestHeavyProb && this.RoughMinSpots == other.RoughMinSpots && this.RoughMaxSpots == other.RoughMaxSpots && this.RoughMinHexes == other.RoughMinHexes && this.RoughMaxHexes == other.RoughMaxHexes && this.SwampMinSpots == other.SwampMinSpots && this.SwampMaxSpots == other.SwampMaxSpots && this.SwampMinHexes == other.SwampMinHexes && this.SwampMaxHexes == other.SwampMaxHexes && this.PavementMinSpots == other.PavementMinSpots && this.PavementMaxSpots == other.PavementMaxSpots && this.PavementMinHexes == other.PavementMinHexes && this.PavementMaxHexes == other.PavementMaxHexes && this.IceMaxHexes == other.IceMaxHexes && this.IceMinSpots == other.IceMinSpots && this.IceMaxSpots == other.IceMaxSpots && this.IceMinHexes == other.IceMinHexes && this.RubbleMaxHexes == other.RubbleMaxHexes && this.RubbleMinHexes == other.RubbleMinHexes && this.RubbleMinSpots == other.RubbleMinSpots && this.RubbleMaxSpots == other.RubbleMaxSpots && this.FortifiedMaxHexes == other.FortifiedMaxHexes && this.FortifiedMinHexes == other.FortifiedMinHexes && this.FortifiedMinSpots == other.FortifiedMinSpots && this.FortifiedMaxSpots == other.FortifiedMaxSpots && this.MinBuildings == other.MinBuildings && this.MaxBuildings == other.MaxBuildings && this.MinCF == other.MinCF && this.MaxCF == other.MaxCF && this.MinFloors == other.MinFloors && this.MaxFloors == other.MaxFloors && this.BuildingTypes == other.BuildingTypes && this.RoadProb == other.RoadProb && this.RiverProb == other.RiverProb && this.Algorithm == other.Algorithm;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.Name;
    }

    public void setName(String name) {
        this.Name = name;
    }

    public String getTheme() {
        return this.Theme;
    }

    public void setTheme(String theme) {
        if (theme.length() <= 1) {
            theme = " ";
        }
        this.Theme = theme;
    }
}

