/*
 * Decompiled with CFR 0.152.
 */
package common.util;

import common.util.HTML;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public class BinReader {
    private BufferedReader in;
    private boolean debug;

    private String read(String debugName) throws IOException {
        String s = this.in.readLine();
        if (this.debug) {
            if (!s.substring(0, s.indexOf(61)).equals(debugName)) {
                throw new RuntimeException("serialization mismatch");
            }
            return s.substring(s.indexOf(61) + 1);
        }
        return s;
    }

    public BinReader(Reader in) {
        this.in = new BufferedReader(in);
        try {
            this.in.mark(100);
            String s = this.in.readLine();
            this.debug = s.equals("###DEBUG_ON###");
            if (!this.debug) {
                this.in.reset();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.debug = false;
        }
    }

    public int readInt(String debugName) throws IOException {
        return Integer.parseInt(this.read(debugName));
    }

    public double readDouble(String debugName) throws IOException {
        return Double.parseDouble(this.read(debugName));
    }

    public boolean readBoolean(String debugName) throws IOException {
        String s = this.read(debugName);
        return !s.equalsIgnoreCase("false") && !s.equals("0") && !s.equals("");
    }

    public String readLine(String debugName) throws IOException {
        return HTML.br2cr(this.read(debugName));
    }

    public String readStringLine(String debugName) throws IOException {
        return this.read(debugName);
    }

    public void close() throws IOException {
        this.in.close();
    }
}

