/*
 * Decompiled with CFR 0.152.
 */
package server;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import server.MMServ;
import server.campaign.CampaignMain;

public class SMWLogger {
    private static final int rotations = 5;
    private static final int normFileSize = 1000000;
    private static final int bigFileSize = 5000000;
    private static final int hugeFileSize = 10000000;
    private static boolean logging = false;
    private static boolean addSeconds = false;
    private static boolean clientlog = false;
    private static File logDir;
    private static Logger mainLog;
    private static Logger factionLog;
    private static Logger taskLog;
    private static Logger cmdLog;
    private static Logger pmLog;
    private static Logger bmLog;
    private static Logger infoLog;
    private static Logger warnLog;
    private static Logger errLog;
    private static Logger modLog;
    private static Logger cheatLog;
    private static Logger tickLog;
    private static MMNetFormatter mmnetFormatter;
    private static FileHandler mainHandler;
    private static FileHandler factionHandler;
    private static FileHandler taskHandler;
    private static FileHandler cmdHandler;
    private static FileHandler pmHandler;
    private static FileHandler bmHandler;
    private static FileHandler infoHandler;
    private static FileHandler warnHandler;
    private static FileHandler errHandler;
    private static FileHandler modHandler;
    private static FileHandler cheatHandler;
    private static FileHandler tickHandler;

    public SMWLogger() {
        this("logs");
    }

    public SMWLogger(String s) {
        if (logging) {
            return;
        }
        logDir = new File(s);
        if (!logDir.exists()) {
            try {
                if (!logDir.mkdirs()) {
                    MMServ.mmlog.errLog("WARNING: logging directory cannot be created!");
                    MMServ.mmlog.errLog("WARNING: disabling log subsystem");
                    return;
                }
            }
            catch (Exception e) {
                MMServ.mmlog.errLog(e);
            }
        } else if (!logDir.isDirectory()) {
            MMServ.mmlog.errLog("WARNING: logging directory is not a directory!");
            MMServ.mmlog.errLog("WARNING: disabling log subsystem");
            return;
        }
        if (!logDir.canWrite()) {
            MMServ.mmlog.errLog("WARNING: cannot write in logging directory!");
            MMServ.mmlog.errLog("WARNING: disabling log subsystem");
            return;
        }
        mmnetFormatter = new MMNetFormatter();
        try {
            mainHandler = new FileHandler(logDir.getPath() + "/mainlog", 5000000, 5, true);
            mainHandler.setLevel(Level.INFO);
            mainHandler.setFilter(null);
            mainHandler.setFormatter(mmnetFormatter);
            mainLog = Logger.getLogger("mainLogger");
            mainLog.setUseParentHandlers(false);
            mainLog.addHandler(mainHandler);
            factionHandler = new FileHandler(logDir.getPath() + "/factionlog", 5000000, 5, true);
            factionHandler.setLevel(Level.INFO);
            factionHandler.setFilter(null);
            factionHandler.setFormatter(mmnetFormatter);
            factionLog = Logger.getLogger("factionLogger");
            factionLog.setUseParentHandlers(false);
            factionLog.addHandler(factionHandler);
            taskHandler = new FileHandler(logDir.getPath() + "/tasklog", 5000000, 5, true);
            taskHandler.setLevel(Level.INFO);
            taskHandler.setFilter(null);
            taskHandler.setFormatter(mmnetFormatter);
            taskLog = Logger.getLogger("taskLogger");
            taskLog.setUseParentHandlers(false);
            taskLog.addHandler(taskHandler);
            cmdHandler = new FileHandler(logDir.getPath() + "/cmdlog", 10000000, 5, true);
            cmdHandler.setLevel(Level.INFO);
            cmdHandler.setFilter(null);
            cmdHandler.setFormatter(mmnetFormatter);
            cmdLog = Logger.getLogger("cmdLogger");
            cmdLog.setUseParentHandlers(false);
            cmdLog.addHandler(cmdHandler);
            pmHandler = new FileHandler(logDir.getPath() + "/pmlog", 5000000, 5, true);
            pmHandler.setLevel(Level.INFO);
            pmHandler.setFilter(null);
            pmHandler.setFormatter(mmnetFormatter);
            pmLog = Logger.getLogger("pmLogger");
            pmLog.setUseParentHandlers(false);
            pmLog.addHandler(pmHandler);
            bmHandler = new FileHandler(logDir.getPath() + "/bmlog", 1000000, 5, true);
            bmHandler.setLevel(Level.INFO);
            bmHandler.setFilter(null);
            bmHandler.setFormatter(mmnetFormatter);
            bmLog = Logger.getLogger("bmLogger");
            bmLog.setUseParentHandlers(false);
            bmLog.addHandler(bmHandler);
            infoHandler = new FileHandler(logDir.getPath() + "/infolog", 1000000, 5, true);
            infoHandler.setLevel(Level.INFO);
            infoHandler.setFilter(null);
            infoHandler.setFormatter(mmnetFormatter);
            infoLog = Logger.getLogger("infoLogger");
            infoLog.setUseParentHandlers(false);
            infoLog.addHandler(infoHandler);
            warnHandler = new FileHandler(logDir.getPath() + "/warnlog", 1000000, 5, true);
            warnHandler.setLevel(Level.INFO);
            warnHandler.setFilter(null);
            warnHandler.setFormatter(mmnetFormatter);
            warnLog = Logger.getLogger("warnLogger");
            warnLog.setUseParentHandlers(false);
            warnLog.addHandler(warnHandler);
            errHandler = new FileHandler(logDir.getPath() + "/errlog", 1000000, 5, true);
            errHandler.setLevel(Level.INFO);
            errHandler.setFilter(null);
            errHandler.setFormatter(mmnetFormatter);
            errLog = Logger.getLogger("errLogger");
            errLog.setUseParentHandlers(false);
            errLog.addHandler(errHandler);
            modHandler = new FileHandler(logDir.getPath() + "/modlog", 5000000, 5, true);
            modHandler.setLevel(Level.INFO);
            modHandler.setFilter(null);
            modHandler.setFormatter(mmnetFormatter);
            modLog = Logger.getLogger("modLogger");
            modLog.setUseParentHandlers(false);
            modLog.addHandler(modHandler);
            cheatHandler = new FileHandler(logDir.getPath() + "/cheatlog", 1000000, 5, true);
            cheatHandler.setLevel(Level.INFO);
            cheatHandler.setFilter(null);
            cheatHandler.setFormatter(mmnetFormatter);
            cheatLog = Logger.getLogger("cheatLogger");
            cheatLog.setUseParentHandlers(false);
            cheatLog.addHandler(cheatHandler);
            tickHandler = new FileHandler(logDir.getPath() + "/ticklog", 1000000, 5, true);
            tickHandler.setLevel(Level.INFO);
            tickHandler.setFilter(null);
            tickHandler.setFormatter(mmnetFormatter);
            tickLog = Logger.getLogger("tickLogger");
            tickLog.setUseParentHandlers(false);
            tickLog.addHandler(tickHandler);
            logging = true;
        }
        catch (Exception e) {
            MMServ.mmlog.errLog(e);
        }
    }

    public void mainLog(String s) {
        if (logging) {
            mainLog.info(s);
        }
    }

    public void factionLog(String s) {
        if (logging) {
            factionLog.info(s);
        }
    }

    public void taskLog(String s) {
        if (logging) {
            taskLog.info(s);
        }
    }

    public void cmdLog(String s) {
        String lower;
        if (logging && (lower = s.toLowerCase()).indexOf("hm#") == -1 && lower.indexOf("factionmail#") == -1) {
            cmdLog.info(s);
        }
    }

    public void pmLog(String s) {
        if (logging) {
            pmLog.info(s);
        }
    }

    public void bmLog(String s) {
        if (logging) {
            bmLog.info(s);
        }
    }

    public void infoLog(String s) {
        if (logging) {
            infoLog.info(s);
        }
    }

    public void log(String s) {
        if (logging) {
            infoLog.info(s);
        }
    }

    public void warnLog(String s) {
        if (logging) {
            warnLog.info(s);
        }
    }

    public void errLog(String s) {
        if (logging) {
            errLog.info(s);
            if (CampaignMain.cm != null) {
                CampaignMain.cm.doSendErrLog(s);
            }
        }
    }

    public void errLog(Exception e) {
        if (logging) {
            errLog.warning("[" + e.toString() + "]");
            if (CampaignMain.cm != null) {
                CampaignMain.cm.doSendErrLog("[" + e.toString() + "]");
            }
            StackTraceElement[] t = e.getStackTrace();
            for (int i = 0; i < t.length; ++i) {
                errLog.warning("   " + t[i].toString());
                if (CampaignMain.cm == null) continue;
                CampaignMain.cm.doSendErrLog("   " + t[i].toString());
            }
        }
    }

    public void modLog(String s) {
        if (logging) {
            modLog.info(s);
        }
    }

    public void cheatLog(String s) {
        if (logging) {
            cheatLog.info(s);
        }
    }

    public void tickLog(String s) {
        if (logging) {
            tickLog.info(s);
        }
    }

    public void enableSeconds(boolean b) {
        addSeconds = b;
    }

    public void enableLogging(boolean b) {
        logging = b;
    }

    public void client(boolean b) {
        clientlog = b;
    }

    public static synchronized void addToModeratorLog(String s) {
        try {
            FileOutputStream out = new FileOutputStream("./campaign/moderator.log", true);
            PrintStream p = new PrintStream(out);
            Date d = new Date(System.currentTimeMillis());
            p.println(d + ":" + s);
            p.close();
            out.close();
            CampaignMain.cm.doSendModMail("MODLOG: ", s);
        }
        catch (Exception ex) {
            MMServ.mmlog.errLog("Problems writing modlog to file");
            MMServ.mmlog.errLog(ex);
            MMServ.addToErrorLog(ex);
        }
    }

    public class MMNetFormatter
    extends SimpleFormatter {
        public String format(LogRecord record) {
            GregorianCalendar now = new GregorianCalendar();
            now.setTimeInMillis(record.getMillis());
            StringBuffer sb = new StringBuffer();
            sb.append(now.get(1));
            if (now.get(2) < 9) {
                sb.append("0");
            }
            sb.append(now.get(2) + 1);
            if (now.get(5) < 10) {
                sb.append("0");
            }
            sb.append(now.get(5) + " ");
            if (now.get(11) < 10) {
                sb.append("0");
            }
            sb.append(now.get(11) + ":");
            if (now.get(12) < 10) {
                sb.append("0");
            }
            if (addSeconds) {
                sb.append(now.get(12) + ":");
                if (now.get(13) < 10) {
                    sb.append("0");
                }
                sb.append(now.get(13) + "|" + this.formatMessage(record) + "\n");
            } else {
                sb.append(now.get(12) + "|" + this.formatMessage(record) + "\n");
            }
            return sb.toString();
        }
    }
}

