/*
 * Decompiled with CFR 0.152.
 */
package server;

import com.lyrisoft.chat.Translator;
import com.lyrisoft.chat.server.remote.AccessDenied;
import com.lyrisoft.chat.server.remote.AccessException;
import com.lyrisoft.chat.server.remote.ChatClient;
import com.lyrisoft.chat.server.remote.ChatServer;
import com.lyrisoft.chat.server.remote.persistence.auth.Auth;
import common.comm.TransportCodec;
import java.net.InetAddress;
import java.util.HashMap;
import server.MMServ;

public class ServerWrapper
extends ChatServer {
    MMServ myServer;

    public static ServerWrapper createServer(MMServ server) throws Exception {
        System.setProperty("NFC_HOME", ".");
        return new ServerWrapper(server);
    }

    public ServerWrapper(MMServ server) throws Exception {
        this.myServer = server;
    }

    public void start() {
        MMServ.mmlog.mainLog("Starting");
        this.acceptConnections();
    }

    public MMServ getMMServ() {
        return this.myServer;
    }

    public void processCommand(String username, String command) {
        if (username == null) {
            return;
        }
        try {
            this.myServer.clientRecieve(command, username);
        }
        catch (Exception e) {
            MMServ.mmlog.errLog(e);
        }
    }

    public void sendServerMessage(String msg, String name) {
        ChatClient client = this.getClient(ChatServer.clientKey(name));
        if (client != null) {
            try {
                client.sendRaw("/comm\t" + TransportCodec.encode(msg));
            }
            catch (Exception e) {
                MMServ.mmlog.errLog(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcastComm(String command) {
        HashMap hashMap = this._users;
        synchronized (hashMap) {
            for (ChatClient cc : this._users.values()) {
                this.sendServerMessage(command, ChatServer.clientKey(cc));
            }
        }
    }

    public boolean roomExists(String roomname) {
        if (roomname.equalsIgnoreCase("main")) {
            return true;
        }
        return this._distributedState.roomExists(roomname);
    }

    public InetAddress getIP(String username) {
        try {
            ChatClient c = this.getClient(username);
            if (c == null) {
                MMServ.mmlog.mainLog("WARNING: Tried to get the IP from " + username + ", who is not here.");
                this.myServer.clientLogout(username);
                try {
                    return InetAddress.getLocalHost();
                }
                catch (Exception ex) {
                    MMServ.addToErrorLog(ex);
                    return null;
                }
            }
            return InetAddress.getByName(c.getHost());
        }
        catch (Exception e) {
            MMServ.mmlog.errLog(e);
            try {
                return InetAddress.getLocalHost();
            }
            catch (Exception ex) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signOn(ChatClient client, String password) throws AccessException, AccessDenied {
        ServerWrapper.log(client.getUserId() + " is attempting a signon");
        String userId = client.getUserId();
        this.validateUserId(userId);
        Auth auth = null;
        auth = this._authenticator.authenticate(userId, password);
        client.setUserId(auth.getUserId());
        HashMap hashMap = this._users;
        synchronized (hashMap) {
            if (this._distributedState.userExists(ServerWrapper.clientKey(client))) {
                if (auth.getAccess() >= 2 || auth.getAccess() < 2 && client.getUserId().startsWith("[Dedicated]")) {
                    this.signOff(client.getServer().getClient(ServerWrapper.clientKey(client)));
                } else {
                    throw new AccessDenied(client.getUserId());
                }
            }
            int access = auth.getAccess();
            client.setAccessLevel(access);
            this._users.put(ServerWrapper.clientKey(client), client);
            ServerWrapper.log(client.getUserId() + " is authenticated.  Access = " + access + (client.getTunneling() ? " (tunneling)" : ""));
            ++this._cumulativeLogins;
        }
        client.ackSignon(auth.getUserId());
        this.sendMotd(client);
        this._distributedState.signon(this.getName(), userId);
        this.myServer.clientLogin(client.getUserId());
    }

    public void signOff(ChatClient client) {
        super.signOff(client);
        try {
            this.myServer.clientLogout(client.getUserId());
        }
        catch (Exception e) {
            MMServ.mmlog.errLog(e);
        }
    }

    protected void validateUserId(String user) throws AccessException {
        if (this.getName().toLowerCase().equals(user.toLowerCase())) {
            throw new AccessException(Translator.getMessage("reserved_name", this.getName()));
        }
        if ("server".equalsIgnoreCase(user)) {
            throw new AccessException(Translator.getMessage("reserved_name", "server"));
        }
        char[] chars = user.toLowerCase().toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (Character.isLetterOrDigit(chars[i]) || chars[i] == '_' || chars[i] == '-' || chars[i] == '(' || chars[i] == ')' || chars[i] == '[' || chars[i] == ']' || chars[i] == '{' || chars[i] == '}' || chars[i] == ' ' || chars[i] == '.' || chars[i] == '!' || chars[i] == '?') continue;
            throw new AccessException("/badchars");
        }
    }
}

