/*
 * Decompiled with CFR 0.152.
 */
package server.campaign;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.StringTokenizer;
import server.MMServ;
import server.campaign.CampaignMain;
import server.campaign.SUnit;
import server.campaign.util.TimeZoneData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildTable {
    private static Hashtable table;

    public BuildTable(String FileName) {
        table = Boolean.valueOf(CampaignMain.cm.getConfig("UseOldStyleBuildTables")) == false ? BuildTable.getNewListFromFile(new File(FileName)) : BuildTable.getListFromFile(new File(FileName));
    }

    public static String getUnitFilename(String unitProducer, String size, int type_id, TimeZoneData TZUsed) {
        boolean fileFound = false;
        String Filename = "";
        while (!fileFound) {
            BuildTable MechTable = BuildTable.getListFromFile(unitProducer, size, TZUsed.getName(), type_id);
            int totalentries = (Integer)table.get("TotalEntries");
            int ran = CampaignMain.cm.getR().nextInt(totalentries - 1) + 1;
            Filename = (String)BuildTable.getTable().get(new Integer(ran));
            if (Filename.indexOf(".") == -1) {
                unitProducer = Filename;
                continue;
            }
            fileFound = true;
        }
        return Filename;
    }

    public static String getUnitFilename(String unitFileName) {
        boolean fileFound = false;
        String Filename = "";
        while (!fileFound) {
            table = BuildTable.getNewListFromFile(new File(unitFileName));
            int totalentries = (Integer)table.get("TotalEntries");
            int ran = CampaignMain.cm.getR().nextInt(totalentries - 1) + 1;
            Filename = (String)BuildTable.getTable().get(new Integer(ran));
            if (Filename.indexOf(".") == -1) {
                unitFileName = Filename;
                continue;
            }
            fileFound = true;
        }
        return Filename;
    }

    private static BuildTable getListFromFile(String faction, String size, int Type2) {
        return BuildTable.getListFromFile(faction, size, "3025", Type2);
    }

    public static String getFileName(String faction, String size, String year, int Type2) {
        String result;
        String addon = "";
        if (Type2 != 0) {
            addon = SUnit.getTypeClassDesc(Type2);
        }
        if (!new File(result = "./data/buildtables/" + year + "/" + faction + "_" + size + addon + ".txt").exists()) {
            result = "./data/buildtables/" + year + "/Common_" + size + addon + ".txt";
        }
        return result;
    }

    private static BuildTable getListFromFile(String faction, String size, String year, int Type2) {
        return new BuildTable(BuildTable.getFileName(faction, size, year, Type2));
    }

    private static Hashtable<Object, Object> getNewListFromFile(File prodFile) {
        Hashtable<Object, Object> result = new Hashtable<Object, Object>();
        try {
            FileInputStream fis = new FileInputStream(prodFile);
            BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
            int totalentries = 0;
            int currentCount = 1;
            while (dis.ready()) {
                String l = dis.readLine();
                StringTokenizer ST = new StringTokenizer(l);
                if (!ST.hasMoreElements()) continue;
                int amount = Integer.parseInt((String)ST.nextElement());
                int from = currentCount;
                int to = currentCount + amount;
                currentCount += amount;
                String Filename = "";
                while (ST.hasMoreElements()) {
                    Filename = Filename + (String)ST.nextElement();
                    if (!ST.hasMoreElements()) continue;
                    Filename = Filename + " ";
                }
                for (int i = from; i <= to; ++i) {
                    result.put(new Integer(i), Filename);
                }
                if (to <= totalentries) continue;
                totalentries = to;
            }
            result.put("TotalEntries", new Integer(totalentries));
            dis.close();
            fis.close();
        }
        catch (Exception ex) {
            MMServ.addToErrorLog(ex);
            MMServ.mmlog.errLog(ex);
        }
        return result;
    }

    private static Hashtable<Object, Object> getListFromFile(File prodFile) {
        if (!Boolean.valueOf(CampaignMain.cm.getConfig("UseOldStyleBuildTables")).booleanValue()) {
            return BuildTable.getNewListFromFile(prodFile);
        }
        Hashtable<Object, Object> result = new Hashtable<Object, Object>();
        try {
            FileInputStream fis = new FileInputStream(prodFile);
            BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
            int totalentries = 0;
            while (dis.ready()) {
                String l = dis.readLine();
                StringTokenizer ST = new StringTokenizer(l);
                if (ST.hasMoreElements()) {
                    int from = Integer.parseInt((String)ST.nextElement());
                    int to = Integer.parseInt((String)ST.nextElement());
                    String Filename = "";
                    while (ST.hasMoreElements()) {
                        Filename = Filename + (String)ST.nextElement();
                        if (!ST.hasMoreElements()) continue;
                        Filename = Filename + " ";
                    }
                    for (int i = from; i <= to; ++i) {
                        result.put(new Integer(i), Filename);
                    }
                    if (to > totalentries) {
                        totalentries = to;
                    }
                }
                result.put("TotalEntries", new Integer(totalentries));
            }
            dis.close();
            fis.close();
        }
        catch (Exception ex) {
            MMServ.addToErrorLog(ex);
            MMServ.mmlog.errLog(ex);
        }
        return result;
    }

    public static Hashtable getTable() {
        return table;
    }
}

