/*
 * Decompiled with CFR 0.152.
 */
package server.campaign;

import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import common.CampaignData;
import common.House;
import common.Influences;
import common.TaskInfo;
import common.comm.ServerDescription;
import common.comm.ServerDescriptionList;
import common.util.MMNetXStream;
import gd.xml.XMLResponder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import megamek.client.Client;
import megamek.common.Mounted;
import megamek.common.WeaponType;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.cfg.Configuration;
import server.MMServ;
import server.campaign.BuildTable;
import server.campaign.DefaultServerOptions;
import server.campaign.NewbieHouse;
import server.campaign.NewbiePlanet;
import server.campaign.NormalHouse;
import server.campaign.SArmy;
import server.campaign.SHouse;
import server.campaign.SPlanet;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.SliceThread;
import server.campaign.TickThread;
import server.campaign.UnitCosts;
import server.campaign.commands.AcceptContractCommand;
import server.campaign.commands.ActivateCommand;
import server.campaign.commands.AddNewsCommand;
import server.campaign.commands.AddToMuseumCommand;
import server.campaign.commands.ArmyLowerLimiterCommand;
import server.campaign.commands.ArmyUpperLimiterCommand;
import server.campaign.commands.AttackCommand;
import server.campaign.commands.AutoBMStatusCommand;
import server.campaign.commands.AutoJoinGameCommand;
import server.campaign.commands.AutoPlanetStatusCommand;
import server.campaign.commands.BMStatusCommand;
import server.campaign.commands.BidCommand;
import server.campaign.commands.BuildTableListCommand;
import server.campaign.commands.BuyPilotsFromHouseCommand;
import server.campaign.commands.CalcDistCommand;
import server.campaign.commands.CancelOfferCommand;
import server.campaign.commands.CheckArmyEligibilityCommand;
import server.campaign.commands.CheckArmyLinkCommand;
import server.campaign.commands.CheckAttackCommand;
import server.campaign.commands.CheckDistCommand;
import server.campaign.commands.ClearPlayerOptionsCommand;
import server.campaign.commands.Command;
import server.campaign.commands.CreateArmyCommand;
import server.campaign.commands.DeactivateCommand;
import server.campaign.commands.DefectCommand;
import server.campaign.commands.DefendCommand;
import server.campaign.commands.DirectSellUnitCommand;
import server.campaign.commands.DisplayPlayerPersonalPilotQueueCommand;
import server.campaign.commands.DonateCommand;
import server.campaign.commands.DonatePilotCommand;
import server.campaign.commands.EmployeeHouseMailCommand;
import server.campaign.commands.EnrollCommand;
import server.campaign.commands.ExchangePilotInUnitCommand;
import server.campaign.commands.ExchangeUnitCommand;
import server.campaign.commands.FactionLeaderFluffCommand;
import server.campaign.commands.FactionLeaderMuteCommand;
import server.campaign.commands.FireTechsCommand;
import server.campaign.commands.GamesCommand;
import server.campaign.commands.HelpCommand;
import server.campaign.commands.HireTechsCommand;
import server.campaign.commands.HouseCommand;
import server.campaign.commands.HouseContractsCommand;
import server.campaign.commands.HouseMailCommand;
import server.campaign.commands.HouseRankingCommand;
import server.campaign.commands.HouseStatusCommand;
import server.campaign.commands.ISStatusCommand;
import server.campaign.commands.LastOnlineCommand;
import server.campaign.commands.LinkUnitCommand;
import server.campaign.commands.ListCommandsCommand;
import server.campaign.commands.LoginCommand;
import server.campaign.commands.LogoutCommand;
import server.campaign.commands.MOTDCommand;
import server.campaign.commands.MercStatusCommand;
import server.campaign.commands.MyBidsCommand;
import server.campaign.commands.MyStatusCommand;
import server.campaign.commands.MyVotesCommand;
import server.campaign.commands.NameArmyCommand;
import server.campaign.commands.NamePilotCommand;
import server.campaign.commands.NoPlayCommand;
import server.campaign.commands.NotifyFightingCommand;
import server.campaign.commands.OfferContractCommand;
import server.campaign.commands.PlanetCommand;
import server.campaign.commands.PlayersCommand;
import server.campaign.commands.RangeCommand;
import server.campaign.commands.RecallCommand;
import server.campaign.commands.RefreshFactoryCommand;
import server.campaign.commands.RefuseContractCommand;
import server.campaign.commands.RemoveArmyCommand;
import server.campaign.commands.RemoveVoteCommand;
import server.campaign.commands.RepairUnitCommand;
import server.campaign.commands.RepodCommand;
import server.campaign.commands.RequestCommand;
import server.campaign.commands.RequestDonatedCommand;
import server.campaign.commands.RequestServerMailCommand;
import server.campaign.commands.RetirePilotCommand;
import server.campaign.commands.ScrapCommand;
import server.campaign.commands.SellCommand;
import server.campaign.commands.SendToMiscCommand;
import server.campaign.commands.ServerVersionCommand;
import server.campaign.commands.SetAutoEjectCommand;
import server.campaign.commands.SetClientVersionCommand;
import server.campaign.commands.SetMOTDCommand;
import server.campaign.commands.SetMaintainedCommand;
import server.campaign.commands.SetMyLogoCommand;
import server.campaign.commands.SetPlayerOptionCommand;
import server.campaign.commands.SetSearchLightCommand;
import server.campaign.commands.SetTargetSystemTypeCommand;
import server.campaign.commands.SetUnitAmmoCommand;
import server.campaign.commands.SetUnitBurstCommand;
import server.campaign.commands.SetUnitRepairCommand;
import server.campaign.commands.SetUnmaintainedCommand;
import server.campaign.commands.ShowToHouseCommand;
import server.campaign.commands.StatusCommand;
import server.campaign.commands.TerminateCommand;
import server.campaign.commands.TickCommand;
import server.campaign.commands.TransferMoneyCommand;
import server.campaign.commands.TransferPilotCommand;
import server.campaign.commands.TransferUnitCommand;
import server.campaign.commands.UnemployedMercsCommand;
import server.campaign.commands.UnenrollCommand;
import server.campaign.commands.UnitPositionCommand;
import server.campaign.commands.UseRewardPointsCommand;
import server.campaign.commands.VoteCommand;
import server.campaign.commands.admin.AddOmniVariantModCommand;
import server.campaign.commands.admin.AddServerCommand;
import server.campaign.commands.admin.AddTraitCommand;
import server.campaign.commands.admin.AdminAllowHouseDefectionCommand;
import server.campaign.commands.admin.AdminChangePlanetOwnerCommand;
import server.campaign.commands.admin.AdminChangeServerConfigCommand;
import server.campaign.commands.admin.AdminCreateFactionCommand;
import server.campaign.commands.admin.AdminCreateFactoryCommand;
import server.campaign.commands.admin.AdminCreatePlanetCommand;
import server.campaign.commands.admin.AdminCreateSolarisCommand;
import server.campaign.commands.admin.AdminCreateTerrainCommand;
import server.campaign.commands.admin.AdminDestroyFactoryCommand;
import server.campaign.commands.admin.AdminDestroyPlanetCommand;
import server.campaign.commands.admin.AdminDestroyTerrainCommand;
import server.campaign.commands.admin.AdminDonateCommand;
import server.campaign.commands.admin.AdminExchangePlanetOwnershipCommand;
import server.campaign.commands.admin.AdminGrantComponentsCommand;
import server.campaign.commands.admin.AdminHousePilotsCommand;
import server.campaign.commands.admin.AdminHouseStatusCommand;
import server.campaign.commands.admin.AdminListAndRemoveOMGCommand;
import server.campaign.commands.admin.AdminListHouseBannedAmmoCommand;
import server.campaign.commands.admin.AdminListServerBannedAmmoCommand;
import server.campaign.commands.admin.AdminLockCampaignCommand;
import server.campaign.commands.admin.AdminLockFactoryCommand;
import server.campaign.commands.admin.AdminPasswordCommand;
import server.campaign.commands.admin.AdminPlayerStatusCommand;
import server.campaign.commands.admin.AdminRemoveUnitsOnMarketCommand;
import server.campaign.commands.admin.AdminResetAllInfluenceCommand;
import server.campaign.commands.admin.AdminResetHouseRankingsCommand;
import server.campaign.commands.admin.AdminSaveCommand;
import server.campaign.commands.admin.AdminSaveCommandLevelsCommand;
import server.campaign.commands.admin.AdminSavePlanetsToXMLCommand;
import server.campaign.commands.admin.AdminSaveServerConfigsCommand;
import server.campaign.commands.admin.AdminScrapCommand;
import server.campaign.commands.admin.AdminSetCommandLevelCommand;
import server.campaign.commands.admin.AdminSetHouseAmmoBanCommand;
import server.campaign.commands.admin.AdminSetHouseComponentModCommand;
import server.campaign.commands.admin.AdminSetHouseFluFileCommand;
import server.campaign.commands.admin.AdminSetHousePlayerColorCommand;
import server.campaign.commands.admin.AdminSetHousePriceModCommand;
import server.campaign.commands.admin.AdminSetPlanetBoardSizeCommand;
import server.campaign.commands.admin.AdminSetPlanetGravityCommand;
import server.campaign.commands.admin.AdminSetPlanetMapSizeCommand;
import server.campaign.commands.admin.AdminSetPlanetTemperatureCommand;
import server.campaign.commands.admin.AdminSetPlanetVacuumCommand;
import server.campaign.commands.admin.AdminSetServerAmmoBanCommand;
import server.campaign.commands.admin.AdminTerminateAllCommand;
import server.campaign.commands.admin.AdminTransferCommand;
import server.campaign.commands.admin.AdminUnlockCampaignCommand;
import server.campaign.commands.admin.AdminViewLogCommand;
import server.campaign.commands.admin.CampaignConfigCommand;
import server.campaign.commands.admin.ChangeHouseColorCommand;
import server.campaign.commands.admin.ChangeNameCommand;
import server.campaign.commands.admin.CreateMercFactionCommand;
import server.campaign.commands.admin.CreateUnitCommand;
import server.campaign.commands.admin.DeleteAccountCommand;
import server.campaign.commands.admin.FluffCommand;
import server.campaign.commands.admin.ForcedDefectCommand;
import server.campaign.commands.admin.GrantControlCommand;
import server.campaign.commands.admin.RemoveTraitCommand;
import server.campaign.commands.admin.ServerGameOptionsCommand;
import server.campaign.commands.admin.SetAdvancePlanetTerrainCommand;
import server.campaign.commands.admin.SetHouseConquerCommand;
import server.campaign.commands.admin.SetHouseInHouseAttacksCommand;
import server.campaign.commands.admin.SetHouseLogoCommand;
import server.campaign.commands.admin.SetMultiPlayerGroupCommand;
import server.campaign.commands.admin.SetPlanetConquerCommand;
import server.campaign.commands.admin.SetPlanetMinOwnerShipCommand;
import server.campaign.commands.admin.SingASongCommand;
import server.campaign.commands.admin.StripUnitsCommand;
import server.campaign.commands.helpers.HireAndMaintainHelper;
import server.campaign.commands.helpers.HireAndRequestNewHelper;
import server.campaign.commands.helpers.HireAndRequestUsedHelper;
import server.campaign.commands.helpers.RemoveAndAddNoPlayHelper;
import server.campaign.commands.mod.CheckCommand;
import server.campaign.commands.mod.GetModLogCommand;
import server.campaign.commands.mod.GetPlayerUnitsCommand;
import server.campaign.commands.mod.GrantEXPCommand;
import server.campaign.commands.mod.GrantInfluenceCommand;
import server.campaign.commands.mod.GrantMoneyCommand;
import server.campaign.commands.mod.GrantRewardCommand;
import server.campaign.commands.mod.HardTerminateCommand;
import server.campaign.commands.mod.ListMultiPlayerGroupsCommand;
import server.campaign.commands.mod.ModDeactivateCommand;
import server.campaign.commands.mod.ModFullRepairCommand;
import server.campaign.commands.mod.ModGamesCommand;
import server.campaign.commands.mod.ModLogCommand;
import server.campaign.commands.mod.ModNoPlayCommand;
import server.campaign.commands.mod.ModTerminateCommand;
import server.campaign.commands.mod.ModeratorMailCommand;
import server.campaign.commands.mod.SetEloCommand;
import server.campaign.commands.mod.SetPricemodCommand;
import server.campaign.commands.mod.TerminateContractCommand;
import server.campaign.commands.mod.TouchCommand;
import server.campaign.commands.mod.UnlockLancesCommand;
import server.campaign.event.StatusChangeEvent;
import server.campaign.event.StatusChangeListener;
import server.campaign.market.Market;
import server.campaign.market.MarketUnit;
import server.campaign.mercenaries.MercHouse;
import server.campaign.operations.Operation;
import server.campaign.operations.OperationManager;
import server.campaign.operations.ShortOperation;
import server.campaign.pilot.SPilot;
import server.campaign.pilot.skills.AstechSkill;
import server.campaign.pilot.skills.DodgeManeuverSkill;
import server.campaign.pilot.skills.EnhancedInterfaceSkill;
import server.campaign.pilot.skills.GiftedSkill;
import server.campaign.pilot.skills.GunneryBallisticSkill;
import server.campaign.pilot.skills.GunneryLaserSkill;
import server.campaign.pilot.skills.GunneryMissileSkill;
import server.campaign.pilot.skills.IronManSkill;
import server.campaign.pilot.skills.ManeuveringAceSkill;
import server.campaign.pilot.skills.MeleeSpecialistSkill;
import server.campaign.pilot.skills.NaturalAptitudeGunnerySkill;
import server.campaign.pilot.skills.NaturalAptitudePilotingSkill;
import server.campaign.pilot.skills.PainResistanceSkill;
import server.campaign.pilot.skills.QuickStudySkill;
import server.campaign.pilot.skills.SPilotSkill;
import server.campaign.pilot.skills.SurvivalistSkill;
import server.campaign.pilot.skills.TacticalGeniusSkill;
import server.campaign.pilot.skills.TraitSkill;
import server.campaign.pilot.skills.WeaponSpecialistSkill;
import server.campaign.util.HouseEntry;
import server.campaign.util.HouseEntryKeeper;
import server.campaign.util.HouseRankingHelpContainer;
import server.campaign.util.MechStatistics;
import server.campaign.util.MechStatsKeeper;
import server.campaign.util.PlanetEntry;
import server.campaign.util.PlanetEntryKeeper;
import server.campaign.util.Statistics;
import server.campaign.util.UnitEntry;
import server.campaign.util.UnitEntryKeeper;
import server.campaign.util.XMLFactionDataParser;
import server.campaign.util.XMLPlanetDataParser;
import server.campaign.util.XMLTerrainDataParser;
import server.campaign.votes.VoteManager;
import server.dataProvider.Server;
import server.util.AutomaticBackup;
import server.util.RepairTrackingThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CampaignMain
implements Serializable,
StatusChangeListener {
    private static final long serialVersionUID = -8671163467590633378L;
    public static CampaignMain cm;
    public static DefaultServerOptions dso;
    MMServ myServer;
    Hashtable<String, SPlayer> players = new Hashtable();
    Hashtable<String, SPlayer> savePlayers = new Hashtable();
    CampaignData data = new CampaignData();
    Hashtable activePlayers = new Hashtable();
    Hashtable<String, Object> Commands = new Hashtable();
    MechStatsKeeper MechStats = new MechStatsKeeper();
    Properties config = new Properties();
    Hashtable<String, String> omniVariantMods = new Hashtable();
    int TaskID;
    int gamesCompleted;
    Hashtable<Integer, Object> pilotSkills = new Hashtable();
    Random r = new Random();
    Vector unresolvedContracts = new Vector();
    TickThread TThread;
    SliceThread SThread;
    Server dataProviderServer;
    Market market;
    VoteManager voteManager;
    OperationManager opsManager;
    ServerDescriptionList serverDescriptions = new ServerDescriptionList();
    private double biggestX;
    private double biggestY;
    private double biggestPosX;
    private double biggestNegX;
    private double biggestPosY;
    private double biggestNegY;
    LinkedList<String> NewsFeed = new LinkedList();
    SessionFactory factory;
    private int currentUnitID = 1;
    AutomaticBackup aub = new AutomaticBackup(System.currentTimeMillis());
    UnitCosts unitCostLists = null;
    private boolean isArchiving = false;
    private Client megaMekClient = new Client("MWServer", "None", 0);
    RepairTrackingThread RTT = null;

    public CampaignMain(MMServ serv) {
        int n;
        String line;
        BufferedReader dis;
        File configFile;
        cm = this;
        this.myServer = serv;
        dso = new DefaultServerOptions();
        dso.createDefaults();
        try {
            this.config.putAll((Map<?, ?>)dso.getServerDefaults());
            this.config.load(new FileInputStream(this.myServer.getConfigParam("CAMPAIGNCONFIG")));
        }
        catch (Exception ex) {
            MMServ.mmlog.errLog("Problems with loading campaign config");
            MMServ.mmlog.errLog(ex);
            MMServ.addToErrorLog(ex);
            dso.createConfig();
            try {
                this.config.load(new FileInputStream(this.myServer.getConfigParam("CAMPAIGNCONFIG")));
            }
            catch (Exception ex1) {
                MMServ.mmlog.errLog("Problems with loading campaing config from defaults");
                MMServ.mmlog.errLog(ex1);
                MMServ.addToErrorLog(ex1);
                System.exit(1);
            }
        }
        dso.createConfig();
        this.addToNewsFeed("MekWars Server Started!");
        this.initializePilotSkills();
        StringTokenizer st = new StringTokenizer(this.getConfig("OwnServerDescription"), "$");
        ServerDescriptionList.ownServerDescription.decode(st);
        while (st.hasMoreTokens()) {
            ServerDescription sd = new ServerDescription();
            sd.decode(st);
            this.serverDescriptions.update(sd);
        }
        this.serverDescriptions.load(this.getConfig("ServerDescription"));
        this.data = new CampaignData();
        MMServ.mmlog.infoLog("Loading MegaMek Game Options");
        this.megaMekClient.game.getOptions().loadOptions("");
        new XMLTerrainDataParser("./data/terrain.xml");
        cm.loadTopUnitID();
        this.gamesCompleted = 0;
        File xmldata = new File("./campaign/data.xml");
        boolean xmldataexists = true;
        if (xmldata.exists()) {
            try {
                this.loadData();
            }
            catch (Throwable t) {
                MMServ.mmlog.errLog(t.getMessage());
                xmldataexists = false;
            }
        } else {
            xmldataexists = false;
        }
        if (!xmldataexists) {
            try {
                File configFile2 = new File("./campaign/houses.dat");
                FileInputStream fis2 = new FileInputStream(configFile2);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fis2));
                while (bufferedReader.ready()) {
                    SHouse h;
                    String line2 = bufferedReader.readLine();
                    if (line2.startsWith("[N][C]")) {
                        line2 = line2.substring(6);
                        h = new NewbieHouse(this.data.getUnusedHouseID());
                    } else if (line2.startsWith("[N]")) {
                        line2 = line2.substring(3);
                        h = new NewbieHouse(this.data.getUnusedHouseID());
                    } else if (line2.startsWith("[M]")) {
                        line2 = line2.substring(3);
                        h = new MercHouse(this.data.getUnusedHouseID());
                    } else {
                        h = new NormalHouse(this.data.getUnusedHouseID());
                    }
                    h.addStatusListener(this);
                    h.fromString(line2, this.r);
                    this.addHouse(h);
                }
                bufferedReader.close();
                fis2.close();
            }
            catch (Exception ex) {
                MMServ.mmlog.errLog(ex);
                MMServ.mmlog.errLog("House data not found. Creating empty faction data");
                MMServ.mmlog.mainLog("House-Data not found creating...");
            }
            try {
                File configFile2 = new File("./campaign/planets.dat");
                FileInputStream fis = new FileInputStream(configFile2);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fis));
                while (bufferedReader.ready()) {
                    SPlanet p;
                    String line2 = bufferedReader.readLine();
                    if (line2.startsWith("[N]")) {
                        line2 = line2.substring(3);
                        p = new NewbiePlanet();
                    } else {
                        p = new SPlanet();
                    }
                    p.fromString(line2, this.r, this.data);
                    this.addPlanet(p);
                }
                bufferedReader.close();
                fis.close();
                for (SPlanet p : this.data.getAllPlanets()) {
                    if (p.getOwner() == null) continue;
                    p.getOwner().addPlanet(p);
                }
            }
            catch (Exception ex) {
                MMServ.mmlog.errLog(ex);
                MMServ.mmlog.errLog("Planetary data not found. Creating empty planetary data");
                MMServ.mmlog.mainLog("Planet-Data not found creating...");
            }
        }
        this.market = new Market();
        Enumeration enumeration = this.getAllPlayers().elements();
        while (enumeration.hasMoreElements()) {
            ((SPlayer)enumeration.nextElement()).setUnitsOnMarket(new Vector());
        }
        if (!this.useHibernate()) {
            try {
                configFile = new File("./campaign/bm.dat");
                FileInputStream fileInputStream = new FileInputStream(configFile);
                dis = new BufferedReader(new InputStreamReader(fileInputStream));
                while (dis.ready()) {
                    line = dis.readLine();
                    MarketUnit m = new MarketUnit();
                    m.fromString(line, this);
                    this.getMarket().addUnit(m);
                }
                dis.close();
                fileInputStream.close();
            }
            catch (Exception ex) {
                MMServ.mmlog.errLog("Problems reading black market data");
                MMServ.mmlog.mainLog("No BM Data found");
            }
        }
        try {
            configFile = new File("./campaign/banammo.dat");
            FileInputStream fileInputStream = new FileInputStream(configFile);
            dis = new BufferedReader(new InputStreamReader(fileInputStream));
            while (dis.ready()) {
                line = dis.readLine();
                this.loadBanAmmo(line);
            }
            dis.close();
            fileInputStream.close();
        }
        catch (Exception ex) {
            MMServ.mmlog.errLog("Problems reading banned ammo data");
            MMServ.mmlog.mainLog("No BM Data found");
        }
        cm.loadOmniVariantMods();
        for (SHouse sHouse : this.data.getAllHouses()) {
            sHouse.ResetPlayers();
        }
        if (Boolean.valueOf(cm.getConfig("UseCalculatedCosts")).booleanValue()) {
            this.unitCostLists = new UnitCosts();
            this.unitCostLists.loadUnitCosts();
        }
        this.TThread = new TickThread(this, Integer.parseInt(this.getConfig("TickTime")));
        this.TThread.start();
        this.SThread = new SliceThread(this, Integer.parseInt(this.getConfig("SliceTime")));
        this.SThread.start();
        this.init();
        Iterator<House> e = this.data.getAllPlanets().iterator();
        this.biggestX = 0.0;
        this.biggestY = 0.0;
        this.biggestPosY = 0.0;
        this.biggestPosX = 0.0;
        this.biggestNegY = 0.0;
        this.biggestNegX = 0.0;
        while (e.hasNext()) {
            double y;
            SPlanet sPlanet = (SPlanet)((Object)e.next());
            double x = sPlanet.getPosition().getX();
            if (x < 0.0) {
                if ((x *= -1.0) > this.biggestNegX) {
                    this.biggestNegX = x;
                }
            } else if (x > this.biggestPosX) {
                this.biggestPosX = x;
            }
            if (x > this.biggestX) {
                this.biggestX = x;
            }
            if ((y = sPlanet.getPosition().getY()) < 0.0) {
                if ((y *= -1.0) > this.biggestNegY) {
                    this.biggestNegY = y;
                }
            } else if (y > this.biggestPosY) {
                this.biggestPosY = y;
            }
            if (!(y > this.biggestY)) continue;
            this.biggestY = y;
        }
        try {
            File file = new File("./campaign/mechstat.dat");
            FileInputStream fis3 = new FileInputStream(file);
            BufferedReader dis3 = new BufferedReader(new InputStreamReader(fis3));
            while (dis3.ready()) {
                String line3 = dis3.readLine();
                MechStatistics m = new MechStatistics(line3);
                this.MechStats.put(m.getMechFileName(), m);
            }
            dis3.close();
            fis3.close();
        }
        catch (Exception exception) {
            MMServ.mmlog.errLog("Problems reading unit statistics data");
            MMServ.mmlog.errLog(exception);
            MMServ.addToErrorLog(exception);
            MMServ.mmlog.mainLog("No Mech Statistic Data found");
        }
        if (Boolean.valueOf(this.getConfig("HTMLOUTPUT")).booleanValue()) {
            Statistics.doRanking();
        }
        this.voteManager = new VoteManager(this);
        int n2 = 4867;
        try {
            n = Integer.parseInt(this.myServer.getConfigParam("DATAPORT"));
        }
        catch (NumberFormatException x) {
            // empty catch block
        }
        this.opsManager = new OperationManager();
        this.dataProviderServer = new Server(this.data, n);
        Thread t = new Thread(this.dataProviderServer);
        t.start();
        if (Boolean.valueOf(cm.getConfig("UseAdvanceRepair")).booleanValue()) {
            this.RTT = new RepairTrackingThread(Long.parseLong(cm.getConfig("TimeForEachRepairPoint")) * 1000L);
            this.RTT.start();
        }
    }

    public void saveData() {
        try {
            this.data.saveData(new File("campaign"));
        }
        catch (IOException e) {
            MMServ.mmlog.errLog(e);
        }
    }

    public void loadData() throws Throwable {
        System.gc();
        MMServ.mmlog.mainLog("loading main xml-cache...");
        this.data = CampaignData.loadData(new File("campaign"));
        MMNetXStream xml = new MMNetXStream((HierarchicalStreamDriver)new DomDriver());
        for (SHouse sHouse : this.data.getAllHouses()) {
            MMServ.mmlog.mainLog("loading " + sHouse.getName() + "'s data...");
            sHouse.setMembers((Hashtable)xml.fromXML(new FileReader("./campaign/members" + sHouse.getName() + ".xml")));
            sHouse.recalcWarefactionsAndComponents();
        }
        System.gc();
        for (SHouse sHouse : this.data.getAllHouses()) {
            sHouse.addStatusListener(this);
            sHouse.postXMLLoading();
        }
    }

    public boolean isDebugEnabled() {
        return this.myServer.isDebug();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toFile() {
        try {
            int c;
            FileOutputStream out = new FileOutputStream("./campaign/planets.dat");
            PrintStream p = new PrintStream(out);
            for (SPlanet sPlanet : this.data.getAllPlanets()) {
                p.println(sPlanet.toString());
            }
            p.close();
            out.close();
            out = new FileOutputStream("./campaign/houses.dat");
            p = new PrintStream(out);
            for (SHouse sHouse : this.data.getAllHouses()) {
                p.println(sHouse.toString());
            }
            p.close();
            out.close();
            out = new FileOutputStream("./campaign/bm.dat");
            p = new PrintStream(out);
            Enumeration enumeration = this.market.getAllUnits().elements();
            while (enumeration.hasMoreElements()) {
                MarketUnit m = (MarketUnit)enumeration.nextElement();
                p.println(m.toString(new String(""), false));
            }
            p.close();
            out.close();
            out = new FileOutputStream("./campaign/banammo.dat");
            p = new PrintStream(out);
            Enumeration<String> ban = cm.getServerBannedAmmo().keys();
            p.print("server#");
            while (ban.hasMoreElements()) {
                String ammo = ban.nextElement();
                p.print(ammo);
                p.print("#");
            }
            p.println();
            for (SHouse sHouse : this.data.getAllHouses()) {
                if (sHouse.getBannedAmmo().size() < 1) continue;
                ban = sHouse.getBannedAmmo().keys();
                p.print(sHouse.getName() + "#");
                while (ban.hasMoreElements()) {
                    String ammo = ban.nextElement();
                    p.print(ammo);
                    p.print("#");
                }
                p.println();
            }
            p.close();
            out.close();
            FileInputStream fileInputStream = new FileInputStream("./campaign/planets.dat");
            out = new FileOutputStream("./campaign/planets.bak");
            while ((c = fileInputStream.read()) != -1) {
                out.write(c);
            }
            fileInputStream.close();
            out.close();
            FileInputStream fileInputStream2 = new FileInputStream("./campaign/houses.dat");
            out = new FileOutputStream("./campaign/houses.bak");
            while ((c = fileInputStream2.read()) != -1) {
                out.write(c);
            }
            fileInputStream2.close();
            out.close();
            FileInputStream fileInputStream3 = new FileInputStream("./campaign/bm.dat");
            out = new FileOutputStream("./campaign/bm.bak");
            while ((c = fileInputStream3.read()) != -1) {
                out.write(c);
            }
            fileInputStream3.close();
            out.close();
            cm.saveOmniVariantMods();
            if (!this.useHibernate()) {
                out = new FileOutputStream("./campaign/mechstat.dat");
                p = new PrintStream(out);
                Enumeration ei = this.MechStats.elements();
                while (ei.hasMoreElements()) {
                    MechStatistics m = (MechStatistics)ei.nextElement();
                    p.println(m.toString());
                }
                p.close();
                out.close();
                try {
                    out = new FileOutputStream(this.getConfig("MechstatPath"));
                    p = new PrintStream(out);
                    p.println("<html><head><link rel=\"stylesheet\" type=\"text/css\" href=\"format.css\"><style type=\"text/css\"></style></head><body><font face=\"Verdana, Arial, Helvetica, sans-serif\">");
                    for (int i = 0; i <= 3; ++i) {
                        p.println(Statistics.doGetMechStats(i));
                        p.println("<br>");
                    }
                    p.println("</font></body></style></html>");
                    p.close();
                    out.close();
                }
                catch (FileNotFoundException efnf) {
                    // empty catch block
                }
            }
            this.market.WriteMarketStatistic();
            MMServ.mmlog.mainLog("STATUS SAVED");
        }
        catch (Exception ex) {
            MMServ.mmlog.errLog("Problems saving configuration to file");
            MMServ.mmlog.errLog(ex);
            MMServ.addToErrorLog(ex);
        }
        finally {
            try {
                File dir = new File(this.getConfig("LockFilePath"));
                dir.delete();
            }
            catch (Exception ex) {
                MMServ.mmlog.errLog("Couldn't delete Lock file.. whatever.. ignoring it!");
            }
        }
    }

    public boolean isLoggedIn(String Username) {
        if (Username.startsWith("[Dedicated]")) {
            return true;
        }
        SHouse h = this.getHouseForPlayer(Username);
        if (h != null) {
            return h.isLoggedIn(Username);
        }
        return false;
    }

    public String getConfig(String key) {
        if (this.config.getProperty(key) == null) {
            if (dso.getServerDefaults().getProperty(key) == null) {
                MMServ.mmlog.mainLog("You're missing the config variable: " + key + " in campaignconfig!");
                MMServ.mmlog.errLog("You're missing the config variable: " + key + " in campaignconfig! returning -1");
                cm.doSendModMail("Error", "The Server is missing the config variable: " + key + " in campaignconfig! returning -1");
                return "-1";
            }
            return dso.getServerDefaults().getProperty(key).trim();
        }
        return this.config.getProperty(key).trim();
    }

    public OperationManager getOpsManager() {
        return this.opsManager;
    }

    public void fromUser(String text, String Username) {
        StringTokenizer ST;
        if (!this.isLoggedIn(Username) && text.toUpperCase().indexOf("ENROLL") == -1 && text.toUpperCase().indexOf("LOGIN") == -1 && text.toUpperCase().indexOf("HOUSESTATUS") == -1) {
            this.toUser("You are not logged in!", Username, true);
            text = "  ";
        }
        if ((ST = new StringTokenizer(text = text.substring(2), "#")).hasMoreElements()) {
            String task = ((String)ST.nextElement()).toUpperCase();
            if (!task.equals("pong")) {
                try {
                    this.getPlayer(Username).setLastTimeCommandSent(System.currentTimeMillis());
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (this.Commands.get(task) != null) {
                MMServ.mmlog.cmdLog(Username + ": " + text);
                Command c = (Command)this.Commands.get(task);
                c.process(ST, Username);
                return;
            }
        }
    }

    public SPlanet getPlanetFromPartialString(String PlanetName, String Username) {
        Iterator e = this.data.getAllPlanets().iterator();
        SPlanet theone = null;
        boolean found = false;
        while (e.hasNext() && !found) {
            SPlanet p = (SPlanet)e.next();
            if (p.getName().equals(PlanetName)) {
                theone = p;
                found = true;
                continue;
            }
            if (p.getName().indexOf(PlanetName) == -1) continue;
            if (theone == null) {
                theone = p;
                continue;
            }
            this.toUser("This String was not unique, please be more specific.", Username, true);
            return null;
        }
        if (theone == null) {
            this.toUser("Couldn't find a Planet with this name.", Username, true);
            return null;
        }
        return theone;
    }

    public void doSendHouseMail(SHouse h, String Username, String text) {
        String name;
        MMServ.mmlog.factionLog(Username + "[" + h.getAbbreviation() + "]: " + text);
        text = "(Housemail)" + Username + ":" + text;
        Enumeration e = h.getActMembers().keys();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            this.toUser(text, name, true);
        }
        e = h.getFightingMembers().keys();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            this.toUser(text, name, true);
        }
    }

    public void doSendModMail(String Username, String text) {
        MMServ.mmlog.modLog("[MM] " + Username + ": " + text);
        text = "(Moderator Mail) " + Username + ": " + text;
        Enumeration<String> e = this.players.keys();
        while (e.hasMoreElements()) {
            String name = e.nextElement();
            Command command = (Command)cm.getServerCommands().get("MM");
            if (cm.getServer().getUserLevel(name) < command.getExecutionLevel()) continue;
            this.toUser(text, name, true);
        }
    }

    public void doSendErrLog(String text) {
        text = "(Error Log): " + text;
        Enumeration<String> e = this.players.keys();
        while (e.hasMoreElements()) {
            String name = e.nextElement();
            Command command = (Command)cm.getServerCommands().get("MM");
            if (cm.getServer().getUserLevel(name) < command.getExecutionLevel()) continue;
            this.toUser(text, name, true);
        }
    }

    public MechStatistics getMechstats(String Mechfile) {
        return (MechStatistics)this.MechStats.get(Mechfile);
    }

    public MechStatsKeeper getMechStats() {
        return this.MechStats;
    }

    public void doProcessAutomaticReport(String s, String Username) {
        if (s.indexOf(Username) == -1) {
            return;
        }
        SPlayer reporter = this.getPlayer(Username);
        if (reporter == null) {
            return;
        }
        ShortOperation so = this.getOpsManager().getShortOpForPlayer(reporter);
        if (so == null) {
            return;
        }
        if (so.hasPlayer(reporter)) {
            Operation o = this.getOpsManager().getOperation(so.getName());
            this.getOpsManager().resolveShortAttack(o, so, s);
            return;
        }
    }

    public void addInProgressUpdate(String s, String Username) {
        SPlayer reporter = this.getPlayer(Username);
        if (reporter == null) {
            return;
        }
        ShortOperation so = this.getOpsManager().getShortOpForPlayer(reporter);
        if (so == null) {
            return;
        }
        if (so.getAllPlayerNames().size() > 2) {
            return;
        }
        so.addInProgressUpdate(s);
    }

    public CampaignData getData() {
        return this.data;
    }

    public Hashtable getAllPlayers() {
        Iterator<House> e = this.data.getAllHouses().iterator();
        Hashtable<String, SPlayer> result = new Hashtable<String, SPlayer>();
        while (e.hasNext()) {
            SHouse h = (SHouse)e.next();
            result.putAll(h.getMembers());
        }
        return result;
    }

    public Vector getMercHouses() {
        Vector<SHouse> result = new Vector<SHouse>();
        for (SHouse sHouse : this.data.getAllHouses()) {
            if (!sHouse.isMercHouse()) continue;
            result.add(sHouse);
        }
        return result;
    }

    public void doLoginPlayer(String Username) {
        boolean foundhim = false;
        Iterator<House> e = this.data.getAllHouses().iterator();
        while (e.hasNext() && !foundhim) {
            SHouse h = (SHouse)e.next();
            String s = h.doLogin(Username);
            if (s == null) continue;
            this.toUser(s, Username, true);
            foundhim = true;
            String addon = h.getAbbreviation();
            SPlayer p = this.getPlayer(Username);
            this.players.put(p.getName().toLowerCase(), p);
            p.setLastOnline(System.currentTimeMillis());
            this.myServer.getUser(Username).setAddon(addon);
            cm.toUser("PS|" + p.toClientString(), p.getName(), false);
            for (SArmy currA : p.getArmies()) {
                currA.getLegalOperations().clear();
                cm.getOpsManager().checkOperations(currA, false);
            }
            String result = "PI|PL|";
            Enumeration<SPlayer> en = this.players.elements();
            while (en.hasMoreElements()) {
                SPlayer pl = en.nextElement();
                result = result + this.getPlayerUpdateString(pl);
                result = result + "|";
            }
            this.toUser(result, Username, false);
            this.sendPlayerUpdate(p);
            this.toUser("CC|NT|" + this.TThread.getRemainingSleepTime(), p.getName(), false);
            p.setLastTimeCommandSent(System.currentTimeMillis());
        }
        if (!foundhim) {
            this.toUser("Login failed. (This usually means your account hasn't been enrolled in the campaign. Go to the Campaign menu and select 'Enroll' to join the campaign.)", Username, true);
        }
    }

    public MMServ getServer() {
        return this.myServer;
    }

    public void sendPlayerUpdate(SPlayer p) {
        this.doSendToAllOnlinePlayers("PI|DA|" + this.getPlayerUpdateString(p), false);
    }

    private String getPlayerUpdateString(SPlayer p) {
        String result = "";
        int Status2 = p.getActivityStatus();
        if (Status2 == 2 && Boolean.valueOf(this.getConfig("HideActiveStatus")).booleanValue()) {
            Status2 = 3;
        }
        result = p.getName() + "|" + p.getExperience() + "#";
        result = Boolean.valueOf(this.getConfig("HideELO")) != false ? result + "0" : result + p.getRatingRounded();
        result = result + "#" + Status2 + "#";
        result = p.getFluffText().equals("") ? result + " #" : result + p.getFluffText() + "#";
        result = result + p.getHouseFightingFor().getAbbreviation() + "#";
        result = result + p.getHouseName() + "#";
        result = result + p.getHouseFightingFor().getHousePlayerColor(p.getHouseFightingFor().getMyData().redColor) + "#";
        result = result + p.getHouseFightingFor().getHousePlayerColor(p.getHouseFightingFor().getMyData().greenColor) + "#";
        result = result + p.getHouseFightingFor().getHousePlayerColor(p.getHouseFightingFor().getMyData().blueColor) + "#";
        return result;
    }

    public void sendPlayerStatusUpdate(SPlayer p, boolean sendToAll) {
        int realStatus;
        int Status2 = realStatus = p.getActivityStatus();
        if (realStatus == 2 && Boolean.valueOf(this.getConfig("HideActiveStatus")).booleanValue()) {
            Status2 = 3;
        }
        if (sendToAll) {
            this.doSendToAllOnlinePlayers("PI|CS|" + p.getName() + "|" + Status2, false);
        }
        this.toUser("CS|" + realStatus, p.getName(), false);
    }

    public SPlayer getPlayer(String Name2) {
        SPlayer result;
        for (SHouse sHouse : this.data.getAllHouses()) {
            result = sHouse.getMember(Name2);
            if (result == null) continue;
            return result;
        }
        result = cm.loadPlayerFile(Name2);
        if (result != null) {
            result.setSave(true);
        }
        return result;
    }

    public SPlayer loadPlayerFile(String name) {
        if (!name.startsWith("[Dedicated]")) {
            try {
                MMServ.mmlog.mainLog("Loading " + name);
                File configFile = new File("./campaign/players/" + name.toLowerCase() + ".dat");
                FileInputStream fis = new FileInputStream(configFile);
                BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
                SPlayer p = new SPlayer();
                String pString = dis.readLine();
                p.fromString(pString);
                p.addStatusListener(p.getMyHouse());
                p.getMyHouse().getMembers().put(name.toLowerCase(), p);
                return p;
            }
            catch (FileNotFoundException fnf) {
                if (!name.startsWith("Nobody") && !name.equals("SERVER")) {
                    MMServ.mmlog.errLog("could not find a pfile for " + name);
                }
                return null;
            }
            catch (Exception ex) {
                MMServ.mmlog.errLog(ex);
                MMServ.mmlog.errLog("Unable to load pfile " + name);
                return null;
            }
        }
        return null;
    }

    public boolean doLogoutPlayer(String name) {
        if (name == null) {
            return true;
        }
        this.players.remove(name);
        boolean result = false;
        for (SHouse sHouse : this.data.getAllHouses()) {
            if (!sHouse.doLogout(name)) continue;
            result = true;
        }
        this.myServer.getUser(name).setAddon("");
        this.doSendToAllOnlinePlayers("PI|CS|" + name + "|" + 1, false);
        this.toUser("<font color=\"black\">[*] You've logged out of the campaign.</font>", name, true);
        return result;
    }

    public void toUser(String txt, String Username, boolean isChat) {
        if (isChat) {
            this.myServer.fromCampaignMod("CH|" + txt, Username);
        } else {
            this.myServer.fromCampaignMod(txt, Username);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void init() {
        XMLResponder parser;
        MMServ.mmlog.modLog("SERVER STARTED");
        boolean redo = false;
        this.Commands.put("ACCEPTCONTRACT", new AcceptContractCommand());
        this.Commands.put("ACTIVATE", new ActivateCommand());
        this.Commands.put("ADDNEWS", new AddNewsCommand());
        this.Commands.put("ADDTOMUSEUM", new AddToMuseumCommand());
        this.Commands.put("ADDTRAIT", new AddTraitCommand());
        this.Commands.put("ADDOMNIVARIANTMOD", new AddOmniVariantModCommand());
        this.Commands.put("ADMINALLOWHOUSEDEFECTION", new AdminAllowHouseDefectionCommand());
        this.Commands.put("ADMINCHANGEPLANETOWNER", new AdminChangePlanetOwnerCommand());
        this.Commands.put("ADMINCHANGESERVERCONFIG", new AdminChangeServerConfigCommand());
        this.Commands.put("ADMINCREATEFACTION", new AdminCreateFactionCommand());
        this.Commands.put("ADMINCREATEPLANET", new AdminCreatePlanetCommand());
        this.Commands.put("ADMINCREATEFACTORY", new AdminCreateFactoryCommand());
        this.Commands.put("ADMINCREATESOLARIS", new AdminCreateSolarisCommand());
        this.Commands.put("ADMINCREATETERRAIN", new AdminCreateTerrainCommand());
        this.Commands.put("ADMINDESTROYFACTORY", new AdminDestroyFactoryCommand());
        this.Commands.put("ADMINDESTROYPLANET", new AdminDestroyPlanetCommand());
        this.Commands.put("ADMINDESTROYTERRAIN", new AdminDestroyTerrainCommand());
        this.Commands.put("ADMINDONATE", new AdminDonateCommand());
        this.Commands.put("ADMINEXCHANGEPLANETOWNERSHIP", new AdminExchangePlanetOwnershipCommand());
        this.Commands.put("ADMINGRANTCOMPONENTS", new AdminGrantComponentsCommand());
        this.Commands.put("ADMINHOUSEPILOTS", new AdminHousePilotsCommand());
        this.Commands.put("ADMINHOUSESTATUS", new AdminHouseStatusCommand());
        this.Commands.put("ADMINLOCKCAMPAIGN", new AdminLockCampaignCommand());
        this.Commands.put("ADMINLOCKFACTORY", new AdminLockFactoryCommand());
        this.Commands.put("ADMINLISTANDREMOVEOMG", new AdminListAndRemoveOMGCommand());
        this.Commands.put("ADMINLISTHOUSEBANNEDAMMO", new AdminListHouseBannedAmmoCommand());
        this.Commands.put("ADMINLISTSERVERBANNEDAMMO", new AdminListServerBannedAmmoCommand());
        this.Commands.put("ADMINPASSWORD", new AdminPasswordCommand());
        this.Commands.put("ADMINPLAYERSTATUS", new AdminPlayerStatusCommand());
        this.Commands.put("ADMINREMOVEUNITSONMARKET", new AdminRemoveUnitsOnMarketCommand());
        this.Commands.put("ADMINRESETALLINFLUENCE", new AdminResetAllInfluenceCommand());
        this.Commands.put("ADMINRESETHOUSERANKINGS", new AdminResetHouseRankingsCommand());
        this.Commands.put("ADMINSAVE", new AdminSaveCommand());
        this.Commands.put("ADMINSAVECOMMANDLEVELS", new AdminSaveCommandLevelsCommand());
        this.Commands.put("ADMINSAVEPLANETSTOXML", new AdminSavePlanetsToXMLCommand());
        this.Commands.put("ADMINSAVESERVERCONFIGS", new AdminSaveServerConfigsCommand());
        this.Commands.put("ADMINSETCOMMANDLEVEL", new AdminSetCommandLevelCommand());
        this.Commands.put("ADMINSETHOUSECOMPONENTMOD", new AdminSetHouseComponentModCommand());
        this.Commands.put("ADMINSETHOUSEFLUFILE", new AdminSetHouseFluFileCommand());
        this.Commands.put("ADMINSETHOUSEPLAYERCOLOR", new AdminSetHousePlayerColorCommand());
        this.Commands.put("ADMINSETHOUSEPRICEMOD", new AdminSetHousePriceModCommand());
        this.Commands.put("ADMINSETPLANETBOARDSIZE", new AdminSetPlanetBoardSizeCommand());
        this.Commands.put("ADMINSETPLANETGRAVITY", new AdminSetPlanetGravityCommand());
        this.Commands.put("ADMINSETPLANETMAPSIZE", new AdminSetPlanetMapSizeCommand());
        this.Commands.put("ADMINSETPLANETTEMPERATURE", new AdminSetPlanetTemperatureCommand());
        this.Commands.put("ADMINSETPLANETVACUUM", new AdminSetPlanetVacuumCommand());
        this.Commands.put("ADMINSETHOUSEAMMOBAN", new AdminSetHouseAmmoBanCommand());
        this.Commands.put("ADMINSETSERVERAMMOBAN", new AdminSetServerAmmoBanCommand());
        this.Commands.put("ADMINSCRAP", new AdminScrapCommand());
        this.Commands.put("ADMINTERMINATEALL", new AdminTerminateAllCommand());
        this.Commands.put("ADMINTRANSFER", new AdminTransferCommand());
        this.Commands.put("ADMINUNLOCKCAMPAIGN", new AdminUnlockCampaignCommand());
        this.Commands.put("ADMINVIEWLOG", new AdminViewLogCommand());
        this.Commands.put("ADDSERVER", new AddServerCommand());
        this.Commands.put("ALL", new ArmyLowerLimiterCommand());
        this.Commands.put("AUL", new ArmyUpperLimiterCommand());
        this.Commands.put("ATTACK", new AttackCommand());
        this.Commands.put("AUTOBMSTATUS", new AutoBMStatusCommand());
        this.Commands.put("AUTOPLANETSTATUS", new AutoPlanetStatusCommand());
        this.Commands.put("AUTOJOINGAME", new AutoJoinGameCommand());
        this.Commands.put("BID", new BidCommand());
        this.Commands.put("BMSTATUS", new BMStatusCommand());
        this.Commands.put("BUILDTABLELIST", new BuildTableListCommand());
        this.Commands.put("BUYPILOTSFROMHOUSE", new BuyPilotsFromHouseCommand());
        this.Commands.put("CALCDIST", new CalcDistCommand());
        this.Commands.put("CAMPAIGNCONFIG", new CampaignConfigCommand());
        this.Commands.put("CANCELOFFER", new CancelOfferCommand());
        this.Commands.put("CHANGEHOUSECOLOR", new ChangeHouseColorCommand());
        this.Commands.put("CHANGENAME", new ChangeNameCommand());
        this.Commands.put("CHECKATTACK", new CheckAttackCommand());
        this.Commands.put("CA", new CheckAttackCommand());
        this.Commands.put("CHECK", new CheckCommand());
        this.Commands.put("CHECKARMYELIGIBILITY", new CheckArmyEligibilityCommand());
        this.Commands.put("CHECKARMYLINK", new CheckArmyLinkCommand());
        this.Commands.put("CHECKDIST", new CheckDistCommand());
        this.Commands.put("CLEARPLAYEROPTIONS", new ClearPlayerOptionsCommand());
        this.Commands.put("CREATEARMY", new CreateArmyCommand());
        this.Commands.put("CRA", new CreateArmyCommand());
        this.Commands.put("CREATEMERCFACTION", new CreateMercFactionCommand());
        this.Commands.put("CREATEUNIT", new CreateUnitCommand());
        this.Commands.put("DEACTIVATE", new DeactivateCommand());
        this.Commands.put("DEFECT", new DefectCommand());
        this.Commands.put("DEFEND", new DefendCommand());
        this.Commands.put("DELETEACCOUNT", new DeleteAccountCommand());
        this.Commands.put("DIRECTSELLUNIT", new DirectSellUnitCommand());
        this.Commands.put("DISPLAYPLAYERPERSONALPILOTQUEUE", new DisplayPlayerPersonalPilotQueueCommand());
        this.Commands.put("DONATE", new DonateCommand());
        this.Commands.put("DONATEPILOT", new DonatePilotCommand());
        this.Commands.put("EHM", new EmployeeHouseMailCommand());
        this.Commands.put("EMPLOYEEHOUSEMAIL", new EmployeeHouseMailCommand());
        this.Commands.put("ENROLL", new EnrollCommand());
        this.Commands.put("EXCHANGEUNIT", new ExchangeUnitCommand());
        this.Commands.put("EXU", new ExchangeUnitCommand());
        this.Commands.put("EXM", new ExchangeUnitCommand());
        this.Commands.put("EXCHANGEPILOTINUNIT", new ExchangePilotInUnitCommand());
        this.Commands.put("EXP", new ExchangePilotInUnitCommand());
        this.Commands.put("FACTION", new HouseCommand());
        this.Commands.put("FACTIONLEADERFLUFF", new FactionLeaderFluffCommand());
        this.Commands.put("FLF", new FactionLeaderFluffCommand());
        this.Commands.put("FACTIONLEADERMUTE", new FactionLeaderMuteCommand());
        this.Commands.put("FLM", new FactionLeaderMuteCommand());
        this.Commands.put("FIRETECHS", new FireTechsCommand());
        this.Commands.put("FLUFF", new FluffCommand());
        this.Commands.put("FORCEDDEFECT", new ForcedDefectCommand());
        this.Commands.put("GAMES", new GamesCommand());
        this.Commands.put("GETMODLOG", new GetModLogCommand());
        this.Commands.put("GETPLAYERUNITS", new GetPlayerUnitsCommand());
        this.Commands.put("GRANTCONTROL", new GrantControlCommand());
        this.Commands.put("GRANTEXP", new GrantEXPCommand());
        this.Commands.put("GRANTINFLUENCE", new GrantInfluenceCommand());
        this.Commands.put("GRANTMONEY", new GrantMoneyCommand());
        this.Commands.put("GRANTREWARD", new GrantRewardCommand());
        this.Commands.put("HARDTERMINATE", new HardTerminateCommand());
        this.Commands.put("HELP", new HelpCommand());
        this.Commands.put("HIREANDMAINTAIN", new HireAndMaintainHelper());
        this.Commands.put("HIREANDREQUESTNEW", new HireAndRequestNewHelper());
        this.Commands.put("HIREANDREQUESTUSED", new HireAndRequestUsedHelper());
        this.Commands.put("HIRETECHS", new HireTechsCommand());
        this.Commands.put("HOUSE", new HouseCommand());
        this.Commands.put("HOUSECONTRACTS", new HouseContractsCommand());
        this.Commands.put("HOUSEMAIL", new HouseMailCommand());
        this.Commands.put("HM", new HouseMailCommand());
        this.Commands.put("HOUSERANKING", new HouseRankingCommand());
        this.Commands.put("HOUSESTATUS", new HouseStatusCommand());
        this.Commands.put("ISSTATUS", new ISStatusCommand());
        this.Commands.put("ISS", new ISStatusCommand());
        this.Commands.put("US", new ISStatusCommand());
        this.Commands.put("UNIVERSESTATUS", new ISStatusCommand());
        this.Commands.put("LASTONLINE", new LastOnlineCommand());
        this.Commands.put("LINKUNIT", new LinkUnitCommand());
        this.Commands.put("LISTCOMMANDS", new ListCommandsCommand());
        this.Commands.put("LISTMULTIPLAYERGROUPS", new ListMultiPlayerGroupsCommand());
        this.Commands.put("LOGIN", new LoginCommand());
        this.Commands.put("LOGOUT", new LogoutCommand());
        this.Commands.put("MERCSTATUS", new MercStatusCommand());
        this.Commands.put("MSTATUS", new MercStatusCommand());
        this.Commands.put("MODERATORMAIL", new ModeratorMailCommand());
        this.Commands.put("MM", new ModeratorMailCommand());
        this.Commands.put("MODDEACTIVATE", new ModDeactivateCommand());
        this.Commands.put("MODGAMES", new ModGamesCommand());
        this.Commands.put("MODFULLREPAIR", new ModFullRepairCommand());
        this.Commands.put("MODLOG", new ModLogCommand());
        this.Commands.put("MODNOPLAY", new ModNoPlayCommand());
        this.Commands.put("MODTERMINATE", new ModTerminateCommand());
        this.Commands.put("MOTD", new MOTDCommand());
        this.Commands.put("MYBIDS", new MyBidsCommand());
        this.Commands.put("MYSTATUS", new MyStatusCommand());
        this.Commands.put("MYVOTES", new MyVotesCommand());
        this.Commands.put("NAMEARMY", new NameArmyCommand());
        this.Commands.put("NAMEPILOT", new NamePilotCommand());
        this.Commands.put("NOPLAY", new NoPlayCommand());
        this.Commands.put("NOTFIYFIGHTING", new NotifyFightingCommand());
        this.Commands.put("OFFERCONTRACT", new OfferContractCommand());
        this.Commands.put("PLANET", new PlanetCommand());
        this.Commands.put("PLAYERS", new PlayersCommand());
        this.Commands.put("RANGE", new RangeCommand());
        this.Commands.put("RECALL", new RecallCommand());
        this.Commands.put("REPOD", new RepodCommand());
        this.Commands.put("REFRESHFACTORY", new RefreshFactoryCommand());
        this.Commands.put("REFUSECONTRACT", new RefuseContractCommand());
        this.Commands.put("REMOVEANDADDNOPLAY", new RemoveAndAddNoPlayHelper());
        this.Commands.put("REMOVEARMY", new RemoveArmyCommand());
        this.Commands.put("RMA", new RemoveArmyCommand());
        this.Commands.put("REMOVETRAIT", new RemoveTraitCommand());
        this.Commands.put("REMOVEVOTE", new RemoveVoteCommand());
        this.Commands.put("REPAIRUNIT", new RepairUnitCommand());
        this.Commands.put("UNITPOSITION", new UnitPositionCommand());
        this.Commands.put("REQUEST", new RequestCommand());
        this.Commands.put("REQUESTDONATED", new RequestDonatedCommand());
        this.Commands.put("REQUESTSERVERMAIL", new RequestServerMailCommand());
        this.Commands.put("RETIREPILOT", new RetirePilotCommand());
        this.Commands.put("SAS", new SingASongCommand());
        this.Commands.put("SCRAP", new ScrapCommand());
        this.Commands.put("SELL", new SellCommand());
        this.Commands.put("SENDTOMISC", new SendToMiscCommand());
        this.Commands.put("SERVERVERSION", new ServerVersionCommand());
        this.Commands.put("SERVERGAMEOPTIONS", new ServerGameOptionsCommand());
        this.Commands.put("SETADVANCEPLANETTERRAIN", new SetAdvancePlanetTerrainCommand());
        this.Commands.put("SETAUTOEJECT", new SetAutoEjectCommand());
        this.Commands.put("SETCLIENTVERSION", new SetClientVersionCommand());
        this.Commands.put("SETELO", new SetEloCommand());
        this.Commands.put("SETHOUSELOGO", new SetHouseLogoCommand());
        this.Commands.put("SETHOUSECONQUER", new SetHouseConquerCommand());
        this.Commands.put("SETHOUSEINHOUSEATTACKS", new SetHouseInHouseAttacksCommand());
        this.Commands.put("SETMAINTAINED", new SetMaintainedCommand());
        this.Commands.put("SETMOTD", new SetMOTDCommand());
        this.Commands.put("SETMULTIPLAYERGROUP", new SetMultiPlayerGroupCommand());
        this.Commands.put("SETMYLOGO", new SetMyLogoCommand());
        this.Commands.put("SETPLANETCONQUER", new SetPlanetConquerCommand());
        this.Commands.put("SETPLANETMINOWNERSHIP", new SetPlanetMinOwnerShipCommand());
        this.Commands.put("SETPLAYEROPTION", new SetPlayerOptionCommand());
        this.Commands.put("SETPRICEMOD", new SetPricemodCommand());
        this.Commands.put("SETSEARCHLIGHT", new SetSearchLightCommand());
        this.Commands.put("SETTARGETSYSTEMTYPE", new SetTargetSystemTypeCommand());
        this.Commands.put("SETUNITAMMO", new SetUnitAmmoCommand());
        this.Commands.put("SETUNITBURST", new SetUnitBurstCommand());
        this.Commands.put("SETUNITREPAIR", new SetUnitRepairCommand());
        this.Commands.put("SETUNMAINTAINED", new SetUnmaintainedCommand());
        this.Commands.put("SHOWTOHOUSE", new ShowToHouseCommand());
        this.Commands.put("STH", new ShowToHouseCommand());
        this.Commands.put("STATUS", new StatusCommand());
        this.Commands.put("STRIPUNITS", new StripUnitsCommand());
        this.Commands.put("TERMINATE", new TerminateCommand());
        this.Commands.put("TERMINATECONTRACT", new TerminateContractCommand());
        this.Commands.put("TICK", new TickCommand());
        this.Commands.put("TOUCH", new TouchCommand());
        this.Commands.put("TRANSFERMONEY", new TransferMoneyCommand());
        this.Commands.put("TRANSFERPILOT", new TransferPilotCommand());
        this.Commands.put("TRANSFERUNIT", new TransferUnitCommand());
        this.Commands.put("UNEMPLOYEDMERCS", new UnemployedMercsCommand());
        this.Commands.put("UNENROLL", new UnenrollCommand());
        this.Commands.put("UNLOCKLANCES", new UnlockLancesCommand());
        this.Commands.put("USEREWARDPOINTS", new UseRewardPointsCommand());
        this.Commands.put("VOTE", new VoteCommand());
        try {
            File configFile = new File("./data/commands/commands.dat");
            FileInputStream fileInputStream = new FileInputStream(configFile);
            BufferedReader dis = new BufferedReader(new InputStreamReader(fileInputStream));
            while (dis.ready()) {
                StringTokenizer command = new StringTokenizer(dis.readLine(), "#");
                String commandName = command.nextToken();
                if (!this.Commands.containsKey(commandName)) continue;
                ((Command)this.Commands.get(commandName)).setExecutionLevel(Integer.parseInt(command.nextToken()));
            }
        }
        catch (Exception ex) {
            MMServ.mmlog.errLog("Unable to find commands.dat. Continuing with defaults in place");
        }
        if (this.data.getAllPlanets().size() > 0 && this.data.getAllHouses().size() > 0) {
            return;
        }
        if (this.data.getAllPlanets().size() == 0 && this.data.getAllHouses().size() == 0) {
            redo = true;
        }
        if (this.data.getAllHouses().size() == 0) {
            try {
                parser = new XMLFactionDataParser(this, "./data/factions.xml");
                Vector vector = ((XMLFactionDataParser)parser).getFactions();
                for (int i = 0; i < vector.size(); ++i) {
                    SHouse h = (SHouse)vector.elementAt(i);
                    h.addStatusListener(this);
                    this.addHouse(h);
                }
            }
            catch (Exception ex) {
                MMServ.mmlog.errLog("Error while reading faction data -- bailing out");
                MMServ.mmlog.errLog(ex);
                MMServ.addToErrorLog(ex);
                MMServ.mmlog.mainLog("Error while reading Faction Data!");
                System.exit(1);
            }
            NewbieHouse solaris = new NewbieHouse(this.data.getUnusedHouseID(), cm.getConfig("NewbieHouseName"), "#33CCCC", 4, 5, "SOL");
            solaris.addStatusListener(this);
            this.addHouse(solaris);
        }
        if (this.data.getAllPlanets().size() == 0) {
            for (SHouse sHouse : this.data.getAllHouses()) {
                sHouse.setInitialHouseRanking(0);
            }
            try {
                parser = new XMLPlanetDataParser(this, "./data/planets.xml");
                Vector vector = ((XMLPlanetDataParser)parser).getPlanets();
                for (int i = 0; i < vector.size(); ++i) {
                    SPlanet p = (SPlanet)vector.elementAt(i);
                    this.addPlanet(p);
                    for (SHouse faction : p.getInfluence().getHouses()) {
                        if (faction.getId() == p.getInfluence().getOwner().intValue()) {
                            faction.addPlanet(p);
                        }
                        faction.setInitialHouseRanking(faction.getInitialHouseRanking() + p.getInfluence().getInfluence(faction.getId()));
                    }
                }
            }
            catch (Exception ex) {
                MMServ.mmlog.errLog("Error while reading planet data -- bailing out");
                MMServ.mmlog.errLog(ex);
                MMServ.addToErrorLog(ex);
                MMServ.mmlog.mainLog("Error while reading Planet Data!");
                System.exit(1);
            }
            HashMap<Integer, Integer> solFlu = new HashMap<Integer, Integer>();
            solFlu.put(new Integer(cm.getHouseFromPartialString(cm.getConfig("NewbieHouseName"), null).getId()), new Integer(100));
            NewbiePlanet newbiePlanet = new NewbiePlanet(0, "Solaris VII", new Influences(solFlu), 0, 0, -3.0, -2.0);
            if (this.data.getPlanetByName("Solaris VII") == null) {
                this.addPlanet(newbiePlanet);
                cm.getHouseFromPartialString(cm.getConfig("NewbieHouseName"), null).addPlanet(newbiePlanet);
            }
        }
        if (redo) {
            void var3_17;
            int numberOfFreeTicks = Integer.parseInt(this.getConfig("FreeMinticksOnStartup"));
            MMServ.mmlog.infoLog("Granting Free Ticks");
            boolean bl = false;
            while (var3_17 < numberOfFreeTicks) {
                this.tick(false, 0);
                ++var3_17;
            }
        }
        this.toFile();
    }

    public void addHouse(SHouse s) {
        this.data.addHouse(s);
        if (cm.useHibernate() && HouseEntryKeeper.getHouseEntry(s.getName()) == null) {
            HouseEntryKeeper.addHouseEntry(HouseEntry.getEntry(s.getName(), s.getAbbreviation(), s.getHouseColor(), s.isConquerable()));
        }
    }

    public void addPlanet(SPlanet p) {
        this.data.addPlanet(p);
        if (cm.useHibernate() && PlanetEntryKeeper.getPlanetEntry(p.getName()) == null) {
            PlanetEntryKeeper.addPlanetEntry(PlanetEntry.getEntry(p.getName()));
        }
    }

    public synchronized void userRoll(String text, String Username) {
        Random random = new Random();
        int dice = 2;
        int sides = 6;
        int total = 0;
        int roll = 0;
        String x = "";
        if ((text = text.length() >= 5 ? text.substring(5) : "").trim() != "") {
            StringTokenizer ST = new StringTokenizer(text, "d");
            try {
                if (ST.hasMoreElements()) {
                    x = (String)ST.nextElement();
                    dice = Integer.parseInt(x.trim());
                }
                if (ST.hasMoreElements()) {
                    x = (String)ST.nextElement();
                    sides = Integer.parseInt(x.trim());
                }
            }
            catch (NumberFormatException ex) {
                this.toUser("/roll: error parsing arguments.", Username, true);
                return;
            }
            catch (StringIndexOutOfBoundsException ex) {
                this.toUser("/roll: error parsing arguments.", Username, true);
                return;
            }
        }
        if (dice > 50 || sides > 1000) {
            this.toAllUsers(Username + " is a stupid haxx0r!");
            return;
        }
        StringBuffer diceBuffer = new StringBuffer();
        for (int i = 0; i < dice; ++i) {
            roll = random.nextInt(sides) + 1;
            total += roll;
            if (dice < 2) {
                diceBuffer.append(roll);
                continue;
            }
            if (i < dice - 1) {
                diceBuffer.append(roll);
                diceBuffer.append(", ");
                continue;
            }
            diceBuffer.append("and ");
            diceBuffer.append(roll);
        }
        if (text != "") {
            this.toAllUsers("<font color=\"black\">" + Username + " has rolled " + diceBuffer + " for a total of " + total + ", with " + text + "</font>");
        } else {
            this.toAllUsers("<font color=\"black\">" + Username + " has rolled " + diceBuffer + " for a total of " + total + ", with 2d6</font>");
        }
    }

    public void addMechStat(String Filename, int mechsize, int gameplayed, int gamewon, int scrapped) {
        MechStatistics m = null;
        m = this.MechStats.get(Filename) == null ? new MechStatistics(Filename, mechsize) : (MechStatistics)this.MechStats.get(Filename);
        SUnit unit = new SUnit();
        m.setOriginalBV(unit.loadMech(Filename).calculateBattleValue());
        unit = null;
        m.addStats(gameplayed, gamewon, m.getOriginalBV());
        m.setTimesScrapped(m.getTimesScrapped() + scrapped);
        this.MechStats.put(Filename, m);
    }

    public synchronized void slice(int sliceID) {
        int n;
        MMServ.mmlog.mainLog("Slice Started");
        for (SHouse sHouse : this.data.getAllHouses()) {
            SPlayer p;
            int battlers;
            int idlers = sHouse.getActMembers().size();
            int hplayers = idlers + (battlers = sHouse.getFightingMembers().size());
            if (hplayers > 0) {
                Enumeration actives = sHouse.getActMembers().elements();
                while (actives.hasMoreElements()) {
                    p = (SPlayer)actives.nextElement();
                    if (p.isActive()) {
                        p.doMaintainance();
                    }
                    this.toUser(sHouse.payInfluence(p), p.getName(), true);
                }
                Enumeration fighters = sHouse.getFightingMembers().elements();
                while (fighters.hasMoreElements()) {
                    SPlayer p2 = (SPlayer)fighters.nextElement();
                    p2.doMaintainance();
                    p2.addBusySlices(1);
                }
            }
            if (Long.parseLong(cm.getConfig("MaxIdleTime")) <= 0L) continue;
            Enumeration<SPlayer> memb = sHouse.getMembers().elements();
            while (memb.hasMoreElements()) {
                p = memb.nextElement();
                long idleTime = System.currentTimeMillis() - p.getLastTimeCommandSent();
                long maxIdleTime = Long.parseLong(cm.getConfig("MaxIdleTime")) * 60000L;
                if (cm.getServer().isModerator(p.getName()) || p.isBusy() || p.getActivityStatus() <= 1) {
                    p.setLastTimeCommandSent(System.currentTimeMillis());
                    continue;
                }
                if (idleTime <= maxIdleTime) continue;
                cm.toUser("You have been kicked by for being idle", p.getName(), true);
                cm.toUser("KI|bye bye idler!", p.getName(), false);
            }
        }
        int n2 = Integer.parseInt(cm.getConfig("SaveEverySlice"));
        if (n2 < 1) {
            n = 1;
        }
        if (sliceID % n == 0) {
            cm.savePlayers();
            cm.saveTopUnitID();
        }
    }

    public synchronized void tick(boolean real, int tickid) {
        String result = "";
        int totalstuff = 0;
        MMServ.mmlog.tickLog("Tick! (" + tickid + ")");
        Iterator<House> e = this.data.getAllHouses().iterator();
        while (e.hasNext()) {
            result = "";
            SHouse h = (SHouse)e.next();
            int factionplayers = h.getActMembers().size() + h.getFightingMembers().size();
            if (factionplayers > 0) {
                MMServ.mmlog.tickLog(h.getName() + " has " + factionplayers + " members online (" + h.getFightingMembers().size() + " fighting)");
            }
            int gameCount = 0;
            for (ShortOperation currO : this.getOpsManager().getRunningOps().values()) {
                if (currO.getStatus() != ShortOperation.STATUS_INPROGRESS) continue;
                ++gameCount;
            }
            MMServ.mmlog.tickLog(gameCount + " games in progress.");
            totalstuff += factionplayers;
            if (h.getActMembers().size() == 0 && h.getFightingMembers().size() == 0 && real) continue;
            try {
                result = h.tick(real, tickid);
            }
            catch (Exception ex) {
                MMServ.mmlog.errLog("Problems with faction updates (tick)");
                MMServ.mmlog.errLog(ex);
                MMServ.addToErrorLog(ex);
            }
            try {
                SPlayer p;
                Enumeration m = h.getActMembers().elements();
                while (m.hasMoreElements()) {
                    p = (SPlayer)m.nextElement();
                    p.setScrapsThisTick(0);
                    p.setDonatonsThisTick(0);
                    this.toUser("SM|" + result, p.getName(), false);
                    if (!p.countsForTick()) continue;
                    if (p.getPricePenalty() > 0) {
                        p.addPricePenalty(Integer.parseInt(this.getConfig("MezzoDrain")) * -1);
                        continue;
                    }
                    p.addPricePenalty(Integer.parseInt(this.getConfig("MezzoNegDrain")) * -1);
                }
                m = h.getFightingMembers().elements();
                while (m.hasMoreElements()) {
                    p = (SPlayer)m.nextElement();
                    p.setScrapsThisTick(0);
                    p.setDonatonsThisTick(0);
                    this.toUser("SM|" + result, p.getName(), false);
                    if (!p.countsForTick()) continue;
                    if (p.getPricePenalty() > 0) {
                        p.addPricePenalty(Integer.parseInt(this.getConfig("MezzoDrain")) * -1);
                        continue;
                    }
                    p.addPricePenalty(Integer.parseInt(this.getConfig("MezzoNegDrain")) * -1);
                }
            }
            catch (Exception ex) {
                MMServ.mmlog.errLog("Problems with welfare/mezzo updates (tick)");
                MMServ.mmlog.errLog(ex);
                MMServ.addToErrorLog(ex);
            }
        }
        MMServ.mmlog.tickLog("Total players: " + totalstuff);
        totalstuff = 0;
        result = this.opsManager.tick();
        this.doSendToAllOnlinePlayers(result);
        this.market.tick();
        if (Boolean.valueOf(this.getConfig("ShowFactionRanks")).booleanValue()) {
            result = Statistics.getReadableHouseRanking(true);
            this.doSendToAllOnlinePlayers(result);
        }
        if (Boolean.valueOf(this.getConfig("HTMLOUTPUT")).booleanValue()) {
            Statistics.doRanking();
        }
        this.serverDescriptions.connectAll();
        this.serverDescriptions.save(this.getConfig("ServerDescription"));
        CampaignMain.cm.aub = new AutomaticBackup(System.currentTimeMillis());
        new Thread(CampaignMain.cm.aub).start();
        System.gc();
    }

    public boolean useHibernate() {
        boolean b = Boolean.valueOf(this.getConfig("Hibernate"));
        return b;
    }

    public TreeSet getHouseRanking() {
        Hashtable<String, HouseRankingHelpContainer> factioncontainer = new Hashtable<String, HouseRankingHelpContainer>();
        for (SHouse sHouse : this.data.getAllHouses()) {
            if (sHouse.isMercHouse() || sHouse.isNewbieHouse()) continue;
            HouseRankingHelpContainer hrc = new HouseRankingHelpContainer(sHouse);
            factioncontainer.put(sHouse.getName(), hrc);
        }
        for (SPlanet sPlanet : this.data.getAllPlanets()) {
            for (SHouse hs : sPlanet.getInfluence().getHouses()) {
                if (hs.isNewbieHouse() || hs.isMercHouse()) continue;
                ((HouseRankingHelpContainer)factioncontainer.get(hs.getName())).addAmount(sPlanet.getInfluence().getInfluence(hs.getId()));
            }
        }
        TreeSet treeSet = new TreeSet();
        Enumeration en = factioncontainer.elements();
        while (en.hasMoreElements()) {
            treeSet.add(en.nextElement());
        }
        return treeSet;
    }

    public void doSendToAllOnlinePlayers(String txt) {
        this.doSendToAllOnlinePlayers(txt, true);
    }

    public void doSendToAllOnlinePlayers(String txt, boolean isChat) {
        for (SHouse sHouse : this.data.getAllHouses()) {
            String name;
            SPlayer p;
            Enumeration m = sHouse.getActMembers().elements();
            while (m.hasMoreElements()) {
                p = (SPlayer)m.nextElement();
                name = p.getName();
                this.toUser(txt, name, isChat);
            }
            m = sHouse.getFightingMembers().elements();
            while (m.hasMoreElements()) {
                p = (SPlayer)m.nextElement();
                name = p.getName();
                this.toUser(txt, name, isChat);
            }
        }
    }

    public SPlanet getPlanetInfo(String PlanetName) {
        for (SHouse sHouse : this.data.getAllHouses()) {
            if (sHouse.getPlanets().get(PlanetName) == null) continue;
            return (SPlanet)sHouse.getPlanets().get(PlanetName);
        }
        return null;
    }

    public SHouse getHouseForPlanet(SPlanet p) {
        return p.getOwner();
    }

    public SHouse getHouseForPlayer(String Username) {
        for (SHouse sHouse : this.data.getAllHouses()) {
            if (sHouse.getMembers().get(Username.toLowerCase()) == null) continue;
            return sHouse;
        }
        return null;
    }

    public boolean isPlayerActive(String Player2) {
        for (SHouse sHouse : this.data.getAllHouses()) {
            if (!sHouse.isLoggedIn(Player2)) continue;
            return true;
        }
        return false;
    }

    public Random getR() {
        return this.r;
    }

    public int getCurrentTick() {
        return this.TThread.tickid;
    }

    public synchronized void addToTaskFeed(TaskInfo taskInfo) {
        try {
            String file = this.config.getProperty("TaskNewsPath");
            if (file == null) {
                return;
            }
            MMNetXStream xml = new MMNetXStream((HierarchicalStreamDriver)new DomDriver());
            LinkedList feed = new LinkedList();
            try {
                feed = (LinkedList)xml.fromXML(new FileReader(file));
            }
            catch (FileNotFoundException e) {
                feed = new LinkedList();
            }
            catch (Exception ex) {
                return;
            }
            if (feed.size() > 300) {
                feed.removeFirst();
            }
            feed.addLast(taskInfo);
            try {
                xml.toXML(feed, new FileWriter(this.getConfig("TaskNewsPath")));
            }
            catch (FileNotFoundException efnf) {
            }
            catch (IOException e1) {
                MMServ.mmlog.errLog("Could not write Task - Feed");
                MMServ.mmlog.errLog(e1);
            }
        }
        catch (RuntimeException e) {
            MMServ.mmlog.errLog(e);
        }
    }

    public synchronized void addToNewsFeed(String s) {
        this.NewsFeed.addLast(s);
        if (this.NewsFeed.size() > 200) {
            this.NewsFeed.removeFirst();
        }
        try {
            FileOutputStream out = new FileOutputStream(this.getConfig("NewsPath"));
            PrintStream ps = new PrintStream(out);
            ps.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>");
            ps.println("<rdf:RDF");
            ps.println("xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"");
            ps.println("xmlns=\"http://my.netscape.com/rdf/simple/0.9/\">");
            ps.println("<channel>");
            ps.println("<title>MegamekNET Campaign News Feed</title>");
            ps.println("<link>http://www.megamek.net</link>");
            ps.println("<description>Campaign News</description>");
            ps.println("</channel>");
            for (String entry : this.NewsFeed) {
                ps.println("<item>");
                ps.println("<title>" + entry + "</title>");
                ps.println("<link>http://www.megamek.net</link>");
                ps.println("</item>");
            }
            ps.println("</rdf:RDF>");
            ps.close();
        }
        catch (FileNotFoundException efnf) {
        }
        catch (Exception ex) {
            MMServ.mmlog.errLog("Problems writing the news feed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configureHibernate() {
        try {
            this.factory = new Configuration().configure().buildSessionFactory();
        }
        catch (Exception e) {
            MMServ.mmlog.errLog(e);
        }
    }

    public void toAllUsers(String txt) {
        for (SHouse sHouse : this.data.getAllHouses()) {
            SPlayer p;
            Hashtable a = sHouse.getActMembers();
            Enumeration f = a.elements();
            while (f.hasMoreElements()) {
                p = (SPlayer)f.nextElement();
                this.toUser(txt, p.getName(), true);
            }
            a = sHouse.getFightingMembers();
            f = a.elements();
            while (f.hasMoreElements()) {
                p = (SPlayer)f.nextElement();
                this.toUser(txt, p.getName(), true);
            }
        }
    }

    @Override
    public void statusChanged(StatusChangeEvent e) {
        e.processEvent(this);
    }

    public Market getMarket() {
        return this.market;
    }

    public void initializePilotSkills() {
        this.pilotSkills.put(new Integer(1), new DodgeManeuverSkill(1));
        this.pilotSkills.put(new Integer(7), new ManeuveringAceSkill(7));
        this.pilotSkills.put(new Integer(3), new MeleeSpecialistSkill(3));
        this.pilotSkills.put(new Integer(4), new PainResistanceSkill(4));
        this.pilotSkills.put(new Integer(2), new AstechSkill(2));
        this.pilotSkills.put(new Integer(5), new NaturalAptitudeGunnerySkill(5));
        this.pilotSkills.put(new Integer(6), new NaturalAptitudePilotingSkill(6));
        this.pilotSkills.put(new Integer(13), new IronManSkill(13));
        this.pilotSkills.put(new Integer(9), new GunneryBallisticSkill(9));
        this.pilotSkills.put(new Integer(10), new GunneryLaserSkill(10));
        this.pilotSkills.put(new Integer(11), new GunneryMissileSkill(11));
        this.pilotSkills.put(new Integer(8), new TacticalGeniusSkill(8));
        this.pilotSkills.put(new Integer(12), new WeaponSpecialistSkill(12));
        this.pilotSkills.put(new Integer(14), new SurvivalistSkill(14));
        this.pilotSkills.put(new Integer(15), new TraitSkill(15));
        this.pilotSkills.put(new Integer(16), new EnhancedInterfaceSkill(16));
        this.pilotSkills.put(new Integer(17), new QuickStudySkill(17));
        this.pilotSkills.put(new Integer(18), new GiftedSkill(18));
    }

    public Session getSession() {
        try {
            return this.getFactory().openSession();
        }
        catch (Exception ex) {
            MMServ.mmlog.errLog(ex);
            return null;
        }
    }

    public SessionFactory getFactory() {
        if (this.factory == null) {
            try {
                this.configureHibernate();
            }
            catch (Exception ex) {
                MMServ.mmlog.errLog(ex);
            }
        }
        return this.factory;
    }

    public Properties getConfig() {
        return this.config;
    }

    public Hashtable getServerCommands() {
        return this.Commands;
    }

    public Hashtable<String, String> getServerBannedAmmo() {
        return cm.getData().getServerBannedAmmo();
    }

    public VoteManager getVoteManager() {
        return this.voteManager;
    }

    public TickThread getTThread() {
        return this.TThread;
    }

    public Vector getUnresolvedContracts() {
        return this.unresolvedContracts;
    }

    public SPilotSkill getRandomSkill(SPilot p, int unitType) {
        int total = 0;
        Enumeration<Object> it = this.pilotSkills.elements();
        Hashtable<Integer, Integer> skilltable = new Hashtable<Integer, Integer>();
        if (p.getSkills().has(15)) {
            String trait = p.getTraitName();
            if (trait.indexOf("*") > -1) {
                trait = trait.substring(0, trait.indexOf("*"));
            }
            Vector<Object> traitsList = new Vector();
            traitsList = this.getFactionTraits(p.getCurrentFaction());
            for (String string : traitsList) {
                StringTokenizer traitName = new StringTokenizer(string, "*");
                String traitString = traitName.nextToken();
                if (!traitString.equalsIgnoreCase(trait)) continue;
                while (traitName.hasMoreElements()) {
                    int traitid = Integer.parseInt(traitName.nextToken());
                    int traitMod = Integer.parseInt(traitName.nextToken());
                    skilltable.put(traitid, traitMod);
                }
            }
        }
        while (it.hasMoreElements()) {
            SPilotSkill skill = (SPilotSkill)it.nextElement();
            total += skill.getChance(unitType, p);
        }
        if (total == 0) {
            return null;
        }
        int rnd = 1;
        if (total > 1) {
            rnd = this.getR().nextInt(total) + 1;
        }
        it = this.pilotSkills.elements();
        while (it.hasMoreElements()) {
            SPilotSkill skill = (SPilotSkill)it.nextElement();
            int chance = skill.getChance(unitType, p);
            if (skilltable.get(new Integer(skill.getId())) != null) {
                chance += ((Integer)skilltable.get(skill.getId())).intValue();
            }
            if (rnd <= chance) {
                return skill;
            }
            rnd -= skill.getChance(unitType, p);
        }
        MMServ.mmlog.errLog("Problems during skill earning! rnd = " + rnd + " total = " + total);
        return null;
    }

    public SPilotSkill getPilotSkill(String skill) {
        Enumeration<Object> it = this.pilotSkills.elements();
        while (it.hasMoreElements()) {
            SPilotSkill pSkill = (SPilotSkill)it.nextElement();
            if (!pSkill.getName().equalsIgnoreCase(skill)) continue;
            return pSkill;
        }
        return null;
    }

    public SPilotSkill getPilotSkill(int id) {
        return (SPilotSkill)this.pilotSkills.get(new Integer(id));
    }

    public void doDisconnectCheckOnPlayer(String name) {
        this.opsManager.doDisconnectCheckOnPlayer(name);
    }

    public void doReconnectCheckOnPlayer(String name) {
        this.opsManager.doReconnectCheckOnPlayer(name);
    }

    public static String readableTime(long elapsed) {
        String result = "";
        long elapsedDays = elapsed / 86400000L;
        long elapsedHours = elapsed % 86400000L / 3600000L;
        long elapsedMinutes = elapsed % 3600000L / 60000L;
        if (elapsedDays > 0L) {
            result = result + elapsedDays + "d ";
        }
        if (elapsedHours > 0L || elapsedDays > 0L) {
            result = result + elapsedHours + "h ";
        }
        result = result + elapsedMinutes + "m";
        return result;
    }

    public static String readableTimeWithSeconds(long elapsed) {
        String result = "";
        long elapsedMinutes = elapsed / 60000L;
        long elapsedSeconds = elapsed % 60000L / 1000L;
        if (elapsedMinutes > 0L) {
            result = result + elapsedMinutes + " min ";
        }
        if (elapsedSeconds > 0L && elapsedMinutes > 0L) {
            result = result + ", " + elapsedSeconds + " sec ";
        } else if (elapsedSeconds > 0L) {
            result = result + elapsedSeconds + " sec ";
        }
        return result;
    }

    public int getCurrentUnitID() {
        return this.currentUnitID;
    }

    public void setCurrentUnitID(int currentUnitID) {
        this.currentUnitID = currentUnitID;
    }

    public synchronized int getAndUpdateCurrentUnitID(SUnit u) {
        if (this.useHibernate()) {
            UnitEntry entry = UnitEntry.getEntry(u.getUnitFilename(), u.getPilot().getName(), u.getPilot().getGunnery(), u.getPilot().getPiloting(), u.getPilot().getSkillString(false));
            UnitEntryKeeper.addUnitEntry(entry);
            return entry.getID();
        }
        ++this.currentUnitID;
        return this.currentUnitID - 1;
    }

    public SHouse getHouseFromPartialString(String HouseString, String Username) {
        Iterator<House> e = this.getData().getAllHouses().iterator();
        SHouse theone = null;
        boolean found = false;
        while (e.hasNext() && !found) {
            SHouse h = (SHouse)e.next();
            if (h.getName().indexOf(HouseString) != -1) {
                if (theone == null) {
                    theone = h;
                } else {
                    if (Username != null) {
                        cm.toUser("This String was not unique, please be more specific", Username, true);
                    }
                    return null;
                }
            }
            if (!h.getName().equals(HouseString)) continue;
            theone = h;
            found = true;
        }
        if (theone == null) {
            if (Username != null) {
                cm.toUser("Couldn't find a House with this name", Username, true);
            }
            return null;
        }
        return theone;
    }

    public String serverExchangeConnect(String servers) {
        this.serverDescriptions.merge(servers);
        return this.serverDescriptions.encode();
    }

    public ServerDescriptionList getServerDescriptions() {
        return this.serverDescriptions;
    }

    public void addSavePlayers(SPlayer p) {
        this.savePlayers.put(p.getName().toLowerCase(), p);
    }

    public Hashtable getSavePlayers() {
        return this.savePlayers;
    }

    public void savePlayers() {
        while (this.isArchiving()) {
            try {
                Thread.sleep(125L);
            }
            catch (Exception ex) {}
        }
        Date d = new Date(System.currentTimeMillis());
        MMServ.mmlog.infoLog(d + ": Starting Player Saving cycle");
        Enumeration pSaves = cm.getSavePlayers().elements();
        while (pSaves.hasMoreElements()) {
            SPlayer p = (SPlayer)pSaves.nextElement();
            MMServ.mmlog.infoLog("Saving " + p.getName());
            p.savePlayerFile();
        }
        d = new Date(System.currentTimeMillis());
        MMServ.mmlog.mainLog(d + ": Player save cycle completed.");
        MMServ.mmlog.infoLog(d + ": Player saves finished.");
        cm.clearSavePlayers();
    }

    public void forceSavePlayers(String Username) {
        for (SHouse sHouse : cm.getData().getAllHouses()) {
            Enumeration<SPlayer> players = sHouse.getMembers().elements();
            while (players.hasMoreElements()) {
                SPlayer player = players.nextElement();
                player.savePlayerFile();
                if (Username == null) continue;
                cm.toUser(player.getName() + " saved", Username, true);
            }
        }
    }

    public void clearSavePlayers() {
        Iterator pSaves = cm.getSavePlayers().values().iterator();
        while (pSaves.hasNext()) {
            SPlayer p = (SPlayer)pSaves.next();
            if (!p.isRemoveable()) continue;
            pSaves.remove();
            if (p.getActivityStatus() != 1) continue;
            Object var2_2 = null;
        }
    }

    public void loadBanAmmo(String line) {
        StringTokenizer st = new StringTokenizer(line, "#");
        String HouseName = (String)st.nextElement();
        SHouse faction = null;
        if (!HouseName.equalsIgnoreCase("server")) {
            faction = cm.getHouseFromPartialString(HouseName, null);
            while (st.hasMoreTokens()) {
                faction.getBannedAmmo().put(st.nextToken(), "Banned");
            }
        } else {
            while (st.hasMoreElements()) {
                cm.getServerBannedAmmo().put(st.nextToken(), "Banned");
            }
        }
    }

    public void saveTopUnitID() {
        int topID = cm.getCurrentUnitID();
        try {
            FileOutputStream pout = new FileOutputStream("./campaign/topserverid.dat");
            PrintStream unitIDFile = new PrintStream(pout);
            unitIDFile.println(topID);
            unitIDFile.close();
            pout.close();
        }
        catch (Exception ex) {
            MMServ.mmlog.errLog(ex);
        }
    }

    public void loadTopUnitID() {
        try {
            File idFile = new File("./campaign/topserverid.dat");
            FileInputStream fis = new FileInputStream(idFile);
            BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
            cm.setCurrentUnitID(Integer.parseInt(dis.readLine()));
            dis.close();
            fis.close();
        }
        catch (Exception ex) {
            MMServ.mmlog.errLog(ex);
        }
    }

    public void setGamesCompleted(int i) {
        this.gamesCompleted = i;
    }

    public void addGamesCompleted(int i) {
        this.setGamesCompleted(this.getGamesCompleted() + i);
    }

    public int getGamesCompleted() {
        return this.gamesCompleted;
    }

    public int getEnumerationCount(Enumeration enumeration) {
        int count = 0;
        Enumeration tempEnum = enumeration;
        while (tempEnum.hasMoreElements()) {
            tempEnum.nextElement();
            ++count;
        }
        return count;
    }

    public int getMachineGunCount(Enumeration enumeration) {
        int count = 0;
        Enumeration tempEnum = enumeration;
        while (tempEnum.hasMoreElements()) {
            Mounted weapons = (Mounted)tempEnum.nextElement();
            WeaponType weapon = (WeaponType)weapons.getType();
            if (!weapon.hasFlag(512)) continue;
            ++count;
        }
        return count;
    }

    public int getHangarSpaceRequired(int typeid, int weightclass, int baymod, String model) {
        if (typeid == 3) {
            return 0;
        }
        if (typeid == 2 && Boolean.valueOf(cm.getConfig("FootInfTakeNoBays")).booleanValue()) {
            boolean isFoot = model.startsWith("Foot");
            boolean isAMFoot = model.startsWith("Anti-Mech Foot");
            if (isFoot || isAMFoot) {
                return 0;
            }
        }
        int result = 1;
        String techAmount = "TechsFor" + SUnit.getWeightClassDesc(weightclass) + SUnit.getTypeClassDesc(typeid);
        result = Integer.parseInt(cm.getConfig(techAmount));
        if ((result += baymod) < 0) {
            result = 0;
        }
        return result;
    }

    public Vector<String> getFactionTraits(String faction) {
        Vector<String> traits = new Vector<String>();
        File traitNames = new File("./data/pilotnames/" + faction.toLowerCase() + "traitnames.txt");
        if (!traitNames.exists()) {
            traitNames = new File("./data/pilotnames/commontraitnames.txt");
        }
        try {
            FileInputStream fis = new FileInputStream(traitNames);
            BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
            while (dis.ready()) {
                traits.addElement(dis.readLine());
            }
        }
        catch (FileNotFoundException nf) {
            MMServ.mmlog.errLog("File Not Found: " + traitNames);
        }
        catch (Exception ex) {
            MMServ.mmlog.errLog("Error loading Faction Traits: " + faction);
            MMServ.mmlog.errLog(ex);
        }
        return traits;
    }

    public void saveFactionTraits(String faction, Vector traits) {
        File traitFile = new File("./data/pilotnames/" + faction.toLowerCase() + "traitnames.txt");
        try {
            if (!traitFile.exists()) {
                traitFile.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(traitFile);
            PrintStream p = new PrintStream(fos);
            for (int pos = 0; pos < traits.size(); ++pos) {
                String tempTrait = (String)traits.elementAt(pos);
                p.println(tempTrait);
            }
        }
        catch (Exception ex) {
            MMServ.mmlog.errLog("Error while saving trait file for faction: " + faction);
            MMServ.mmlog.errLog(ex);
        }
    }

    public void setOmniVariantMods(Hashtable<String, String> table) {
        this.omniVariantMods = table;
    }

    public Hashtable<String, String> getOmniVariantMods() {
        return this.omniVariantMods;
    }

    public void saveOmniVariantMods() {
        if (this.omniVariantMods.size() < 1) {
            return;
        }
        try {
            FileOutputStream out = new FileOutputStream("./campaign/omnivariantmods.dat");
            PrintStream p = new PrintStream(out);
            Enumeration<String> e = cm.getOmniVariantMods().elements();
            Enumeration<String> key = cm.getOmniVariantMods().keys();
            while (e.hasMoreElements()) {
                String variant = key.nextElement();
                String mods = e.nextElement();
                p.println(variant + "#" + mods);
            }
            p.close();
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String moneyOrFluMessage(boolean money, boolean shortname, int amount) {
        return this.moneyOrFluMessage(money, shortname, amount, false);
    }

    public String moneyOrFluMessage(boolean money, boolean shortname, int amount, boolean showSign) {
        String result = Integer.toString(amount);
        String moneyShort = cm.getConfig("MoneyShortName").toLowerCase();
        String moneyLong = cm.getConfig("MoneyLongName");
        String fluShort = cm.getConfig("FluShortName").toLowerCase();
        String fluLong = cm.getConfig("FluLongName");
        String sign = "+";
        if (amount < 0) {
            sign = "-";
            result = Integer.toString(amount *= -1);
        }
        result = money ? (shortname ? (amount == 1 && moneyShort.endsWith("s") ? result + moneyShort.substring(0, moneyShort.length() - 1) : (amount > 1 && !moneyShort.endsWith("s") ? result + moneyShort + "s" : result + moneyShort)) : (amount == 1 && moneyLong.endsWith("s") ? result + moneyLong.substring(0, moneyLong.length() - 1) : (amount > 1 && !moneyLong.endsWith("s") ? result + moneyLong + "s" : result + moneyLong))) : (shortname ? (amount == 1 && fluShort.endsWith("s") ? result + fluShort.substring(0, fluShort.length() - 1) : (amount > 1 && !fluShort.endsWith("s") ? result + fluShort + "s" : result + fluShort)) : (amount == 1 && fluLong.endsWith("s") ? result + fluLong.substring(0, fluLong.length() - 1) : (amount > 1 && !fluLong.endsWith("s") ? result + fluLong + "s" : result + fluLong)));
        String toReturn = "";
        if (!shortname) {
            toReturn = " ";
        }
        toReturn = toReturn + result;
        if (showSign) {
            return sign + toReturn;
        }
        return toReturn;
    }

    public void loadOmniVariantMods() {
        try {
            File configFile = new File("./campaign/omnivariantmods.dat");
            FileInputStream fis = new FileInputStream(configFile);
            BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
            while (dis.ready()) {
                StringTokenizer line = new StringTokenizer(dis.readLine(), "#");
                cm.getOmniVariantMods().put(line.nextToken(), line.nextToken());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setArchiving(boolean archive) {
        this.isArchiving = archive;
    }

    public boolean isArchiving() {
        return this.isArchiving;
    }

    public SUnit buildWelfareMek(String producer) {
        String Filename = "./data/buildtables/3025/Welfare.txt";
        String unitFileName = BuildTable.getUnitFilename(Filename);
        SUnit cm = new SUnit(producer, unitFileName, 0);
        return cm;
    }

    public void saveConfigureFile(Properties config, String fileName) {
        TreeMap<Object, Object> tree = new TreeMap<Object, Object>(config);
        String property = "";
        String value = "";
        try {
            PrintStream ps = new PrintStream(new FileOutputStream(fileName));
            Iterator<Object> i = tree.keySet().iterator();
            while (i.hasNext()) {
                value = (String)tree.get(property);
                if (value != null) {
                    ps.println(property + "=" + value);
                }
                property = (String)i.next();
            }
            ps.close();
        }
        catch (FileNotFoundException fe) {
            MMServ.mmlog.errLog(fileName + " not found");
        }
        catch (Exception ex) {
            MMServ.mmlog.errLog(ex);
        }
    }

    public UnitCosts getUnitCostLists() {
        return CampaignMain.cm.unitCostLists;
    }

    public Client getMegaMekClient() {
        return this.megaMekClient;
    }

    public void setMegaMekClient(Client mmClient) {
        this.megaMekClient = mmClient;
    }

    public RepairTrackingThread getRTT() {
        return this.RTT;
    }
}

