/*
 * Decompiled with CFR 0.152.
 */
package server.campaign;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import server.campaign.CampaignMain;
import server.campaign.NewbiePlanet;
import server.campaign.NonConqHouse;
import server.campaign.SPlanet;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.SUnitFactory;
import server.campaign.dataFiles.SHouseData;
import server.campaign.util.UnitHistoryKeeper;

public class NewbieHouse
extends NonConqHouse {
    public int getDistanceTo(SPlanet p, SPlayer player) {
        if (p instanceof NewbiePlanet) {
            return 0;
        }
        return Integer.MAX_VALUE;
    }

    public NewbieHouse() {
        this.getMySHouseData().setHouseType(1);
    }

    public NewbieHouse(SHouseData data) {
        super(data);
    }

    public NewbieHouse(int id, String name, String HouseColor, int BaseGunner, int BasePilot, String abbreviation) {
        super(id, name, HouseColor, BaseGunner, BasePilot, abbreviation);
        this.setMayUseBM(false);
        this.getMySHouseData().setHouseType(1);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("[N]");
        result.append(super.toString());
        return result.toString();
    }

    public int getBaysProvided() {
        int newbBays = Integer.parseInt(CampaignMain.cm.getConfig("NewbieHouseBays"));
        return newbBays;
    }

    public int addMech(SUnit mech) {
        if (mech.getWeightclass() >= 2) {
            return 1;
        }
        Vector Weightclass = (Vector)this.getHangar(mech.getType()).elementAt(mech.getWeightclass());
        if (Weightclass.size() > 20) {
            return 1;
        }
        Weightclass.add(mech);
        return 0;
    }

    public String cleanupHangarAndPP() {
        for (int type = 0; type < 3; ++type) {
            for (int size = 0; size < 4; ++size) {
                Vector Weightclass = (Vector)this.getHangar(type).elementAt(size);
                while (Weightclass.size() > 20) {
                    Weightclass.removeElementAt(0);
                }
            }
        }
        return "";
    }

    public SUnit getEntity(int weightclass, int type_id) {
        SUnit m = super.getEntity(weightclass, type_id);
        if (m == null) {
            m = this.getRandomUnit(type_id, weightclass);
        }
        return m;
    }

    public void setPP(int weight, int val) {
    }

    public String potentialHouseProduction() {
        return "";
    }

    public int getMoney() {
        return 0;
    }

    public int getPP(int weight, int type_id) {
        return 1 * this.getPPCost(weight, type_id);
    }

    public void addMember(SPlayer p) {
        super.addMember(p);
        String units = this.getNewSOLUnits(p);
        String result = "<font color=\"black\">";
        p.addMoney(Integer.parseInt(CampaignMain.cm.getConfig("PlayerBaseMoney")));
        result = result + "<font color=\"blue\">WELCOME TO MEKWARS!</font>";
        result = result + "<br>";
        result = result + "<br>You've been assigned " + units;
        result = result + "<br><br>If you didn't already read the <b>New Player Guide</b>, do it now. It's in your client directory.";
        result = result + "<br>Have fun and enjoy your stay!";
        result = result + "</font><br>";
        CampaignMain.cm.toUser("SP|" + result, p.getName(), false);
    }

    public SUnit getRandomUnit(int type, int size) {
        SPlanet p = new SPlanet();
        p.setOwner(this);
        String productionName = CampaignMain.cm.getConfig("NewbieHouseName");
        SUnitFactory m = new SUnitFactory(productionName, p, SUnit.getWeightClassDesc(size), "Solaris", new Hashtable(), 0, 100, type);
        SUnit result = m.getMechProduced(type, this.getNewPilot(type));
        result.setProducer(productionName);
        return result;
    }

    public String requestNewMech(SPlayer p) {
        String result;
        int replace = Integer.parseInt(CampaignMain.cm.getConfig("NumUnitsToQualifyForNew"));
        if (p.getName().toLowerCase().startsWith("[coach]")) {
            replace = 99;
        }
        if (p.getActivityStatus() != 4) {
            if (p.getAllUnitsData().size() <= replace) {
                p.stripOfAllUnits();
                this.getNewSOLUnits(p);
                result = "Your units have been reset.";
                CampaignMain.cm.toUser("PS|" + p.toClientString(), p.getName(), false);
            } else {
                result = "You already have enough units!";
            }
        } else {
            result = "You cannot get new units while playing a game.";
        }
        return result;
    }

    public boolean isNewbieHouse() {
        return true;
    }

    public NewbieHouse(int id) {
        super(id);
        this.setMayUseBM(false);
        this.getMySHouseData().setHouseType(1);
    }

    public String getNewSOLUnits(SPlayer p) {
        int i;
        Vector<SUnit> units = new Vector<SUnit>();
        int numLMeks = Integer.parseInt(CampaignMain.cm.getConfig("SOLLightMeks"));
        int numMMeks = Integer.parseInt(CampaignMain.cm.getConfig("SOLMediumMeks"));
        int numHMeks = Integer.parseInt(CampaignMain.cm.getConfig("SOLHeavyMeks"));
        int numAMeks = Integer.parseInt(CampaignMain.cm.getConfig("SOLAssaultMeks"));
        int numLVehs = Integer.parseInt(CampaignMain.cm.getConfig("SOLLightVehs"));
        int numMVehs = Integer.parseInt(CampaignMain.cm.getConfig("SOLMediumVehs"));
        int numHVehs = Integer.parseInt(CampaignMain.cm.getConfig("SOLHeavyVehs"));
        int numAVehs = Integer.parseInt(CampaignMain.cm.getConfig("SOLAssaultVehs"));
        int numLInf = Integer.parseInt(CampaignMain.cm.getConfig("SOLLightInf"));
        int numMInf = Integer.parseInt(CampaignMain.cm.getConfig("SOLMediumInf"));
        int numHInf = Integer.parseInt(CampaignMain.cm.getConfig("SOLHeavyInf"));
        int numAInf = Integer.parseInt(CampaignMain.cm.getConfig("SOLAssaultInf"));
        int numLPM = Integer.parseInt(CampaignMain.cm.getConfig("SOLLightProtoMek"));
        int numMPM = Integer.parseInt(CampaignMain.cm.getConfig("SOLMediumProtoMek"));
        int numHPM = Integer.parseInt(CampaignMain.cm.getConfig("SOLHeavyProtoMek"));
        int numAPM = Integer.parseInt(CampaignMain.cm.getConfig("SOLAssaultProtoMek"));
        int numLBA = Integer.parseInt(CampaignMain.cm.getConfig("SOLLightBattleArmor"));
        int numMBA = Integer.parseInt(CampaignMain.cm.getConfig("SOLMediumBattleArmor"));
        int numHBA = Integer.parseInt(CampaignMain.cm.getConfig("SOLHeavyBattleArmor"));
        int numABA = Integer.parseInt(CampaignMain.cm.getConfig("SOLAssaultBattleArmor"));
        for (i = 0; i < numLMeks; ++i) {
            units.add(this.getRandomUnit(0, 0));
        }
        for (i = 0; i < numMMeks; ++i) {
            units.add(this.getRandomUnit(0, 1));
        }
        for (i = 0; i < numHMeks; ++i) {
            units.add(this.getRandomUnit(0, 2));
        }
        for (i = 0; i < numAMeks; ++i) {
            units.add(this.getRandomUnit(0, 3));
        }
        for (i = 0; i < numLVehs; ++i) {
            units.add(this.getRandomUnit(1, 0));
        }
        for (i = 0; i < numMVehs; ++i) {
            units.add(this.getRandomUnit(1, 1));
        }
        for (i = 0; i < numHVehs; ++i) {
            units.add(this.getRandomUnit(1, 2));
        }
        for (i = 0; i < numAVehs; ++i) {
            units.add(this.getRandomUnit(1, 3));
        }
        for (i = 0; i < numLInf; ++i) {
            units.add(this.getRandomUnit(2, 0));
        }
        for (i = 0; i < numMInf; ++i) {
            units.add(this.getRandomUnit(2, 1));
        }
        for (i = 0; i < numHInf; ++i) {
            units.add(this.getRandomUnit(2, 2));
        }
        for (i = 0; i < numAInf; ++i) {
            units.add(this.getRandomUnit(2, 3));
        }
        for (i = 0; i < numLPM; ++i) {
            units.add(this.getRandomUnit(3, 0));
        }
        for (i = 0; i < numMPM; ++i) {
            units.add(this.getRandomUnit(3, 1));
        }
        for (i = 0; i < numHPM; ++i) {
            units.add(this.getRandomUnit(3, 2));
        }
        for (i = 0; i < numAPM; ++i) {
            units.add(this.getRandomUnit(3, 3));
        }
        for (i = 0; i < numLBA; ++i) {
            units.add(this.getRandomUnit(4, 0));
        }
        for (i = 0; i < numMBA; ++i) {
            units.add(this.getRandomUnit(4, 1));
        }
        for (i = 0; i < numHBA; ++i) {
            units.add(this.getRandomUnit(4, 2));
        }
        for (i = 0; i < numABA; ++i) {
            units.add(this.getRandomUnit(4, 3));
        }
        Enumeration e = units.elements();
        String toReturn = "";
        while (e.hasMoreElements()) {
            SUnit currUnit = (SUnit)e.nextElement();
            p.addUnit(currUnit, true);
            UnitHistoryKeeper.addBoughtFromFactoryEntry(currUnit.getId(), p.getName(), this.getName());
            toReturn = toReturn + currUnit.getVerboseModelName();
            if (e.hasMoreElements()) {
                toReturn = toReturn + ", ";
                continue;
            }
            toReturn = toReturn + ".";
        }
        return toReturn;
    }
}

