/*
 * Decompiled with CFR 0.152.
 */
package server.campaign;

import common.Army;
import common.Unit;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import server.MMServ;
import server.campaign.CampaignMain;
import server.campaign.IArmy;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.dataFiles.SArmyData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SArmy
extends Army
implements IArmy {
    public void addUnit(SUnit u) {
        this.getUnits().add(u);
        super.setBV(0);
        this.setRawForceSize(0.0);
    }

    public void addUnit(SUnit u, int position) {
        this.getUnits().add(position, u);
        super.setBV(0);
        this.setRawForceSize(0.0);
    }

    public void removeUnit(int id) {
        Vector<Unit> v = this.getUnits();
        for (int i = 0; i < v.size(); ++i) {
            SUnit unit = (SUnit)v.elementAt(i);
            if (unit.getId() != id) continue;
            this.getUnits().removeElementAt(i);
            break;
        }
        super.setBV(0);
        this.setRawForceSize(0.0);
        this.removeUnitFromC3Network(id);
    }

    public int getUnitPosition(int id) {
        Vector<Unit> v = this.getUnits();
        for (int i = 0; i < v.size(); ++i) {
            SUnit unit = (SUnit)v.elementAt(i);
            if (unit.getId() != id) continue;
            return i;
        }
        return -1;
    }

    @Override
    public double getRawForceSize() {
        if (this.getMySArmyData().getRawForceSize() != 0.0) {
            return this.getMySArmyData().getRawForceSize();
        }
        Enumeration<Unit> e = this.getUnits().elements();
        while (e.hasMoreElements()) {
            SUnit u = (SUnit)e.nextElement();
            if (u.getType() == 2) {
                this.getMySArmyData().setRawForceSize(this.getMySArmyData().getRawForceSize() + Double.parseDouble(CampaignMain.cm.getConfig("InfantryOperationsBVMod")));
                continue;
            }
            if (u.getType() == 1) {
                this.getMySArmyData().setRawForceSize(this.getMySArmyData().getRawForceSize() + Double.parseDouble(CampaignMain.cm.getConfig("VehicleOperationsBVMod")));
                continue;
            }
            this.getMySArmyData().setRawForceSize(this.getMySArmyData().getRawForceSize() + Double.parseDouble(CampaignMain.cm.getConfig("MekOperationsBVMod")));
        }
        return this.getMySArmyData().getRawForceSize();
    }

    public void setRawForceSize(double rfs) {
        this.getMySArmyData().setRawForceSize(rfs);
    }

    @Override
    public int getOperationsBV(IArmy OpposingForce) {
        boolean useingOpRules = Boolean.valueOf(CampaignMain.cm.getConfig("UseOperationsRule"));
        if (!useingOpRules) {
            return this.getBV(false);
        }
        double thisRawSize = this.getRawForceSize();
        double opForceRawSize = Double.parseDouble(CampaignMain.cm.getConfig("BaseForceSize"));
        if (OpposingForce != null && OpposingForce.getRawForceSize() > opForceRawSize) {
            opForceRawSize = OpposingForce.getRawForceSize();
        }
        if (opForceRawSize >= thisRawSize) {
            return this.getBV(false);
        }
        double baseForcePenalty = Double.parseDouble(CampaignMain.cm.getConfig("BaseForcePenalty"));
        double forceDifference = thisRawSize - opForceRawSize;
        double baseForceMultiplier = forceDifference * baseForcePenalty;
        double rawForceMultiplier = forceDifference / opForceRawSize;
        double finalMultiplier = 0.0;
        finalMultiplier = baseForceMultiplier < rawForceMultiplier ? baseForceMultiplier : rawForceMultiplier;
        double doubleBV = this.getBV(false);
        return (int)(doubleBV * (finalMultiplier += 1.0));
    }

    public int getBV(boolean zeroWithDestroyed) {
        int total = 0;
        int subTotal = 0;
        boolean hasTAGHomingCombo = this.hasTAGAndHomingCombo();
        if (zeroWithDestroyed) {
            total = this.getBV();
        } else {
            Enumeration<Unit> e = this.getUnits().elements();
            while (e.hasMoreElements()) {
                SUnit u = (SUnit)e.nextElement();
                subTotal = u.hasBeenC3LinkedTo(this) ? u.getBV(true) : (this.getC3Network().get(new Integer(u.getId())) != null ? u.getBV(true) : u.getBV(false));
                if (hasTAGHomingCombo) {
                    double temp = (double)subTotal / u.getEntity().getCrew().getBVSkillMultiplier();
                    if (u.hasTAG()) {
                        temp += 200.0;
                    }
                    if (u.hasHoming()) {
                        temp += 200.0;
                    }
                    subTotal = (int)(temp *= u.getEntity().getCrew().getBVSkillMultiplier());
                }
                total += subTotal;
            }
        }
        return total;
    }

    public boolean hasTAGAndHomingCombo() {
        boolean hasTAG = false;
        boolean hasHoming = false;
        try {
            Enumeration<Unit> e = this.getUnits().elements();
            while (e.hasMoreElements()) {
                SUnit u = (SUnit)e.nextElement();
                if (u.hasTAG()) {
                    hasTAG = true;
                }
                if (u.hasHoming()) {
                    hasHoming = true;
                }
                if (!hasTAG || !hasHoming) continue;
                return true;
            }
        }
        catch (Exception ex) {
            MMServ.mmlog.errLog("Bad unit in army for TAGandHomingCombo returning false.");
            return false;
        }
        return false;
    }

    @Override
    public int getBV() {
        if (super.getBV() == 0) {
            this.calcBV();
        }
        int toReturn = super.getBV();
        return toReturn;
    }

    public void calcBV() {
        int total = 0;
        int subTotal = 0;
        boolean hasTAGHomingCombo = this.hasTAGAndHomingCombo();
        Enumeration<Unit> e = this.getUnits().elements();
        while (e.hasMoreElements()) {
            SUnit u = (SUnit)e.nextElement();
            subTotal = u.hasBeenC3LinkedTo(this) ? u.getBV(true) : (this.getC3Network().get(new Integer(u.getId())) != null ? u.getBV(true) : u.getBV(false));
            if (hasTAGHomingCombo) {
                double temp = (double)subTotal / u.getEntity().getCrew().getBVSkillMultiplier();
                if (u.hasTAG()) {
                    temp += 200.0;
                }
                if (u.hasHoming()) {
                    temp += 200.0;
                }
                subTotal = (int)(temp *= u.getEntity().getCrew().getBVSkillMultiplier());
            }
            total += subTotal;
        }
        this.setBV(total);
    }

    public SArmy() {
        super(new SArmyData());
        this.setOpponents(new Vector<SArmy>());
    }

    public SArmy(int id) {
        super(new SArmyData());
        this.setID(id);
        this.setOpponents(new Vector<SArmy>());
    }

    @Override
    public boolean matches(IArmy enemy) {
        int ownNum;
        int enemyNum;
        int cap = Integer.parseInt(CampaignMain.cm.getConfig("MaxBVDifference"));
        double percentCap = Double.parseDouble(CampaignMain.cm.getConfig("MaxBVPercent"));
        if (enemy.getBV() == 0) {
            return false;
        }
        if (percentCap == 0.0) {
            if (Math.abs(enemy.getOperationsBV(this) - this.getOperationsBV(enemy)) > cap) {
                return false;
            }
        } else {
            double myOpBV;
            double percent = 0.0;
            double enemyOpBV = enemy.getOperationsBV(this);
            if (enemyOpBV > (myOpBV = (double)this.getOperationsBV(enemy))) {
                percent = myOpBV / enemyOpBV;
                percent *= 100.0;
            } else {
                percent = enemyOpBV / myOpBV;
                percent *= 100.0;
            }
            percent = 100 - (int)percent;
            if ((int)(enemyOpBV * percent / 100.0) > cap || (int)(myOpBV * percent / 100.0) > cap ? percent > percentCap : Math.abs(enemyOpBV - myOpBV) > (double)cap) {
                return false;
            }
        }
        boolean infCounts = Boolean.valueOf(CampaignMain.cm.getConfig("CountInfForLimiters"));
        boolean allowLimiters = Boolean.valueOf(CampaignMain.cm.getConfig("AllowLimiters"));
        if (this.getLowerLimiter() != -1 && allowLimiters) {
            int smallest = -1;
            enemyNum = -1;
            if (infCounts) {
                smallest = this.getAmountOfUnits() - Math.abs(this.getLowerLimiter());
                enemyNum = enemy.getAmountOfUnits();
            } else {
                smallest = this.getAmountOfUnitsWithoutInfantry() - Math.abs(this.getLowerLimiter());
                enemyNum = enemy.getAmountOfUnitsWithoutInfantry();
            }
            if (smallest < 1) {
                smallest = 1;
            }
            if (enemyNum < smallest) {
                return false;
            }
        }
        if (this.getUpperLimiter() != -1 && allowLimiters) {
            int highest = -1;
            enemyNum = -1;
            if (infCounts) {
                highest = this.getAmountOfUnits() + this.getUpperLimiter();
                enemyNum = enemy.getAmountOfUnits();
            } else {
                highest = this.getAmountOfUnitsWithoutInfantry() + this.getUpperLimiter();
                enemyNum = enemy.getAmountOfUnitsWithoutInfantry();
            }
            if (enemyNum > highest) {
                return false;
            }
        }
        if (enemy.getLowerLimiter() != -1 && allowLimiters) {
            int smallest = -1;
            ownNum = -1;
            if (infCounts) {
                smallest = enemy.getAmountOfUnits() - Math.abs(enemy.getLowerLimiter());
                ownNum = this.getAmountOfUnits();
            } else {
                smallest = enemy.getAmountOfUnitsWithoutInfantry() - Math.abs(this.getLowerLimiter());
                ownNum = this.getAmountOfUnitsWithoutInfantry();
            }
            if (smallest < 1) {
                smallest = 1;
            }
            if (ownNum < smallest) {
                return false;
            }
        }
        if (enemy.getUpperLimiter() != -1 && allowLimiters) {
            int highest = -1;
            ownNum = -1;
            if (infCounts) {
                highest = enemy.getAmountOfUnits() + enemy.getUpperLimiter();
                ownNum = this.getAmountOfUnits();
            } else {
                highest = enemy.getAmountOfUnitsWithoutInfantry() + enemy.getUpperLimiter();
                ownNum = this.getAmountOfUnitsWithoutInfantry();
            }
            if (ownNum > highest) {
                return false;
            }
        }
        return true;
    }

    public double getWeightedNumberOfUnits() {
        double[] mekscale = new double[]{1.5, 1.5, 2.0, 2.0};
        double[] vehscale = new double[]{0.75, 0.75, 1.0, 1.0};
        double[] infscale = new double[]{0.2, 0.2, 0.2, 0.2};
        double result = 0.0;
        Enumeration<Unit> en = this.getUnits().elements();
        while (en.hasMoreElements()) {
            SUnit mech = (SUnit)en.nextElement();
            if (mech.getType() == 1) {
                result += vehscale[mech.getWeightclass()];
                continue;
            }
            if (mech.getType() == 2) {
                result += infscale[mech.getWeightclass()];
                continue;
            }
            result += mekscale[mech.getWeightclass()];
        }
        return result;
    }

    @Override
    public int getAmountOfUnitsWithoutInfantry() {
        int total = 0;
        Enumeration<Unit> en = this.getUnits().elements();
        while (en.hasMoreElements()) {
            SUnit unit = (SUnit)en.nextElement();
            if (unit.getType() == 2) continue;
            ++total;
        }
        return total;
    }

    public int getAmountOfUnits(boolean countInfantry) {
        if (countInfantry) {
            return this.getAmountOfUnits();
        }
        return this.getAmountOfUnitsWithoutInfantry();
    }

    public boolean isNewbieFriendly() {
        boolean infantryVsSOL = Boolean.valueOf(CampaignMain.cm.getConfig("InfantryVsSOL"));
        boolean vehiclesVsSOL = Boolean.valueOf(CampaignMain.cm.getConfig("VehiclesVsSOL"));
        int maxInfWeightclass = Integer.parseInt(CampaignMain.cm.getConfig("MaxInfantryWeightclassVsSOL"));
        int maxVehWeightclass = Integer.parseInt(CampaignMain.cm.getConfig("MaxVehicleWeightclassVsSOL"));
        int maxMekWeightclass = Integer.parseInt(CampaignMain.cm.getConfig("MaxMekWeightclassVsSOL"));
        Enumeration<Unit> en = this.getUnits().elements();
        while (en.hasMoreElements()) {
            Unit unit = en.nextElement();
            if (unit.getType() == 0 && unit.getWeightclass() > maxMekWeightclass) {
                return false;
            }
            if (unit.getType() == 2 || unit.getType() == 3 || unit.getType() == 4) {
                if (!infantryVsSOL) {
                    return false;
                }
                if (unit.getWeightclass() <= maxInfWeightclass) continue;
                return false;
            }
            if (unit.getType() != 1) continue;
            if (!vehiclesVsSOL) {
                return false;
            }
            if (unit.getWeightclass() <= maxVehWeightclass) continue;
            return false;
        }
        return true;
    }

    public String getInaccurateDescription() {
        return "(Units: " + this.getAmountOfUnits() + " / BV: " + this.getBV() + ")";
    }

    public String getDescription(boolean accurate, boolean showID, boolean idShouldLink) {
        String toReturn = "";
        if (accurate) {
            if (showID && !idShouldLink) {
                toReturn = toReturn + "#" + this.getID() + " - ";
            } else if (showID && idShouldLink) {
                toReturn = toReturn + "<a href=\"MEKWARS/c sth#a#" + this.getID() + "\">#" + this.getID() + "</a> - ";
            }
            toReturn = toReturn + this.getDescription(accurate);
        } else {
            toReturn = toReturn + this.getDescription(accurate);
        }
        return toReturn;
    }

    public String getDescription(boolean accurate) {
        if (accurate) {
            String result = "";
            if (!(this.getName().trim().equals("") || this.getName().equalsIgnoreCase("None") || this.getName().equalsIgnoreCase("No Name"))) {
                result = "\"" + this.getName() + "\" - ";
            }
            Enumeration<Unit> en = this.getUnits().elements();
            while (en.hasMoreElements()) {
                result = result + ((SUnit)en.nextElement()).getSmallDescription();
                if (!en.hasMoreElements()) continue;
                result = result + ", ";
            }
            result = result + "; BV: " + this.getBV();
            boolean usingOperationsRule = Boolean.valueOf(CampaignMain.cm.getConfig("UseOperationsRule"));
            if (this.getUnits().size() > 4 && usingOperationsRule) {
                result = result + ", BV. vs 4 Units: " + this.getOperationsBV(null);
            }
            return result;
        }
        return this.getInaccurateDescription();
    }

    public int getAverageUnitSize() {
        if (this.getAmountOfUnits() == 0) {
            return 0;
        }
        int sum = 0;
        Enumeration<Unit> en = this.getUnits().elements();
        while (en.hasMoreElements()) {
            SUnit unit = (SUnit)en.nextElement();
            sum += unit.getWeightclass();
        }
        return sum / this.getAmountOfUnits();
    }

    public int getHeaviesUnitClass() {
        int max = 0;
        Enumeration<Unit> en = this.getUnits().elements();
        while (en.hasMoreElements()) {
            SUnit unit = (SUnit)en.nextElement();
            if (unit.getWeightclass() <= max) continue;
            max = unit.getWeightclass();
        }
        return max;
    }

    public void fromString(String s, String delimiter, SPlayer p) {
        int i;
        StringTokenizer ST = new StringTokenizer(s, delimiter);
        this.setID(Integer.parseInt(ST.nextToken()));
        this.setName(ST.nextToken());
        this.setLowerLimiter(Integer.parseInt(ST.nextToken()));
        this.setUpperLimiter(Integer.parseInt(ST.nextToken()));
        int count = Integer.parseInt(ST.nextToken());
        for (i = 0; i < count; ++i) {
            int id = Integer.parseInt(ST.nextToken());
            if (id == 0) continue;
            this.addUnit(p.getUnit(id));
        }
        if (ST.hasMoreElements()) {
            count = Integer.parseInt(ST.nextToken());
            for (i = 0; i < count; ++i) {
                int key = Integer.parseInt(ST.nextToken());
                int unit = Integer.parseInt(ST.nextToken());
                this.getC3Network().put(new Integer(key), new Integer(unit));
            }
        }
    }

    public String getMinimalInfo() {
        return this.getDescription(true);
    }

    public SArmyData getMySArmyData() {
        return (SArmyData)this.getMyData();
    }

    public String getInfo() {
        return this.getDescription(true);
    }

    public TreeMap<String, String> getLegalOperations() {
        return this.getMySArmyData().getLegalOperations();
    }

    public void setOpponents(Vector<SArmy> v) {
        this.getMySArmyData().setOpponents(v);
    }

    public Vector<SArmy> getOpponents() {
        return this.getMySArmyData().getOpponents();
    }

    public void addOpponent(SArmy a) {
        try {
            this.getOpponents().add(a);
        }
        catch (Exception e) {
            MMServ.mmlog.errLog("Error adding army to opponentList. Trace follows.");
            MMServ.mmlog.errLog(e);
        }
    }

    public void removeOpponent(SArmy a) {
        try {
            this.getOpponents().remove(a);
        }
        catch (Exception e) {
            MMServ.mmlog.errLog("Error removing army from opponentList. Trace follows.");
            MMServ.mmlog.errLog(e);
        }
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        CampaignMain.cm.toUser("PL|RNA|" + this.getID() + "#" + name, this.getPlayerName(), false);
    }

    public void setPlayerName(String s) {
        this.getMySArmyData().setPlayerName(s);
    }

    public String getPlayerName() {
        return this.getMySArmyData().getPlayerName();
    }

    public boolean isLegalMekToInfantryRatio() {
        int infcount = 0;
        int mekcount = 0;
        Enumeration<Unit> en = this.getUnits().elements();
        while (en.hasMoreElements()) {
            Unit unit = en.nextElement();
            if (unit.getType() == 2) {
                ++infcount;
                continue;
            }
            if (unit.getType() != 0) continue;
            ++mekcount;
        }
        if (infcount == 0) {
            return true;
        }
        if (mekcount == 0) {
            return false;
        }
        int ratio = infcount * 100 / mekcount;
        return ratio <= Integer.parseInt(CampaignMain.cm.getConfig("MekToInfantryRatio"));
    }

    public boolean isLegalMekToVehicleRatio() {
        int veecount = 0;
        int mekcount = 0;
        Enumeration<Unit> en = this.getUnits().elements();
        while (en.hasMoreElements()) {
            Unit unit = en.nextElement();
            if (unit.getType() == 1) {
                ++veecount;
                continue;
            }
            if (unit.getType() != 0) continue;
            ++mekcount;
        }
        if (veecount == 0) {
            return true;
        }
        if (mekcount == 0) {
            return false;
        }
        int ratio = veecount * 100 / mekcount;
        return ratio <= Integer.parseInt(CampaignMain.cm.getConfig("MekToVehicleRatio"));
    }

    public void checkLegalRatio(String Username) {
        if (Boolean.valueOf(CampaignMain.cm.getConfig("AllowRatios")).booleanValue()) {
            if (!this.isLegalMekToInfantryRatio()) {
                CampaignMain.cm.toUser("This army has an Illegal Mek to Infantry ratio and will not be allowed to participate in games.", Username, true);
            } else if (!this.isLegalMekToVehicleRatio()) {
                CampaignMain.cm.toUser("This army has an Illegal Mek to Vehicle ratio and will not be allowed to participate in games.", Username, true);
            } else {
                CampaignMain.cm.toUser("Army Ratio Checks", Username, true);
            }
        }
    }

    @Override
    public void setLowerLimiter(int lowerLimit) {
        int buffer = Integer.parseInt(CampaignMain.cm.getConfig("LowerLimitBuffer"));
        if (lowerLimit < buffer && lowerLimit != -1) {
            lowerLimit = buffer;
            CampaignMain.cm.toUser("Army " + this.getID() + "'s lower limit set to " + buffer + ".", this.getPlayerName(), true);
            CampaignMain.cm.toUser("PL|SAB|" + this.getID() + "#" + this.getLowerLimiter() + "#" + this.getUpperLimiter(), this.getPlayerName(), false);
        }
        super.setLowerLimiter(lowerLimit);
    }

    @Override
    public void setUpperLimiter(int upperLimit) {
        int buffer = Integer.parseInt(CampaignMain.cm.getConfig("UpperLimitBuffer"));
        if (upperLimit < buffer && upperLimit != -1) {
            upperLimit = buffer;
            CampaignMain.cm.toUser("Army " + this.getID() + "'s upper limit set to " + buffer + ".", this.getPlayerName(), true);
            CampaignMain.cm.toUser("PL|SAB|" + this.getID() + "#" + this.getLowerLimiter() + "#" + this.getUpperLimiter(), this.getPlayerName(), false);
        }
        super.setUpperLimiter(upperLimit);
    }

    public boolean isUnitInArmy(SUnit unit) {
        if (unit == null) {
            return false;
        }
        Vector<Unit> v = this.getUnits();
        for (int i = 0; i < v.size(); ++i) {
            SUnit newUnit = (SUnit)v.elementAt(i);
            if (!newUnit.equals(unit)) continue;
            return true;
        }
        return false;
    }
}

