/*
 * Decompiled with CFR 0.152.
 */
package server.campaign;

import common.CampaignData;
import common.persistence.MMNetSerializable;
import common.persistence.TreeReader;
import common.persistence.TreeWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import server.MMServ;
import server.campaign.CampaignMain;
import server.campaign.NewbieHouse;
import server.campaign.NewbiePlanet;
import server.campaign.NonConqHouse;
import server.campaign.NormalHouse;
import server.campaign.PilotQueues;
import server.campaign.SArmy;
import server.campaign.SPlanet;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.SUnitFactory;
import server.campaign.SmallPlayer;
import server.campaign.commands.Command;
import server.campaign.data.TimeUpdateHouse;
import server.campaign.dataFiles.SHouseData;
import server.campaign.dataFiles.SUnitData;
import server.campaign.event.StatusChangeEvent;
import server.campaign.event.StatusChangeListener;
import server.campaign.event.UserEvent;
import server.campaign.market.MarketBuyer;
import server.campaign.market.MarketSeller;
import server.campaign.market.MarketUnit;
import server.campaign.mercenaries.ContractInfo;
import server.campaign.mercenaries.MercHouse;
import server.campaign.operations.Operation;
import server.campaign.operations.ShortOperation;
import server.campaign.pilot.SPilot;
import server.campaign.util.OpponentListHelper;
import server.campaign.util.UnitHistoryKeeper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SHouse
extends TimeUpdateHouse
implements MMNetSerializable,
Comparable,
StatusChangeListener,
MarketSeller,
MarketBuyer {
    public static final int NORMALHOUSE = 0;
    public static final int NEWBIEHOUSE = 1;
    public static final int MERCHOUSE = 2;
    public static final int NONCONQUERHOUSE = 3;

    public SHouseData getMySHouseData() {
        return (SHouseData)this.getMyData();
    }

    public String toString() {
        int j;
        int i;
        int x;
        int j2;
        Vector tmpVec;
        int i2;
        StringBuffer result = new StringBuffer();
        result.append("HS\u00a7");
        result.append(this.getName());
        result.append("|");
        result.append(this.getMoney());
        result.append("|");
        result.append(this.getHouseColor());
        result.append("|");
        result.append(this.getBaseGunner());
        result.append("|");
        result.append(this.getBasePilot());
        result.append("|");
        result.append(this.getAbbreviation());
        result.append("|");
        for (i2 = 0; i2 < 4; ++i2) {
            tmpVec = (Vector)this.getHangar(0).elementAt(i2);
            tmpVec.trimToSize();
            result.append(tmpVec.size());
            result.append("|");
            for (j2 = 0; j2 < tmpVec.size(); ++j2) {
                result.append(((SUnit)tmpVec.elementAt(j2)).toString(false));
                result.append("|");
            }
        }
        for (i2 = 0; i2 < 4; ++i2) {
            tmpVec = (Vector)this.getHangar(1).elementAt(i2);
            tmpVec.trimToSize();
            result.append(tmpVec.size());
            result.append("|");
            for (j2 = 0; j2 < tmpVec.size(); ++j2) {
                result.append(((SUnit)tmpVec.elementAt(j2)).toString(false));
                result.append("|");
            }
        }
        if (Boolean.valueOf(CampaignMain.cm.getConfig("UseInfantry")).booleanValue()) {
            for (i2 = 0; i2 < 4; ++i2) {
                tmpVec = (Vector)this.getHangar(2).elementAt(i2);
                tmpVec.trimToSize();
                result.append(tmpVec.size());
                result.append("|");
                for (j2 = 0; j2 < tmpVec.size(); ++j2) {
                    result.append(((SUnit)tmpVec.elementAt(j2)).toString(false));
                    result.append("|");
                }
            }
        }
        result.append(this.getLogo());
        result.append("|");
        result.append(this.getMembers().size());
        result.append("|");
        result.append("Components|");
        Enumeration<Integer> e = this.getComponents().keys();
        while (e.hasMoreElements()) {
            Integer id = e.nextElement();
            Vector<Integer> v = this.getComponents().get(id);
            result.append(id + "|" + v.size() + "|");
            for (int i3 = 0; i3 < v.size(); ++i3) {
                result.append(v.elementAt(i3) + "|");
            }
        }
        result.append("EndComponents");
        result.append("|");
        result.append(this.getInitialHouseRanking());
        result.append("|");
        result.append(this.canConquerPlanets());
        result.append("|");
        result.append(this.isInHouseAttacks());
        result.append("|");
        result.append(this.getId());
        result.append("|");
        result.append(this.getHousePlayerColor(this.getMyData().redColor));
        result.append("|");
        result.append(this.getHousePlayerColor(this.getMyData().greenColor));
        result.append("|");
        result.append(this.getHousePlayerColor(this.getMyData().blueColor));
        result.append("|");
        result.append(this.getHouseDefectionFrom());
        result.append("|");
        result.append(this.getPilotQueues().getQueueSize(0));
        result.append("|");
        LinkedList PilotList = this.getPilotQueues().getPilotQueue(0);
        for (x = 0; x < PilotList.size(); ++x) {
            SPilot Pilot2 = (SPilot)PilotList.get(x);
            result.append(Pilot2.toFileFormat("#", false));
            result.append("|");
        }
        result.append(this.getPilotQueues().getQueueSize(1));
        result.append("|");
        PilotList = this.getPilotQueues().getPilotQueue(1);
        for (x = 0; x < PilotList.size(); ++x) {
            SPilot Pilot3 = (SPilot)PilotList.get(x);
            result.append(Pilot3.toFileFormat("#", false));
            result.append("|");
        }
        result.append(this.getPilotQueues().getQueueSize(2));
        result.append("|");
        PilotList = this.getPilotQueues().getPilotQueue(2);
        for (x = 0; x < PilotList.size(); ++x) {
            SPilot Pilot4 = (SPilot)PilotList.get(x);
            result.append(Pilot4.toFileFormat("#", false));
            result.append("|");
        }
        result.append(this.getHouseFluFile());
        result.append("|");
        for (i = 0; i < 4; ++i) {
            Vector tmpVec2 = (Vector)this.getHangar(4).elementAt(i);
            tmpVec2.trimToSize();
            result.append(tmpVec2.size());
            result.append("|");
            for (j = 0; j < tmpVec2.size(); ++j) {
                result.append(((SUnit)tmpVec2.elementAt(j)).toString(false));
                result.append("|");
            }
        }
        for (i = 0; i < 4; ++i) {
            Vector tmpVec3 = (Vector)this.getHangar(3).elementAt(i);
            tmpVec3.trimToSize();
            result.append(tmpVec3.size());
            result.append("|");
            for (j = 0; j < tmpVec3.size(); ++j) {
                result.append(((SUnit)tmpVec3.elementAt(j)).toString(false));
                result.append("|");
            }
        }
        result.append(this.getPilotQueues().getQueueSize(4));
        result.append("|");
        PilotList = this.getPilotQueues().getPilotQueue(4);
        for (x = 0; x < PilotList.size(); ++x) {
            SPilot Pilot5 = (SPilot)PilotList.get(x);
            result.append(Pilot5.toFileFormat("#", false));
            result.append("|");
        }
        result.append(this.getPilotQueues().getQueueSize(3));
        result.append("|");
        PilotList = this.getPilotQueues().getPilotQueue(3);
        for (x = 0; x < PilotList.size(); ++x) {
            SPilot Pilot6 = (SPilot)PilotList.get(x);
            result.append(Pilot6.toFileFormat("#", false));
            result.append("|");
        }
        if (this.getMotd().equals("")) {
            result.append(" ");
        } else {
            result.append(this.getMotd());
        }
        result.append("|");
        result.append(this.getHouseDefectionTo());
        result.append("|");
        return result.toString();
    }

    public Hashtable<Integer, Vector<Integer>> getComponents() {
        return this.getMySHouseData().getComponents();
    }

    @Override
    public void binOut(TreeWriter out) {
        Vector tmpVec;
        int i;
        super.binOut(out);
        out.write(this.getMoney(), "money");
        for (i = 0; i < 4; ++i) {
            tmpVec = (Vector)this.getHangar(0).elementAt(i);
            out.write(tmpVec, "hangar" + i);
        }
        for (i = 0; i < 4; ++i) {
            tmpVec = (Vector)this.getHangar(1).elementAt(i);
            out.write(tmpVec, "vehicle" + i);
        }
        if (Boolean.valueOf(CampaignMain.cm.getConfig("UseInfantry")).booleanValue()) {
            for (i = 0; i < 4; ++i) {
                tmpVec = (Vector)this.getHangar(2).elementAt(i);
                out.write(tmpVec, "infantry" + i);
            }
        }
        out.write(this.getMembers().values(), "members");
        out.startDataBlock("components");
        out.write(this.getMySHouseData().getComponents().size(), "size");
        Enumeration<Integer> e = this.getMySHouseData().getComponents().keys();
        while (e.hasMoreElements()) {
            Integer id = e.nextElement();
            Vector<Integer> v = this.getMySHouseData().getComponents().get(id);
            out.startDataBlock("component");
            out.write(id, "id");
            String ids = "";
            for (int i2 = 0; i2 < v.size(); ++i2) {
                ids = ids + v.elementAt(i2) + (i2 + 1 < v.size() ? "," : "");
            }
            out.write(ids, "ids");
            out.endDataBlock("component");
        }
        out.endDataBlock("components");
    }

    @Override
    public void binIn(TreeReader in, CampaignData data) throws IOException {
        super.binIn(in, data);
        this.setMoney(in.readInt("money"));
    }

    public String getScoutSource() {
        String bnd = this.getName().equals("Steiner") ? "Lyranischer Nachrichten Dienst" : (this.getName().equals("Kurita") ? "ISF" : (this.getName().equals("Davion") ? "MIIO" : (this.getName().equals("Liao") ? "Maskirovka" : (this.getName().equals("Marik") ? "SAFE" : "Army Intelligence Service"))));
        return bnd;
    }

    @Override
    public String getHouseName() {
        return this.getName();
    }

    public String fromString(String s, Random r) {
        try {
            int j;
            SUnit m;
            int numofmechs;
            int i;
            int j2;
            SUnit m2;
            int i2;
            if (CampaignMain.cm.isDebugEnabled()) {
                MMServ.mmlog.infoLog("House: " + s);
            }
            s = s.substring(3);
            StringTokenizer ST = new StringTokenizer(s, "|");
            this.setName((String)ST.nextElement());
            this.setMoney(Integer.parseInt((String)ST.nextElement()));
            this.setHouseColor((String)ST.nextElement());
            this.setBaseGunner(Integer.parseInt((String)ST.nextElement()));
            this.setBasePilot(Integer.parseInt((String)ST.nextElement()));
            this.setPilotQueues(new PilotQueues(this.getBaseGunner(), this.getBasePilot()));
            this.getPilotQueues().setFactionString(this.getName());
            this.setAbbreviation((String)ST.nextElement());
            this.setActMembers(new Hashtable());
            this.setFightingMembers(new Hashtable());
            this.getHangar().put(new Integer(0), new Vector(5, 1));
            this.getHangar().put(new Integer(1), new Vector(5, 1));
            this.getHangar().put(new Integer(2), new Vector(5, 1));
            this.getHangar().put(new Integer(3), new Vector(5, 1));
            this.getHangar().put(new Integer(4), new Vector(5, 1));
            for (i2 = 0; i2 < 4; ++i2) {
                this.getHangar(0).add(new Vector());
                this.getHangar(1).add(new Vector());
                this.getHangar(2).add(new Vector());
                this.getHangar(4).add(new Vector());
                this.getHangar(3).add(new Vector());
            }
            block7: for (i2 = 0; i2 < 4; ++i2) {
                int numofmechs2 = Integer.parseInt((String)ST.nextElement());
                m2 = null;
                for (j2 = 0; j2 < numofmechs2; ++j2) {
                    m2 = new SUnit();
                    m2.fromString((String)ST.nextElement());
                    if (m2 == null) {
                        MMServ.mmlog.errLog("Problem loading Meks for House: " + this.getName());
                        continue block7;
                    }
                    this.addUnit(m2, false);
                }
            }
            block9: for (i2 = 0; i2 < 4; ++i2) {
                int numofvehicles = Integer.parseInt((String)ST.nextElement());
                for (j2 = 0; j2 < numofvehicles; ++j2) {
                    m2 = new SUnit();
                    m2.fromString((String)ST.nextElement());
                    if (m2 == null) {
                        MMServ.mmlog.errLog("Problem loading vehicles for House: " + this.getName());
                        continue block9;
                    }
                    this.addUnit(m2, false);
                }
            }
            if (Boolean.valueOf(CampaignMain.cm.getConfig("UseInfantry")).booleanValue()) {
                block11: for (i2 = 0; i2 < 4; ++i2) {
                    Vector v = new Vector();
                    int numofinfantry = Integer.parseInt((String)ST.nextElement());
                    for (int j3 = 0; j3 < numofinfantry; ++j3) {
                        SUnit m3 = new SUnit();
                        m3.fromString((String)ST.nextElement());
                        if (m3 == null) {
                            MMServ.mmlog.errLog("Problem loading Infantry for House: " + this.getName());
                            continue block11;
                        }
                        this.addUnit(m3, false);
                    }
                }
            }
            Object o = ST.nextElement();
            int numofmembers = 0;
            try {
                numofmembers = Integer.parseInt((String)o);
            }
            catch (Exception ex) {
                this.setLogo((String)o);
                numofmembers = Integer.parseInt((String)ST.nextElement());
            }
            this.setMembers(new Hashtable());
            String next = ST.nextToken();
            while (!next.equals("Components")) {
                SPlayer p = new SPlayer();
                p.fromString(next, this);
                p.addStatusListener(this);
                this.getMembers().put(p.getName().toLowerCase(), p);
                next = (String)ST.nextElement();
            }
            this.getComponents().put(0, new Vector(4, 1));
            this.getComponents().put(1, new Vector(4, 1));
            this.getComponents().put(2, new Vector(4, 1));
            this.getComponents().put(4, new Vector(4, 1));
            this.getComponents().put(3, new Vector(4, 1));
            for (int i3 = 0; i3 < 4; ++i3) {
                this.getComponents().get(0).add(0);
                this.getComponents().get(1).add(0);
                this.getComponents().get(2).add(0);
                this.getComponents().get(4).add(0);
                this.getComponents().get(3).add(0);
            }
            boolean finished = false;
            while (!finished) {
                next = ST.nextToken();
                if (!next.equals("EndComponents")) {
                    Integer id = new Integer(next);
                    int count = Integer.parseInt(ST.nextToken());
                    for (i = 0; i < count; ++i) {
                        Vector<Integer> v = this.getComponents().get(new Integer(id));
                        int val = new Integer(ST.nextToken());
                        v.setElementAt(val, i);
                    }
                    continue;
                }
                finished = true;
            }
            if (ST.hasMoreElements()) {
                this.setInitialHouseRanking(Integer.parseInt(ST.nextToken()));
            }
            if (ST.hasMoreElements()) {
                this.setConquerable(Boolean.valueOf(ST.nextToken()));
            }
            if (ST.hasMoreElements()) {
                this.setInHouseAttacks(Boolean.valueOf(ST.nextToken()));
            }
            this.setId(Integer.parseInt(ST.nextToken()));
            if (ST.hasMoreElements()) {
                try {
                    int redColor = Integer.parseInt(ST.nextToken());
                    int greenColor = Integer.parseInt(ST.nextToken());
                    int blueColor = Integer.parseInt(ST.nextToken());
                    this.setHousePlayerColors(redColor, greenColor, blueColor);
                }
                catch (Exception ex) {
                    this.setHousePlayerColors(255, 255, 255);
                }
            }
            if (ST.hasMoreElements()) {
                this.setHouseDefectionFrom(Boolean.valueOf(ST.nextToken()));
            }
            if (ST.hasMoreElements()) {
                for (int pilotCount = Integer.parseInt(ST.nextToken()); pilotCount > 0; --pilotCount) {
                    SPilot p = new SPilot();
                    p.fromFileFormat(ST.nextToken(), "#");
                    this.getPilotQueues().loadPilot(0, p);
                }
            }
            if (ST.hasMoreElements()) {
                for (int pilotCount = Integer.parseInt(ST.nextToken()); pilotCount > 0; --pilotCount) {
                    SPilot p = new SPilot();
                    p.fromFileFormat(ST.nextToken(), "#");
                    this.getPilotQueues().loadPilot(1, p);
                }
            }
            if (ST.hasMoreElements()) {
                for (int pilotCount = Integer.parseInt(ST.nextToken()); pilotCount > 0; --pilotCount) {
                    SPilot p = new SPilot();
                    p.fromFileFormat(ST.nextToken(), "#");
                    this.getPilotQueues().loadPilot(2, p);
                }
            }
            if (ST.hasMoreElements()) {
                this.setHouseFluFile(ST.nextToken());
            }
            if (ST.hasMoreElements()) {
                block20: for (int i4 = 0; i4 < 4; ++i4) {
                    Vector v = new Vector();
                    numofmechs = Integer.parseInt((String)ST.nextElement());
                    m = null;
                    for (j = 0; j < numofmechs; ++j) {
                        m = new SUnit();
                        m.fromString((String)ST.nextElement());
                        if (m == null) {
                            MMServ.mmlog.errLog("Problem loading Protos for House: " + this.getName());
                            continue block20;
                        }
                        this.addUnit(m, false);
                    }
                }
            }
            if (ST.hasMoreElements()) {
                block22: for (int i5 = 0; i5 < 4; ++i5) {
                    Vector v = new Vector();
                    numofmechs = Integer.parseInt((String)ST.nextElement());
                    m = null;
                    for (j = 0; j < numofmechs; ++j) {
                        m = new SUnit();
                        m.fromString((String)ST.nextElement());
                        if (m == null) {
                            MMServ.mmlog.errLog("Problem loading Protos for House: " + this.getName());
                            continue block22;
                        }
                        this.addUnit(m, false);
                    }
                }
            }
            if (ST.hasMoreElements()) {
                for (int pilotCount = Integer.parseInt(ST.nextToken()); pilotCount > 0; --pilotCount) {
                    SPilot p = new SPilot();
                    p.fromFileFormat(ST.nextToken(), "#");
                    this.getPilotQueues().loadPilot(4, p);
                }
            }
            if (ST.hasMoreElements()) {
                for (int pilotCount = Integer.parseInt(ST.nextToken()); pilotCount > 0; --pilotCount) {
                    SPilot p = new SPilot();
                    p.fromFileFormat(ST.nextToken(), "#");
                    this.getPilotQueues().loadPilot(3, p);
                }
            }
            if (ST.hasMoreElements()) {
                this.setMotd(ST.nextToken());
            }
            if (ST.hasMoreElements()) {
                this.setHouseDefectionTo(new Boolean(ST.nextToken()));
            }
            if (this.isMercHouse()) {
                int contractamount = 0;
                if (ST.hasMoreElements()) {
                    contractamount = Integer.parseInt(ST.nextToken());
                }
                Hashtable<String, ContractInfo> merctable = new Hashtable<String, ContractInfo>();
                for (i = 0; i < contractamount; ++i) {
                    ContractInfo ci = new ContractInfo();
                    ci.fromString(ST.nextToken());
                    merctable.put(ci.getPlayerName(), ci);
                }
                ((MercHouse)this).setOutstandingContracts(merctable);
            }
            MMServ.mmlog.mainLog("House loaded: " + this.getName());
            return s;
        }
        catch (Exception ex) {
            MMServ.mmlog.errLog(ex);
            MMServ.mmlog.errLog("Error while loading House " + this.getName() + " going with what we have.");
            return s;
        }
    }

    public void postXMLLoading() {
        for (SPlayer p : this.getMembers().values()) {
            p.addStatusListener(this);
        }
    }

    public SHouse(int id) {
        super(id);
        this.myData = new SHouseData();
    }

    public static SHouse getHouse(SHouseData data) {
        if (data.getHouseType() == 0) {
            return new NormalHouse(data);
        }
        if (data.getHouseType() == 3) {
            return new NonConqHouse(data);
        }
        if (data.getHouseType() == 2) {
            return new MercHouse(data);
        }
        if (data.getHouseType() == 1) {
            return new NewbieHouse(data);
        }
        return null;
    }

    public SHouse() {
        this.myData = new SHouseData();
        this.setActMembers(new Hashtable());
        this.setFightingMembers(new Hashtable());
        this.setSmallPlayers(new Hashtable());
        this.setStatusChangeList(new EventListenerList());
    }

    public void setStatusChangeList(EventListenerList l) {
        this.getMySHouseData().setStatusChangeList(l);
    }

    public void setFightingMembers(Hashtable h) {
        this.getMySHouseData().setFightingMembers(h);
    }

    public void setActMembers(Hashtable h) {
        this.getMySHouseData().setActMembers(h);
    }

    public void setSmallPlayers(Hashtable h) {
        this.getMySHouseData().setSmallPlayers(h);
    }

    public int getBaysProvided() {
        return this.getMySHouseData().getBaysProvided();
    }

    public int getComponentProduction() {
        return this.getMySHouseData().getComponentProduction();
    }

    public void setPilotQueues(PilotQueues q) {
        this.getMySHouseData().setPilotQueues(q);
    }

    public SHouse(SHouseData data) {
        this.myData = data;
    }

    public SHouse(int id, String name, String HouseColor, int BaseGunner, int BasePilot, String abbreviation) {
        super(id);
        int i;
        Vector<Integer> v;
        this.myData = new SHouseData();
        this.setAbbreviation(abbreviation);
        this.setHouseColor(HouseColor);
        this.setName(name);
        this.setMembers(new Hashtable());
        for (int j = 0; j < 5; ++j) {
            v = new Vector<Integer>();
            for (int i2 = 0; i2 < 4; ++i2) {
                v.add(new Integer(0));
            }
            this.getComponents().put(new Integer(j), v);
        }
        this.setMoney(0);
        this.getHangar().put(new Integer(0), new Vector());
        this.getHangar().put(new Integer(1), new Vector());
        this.getHangar().put(new Integer(2), new Vector());
        this.getHangar().put(new Integer(3), new Vector());
        this.getHangar().put(new Integer(4), new Vector());
        for (i = 0; i < 4; ++i) {
            v = new Vector();
            this.getHangar(0).add(v);
        }
        for (i = 0; i < 4; ++i) {
            v = new Vector();
            this.getHangar(1).add(v);
        }
        if (Boolean.valueOf(CampaignMain.cm.getConfig("UseInfantry")).booleanValue()) {
            for (i = 0; i < 4; ++i) {
                v = new Vector();
                this.getHangar(2).add(v);
            }
        }
        for (i = 0; i < 4; ++i) {
            v = new Vector();
            this.getHangar(3).add(v);
        }
        for (i = 0; i < 4; ++i) {
            v = new Vector();
            this.getHangar(4).add(v);
        }
        this.getComponents().put(0, new Vector(4, 1));
        this.getComponents().put(1, new Vector(4, 1));
        this.getComponents().put(2, new Vector(4, 1));
        this.getComponents().put(4, new Vector(4, 1));
        this.getComponents().put(3, new Vector(4, 1));
        for (i = 0; i < 4; ++i) {
            this.getComponents().get(0).add(0);
            this.getComponents().get(1).add(0);
            this.getComponents().get(2).add(0);
            this.getComponents().get(4).add(0);
            this.getComponents().get(3).add(0);
        }
        this.setActMembers(new Hashtable());
        this.setFightingMembers(new Hashtable());
    }

    public Hashtable<Integer, Vector> getHangar() {
        return this.getMySHouseData().getHangar();
    }

    public Vector getHangar(int Type_id) {
        Hashtable<Integer, Vector> s = this.getHangar();
        if (s == null || s.size() < Type_id) {
            return null;
        }
        return s.get(Type_id);
    }

    public boolean isNewbieHouse() {
        return false;
    }

    public boolean isMercHouse() {
        return false;
    }

    public SHouse getHouseFightingFor(SPlayer player) {
        return this;
    }

    @Override
    public boolean equals(Object o) {
        SHouse h = (SHouse)o;
        if (h == null) {
            return false;
        }
        return h.getName().equals(this.getName());
    }

    public void addDispossessedPilot(SUnit U) {
        this.getPilotQueues().addPilot(U.getType(), (SPilot)U.getPilot());
    }

    public void addDispossessedPilot(SUnit u, boolean skipSkillChange) {
        if (!skipSkillChange) {
            this.getPilotQueues().addPilot(u.getType(), (SPilot)u.getPilot());
        } else {
            this.getPilotQueues().addPilot(u.getType(), (SPilot)u.getPilot(), true);
        }
    }

    public PilotQueues getPilotQueues() {
        return this.getMySHouseData().getPilotQueues();
    }

    public SPilot getNewPilot(int uType) {
        return this.getPilotQueues().getPilot(uType);
    }

    public boolean isLoggedIn(String Username) {
        if (this.getActMembers().get(Username.toLowerCase()) != null) {
            return true;
        }
        return this.getFightingMembers().get(Username.toLowerCase()) != null;
    }

    public void ResetPlayers() {
        this.setActMembers(new Hashtable());
        this.setFightingMembers(new Hashtable());
        Enumeration<SPlayer> e = this.getMembers().elements();
        while (e.hasMoreElements()) {
            SPlayer p = e.nextElement();
            p.unlockLances();
        }
    }

    public int remainingHangarSpaceForWeightclass(int Weightclass, int TypeID) {
        Vector v = (Vector)this.getHangar(TypeID).elementAt(Weightclass);
        if (Weightclass == 0) {
            if (TypeID != 0) {
                return Integer.parseInt(CampaignMain.cm.getConfig("MaxLightUnits")) / 2 - v.size();
            }
            return Integer.parseInt(CampaignMain.cm.getConfig("MaxLightUnits")) - v.size();
        }
        if (TypeID != 0) {
            return Integer.parseInt(CampaignMain.cm.getConfig("MaxOtherUnits")) / 2 - v.size();
        }
        return Integer.parseInt(CampaignMain.cm.getConfig("MaxOtherUnits")) - v.size();
    }

    @Override
    public boolean hasRoom(SUnit m) {
        int type_id = m.getType() == 1 ? 1 : 0;
        return this.remainingHangarSpaceForWeightclass(m.getWeightclass(), type_id) > 0;
    }

    public int getNumberOfActivePlayers() {
        return this.getActMembers().size() + this.getFightingMembers().size();
    }

    public double getWorthOfActivePlayersReadyToFight() {
        SPlayer p;
        double result = 0.0;
        Hashtable act = this.getActMembers();
        Enumeration e = act.elements();
        boolean showOutput = Boolean.valueOf(CampaignMain.cm.getConfig("ShowOutputMultiplierOnTick"));
        while (e.hasMoreElements()) {
            p = (SPlayer)e.nextElement();
            if (!p.countsForTick()) continue;
            double tickWorth = p.getTickWorth();
            result += tickWorth;
            String toReturn = "You counted towards production this tick";
            if (showOutput) {
                DecimalFormat myFormatter = new DecimalFormat("###.##");
                String output = myFormatter.format(tickWorth);
                toReturn = toReturn + " (" + output + " points worth)";
            }
            CampaignMain.cm.toUser(toReturn + ".", p.getName(), true);
        }
        act = this.getFightingMembers();
        e = act.elements();
        while (e.hasMoreElements()) {
            p = (SPlayer)e.nextElement();
            ShortOperation so = CampaignMain.cm.getOpsManager().getShortOpForPlayer(p);
            if (so == null) continue;
            Operation o = CampaignMain.cm.getOpsManager().getOperation(so.getName());
            double countWeight = Double.parseDouble(o.getValue("CountGameForProduction"));
            if (countWeight < 0.0) {
                countWeight = 0.0;
            }
            result += countWeight;
            if (!(countWeight > 0.0)) continue;
            String toReturn = "You counted towards production this tick";
            if (showOutput) {
                DecimalFormat myFormatter = new DecimalFormat("###.##");
                String output = myFormatter.format(countWeight);
                toReturn = toReturn + " (" + output + " points worth)";
            }
            CampaignMain.cm.toUser(toReturn + ".", p.getName(), true);
        }
        return result;
    }

    public String tick(boolean real, int tickid) {
        String result = "<font color=\"black\">-------> <b>Tick! [" + tickid + "]</b><br>";
        double tickworth = 0.0;
        tickworth = !real ? 10.0 : this.getWorthOfActivePlayersReadyToFight();
        double cComp = this.getComponentProduction();
        int componentsToAdd = (int)(tickworth * cComp);
        int refreshToAdd = (int)Math.round(tickworth);
        for (SPlanet p : this.getPlanets().values()) {
            if (!p.getOwner().equals(this)) continue;
            p.tick(real, refreshToAdd);
        }
        boolean useMekPP = Boolean.valueOf(CampaignMain.cm.getConfig("UseMek"));
        boolean useVehiclePP = Boolean.valueOf(CampaignMain.cm.getConfig("UseVehicle"));
        boolean useInfantryPP = Boolean.valueOf(CampaignMain.cm.getConfig("UseInfantry"));
        boolean useProtoMekPP = Boolean.valueOf(CampaignMain.cm.getConfig("UseProtoMek"));
        boolean useBattleArmorPP = Boolean.valueOf(CampaignMain.cm.getConfig("UseBattleArmor"));
        for (int i = 0; i < 4; ++i) {
            if (useMekPP) {
                this.addPP(i, 0, componentsToAdd);
                this.addComponentsProduced(0, componentsToAdd);
            } else {
                this.addPP(i, 0, 0);
            }
            if (useVehiclePP) {
                this.addPP(i, 1, componentsToAdd);
                this.addComponentsProduced(1, componentsToAdd);
            } else {
                this.addPP(i, 1, 0);
            }
            if (useInfantryPP) {
                if (!Boolean.valueOf(CampaignMain.cm.getConfig("UseOnlyLightInfantry")).booleanValue() || i == 0) {
                    this.addPP(i, 2, componentsToAdd);
                }
                this.addComponentsProduced(2, componentsToAdd);
            } else {
                this.addPP(i, 2, 0);
            }
            if (useProtoMekPP) {
                this.addPP(i, 3, componentsToAdd);
                this.addComponentsProduced(3, componentsToAdd);
            } else {
                this.addPP(i, 3, 0);
            }
            if (useBattleArmorPP) {
                this.addPP(i, 4, componentsToAdd);
                this.addComponentsProduced(4, componentsToAdd);
                continue;
            }
            this.addPP(i, 4, 0);
        }
        result = result + this.cleanupHangarAndPP();
        if (this.getShowProductionCountNext() - 1 <= 0) {
            this.setShowProductionCountNext(Integer.parseInt(CampaignMain.cm.getConfig("ShowComponentGainEvery")));
            int MekComponents = this.getComponentsProduced(0);
            int VehComponents = this.getComponentsProduced(1);
            int InfComponents = this.getComponentsProduced(2);
            int ProtoComponents = this.getComponentsProduced(3);
            int BAComponents = this.getComponentsProduced(4);
            DecimalFormat myFormatter = new DecimalFormat("###.##");
            result = result + "<br><i><b>Your factories produced enough components to make:</b></i><br>";
            if (Boolean.valueOf(CampaignMain.cm.getConfig("UseMek")).booleanValue()) {
                result = result + myFormatter.format((double)MekComponents / Double.parseDouble(CampaignMain.cm.getConfig("LightPP"))) + " Light meks<br>";
                result = result + myFormatter.format((double)MekComponents / Double.parseDouble(CampaignMain.cm.getConfig("MediumPP"))) + " Medium meks<br>";
                result = result + myFormatter.format((double)MekComponents / Double.parseDouble(CampaignMain.cm.getConfig("HeavyPP"))) + " Heavy meks<br>";
                result = result + myFormatter.format((double)MekComponents / Double.parseDouble(CampaignMain.cm.getConfig("AssaultPP"))) + " Assault meks<br>";
            }
            if (Boolean.valueOf(CampaignMain.cm.getConfig("UseVehicle")).booleanValue()) {
                result = result + myFormatter.format((double)VehComponents / Double.parseDouble(CampaignMain.cm.getConfig("LightVehiclePP"))) + " Light vehicles<br>";
                result = result + myFormatter.format((double)VehComponents / Double.parseDouble(CampaignMain.cm.getConfig("MediumVehiclePP"))) + " Medium vehicles<br>";
                result = result + myFormatter.format((double)VehComponents / Double.parseDouble(CampaignMain.cm.getConfig("HeavyVehiclePP"))) + " Heavy vehicles<br>";
                result = result + myFormatter.format((double)VehComponents / Double.parseDouble(CampaignMain.cm.getConfig("AssaultVehiclePP"))) + " Assault vehicles<br>";
            }
            if (Boolean.valueOf(CampaignMain.cm.getConfig("UseInfantry")).booleanValue()) {
                if (Boolean.valueOf(CampaignMain.cm.getConfig("UseOnlyLightInfantry")).booleanValue()) {
                    result = result + myFormatter.format((double)InfComponents / Double.parseDouble(CampaignMain.cm.getConfig("LightInfantryPP"))) + " Infantry<br>";
                } else {
                    result = result + myFormatter.format((double)InfComponents / Double.parseDouble(CampaignMain.cm.getConfig("LightInfantryPP"))) + " Light infantry<br>";
                    result = result + myFormatter.format((double)InfComponents / Double.parseDouble(CampaignMain.cm.getConfig("MediumInfantryPP"))) + " Medium infantry<br>";
                    result = result + myFormatter.format((double)InfComponents / Double.parseDouble(CampaignMain.cm.getConfig("HeavyInfantryPP"))) + " Heavy infantry<br>";
                    result = result + myFormatter.format((double)InfComponents / Double.parseDouble(CampaignMain.cm.getConfig("AssaultInfantryPP"))) + " Assault infantry<br>";
                }
            }
            if (Boolean.valueOf(CampaignMain.cm.getConfig("UseProtoMek")).booleanValue()) {
                result = result + myFormatter.format((double)ProtoComponents / Double.parseDouble(CampaignMain.cm.getConfig("LightProtoMekPP"))) + " Light protomechs<br>";
                result = result + myFormatter.format((double)ProtoComponents / Double.parseDouble(CampaignMain.cm.getConfig("MediumProtoMekPP"))) + " Medium protomechs<br>";
                result = result + myFormatter.format((double)ProtoComponents / Double.parseDouble(CampaignMain.cm.getConfig("HeavyProtoMekPP"))) + " Heavy protomechs<br>";
                result = result + myFormatter.format((double)ProtoComponents / Double.parseDouble(CampaignMain.cm.getConfig("AssaultProtoMekPP"))) + " Assault protomechs<br>";
            }
            if (Boolean.valueOf(CampaignMain.cm.getConfig("UseBattleArmor")).booleanValue()) {
                result = result + myFormatter.format((double)BAComponents / Double.parseDouble(CampaignMain.cm.getConfig("LightBattleArmorPP"))) + " Light battle armor<br>";
                result = result + myFormatter.format((double)BAComponents / Double.parseDouble(CampaignMain.cm.getConfig("MediumBattleArmorPP"))) + " Medium battle armor<br>";
                result = result + myFormatter.format((double)BAComponents / Double.parseDouble(CampaignMain.cm.getConfig("HeavyBattleArmorPP"))) + " Heavy battle armor<br>";
                result = result + myFormatter.format((double)BAComponents / Double.parseDouble(CampaignMain.cm.getConfig("AssaultBattleArmorPP"))) + " Assault battle armor<br>";
            }
            this.setComponentsProduced(0, 0);
            this.setComponentsProduced(1, 0);
            this.setComponentsProduced(2, 0);
            this.setComponentsProduced(3, 0);
            this.setComponentsProduced(4, 0);
        } else {
            this.addShowProductionCountNext(-1);
        }
        result = result + "</font>";
        return result;
    }

    public String cleanupHangarAndPP() {
        int type_id;
        String mechsProduced = "";
        String industrialAccidents = "";
        String scrapExcuses = "";
        String marketAdditions = "";
        int types = SUnit.TOTALTYPES;
        for (type_id = 0; type_id < types; ++type_id) {
            for (int i = 0; i < 4; ++i) {
                if (this.remainingHangarSpaceForWeightclass(i, type_id) >= 0) continue;
                Vector v = (Vector)this.getHangar(type_id).elementAt(i);
                SUnit mech = (SUnit)v.elementAt(CampaignMain.cm.getR().nextInt(v.size()));
                this.removeMech(mech);
                if (CampaignMain.cm.getR().nextInt(10) < 5 && mech.mayBeSoldOnMarket()) {
                    int minbid = 0;
                    int time = 0;
                    int avbid = CampaignMain.cm.getMarket().getMarketStatistic().getAverageForMech(mech);
                    String unitPrice = mech.getType() == 0 ? SUnit.getWeightClassDesc(mech.getWeightclass()) + "Price" : SUnit.getWeightClassDesc(mech.getWeightclass()) + SUnit.getTypeClassDesc(mech.getType()) + "Price";
                    String unitTicks = SUnit.getWeightClassDesc(mech.getWeightclass()) + "SaleTicks";
                    minbid = Integer.parseInt(CampaignMain.cm.getConfig(unitPrice));
                    time = Integer.parseInt(CampaignMain.cm.getConfig(unitTicks));
                    if (avbid != 0 && (avbid = avbid * 85 / 100) > minbid * 85 / 100) {
                        minbid = avbid;
                    }
                    MarketUnit m = new MarketUnit(this, time, minbid, "", mech);
                    CampaignMain.cm.getMarket().addUnit(m);
                    marketAdditions = marketAdditions + "A " + mech.getModelName() + " has been added to the black market.<br>";
                    continue;
                }
                String scrapExcuse = this.getExcuseForUnitFailure(mech);
                scrapExcuses = scrapExcuses + scrapExcuse + "<br>";
                UnitHistoryKeeper.addDestroyedByAccidentEntry(mech.getId(), scrapExcuse, this.getName());
            }
        }
        for (type_id = 0; type_id < SUnit.TOTALTYPES; ++type_id) {
            for (int weight = 0; weight < 4; ++weight) {
                while (this.getPP(weight, type_id) > this.getMaxAllowedPP(weight, type_id)) {
                    SUnitFactory m;
                    boolean accident = false;
                    int randomLossFactor = CampaignMain.cm.getR().nextInt(this.getPPCost(weight, type_id)) + 1;
                    if (CampaignMain.cm.getR().nextInt(100) + 1 <= Integer.parseInt(CampaignMain.cm.getConfig("AutoProductionFailureRate"))) {
                        accident = true;
                    }
                    if ((m = this.getUnitFactoryForProduction(type_id, weight)) == null) {
                        accident = true;
                    }
                    if (!accident) {
                        SUnit mech = m.getMechProduced(type_id, this.getNewPilot(type_id));
                        this.addUnit(mech, true);
                        this.addPP(weight, type_id, -this.getPPCost(weight, type_id));
                        UnitHistoryKeeper.addBoughtFromFactoryEntry(mech.getId(), "House " + this.getName(), this.getName());
                        if (type_id == 2) {
                            mechsProduced = mechsProduced + "A militia unit [" + mech.getModelName() + "] from " + m.getPlanet().getName() + " has been activated for front line duty!<br>";
                            continue;
                        }
                        mechsProduced = mechsProduced + "House technicians have assembled a " + mech.getModelName() + " at " + m.getName() + " on " + m.getPlanet().getName() + ".<br>";
                        continue;
                    }
                    this.addPP(weight, type_id, -randomLossFactor);
                    if (type_id == 2) continue;
                    industrialAccidents = industrialAccidents + "An industrial accident destroys a substantial cache of " + SUnit.getWeightClassDesc(weight) + " " + SUnit.getTypeClassDesc(type_id) + " components.<br>";
                }
            }
        }
        return mechsProduced + marketAdditions + industrialAccidents + scrapExcuses;
    }

    public String potentialHouseProduction() {
        String result = "";
        int Typeamount = SUnit.TOTALTYPES;
        result = result + "<TABLE Border=\"1\"><TR><TH></TH><TH>Light</TH><TH>Medium</TH><TH>Heavy</TH><TH>Assault</TH></TR>";
        for (int type_id = 0; type_id < Typeamount; ++type_id) {
            result = result + "<TR><TD VALIGN=MIDDLE><b>" + SUnit.getTypeClassDesc(type_id) + "</b></TD>";
            for (int weight = 0; weight < 4; ++weight) {
                if (!Boolean.valueOf(CampaignMain.cm.getConfig("UseOnlyLightInfantry")).booleanValue() || type_id != 2 || weight == 0) {
                    int n;
                    int costPerPiece = this.getPPCost(weight, type_id);
                    int openFabs = 0;
                    int closedFabs = 0;
                    String openRes = "";
                    String closedRes = "";
                    Vector<String> supportedFactions = new Vector<String>();
                    for (SHouse sHouse : CampaignMain.cm.getData().getAllHouses()) {
                        supportedFactions.add(sHouse.getAbbreviation());
                    }
                    int n2 = Integer.MAX_VALUE;
                    for (SPlanet currentPlanet : this.getPlanets().values()) {
                        for (int i = 0; i < currentPlanet.getUnitFactories().size(); ++i) {
                            SUnitFactory factory = (SUnitFactory)currentPlanet.getUnitFactories().get(i);
                            if (!currentPlanet.getOwner().equals(this) || !factory.canProduce(type_id) || factory.getWeightclass() != weight) continue;
                            String addon = "";
                            SHouse h = CampaignMain.cm.getHouseFromPartialString(factory.getFounder(), null);
                            if (h != null && supportedFactions.contains(h.getAbbreviation())) {
                                addon = addon + h.getAbbreviation();
                            }
                            if (factory.getTicksUntilRefresh() <= 0) {
                                ++openFabs;
                                openRes = openRes + "<img src=\"data/images/open" + addon + ".gif\">";
                                continue;
                            }
                            ++closedFabs;
                            closedRes = closedRes + "<img src=\"data/images/closed" + addon + ".gif\">";
                            if (factory.getTicksUntilRefresh() >= n) continue;
                            n = factory.getTicksUntilRefresh();
                        }
                    }
                    result = result + "<TD><img src=\"data/images/miniticks.gif\">:" + this.getPP(weight, type_id);
                    result = result + "<img src=\"data/images/units.gif\">:" + this.getPP(weight, type_id) / costPerPiece;
                    result = result + "<br>";
                    result = result + openRes + closedRes;
                    if (n < Integer.MAX_VALUE && openFabs == 0) {
                        result = result + "<img src=\"data/images/clock.gif\">:" + n;
                    }
                    if (openFabs + closedFabs == 0) {
                        result = result + "<img src=\"data/images/absent.gif\">";
                    }
                    result = result + "</TD>";
                    continue;
                }
                result = result + "<TD></TD>";
            }
            result = result + "</TR>";
        }
        result = result + "</TABLE>";
        return result;
    }

    public String getExcuseForUnitFailure(SUnit m) {
        if (m.getType() == 0) {
            try {
                String scrapFile = "./data/scrapmessages/mekscrapmessages.txt";
                FileInputStream fis = new FileInputStream(scrapFile);
                BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
                int messages = Integer.parseInt(dis.readLine());
                Random rand = new Random();
                int id = rand.nextInt(messages);
                String scrapMessage = "";
                while (dis.ready()) {
                    scrapMessage = dis.readLine();
                    if (id <= 0) break;
                    --id;
                }
                String scrapMessageWithPilot = scrapMessage.replaceAll("PILOT", m.getPilot().getName());
                String scrapMessageForPlayer = scrapMessageWithPilot.replaceAll("UNIT", m.getModelName());
                return scrapMessageForPlayer;
            }
            catch (Exception e) {
                MMServ.mmlog.errLog("A problem occured with your mekscrapmessages File!");
                return "A " + m.getModelName() + " was kidnapped by aliens from outer space";
            }
        }
        if (m.getType() == 1) {
            try {
                String scrapFile = "./data/scrapmessages/vehiclescrapmessages.txt";
                FileInputStream fis = new FileInputStream(scrapFile);
                BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
                int messages = Integer.parseInt(dis.readLine());
                Random rand = new Random();
                int id = rand.nextInt(messages);
                String scrapMessage = "";
                while (dis.ready()) {
                    scrapMessage = dis.readLine();
                    if (id <= 0) break;
                    --id;
                }
                String scrapMessageWithPilot = scrapMessage.replaceAll("PILOT", m.getPilot().getName());
                String scrapMessageForPlayer = scrapMessageWithPilot.replaceAll("UNIT", m.getModelName());
                return scrapMessageForPlayer;
            }
            catch (Exception e) {
                MMServ.mmlog.errLog("A problem occured with your vehiclescrapmessages File!");
                return "A " + m.getModelName() + " was kidnapped by aliens from outer space";
            }
        }
        if (m.getType() == 2) {
            try {
                String scrapFile = "./data/scrapmessages/infantryscrapmessages.txt";
                FileInputStream fis = new FileInputStream(scrapFile);
                BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
                int messages = Integer.parseInt(dis.readLine());
                Random rand = new Random();
                int id = rand.nextInt(messages);
                String scrapMessage = "";
                while (dis.ready()) {
                    scrapMessage = dis.readLine();
                    if (id <= 0) break;
                    --id;
                }
                String scrapMessageWithPilot = scrapMessage.replaceAll("PILOT", m.getPilot().getName());
                String scrapMessageForPlayer = scrapMessageWithPilot.replaceAll("UNIT", m.getModelName());
                return scrapMessageForPlayer;
            }
            catch (Exception e) {
                MMServ.mmlog.errLog("A problem occured with your infantryscrapmessages File!");
                return "A " + m.getModelName() + " was kidnapped by aliens from outer space";
            }
        }
        if (m.getType() == 3) {
            try {
                String scrapFile = "./data/scrapmessages/protoscrapmessages.txt";
                FileInputStream fis = new FileInputStream(scrapFile);
                BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
                int messages = Integer.parseInt(dis.readLine());
                Random rand = new Random();
                int id = rand.nextInt(messages);
                String scrapMessage = "";
                while (dis.ready()) {
                    scrapMessage = dis.readLine();
                    if (id <= 0) break;
                    --id;
                }
                String scrapMessageWithPilot = scrapMessage.replaceAll("PILOT", m.getPilot().getName());
                String scrapMessageForPlayer = scrapMessageWithPilot.replaceAll("UNIT", m.getModelName());
                return scrapMessageForPlayer;
            }
            catch (Exception e) {
                MMServ.mmlog.errLog("A problem occured with your protoscrapmessages File!");
                return "A " + m.getModelName() + " was kidnapped by aliens from outer space";
            }
        }
        if (m.getType() == 4) {
            try {
                String scrapFile = "./data/scrapmessages/bascrapmessages.txt";
                FileInputStream fis = new FileInputStream(scrapFile);
                BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
                int messages = Integer.parseInt(dis.readLine());
                Random rand = new Random();
                int id = rand.nextInt(messages);
                String scrapMessage = "";
                while (dis.ready()) {
                    scrapMessage = dis.readLine();
                    if (id <= 0) break;
                    --id;
                }
                String scrapMessageWithPilot = scrapMessage.replaceAll("PILOT", m.getPilot().getName());
                String scrapMessageForPlayer = scrapMessageWithPilot.replaceAll("UNIT", m.getModelName());
                return scrapMessageForPlayer;
            }
            catch (Exception e) {
                MMServ.mmlog.errLog("A problem occured with your bascrapmessages File!");
                return "A " + m.getModelName() + " was kidnapped by aliens from outer space";
            }
        }
        return "A " + m.getModelName() + " was kidnapped by aliens from outer space";
    }

    public String payInfluence(SPlayer p) {
        boolean activeLongEnough;
        if (this.isBusy(p.getName())) {
            return "";
        }
        if (p.getInfluence() >= Integer.parseInt(CampaignMain.cm.getConfig("InfluenceCeiling"))) {
            return "";
        }
        if (p.getHouseFightingFor().isMercHouse()) {
            return "";
        }
        boolean bl = activeLongEnough = System.currentTimeMillis() - p.getOnlineSince() > (long)Integer.parseInt(CampaignMain.cm.getConfig("InfluenceTimeMin"));
        if (p.isActive() && p.isAbleToFight() && activeLongEnough) {
            int totalInfluenceGrant = 0;
            totalInfluenceGrant = (int)this.doPayInfluenceMath(p);
            p.addInfluence(totalInfluenceGrant);
            try {
                String fileName = "";
                SHouse faction = p.getHouseFightingFor();
                fileName = faction == null ? "./data/influencemessages/CommonInfluenceMessages.txt" : "./data/influencemessages/" + faction.getHouseFluFile() + "InfluenceMessages.txt";
                File configFile = new File(fileName);
                if (!configFile.exists() && !(configFile = new File(fileName = "./data/influencemessages/CommonInfluenceMessages.txt")).exists()) {
                    MMServ.mmlog.errLog("A problem occured with your CommonInfluenceMessages File!");
                    return "";
                }
                FileInputStream fis = new FileInputStream(configFile);
                BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
                int messages = Integer.parseInt(dis.readLine());
                Random rand = new Random();
                int fluid = rand.nextInt(messages);
                String fluMessage = "";
                while (dis.ready()) {
                    fluMessage = dis.readLine();
                    if (fluid <= 0) break;
                    --fluid;
                }
                int unitId = rand.nextInt(p.getNumberOfUnits());
                SUnit unitForMessages = new SUnit((SUnitData)p.getAllUnitsData().elementAt(unitId));
                String fluMessageWithPilotName = fluMessage.replaceAll("PILOT", unitForMessages.getPilot().getName());
                String fluMessageWithModelName = fluMessageWithPilotName.replaceAll("UNIT", unitForMessages.getModelName());
                String fluMessageWithPlayerName = fluMessageWithModelName.replaceAll("PLAYER", p.getName());
                fluMessageWithPlayerName = fluMessageWithPlayerName + " (+" + CampaignMain.cm.moneyOrFluMessage(false, false, totalInfluenceGrant) + ")";
                return fluMessageWithPlayerName;
            }
            catch (Exception e) {
                MMServ.mmlog.errLog("A problem occured with your CommonInfluenceMessages File!");
                return "";
            }
        }
        return "";
    }

    public double doPayInfluenceMath(SPlayer p) {
        int fluCeiling;
        double totalInfluenceGrant = 0.0;
        double weightedNumArmies = -1.0;
        weightedNumArmies = this.isBusy(p.getName()) ? 1.0 : p.getWeightedArmyNumber();
        double baseFlu = Double.parseDouble(CampaignMain.cm.getConfig("BaseInfluence"));
        totalInfluenceGrant = baseFlu * weightedNumArmies;
        int currentInfluence = p.getInfluence();
        if ((double)currentInfluence > (double)(fluCeiling = Integer.parseInt(CampaignMain.cm.getConfig("InfluenceCeiling"))) * 0.5 && (double)currentInfluence < (double)fluCeiling * 0.75) {
            totalInfluenceGrant *= 0.8;
        } else if ((double)currentInfluence >= (double)fluCeiling * 0.75) {
            totalInfluenceGrant *= 0.6;
        }
        return totalInfluenceGrant;
    }

    public void setPP(int weight, int val, int type_id) {
        Vector<Integer> v = this.getComponents().get(new Integer(type_id));
        if (v != null) {
            v.setElementAt(new Integer(val), weight);
        }
    }

    public int getPP(int weight, int type_id) {
        Vector<Integer> v = this.getComponents().get(new Integer(type_id));
        if (v == null) {
            return 0;
        }
        Integer i = v.elementAt(weight);
        if (i == null) {
            return 0;
        }
        return i;
    }

    public Vector getPossibleFactoryForProduction(int type, int weight) {
        Vector<SUnitFactory> possible = new Vector<SUnitFactory>();
        TreeMap t = this.getPlanets();
        for (SPlanet p : t.values()) {
            Vector v = p.getFactoriesOfWeighclass(weight);
            for (int i = 0; i < v.size(); ++i) {
                SUnitFactory MF = (SUnitFactory)v.elementAt(i);
                if (!MF.canProduce(type) || MF.getTicksUntilRefresh() != 0) continue;
                possible.add(MF);
            }
        }
        return possible;
    }

    public Vector getFactorysForProduction(int type, int weight) {
        Vector<SUnitFactory> possible = new Vector<SUnitFactory>();
        for (SPlanet p : this.getPlanets().values()) {
            Vector v = p.getFactoriesOfWeighclass(weight);
            for (int i = 0; i < v.size(); ++i) {
                SUnitFactory MF = (SUnitFactory)v.elementAt(i);
                if (!MF.canProduce(type)) continue;
                possible.add(MF);
            }
        }
        return possible;
    }

    public SUnitFactory getUnitFactoryForProduction(int type, int weight) {
        Vector possible = this.getPossibleFactoryForProduction(type, weight);
        if (possible.size() == 0) {
            return null;
        }
        int rand = CampaignMain.cm.getR().nextInt(possible.size());
        return (SUnitFactory)possible.elementAt(rand);
    }

    public int getMaxAllowedPP(int weight, int type_id) {
        String unitAPMax = "APAtMax" + SUnit.getWeightClassDesc(weight) + "Units";
        int maxUnits = Integer.parseInt(CampaignMain.cm.getConfig(unitAPMax));
        return maxUnits * this.getPPCost(weight, type_id);
    }

    public int getPPCost(int weight, int type_id) {
        int result = 0;
        if (type_id == 1) {
            result = Integer.parseInt(CampaignMain.cm.getConfig(SUnit.getWeightClassDesc(weight) + "VehiclePP"));
        } else if (type_id == 2) {
            result = Integer.parseInt(CampaignMain.cm.getConfig(SUnit.getWeightClassDesc(weight) + "InfantryPP"));
        } else if (type_id == 0) {
            result = Integer.parseInt(CampaignMain.cm.getConfig(SUnit.getWeightClassDesc(weight) + "PP"));
        } else if (type_id == 4) {
            result = Integer.parseInt(CampaignMain.cm.getConfig(SUnit.getWeightClassDesc(weight) + "BattleArmorPP"));
        } else if (type_id == 3) {
            result = Integer.parseInt(CampaignMain.cm.getConfig(SUnit.getWeightClassDesc(weight) + "ProtoMekPP"));
        }
        if ((result += this.getHouseUnitComponentMod(type_id, weight)) < 1) {
            result = 1;
        }
        return result;
    }

    public void addPP(int weight, int type_id, int val) {
        try {
            if (!Boolean.valueOf(CampaignMain.cm.getConfig("ProduceComponentsWithNoFactory")).booleanValue() && this.getFactorysForProduction(type_id, weight).size() < 1 && val > 0) {
                return;
            }
            Vector<Integer> v = this.getComponents().get(new Integer(type_id));
            v.setElementAt(new Integer(v.elementAt(weight) + val), weight);
        }
        catch (Exception ex) {
            MMServ.mmlog.errLog(ex);
            MMServ.mmlog.errLog("Error in addPP()");
            MMServ.mmlog.errLog("weight: " + weight + " type: " + type_id + " value: " + val);
            Vector<Integer> v = new Vector<Integer>();
            for (int i = 0; i < 4; ++i) {
                v.add(new Integer(0));
            }
            this.getComponents().put(new Integer(type_id), v);
        }
    }

    @Override
    public boolean isHuman() {
        return false;
    }

    public SUnit getEntity(int weightclass, int type_id) {
        Vector s;
        try {
            s = (Vector)this.getHangar(type_id).elementAt(weightclass);
        }
        catch (Exception ex) {
            MMServ.mmlog.errLog(ex);
            MMServ.mmlog.errLog("Empty Vector in getEntity");
            return null;
        }
        if (s == null) {
            return null;
        }
        if (s.size() > 0) {
            int ran = CampaignMain.cm.getR().nextInt(s.size());
            SUnit m = (SUnit)s.elementAt(ran);
            s.removeElementAt(ran);
            m.setStatus(1);
            return m;
        }
        return null;
    }

    public void addMember(SPlayer p) {
        this.getMembers().put(p.getName().toLowerCase(), p);
        p.addStatusListener(this);
        CampaignMain.cm.toUser("SP|Welcome to House " + this.getName(), p.getName(), false);
    }

    public SPlayer getMember(String s) {
        return this.getMembers().get(s.toLowerCase());
    }

    public int getPriceForUnit(int weightclass, int type_id, SPlayer p) {
        int result = Integer.MAX_VALUE;
        String classtype = SUnit.getWeightClassDesc(weightclass) + SUnit.getTypeClassDesc(type_id) + "Price";
        if (Boolean.valueOf(CampaignMain.cm.getConfig("UseCalculatedCosts")).booleanValue()) {
            double cost = 0.0;
            cost = type_id == 1 || type_id == 0 ? CampaignMain.cm.getUnitCostLists().getMinCostValue(weightclass, type_id).doubleValue() : CampaignMain.cm.getUnitCostLists().getMinCostValue(0, type_id).doubleValue();
            result = (int)(cost * Double.valueOf(CampaignMain.cm.getConfig("CostModifier")));
            return result;
        }
        result = type_id == 0 ? Integer.parseInt(CampaignMain.cm.getConfig(SUnit.getWeightClassDesc(weightclass) + "Price")) : Integer.parseInt(CampaignMain.cm.getConfig(classtype));
        if ((result += this.getHouseUnitPriceMod(type_id, weightclass)) < 0) {
            result = 0;
        }
        if (p != null && weightclass != 0 && p.getPricePenalty() > 0) {
            double penalty = Double.parseDouble(CampaignMain.cm.getConfig("PercentPerMezzo")) / 100.0 * (double)p.getPricePenalty() + 1.0;
            result = (int)((double)result * penalty);
        }
        return result;
    }

    public int getInfluenceForUnit(int weightclass, int type_id, SPlayer p) {
        int result = Integer.MAX_VALUE;
        String classtype = SUnit.getWeightClassDesc(weightclass) + SUnit.getTypeClassDesc(type_id) + "Inf";
        result = type_id == 0 ? Integer.parseInt(CampaignMain.cm.getConfig(SUnit.getWeightClassDesc(weightclass) + "Inf")) : Integer.parseInt(CampaignMain.cm.getConfig(classtype));
        if (p != null && weightclass != 0) {
            double penalty = 0.0;
            if (p.getPricePenalty() > 0) {
                penalty = Double.parseDouble(CampaignMain.cm.getConfig("PercentPerMezzo")) / 100.0 * (double)(weightclass - 1) * (double)p.getPricePenalty() + 1.0;
                result = (int)((double)result * penalty);
            }
        }
        return result;
    }

    public void addPlanet(SPlanet p) {
        if (this.getPlanets().get(p.getName()) == null) {
            this.getPlanets().put(p.getName(), p);
            this.setBaysProvided(this.getBaysProvided() + p.getBaysProvided());
            this.setComponentProduction(this.getComponentProduction() + p.getCompProduction());
        }
    }

    public void removePlanet(SPlanet p) {
        if (this.getPlanets().get(p.getName()) != null) {
            this.getPlanets().remove(p.getName());
            this.setBaysProvided(this.getBaysProvided() - p.getBaysProvided());
            this.setComponentProduction(this.getComponentProduction() - p.getCompProduction());
        }
    }

    public void recalcWarefactionsAndComponents() {
        int bays = 0;
        int components = 0;
        for (SPlanet p : this.getPlanets().values()) {
            bays += p.getBaysProvided();
            components += p.getCompProduction();
        }
        this.setBaysProvided(bays);
        this.setComponentProduction(components);
    }

    public void transferMoney(SPlayer p, int amount) {
        if (p != null) {
            p.addMoney(amount);
            this.setMoney(this.getMoney() - amount);
        }
    }

    public void removeMech(SUnit mech) {
        Vector Weightclass = (Vector)this.getHangar(mech.getType()).elementAt(mech.getWeightclass());
        Weightclass.remove(mech);
    }

    @Override
    public void addUnit(SUnit unit, boolean isNew) {
        if (this.hasUnit(unit)) {
            return;
        }
        if (Boolean.valueOf(CampaignMain.cm.getConfig("UseOnlyOneVehicleSize")).booleanValue() && unit.getType() == 1) {
            unit.setWeightclass(0);
        }
        if (isNew) {
            UnitHistoryKeeper.addAcquireEntry(unit.getId(), "House " + this.getName(), this.getName());
        }
        Vector Weightclass = (Vector)this.getHangar(unit.getType()).elementAt(unit.getWeightclass());
        Weightclass.add(unit);
    }

    public boolean hasUnit(SUnit unit) {
        Vector Weightclass = (Vector)this.getHangar(unit.getType()).elementAt(unit.getWeightclass());
        return Weightclass.contains(unit);
    }

    public boolean hasMechsOfSize(int weightclass) {
        return ((Vector)this.getHangar(0).elementAt(weightclass)).size() > 0;
    }

    public String doLogin(String name) {
        SPlayer p = this.getMembers().get(name.toLowerCase());
        if (p == null) {
            return null;
        }
        if (!this.isLoggedIn(name)) {
            Date d = new Date(System.currentTimeMillis());
            MMServ.mmlog.mainLog(d + ":" + "User Logged into House: " + name);
            p.setLastSentStatus("");
            this.fireStatusEvent("User Logged In", name);
            CampaignMain.cm.toUser("CS|2", name, false);
            CampaignMain.cm.toUser("PL|PPQ|" + p.getPlayerPersonalPilotQueue().toString(true), p.getName(), false);
            CampaignMain.cm.toUser("PL|AEU|" + p.getExclusionList().adminExcludeToString("$"), p.getName(), false);
            CampaignMain.cm.toUser("PL|PEU|" + p.getExclusionList().playerExcludeToString("$"), p.getName(), false);
            this.getActMembers().put(name.toLowerCase(), p);
            p.setOnlineSince(System.currentTimeMillis());
            p.setIdle(0);
            p.setImmunetill(0L);
            CampaignMain.cm.getMarket().clearPlayerStatus(name);
            Command c = (Command)CampaignMain.cm.getServerCommands().get("MOTD");
            c.process(new StringTokenizer("", ""), name);
            SmallPlayer smallp = (SmallPlayer)this.getMySHouseData().getSmallPlayers().get(p.getName().toLowerCase());
            if (smallp == null) {
                smallp = new SmallPlayer(p.getExperience(), p.getOnlineSince(), p.getRating(), p.getName(), p.getFluffText(), this);
                this.getMySHouseData().getSmallPlayers().put(smallp.getName().toLowerCase(), smallp);
            }
            Enumeration<SArmy> en = p.getArmies().elements();
            while (en.hasMoreElements()) {
                SArmy currArmy = en.nextElement();
                currArmy.setPlayerName(p.getName());
            }
            CampaignMain.cm.toUser(this.getAutoStatus(), name, false);
            return "<font color=\"black\">[*] You logged into " + this.getName() + " succesfully!</font>";
        }
        return "You are already logged in!";
    }

    public void doSendToall(String text, boolean isChat) {
        SPlayer p;
        Hashtable h = this.getActMembers();
        Enumeration e = h.elements();
        while (e.hasMoreElements()) {
            p = (SPlayer)e.nextElement();
            CampaignMain.cm.toUser(text, p.getName(), isChat);
        }
        h = this.getFightingMembers();
        e = h.elements();
        while (e.hasMoreElements()) {
            p = (SPlayer)e.nextElement();
            CampaignMain.cm.toUser(text, p.getName(), isChat);
        }
    }

    public boolean doLogout(String name) {
        SPlayer p = this.getMembers().get(name.toLowerCase());
        if (p == null) {
            return false;
        }
        if (p.isActive()) {
            p.setActive(false);
        }
        p.setSave(true);
        this.getActMembers().remove(name.toLowerCase());
        this.getFightingMembers().remove(name.toLowerCase());
        Date d = new Date(System.currentTimeMillis());
        MMServ.mmlog.mainLog(d + ":" + "User Logged out: " + name);
        CampaignMain.cm.toUser("CS|1", name, false);
        return true;
    }

    public boolean canConquerPlanets() {
        return this.isConquerable();
    }

    public void removePlayer(String name, boolean donateMechs) {
        this.doLogout(name);
        SPlayer p = this.getMember(name);
        if (p != null) {
            if (donateMechs) {
                Vector v = p.getAllUnitsData();
                for (int i = 0; i < v.size(); ++i) {
                    this.addUnit(new SUnit((SUnitData)v.elementAt(i)), true);
                }
            }
            CampaignMain.cm.getVoteManager().removeAllVotesByPlayer(p);
            CampaignMain.cm.getVoteManager().removeAllVotesForPlayer(p);
            this.getMembers().remove(name.toLowerCase());
            p.setSave(false);
            CampaignMain.cm.getSavePlayers().remove(name.toLowerCase());
            p.getMyHouse().getSmallPlayers().remove(p.getName().toLowerCase());
            File fp = new File("./campaign/players/" + name.toLowerCase() + ".dat");
            fp.delete();
        }
    }

    public int getDistanceTo(SPlanet p, SPlayer player) {
        if (p.getInfluence().getInfluence(this.getId()) > 10) {
            return 0;
        }
        if (p instanceof NewbiePlanet) {
            return 0;
        }
        double distSq = 2.147483647E9;
        for (SPlanet pl : CampaignMain.cm.getData().getAllPlanets()) {
            double tdist;
            if (pl.getInfluence().getInfluence(this.getId()) < 25 || !((tdist = pl.getPosition().distanceSq(p.getPosition())) < distSq)) continue;
            distSq = tdist;
        }
        return (int)distSq;
    }

    public void setBusy(String name) {
        if (this.getActMembers().containsKey(name.toLowerCase())) {
            this.getActMembers().remove(name.toLowerCase());
            this.getFightingMembers().put(name.toLowerCase(), this.getMember(name));
            CampaignMain.cm.toUser("CS|4", name, false);
            SPlayer p = this.getMember(name);
            OpponentListHelper olh = new OpponentListHelper(p, 1);
            olh.sendInfoToOpponents("has entered combat and may no longer be attacked");
        }
    }

    public void setBusyNoOppList(String name) {
        this.getActMembers().remove(name.toLowerCase());
        this.getFightingMembers().put(name.toLowerCase(), this.getMember(name));
        CampaignMain.cm.toUser("CS|4", name, false);
    }

    public void setUnBusy(String name) {
        if (this.getFightingMembers().get(name.toLowerCase()) != null) {
            this.getActMembers().put(name.toLowerCase(), this.getMember(name));
            this.getFightingMembers().remove(name.toLowerCase());
            SPlayer p = this.getMember(name);
            if (p.getImmunetill() == 0L || p.getImmunetill() < System.currentTimeMillis()) {
                OpponentListHelper olh = new OpponentListHelper(p, 0);
                olh.sendInfoToOpponents("has halted combat operations and returned to its post. You may attack it with ");
            }
        }
    }

    public String getPublicStatus() {
        String result = new String("<font color=\"black\">Status for House " + this.getColoredName() + "<br>");
        Iterator e = this.getPlanets().values().iterator();
        result = result + "Planets: ";
        while (e.hasNext()) {
            SPlanet p = (SPlanet)e.next();
            result = result + p.getName();
            for (int i = 0; i < p.getUnitFactories().size(); ++i) {
                SUnitFactory MF = (SUnitFactory)p.getUnitFactories().get(i);
                result = result + "(" + MF.getSize() + ")";
            }
            if (e.hasNext()) {
                result = result + ", ";
                continue;
            }
            result = result + "<br>";
        }
        return result + "</font>";
    }

    public String getAutoStatus() {
        String delimiter = "|";
        String delimiter2 = "$";
        String result = "HS" + delimiter + this.getName() + delimiter;
        result = result + "STARTCOM" + delimiter;
        for (int type_id = 0; type_id < SUnit.TOTALTYPES; ++type_id) {
            for (int weight = 0; weight < 4; ++weight) {
                int costPerPiece = this.getPPCost(weight, type_id);
                result = result + weight + delimiter2 + type_id + delimiter2 + this.getPP(weight, type_id) + delimiter2 + this.getPP(weight, type_id) / costPerPiece + delimiter;
            }
        }
        result = result + "ENDCOM" + delimiter;
        result = result + "STARTFAC" + delimiter;
        for (SPlanet currentPlanet : this.getPlanets().values()) {
            for (int i = 0; i < currentPlanet.getUnitFactories().size(); ++i) {
                SUnitFactory factory = (SUnitFactory)currentPlanet.getUnitFactories().get(i);
                if (!currentPlanet.getOwner().equals(this)) continue;
                result = result + factory.getWeightclass() + delimiter2 + factory.getType() + delimiter2;
                result = result + factory.getFounder() + delimiter2 + factory.getPlanet().getName() + delimiter2 + factory.getName() + delimiter2 + factory.getTicksUntilRefresh() + delimiter;
            }
        }
        result = result + "ENDFAC" + delimiter;
        result = result + "STARTBAY" + delimiter;
        for (int Type_id = 0; Type_id < SUnit.TOTALTYPES; ++Type_id) {
            for (int weight = 0; weight < 4; ++weight) {
                Vector entities = (Vector)this.getHangar(Type_id).elementAt(weight);
                if (entities.size() <= 0 || Boolean.valueOf(CampaignMain.cm.getConfig("UseOnlyLightInfantry")).booleanValue() && weight != 0 && Type_id == 2) continue;
                result = result + weight + delimiter + Type_id + delimiter;
                for (int j = 0; j < entities.size(); ++j) {
                    SUnit m = (SUnit)entities.elementAt(j);
                    result = result + m.getEntity().getChassis() + " " + m.getEntity().getModel() + delimiter2 + m.getPilot().getGunnery() + delimiter2 + m.getPilot().getPiloting() + delimiter2 + m.getBV() + delimiter2 + m.getPilot().getSkillString(true) + delimiter;
                }
                result = result + "NEXT" + delimiter;
            }
        }
        result = result + "ENDBAY" + delimiter;
        return result;
    }

    public String getStatus() {
        String result = this.getPublicStatus();
        result = result + "<font color=\"black\">";
        result = result + this.potentialHouseProduction();
        int Typeamount = SUnit.TOTALTYPES;
        for (int Type_id = 0; Type_id < Typeamount; ++Type_id) {
            result = result + "<hr><b><terrainID>" + SUnit.getTypeClassDesc(Type_id) + "</terrainID></b><br>";
            for (int weight = 0; weight < 4; ++weight) {
                Object[] entities = ((Vector)this.getHangar(Type_id).elementAt(weight)).toArray();
                Arrays.sort(entities, new Comparator(){

                    public int compare(Object obj1, Object obj2) {
                        return ((SUnit)obj1).getSmallDescription().compareTo(((SUnit)obj2).getSmallDescription());
                    }
                });
                if (Boolean.valueOf(CampaignMain.cm.getConfig("UseOnlyLightInfantry")).booleanValue() && weight != 0 && Type_id == 2) continue;
                result = result + SUnit.getWeightClassDesc(weight) + ": ";
                if (entities.length == 0) {
                    result = result + "--";
                }
                for (int j = 0; j < entities.length; ++j) {
                    String name = ((SUnit)entities[j]).getSmallDescription();
                    int num = 1;
                    while (j < entities.length - 1 && name.equalsIgnoreCase(((SUnit)entities[j + 1]).getSmallDescription())) {
                        ++j;
                        ++num;
                    }
                    result = result + name;
                    if (num > 1) {
                        result = result + " (" + num + ")";
                    }
                    if (j >= entities.length - 1) continue;
                    result = result + ", ";
                }
                result = result + "<br>";
            }
        }
        return result + "</font>";
    }

    public String getHouseRanking() {
        String result = "";
        Enumeration<SPlayer> e = this.getMembers().elements();
        TreeSet<SPlayer> s = new TreeSet<SPlayer>();
        while (e.hasMoreElements()) {
            SPlayer p = e.nextElement();
            s.add(p);
        }
        result = result + "<Font color=\"black\">Player Ranking: ";
        Iterator it = s.iterator();
        while (it.hasNext()) {
            SPlayer p = (SPlayer)it.next();
            result = result + p.getName() + "(" + p.getRatingRounded() + ")";
            if (it.hasNext()) {
                result = result + ", ";
                continue;
            }
            result = result + "<br></font>";
        }
        return result;
    }

    public Vector getMechs() {
        return this.getHangar(0);
    }

    @Override
    public int getMoney() {
        return this.getMySHouseData().getMoney();
    }

    public String getColoredName() {
        return "<font color=\"" + this.getHouseColor() + "\">" + this.getName() + "</font>";
    }

    public String getColoredNameAsLink() {
        return "<font color=\"" + this.getHouseColor() + "\">" + this.getNameAsLink() + "</font>";
    }

    public String getColoredAbbreviation() {
        return "<font color=\"" + this.getHouseColor() + "\">" + this.getAbbreviation() + "</font>";
    }

    public TreeMap getPlanets() {
        return this.getMySHouseData().getPlanets();
    }

    public void setMembers(Hashtable Members) {
        this.getMySHouseData().setMembers(Members);
    }

    @Override
    public void setMoney(int money) {
        this.getMySHouseData().setMoney(money);
    }

    public Hashtable getActMembers() {
        return this.getMySHouseData().getActMembers();
    }

    public Hashtable getFightingMembers() {
        return this.getMySHouseData().getFightingMembers();
    }

    public int getLanceSize() {
        return 4;
    }

    public int getComponentsProduced(int unitType) {
        return this.getMySHouseData().getComponentsProduced(unitType);
    }

    public int getShowProductionCountNext() {
        return this.getMySHouseData().getShowProductionCountNext();
    }

    public boolean isBusy(String Playername) {
        return this.getFightingMembers().get(Playername.toLowerCase()) != null;
    }

    @Override
    public void increaseUnitsOnMarket(SUnit m) {
        this.getMySHouseData().setUnitsOnMarket(this.getMySHouseData().getUnitsOnMarket() + 1);
    }

    @Override
    public void decreaseUnitsOnMarket(SUnit m) {
        this.getMySHouseData().setUnitsOnMarket(this.getMySHouseData().getUnitsOnMarket() - 1);
    }

    public Hashtable getSmallPlayers() {
        return this.getMySHouseData().getSmallPlayers();
    }

    public int compareTo(Object o) {
        SHouse h = (SHouse)o;
        if (this.getMoney() > h.getMoney()) {
            return 1;
        }
        if (this.getMoney() < h.getMoney()) {
            return -1;
        }
        return this.getName().compareTo(h.getName());
    }

    @Override
    public void statusChanged(StatusChangeEvent e) {
        this.fireStatusEvent(e);
    }

    public void addStatusListener(StatusChangeListener l) {
        this.getMySHouseData().getStatusChangeList().add(StatusChangeListener.class, l);
    }

    @Override
    public void addMoney(int amount) {
        this.setMoney(this.getMoney() + amount);
    }

    public void addComponentsProduced(int unitType, int amount) {
        this.setComponentsProduced(unitType, this.getComponentsProduced(unitType) + amount);
    }

    public void addShowProductionCountNext(int amount) {
        this.setShowProductionCountNext(this.getShowProductionCountNext() + amount);
    }

    public void removeStatusListener(StatusChangeListener l) {
        this.getMySHouseData().getStatusChangeList().remove(StatusChangeListener.class, l);
    }

    public void fireStatusEvent(String text, String username) {
        UserEvent e = new UserEvent(this, text, username);
        this.fireStatusEvent(e);
    }

    public void fireStatusEvent(StatusChangeEvent e) {
        Object[] listeners = this.getMySHouseData().getStatusChangeList().getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != StatusChangeListener.class) continue;
            ((StatusChangeListener)listeners[i + 1]).statusChanged(e);
        }
    }

    public Hashtable<String, SPlayer> getMembers() {
        return this.getMySHouseData().getMembers();
    }

    public void setBaysProvided(int baysProvided) {
        this.getMySHouseData().setBaysProvided(baysProvided);
    }

    public void setComponentProduction(int componentProduction) {
        this.getMySHouseData().setComponentProduction(componentProduction);
    }

    public void setComponentsProduced(int unitType, int components) {
        this.getMySHouseData().setComponentsProduced(unitType, components);
    }

    public void setShowProductionCountNext(int components) {
        this.getMySHouseData().setShowProductionCountNext(components);
    }

    public void listDispossessedPilots(String Username) {
        this.getMySHouseData().getPilotQueues().listDispossessedPilots(Username);
    }

    public static int getMinEXPForMechClass(int WeightClass) {
        int needed = 0;
        switch (WeightClass) {
            case 1: {
                needed = Integer.parseInt(CampaignMain.cm.getConfig("MinEXPforMedium"));
                break;
            }
            case 2: {
                needed = Integer.parseInt(CampaignMain.cm.getConfig("MinEXPforHeavy"));
                break;
            }
            case 3: {
                needed = Integer.parseInt(CampaignMain.cm.getConfig("MinEXPforAssault"));
            }
        }
        return needed;
    }

    public boolean getHouseDefectionFrom() {
        return this.getMySHouseData().getHouseDefectionFrom();
    }

    public void setHouseDefectionFrom(boolean defection) {
        this.getMySHouseData().setHouseDefectionFrom(defection);
    }

    public boolean getHouseDefectionTo() {
        return this.getMySHouseData().getHouseDefectionTo();
    }

    public void setHouseDefectionTo(boolean defection) {
        this.getMySHouseData().setHouseDefectionTo(defection);
    }

    public double getHighestUnitCost(int weight, int type) {
        Vector s;
        double cost = 0.0;
        try {
            s = (Vector)this.getHangar(type).elementAt(weight);
        }
        catch (Exception ex) {
            MMServ.mmlog.errLog(ex);
            MMServ.mmlog.errLog("Empty Vector in getEntity");
            return Double.MAX_VALUE;
        }
        if (s == null) {
            return Double.MAX_VALUE;
        }
        for (SUnit unit : s) {
            if (!(unit.getEntity().getCost() > cost)) continue;
            cost = unit.getEntity().getCost();
        }
        return cost;
    }
}

