/*
 * Decompiled with CFR 0.152.
 */
package server.campaign;

import common.campaign.pilot.Pilot;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.Vector;
import server.campaign.SUnit;
import server.campaign.pilot.SPilot;

public class SPersonalPilotQueues {
    public static int ppMek = 0;
    public static int ppProto = 1;
    private Vector pilots = new Vector();

    public SPersonalPilotQueues() {
        for (int p = 0; p <= ppProto; ++p) {
            Vector queues = new Vector();
            for (int i = 0; i <= 3; ++i) {
                LinkedList v = new LinkedList();
                queues.add(i, v);
            }
            this.pilots.add(p, queues);
        }
    }

    public void addPilot(int type, int weight, Pilot p) {
        if (p.getName().equals("Vacant")) {
            p = null;
            return;
        }
        if (type == 3) {
            type = ppProto;
        }
        Vector v = (Vector)this.pilots.elementAt(type);
        ((LinkedList)v.get(weight)).addLast(p);
    }

    public Pilot getPilot(int type, int weight, int position) {
        if (type == 3) {
            type = ppProto;
        }
        Vector v = (Vector)this.pilots.elementAt(type);
        LinkedList list = (LinkedList)v.get(weight);
        return (Pilot)list.remove(position);
    }

    public int getQueueSize(int type, int weight) {
        if (type == 3) {
            type = ppProto;
        }
        Vector v = (Vector)this.pilots.elementAt(type);
        return ((LinkedList)v.get(weight)).size();
    }

    public String listDispossessedPilots() {
        String toReturn = "<font color=black>";
        boolean hadPilots = false;
        for (int type = 0; type <= ppProto; ++type) {
            String headerString = "";
            headerString = type == ppProto ? "<b>" + SUnit.getTypeClassDesc(3) + " Pilots:</b><br>" : "<b>" + SUnit.getTypeClassDesc(type) + " Pilots:</b><br>";
            boolean hadPilot = false;
            String pilotString = "";
            for (int weight = 0; weight <= 3; ++weight) {
                Vector v = (Vector)this.pilots.elementAt(type);
                LinkedList l = (LinkedList)v.get(weight);
                if (l.size() == 0) continue;
                pilotString = pilotString + SUnit.getWeightClassDesc(weight) + ":<UL>";
                for (int i = 0; i < l.size(); ++i) {
                    String skills;
                    Pilot pil = (Pilot)l.get(i);
                    pilotString = pilotString + "<LI>" + pil.getName() + " (" + pil.getGunnery();
                    if (type != ppProto) {
                        pilotString = pilotString + "/" + pil.getPiloting();
                    }
                    pilotString = (skills = pil.getSkillString(true)) != null && !skills.trim().equals("") ? pilotString + ", " + skills + ")</LI>" : pilotString + ")</LI>";
                }
                pilotString = pilotString + "</UL>";
            }
            if (pilotString.trim().equals("")) continue;
            toReturn = toReturn + headerString + pilotString;
            hadPilots = true;
        }
        toReturn = toReturn + "</font>";
        if (hadPilots) {
            return toReturn;
        }
        return "You don't have any reserve pilots at the moment.";
    }

    public LinkedList getPilotQueue(int type, int weight) {
        if (type == 3) {
            type = ppProto;
        }
        Vector v = (Vector)this.pilots.elementAt(type);
        LinkedList list = (LinkedList)v.get(weight);
        return list;
    }

    public String toString(boolean toClient) {
        StringBuffer result = new StringBuffer();
        for (int type = 0; type <= ppProto; ++type) {
            for (int weight = 0; weight <= 3; ++weight) {
                LinkedList list = this.getPilotQueue(type, weight);
                result.append(list.size());
                result.append("$");
                for (int count = 0; count < list.size(); ++count) {
                    result.append(((SPilot)list.get(count)).toFileFormat("#", toClient));
                    result.append("$");
                }
            }
        }
        return result.toString();
    }

    public void fromString(String buffer, String delimiter) {
        StringTokenizer ST = new StringTokenizer(buffer, delimiter);
        for (int type = 0; type <= ppProto; ++type) {
            for (int weight = 0; weight <= 3; ++weight) {
                int size = Integer.parseInt(ST.nextToken());
                for (int count = 0; count < size; ++count) {
                    SPilot pilot = new SPilot();
                    pilot.fromFileFormat(ST.nextToken(), "#");
                    this.addPilot(type, weight, pilot);
                }
            }
        }
    }
}

