/*
 * Decompiled with CFR 0.152.
 */
package server.campaign;

import common.Player;
import common.Unit;
import common.util.UnitUtils;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import megamek.common.AmmoType;
import megamek.common.Entity;
import megamek.common.Mounted;
import megamek.common.Protomech;
import server.MMServ;
import server.campaign.CampaignMain;
import server.campaign.ImmunityThread;
import server.campaign.SArmy;
import server.campaign.SHouse;
import server.campaign.SPersonalPilotQueues;
import server.campaign.SUnit;
import server.campaign.SmallPlayer;
import server.campaign.dataFiles.SPlayerData;
import server.campaign.dataFiles.SUnitData;
import server.campaign.event.StatusChangeListener;
import server.campaign.event.UserEvent;
import server.campaign.market.MarketBuyer;
import server.campaign.market.MarketSeller;
import server.campaign.mercenaries.ContractInfo;
import server.campaign.mercenaries.MercHouse;
import server.campaign.util.ExclusionList;
import server.campaign.util.OpponentListHelper;
import server.campaign.util.PlayerEntry;
import server.campaign.util.PlayerEntryKeeper;
import server.campaign.util.PlayerOptionHelper;
import server.campaign.util.UnitHistoryKeeper;
import server.util.MMNetPasswd;
import server.util.MMNetPasswdRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SPlayer
extends Player
implements Serializable,
Comparable,
MarketBuyer,
MarketSeller {
    public static final int MAX_NUM_LANCES = 30;
    public static final int STATUS_DISCONNECTED = 0;
    public static final int STATUS_LOGGEDOUT = 1;
    public static final int STATUS_LOGGEDIN = 2;
    public static final int STATUS_ACTIVE = 3;
    public static final int STATUS_FIGHTING = 4;
    private SPlayerData myData = new SPlayerData();
    private double weightedArmyNumber = -1.0;
    private String sellingto = "";

    public int getActivityStatus() {
        if (this.isBusy()) {
            return 4;
        }
        if (this.isActive()) {
            return 3;
        }
        if (this.getMyHouse().isLoggedIn(this.getName())) {
            return 2;
        }
        return 1;
    }

    public double getRatingRounded() {
        double r = this.getRating();
        BigDecimal bd = new BigDecimal(r);
        bd = bd.setScale(2, 4);
        r = bd.doubleValue();
        return r;
    }

    @Override
    public String getHouseName() {
        return this.getMyHouse().getName();
    }

    public void addChickenCount() {
        this.setChickenCount(this.getChickenCount() + 1);
    }

    public String toClientString() {
        return this.toString(true);
    }

    public String getIP() {
        return CampaignMain.cm.getServer().getIP(this.getName()).toString();
    }

    public String toString() {
        return this.toString(false);
    }

    protected String toString(boolean toClient) {
        StringBuffer result = new StringBuffer();
        result.append("CP~");
        result.append(this.getName());
        result.append("~");
        result.append(this.getMoney());
        result.append("~");
        result.append(this.getExperience());
        result.append("~");
        Vector units = this.getUnitsData();
        result.append(units.size() + "~");
        if (units.size() > 0) {
            for (int i = 0; i < units.size(); ++i) {
                SUnit unit = new SUnit((SUnitData)units.elementAt(i));
                unit.getPilot().setCurrentFaction(this.getHouseName());
                result.append(unit.toString(toClient));
                result.append("~");
            }
        }
        Vector<SArmy> armies = this.getArmies();
        result.append(armies.size());
        result.append("~");
        for (int i = 0; i < armies.size(); ++i) {
            result.append(armies.elementAt(i).toString(toClient, "%"));
            result.append("~");
        }
        result.append(new Boolean(false));
        result.append("~");
        result.append(this.myData.getLastOnline());
        result.append("~");
        result.append(this.TotalMechBays());
        result.append("~");
        result.append(this.getFreeBays());
        result.append("~");
        if (toClient) {
            if (Boolean.valueOf(CampaignMain.cm.getConfig("HideELO")).booleanValue()) {
                result.append("0");
            } else {
                result.append(this.getRatingRounded());
            }
        } else {
            result.append(this.myData.getRating());
        }
        result.append("~");
        result.append(this.myData.getInfluence());
        result.append("~");
        result.append(this.myData.getFluffText());
        result.append(" ~");
        Hashtable gameoptions = new Hashtable(this.myData.getGameoptions());
        result.append(gameoptions.size());
        Enumeration e = gameoptions.elements();
        while (e.hasMoreElements()) {
            PlayerOptionHelper POH = (PlayerOptionHelper)e.nextElement();
            result.append("~");
            result.append(POH.getDescription());
            result.append("~");
            result.append(POH.getSetting());
        }
        result.append("~");
        result.append(this.myData.getTechnicians());
        result.append("~");
        result.append(this.myData.getCurrentReward());
        result.append("~");
        result.append(this.myData.getPricePenalty());
        result.append("~");
        if (toClient) {
            result.append(this.myData.getCurrentTechPayment());
        } else {
            result.append("0");
        }
        result.append("~");
        result.append(this.getMyHouse().getName());
        result.append("~");
        result.append(this.getXPToReward());
        result.append("~");
        if (toClient) {
            result.append(this.getMyHouse().getLogo());
        } else {
            result.append("0");
        }
        result.append("~");
        result.append(this.getPlayerPersonalPilotQueue().toString(toClient));
        result.append("~");
        result.append(this.getExclusionList().adminExcludeToString("$"));
        result.append("~");
        result.append(this.getExclusionList().playerExcludeToString("$"));
        result.append("~");
        return result.toString();
    }

    public void fromString(String s, SHouse h) {
        int i;
        if (CampaignMain.cm.isDebugEnabled()) {
            MMServ.mmlog.infoLog("CSPlayer: " + s);
        }
        this.myData.getArmies().clear();
        s = s.substring(3);
        StringTokenizer ST = new StringTokenizer(s, "~");
        this.myData.setName(ST.nextToken());
        this.myData.setMoney(Integer.parseInt((String)ST.nextElement()));
        this.myData.setExperience(Integer.parseInt((String)ST.nextElement()));
        int numofarmies = 0;
        int numofUnits = Integer.parseInt((String)ST.nextElement());
        this.myData.setUnits(new Vector());
        for (i = 0; i < numofUnits; ++i) {
            SUnit m = new SUnit();
            m.fromString((String)ST.nextElement());
            this.myData.getUnits().add(m.getMySData());
            CampaignMain.cm.toUser("PL|HD|" + m.toString(true), this.getName(), false);
            if (!m.getPilot().getCurrentFaction().equalsIgnoreCase("none")) continue;
            m.getPilot().setCurrentFaction(this.getHouseName());
        }
        numofarmies = Integer.parseInt((String)ST.nextElement());
        MMServ.mmlog.mainLog("SPlayer " + this.getName() + " Lances: " + numofarmies);
        for (i = 0; i < numofarmies; ++i) {
            SArmy a = new SArmy();
            a.fromString((String)ST.nextElement(), "%", this);
            this.myData.getArmies().add(a);
            CampaignMain.cm.toUser("PL|SAD|" + a.toString(true, "%"), this.getName(), false);
        }
        String temp = (String)ST.nextElement();
        this.myData.setLastOnline(Long.parseLong(ST.nextToken()));
        if (ST.hasMoreElements()) {
            ST.nextToken();
            ST.nextToken();
        }
        this.myData.setRating(new Double(ST.nextToken()));
        this.myData.setInfluence(Integer.parseInt(ST.nextToken()));
        if (ST.hasMoreElements()) {
            this.myData.setFluffText(ST.nextToken().trim());
        }
        if (ST.hasMoreElements()) {
            int numofoptions = Integer.parseInt(ST.nextToken());
            for (int i2 = 0; i2 < numofoptions; ++i2) {
                PlayerOptionHelper POH = new PlayerOptionHelper();
                POH.setDescription(ST.nextToken());
                POH.setSetting(ST.nextToken());
                this.myData.getGameoptions().put(POH.getDescription(), POH);
            }
        }
        if (ST.hasMoreElements()) {
            this.myData.setTechnicians(Integer.parseInt(ST.nextToken()));
        }
        if (ST.hasMoreElements()) {
            this.myData.setCurrentReward(Integer.parseInt(ST.nextToken()));
        }
        if (ST.hasMoreElements()) {
            this.myData.setPricePenalty(new Double(ST.nextToken()).intValue());
        }
        if (ST.hasMoreElements()) {
            ST.nextElement();
        }
        this.myData.setMyHouseData(h.getMySHouseData());
        if (ST.hasMoreElements()) {
            this.setXPToReward(Integer.parseInt(ST.nextToken()));
        }
        if (ST.hasMoreElements()) {
            // empty if block
        }
        ST.nextToken();
        if (ST.hasMoreElements()) {
            this.getPlayerPersonalPilotQueue().fromString(ST.nextToken(), "$");
        }
        if (ST.hasMoreElements()) {
            this.getExclusionList().adminExcludeFromString(ST.nextToken(), "$");
        }
        if (ST.hasMoreElements()) {
            this.getExclusionList().playerExcludeFromString(ST.nextToken(), "$");
        }
        CampaignMain.cm.toUser("PL|SB|" + this.TotalMechBays(), this.getName(), false);
        CampaignMain.cm.toUser("PL|SF|" + this.getFreeBays(), this.getName(), false);
        this.setSave(true);
    }

    public void fromString(String s) {
        int i;
        if (CampaignMain.cm.isDebugEnabled()) {
            MMServ.mmlog.infoLog("CSPlayer: " + s);
        }
        this.myData.getArmies().clear();
        s = s.substring(3);
        StringTokenizer ST = new StringTokenizer(s, "~");
        this.myData.setName(ST.nextToken());
        this.myData.setMoney(Integer.parseInt((String)ST.nextElement()));
        this.myData.setExperience(Integer.parseInt((String)ST.nextElement()));
        int numofarmies = 0;
        int numofUnits = Integer.parseInt((String)ST.nextElement());
        this.myData.setUnits(new Vector());
        for (i = 0; i < numofUnits; ++i) {
            SUnit m = new SUnit();
            m.fromString((String)ST.nextElement());
            this.myData.getUnits().add(m.getMySData());
            CampaignMain.cm.toUser("PL|HD|" + m.toString(true), this.getName(), false);
        }
        numofarmies = Integer.parseInt((String)ST.nextElement());
        MMServ.mmlog.mainLog("SPlayer " + this.getName() + " Lances: " + numofarmies);
        for (i = 0; i < numofarmies; ++i) {
            SArmy a = new SArmy();
            a.fromString((String)ST.nextElement(), "%", this);
            this.myData.getArmies().add(a);
            CampaignMain.cm.toUser("PL|SAD|" + a.toString(true, "%"), this.getName(), false);
        }
        String temp = (String)ST.nextElement();
        this.myData.setLastOnline(new Long(ST.nextToken()));
        if (ST.hasMoreElements()) {
            ST.nextToken();
            ST.nextToken();
        }
        this.myData.setRating(new Double(ST.nextToken()));
        this.myData.setInfluence(Integer.parseInt(ST.nextToken()));
        if (ST.hasMoreElements()) {
            this.myData.setFluffText(ST.nextToken().trim());
        }
        if (ST.hasMoreElements()) {
            int numofoptions = Integer.parseInt(ST.nextToken());
            for (int i2 = 0; i2 < numofoptions; ++i2) {
                PlayerOptionHelper POH = new PlayerOptionHelper();
                POH.setDescription(ST.nextToken());
                POH.setSetting(ST.nextToken());
                this.myData.getGameoptions().put(POH.getDescription(), POH);
            }
        }
        if (ST.hasMoreElements()) {
            this.myData.setTechnicians(Integer.parseInt(ST.nextToken()));
        }
        if (ST.hasMoreElements()) {
            this.myData.setCurrentReward(Integer.parseInt(ST.nextToken()));
        }
        if (ST.hasMoreElements()) {
            this.myData.setPricePenalty(Integer.parseInt(ST.nextToken()));
        }
        if (ST.hasMoreElements()) {
            ST.nextElement();
        }
        if (ST.hasMoreElements()) {
            this.myData.setMyHouseData(CampaignMain.cm.getHouseFromPartialString(ST.nextToken(), this.getName()).getMySHouseData());
        }
        if (ST.hasMoreElements()) {
            this.setXPToReward(Integer.parseInt(ST.nextToken()));
        }
        if (ST.hasMoreElements()) {
            ST.nextToken();
        }
        if (ST.hasMoreElements()) {
            this.getPlayerPersonalPilotQueue().fromString(ST.nextToken(), "$");
        }
        if (ST.hasMoreElements()) {
            this.getExclusionList().adminExcludeFromString(ST.nextToken(), "$");
        }
        if (ST.hasMoreElements()) {
            this.getExclusionList().playerExcludeFromString(ST.nextToken(), "$");
        }
        CampaignMain.cm.toUser("PL|SB|" + this.TotalMechBays(), this.getName(), false);
        CampaignMain.cm.toUser("PL|SF|" + this.getFreeBays(), this.getName(), false);
    }

    public void savePlayerFile() {
        try {
            String fileName = this.getName().toLowerCase();
            FileOutputStream pout = new FileOutputStream("./campaign/players/" + fileName.toLowerCase() + ".dat");
            PrintStream pfile = new PrintStream(pout);
            pfile.println(this.toString());
            pfile.close();
            pout.close();
            this.checkRemoveable();
            if (this.isRemoveable()) {
                this.setSave(false);
                if (this.getActivityStatus() == 1) {
                    this.getMyHouse().getMembers().remove(fileName);
                }
            }
        }
        catch (Exception ex) {
            MMServ.mmlog.errLog(ex);
            MMServ.mmlog.errLog("Unable to save " + this.getName().toLowerCase());
        }
    }

    public SPlayer() {
    }

    public void unlockLances() {
        Vector<SArmy> armies = this.getArmies();
        for (int i = 0; i < armies.size(); ++i) {
            armies.elementAt(i).setLocked(false);
            CampaignMain.cm.toUser("PL|SAL|" + i + "#" + false, this.getName(), false);
        }
        this.setArmies(armies);
    }

    public void updateSQLPlayerEntry() {
        if (!CampaignMain.cm.useHibernate()) {
            return;
        }
        PlayerEntry entry = PlayerEntryKeeper.getPlayerEntry(this.getName());
        if (entry == null) {
            entry = PlayerEntry.getEntry(this.getName(), this.getExperience(), this.getRating());
        }
        entry.setELO(this.getRating());
        entry.setEXP(this.getExperience());
        PlayerEntryKeeper.addPlayerEntry(entry);
    }

    public SPlayer(String Name2, SHouse faction) {
        this.myData.setName(Name2);
        this.myData.setMyHouseData(faction.getMySHouseData());
    }

    public boolean mayUse(int Unitsize) {
        if (Unitsize == 1 && Integer.parseInt(CampaignMain.cm.getConfig("MinEXPforMedium")) > this.getExperience()) {
            return false;
        }
        if (Unitsize == 2 && Integer.parseInt(CampaignMain.cm.getConfig("MinEXPforHeavy")) > this.getExperience()) {
            return false;
        }
        return Unitsize != 3 || Integer.parseInt(CampaignMain.cm.getConfig("MinEXPforAssault")) <= this.getExperience();
    }

    public SArmy addArmy() {
        Vector<SArmy> armies = this.getArmies();
        armies.trimToSize();
        int i = 0;
        boolean free = false;
        while (!free) {
            free = true;
            for (int j = 0; j < armies.size(); ++j) {
                if (armies.elementAt(j).getID() != i) continue;
                free = false;
                ++i;
            }
        }
        SArmy arm = new SArmy(i);
        arm.setPlayerName(this.getName());
        arm.setUpperLimiter(Integer.parseInt(CampaignMain.cm.getConfig("DefaultUpperLimit")));
        arm.setLowerLimiter(Integer.parseInt(CampaignMain.cm.getConfig("DefaultLowerLimit")));
        armies.add(arm);
        this.myData.setArmies(armies);
        CampaignMain.cm.toUser("PL|SAD|" + arm.toString(true, "%"), this.getName(), false);
        this.getMyHouse().fireStatusEvent("Army added", this.getName());
        return arm;
    }

    protected boolean isBusy() {
        return this.getMyHouse().isBusy(this.getName());
    }

    public boolean isAbleToFight() {
        Vector<SArmy> armies = this.getArmies();
        for (int i = 0; i < armies.size(); ++i) {
            SArmy l = armies.elementAt(i);
            if (l.getOperationsBV(null) > Integer.parseInt(CampaignMain.cm.getConfig("MaxCountForTick")) || l.getOperationsBV(null) < Integer.parseInt(CampaignMain.cm.getConfig("MinCountForTick"))) continue;
            return true;
        }
        return false;
    }

    public boolean mayAcquireWelfareUnits() {
        return this.getHangarBV() < Integer.parseInt(CampaignMain.cm.getConfig("WelfareTotalUnitBVCeiling")) && this.getMoney() < Integer.parseInt(CampaignMain.cm.getConfig("WelfareCeiling"));
    }

    @Override
    public void addUnit(SUnit m, boolean isNew) {
        if (isNew) {
            UnitHistoryKeeper.addAcquireEntry(m.getId(), this.getName(), this.getMyHouse().getName());
            long immunityTime = Long.parseLong(CampaignMain.cm.getConfig("ImmunityTime")) * 1000L;
            m.setPassesMaintainanceUntil(System.currentTimeMillis() + immunityTime * 2L);
        }
        m.setScrappableFor(-1);
        if (this.getFreeBays() < m.getHangarSpaceRequired()) {
            m.setUnmaintainedStatus();
        } else {
            m.setStatus(1);
        }
        this.checkAmmoForUnit(m);
        m.setPosId(this.getFreeID());
        Vector units = this.getUnitsData();
        units.add(m.getMySData());
        this.myData.setUnits(units);
        this.getMyHouse().fireStatusEvent("Mech added", this.getName());
        CampaignMain.cm.toUser("PL|HD|" + m.toString(true), this.getName(), false);
        if (m.getStatus() == 1) {
            CampaignMain.cm.toUser("PL|SMU|" + m.getId() + "#" + 1, this.getName(), false);
        } else {
            CampaignMain.cm.toUser("PL|SMU|" + m.getId() + "#" + 3, this.getName(), false);
        }
        CampaignMain.cm.toUser("PL|SB|" + this.TotalMechBays(), this.getName(), false);
        CampaignMain.cm.toUser("PL|SF|" + this.getFreeBays(), this.getName(), false);
        this.setSave(true);
    }

    public void removeUnit(int unitid, boolean sendArmyUpdate) {
        SUnit Mech2 = null;
        Vector units = this.getUnitsData();
        for (int i = 0; i < units.size(); ++i) {
            Mech2 = new SUnit((SUnitData)units.elementAt(i));
            if (Mech2.getId() != unitid) continue;
            units.removeElementAt(i);
        }
        this.myData.setUnits(units);
        for (SArmy currA : this.getArmies()) {
            if (currA.getUnitPosition(unitid) <= -1) continue;
            currA.removeUnit(unitid);
            if (!sendArmyUpdate) continue;
            CampaignMain.cm.toUser("PL|SAD|" + currA.toString(true, "%"), this.getName(), false);
            CampaignMain.cm.getOpsManager().checkOperations(currA, true);
        }
        this.getMyHouse().fireStatusEvent("Mech removed", this.getName());
        CampaignMain.cm.toUser("PL|RU|" + unitid, this.getName(), false);
        CampaignMain.cm.toUser("PL|SB|" + this.TotalMechBays(), this.getName(), false);
        CampaignMain.cm.toUser("PL|SF|" + this.getFreeBays(), this.getName(), false);
        this.setSave(true);
    }

    protected int getFreeID() {
        int id = 0;
        Vector units = this.getUnitsData();
        boolean found = false;
        while (!found) {
            found = true;
            for (int i = 0; i < units.size(); ++i) {
                SUnit unit = new SUnit((SUnitData)units.elementAt(i));
                if (unit.getPosId() != id) continue;
                found = false;
                ++id;
            }
        }
        return id;
    }

    public SUnit getUnit(int id) {
        Vector units = this.getUnitsData();
        for (int i = 0; i < units.size(); ++i) {
            SUnit unit = new SUnit((SUnitData)units.elementAt(i));
            if (unit.getId() != id) continue;
            return unit;
        }
        return null;
    }

    public int getNumberOfUnits() {
        int result = this.myData.getUnits().size();
        return result += this.myData.getUnitsOnMarket().size();
    }

    public int TotalMechBays() {
        int minBays;
        int numBays = 0;
        boolean usesXP = Boolean.valueOf(CampaignMain.cm.getConfig("UseExperience"));
        boolean usesTechs = Boolean.valueOf(CampaignMain.cm.getConfig("UseTechnicians"));
        int BASE_BAYS = this.getMyHouse().getBaysProvided();
        if (!this.getMyHouse().isMercHouse() && (numBays += BASE_BAYS) < (minBays = Integer.parseInt(CampaignMain.cm.getConfig("MinimumHouseBays")))) {
            numBays = minBays;
        }
        if (usesXP) {
            int maxBaysFromXP;
            int experienceForBay;
            int experience = this.getExperience();
            int expBays = experience / (experienceForBay = Integer.parseInt(CampaignMain.cm.getConfig("ExperienceForBay")));
            if (expBays > (maxBaysFromXP = Integer.parseInt(CampaignMain.cm.getConfig("MaxBaysFromEXP")))) {
                expBays = maxBaysFromXP;
            }
            numBays += expBays;
        }
        if (usesTechs) {
            numBays += this.getTechnicians();
        }
        return numBays;
    }

    public int getTechHiringFee() {
        int techCost = Integer.parseInt(CampaignMain.cm.getConfig("BaseTechCost"));
        boolean decreaseWithXP = Boolean.valueOf(CampaignMain.cm.getConfig("DecreasingTechCost"));
        if (decreaseWithXP) {
            int xpToDecrease = Integer.parseInt(CampaignMain.cm.getConfig("XPForDecrease"));
            int minTechCost = Integer.parseInt(CampaignMain.cm.getConfig("MinimumTechCost"));
            for (int pExperience = this.getExperience(); pExperience >= xpToDecrease && techCost > minTechCost; pExperience -= xpToDecrease, --techCost) {
            }
            if (techCost < 0) {
                techCost = 0;
            }
        }
        return techCost;
    }

    public String doPayTechnicians(double percentage, int gamePayAmount) {
        String toReturn = "";
        int techPay = 0;
        if (this.getTechnicians() == 0) {
            return toReturn;
        }
        techPay = this.getCurrentTechPayment() < 0 ? this.doPayTechniciansMath() : this.getCurrentTechPayment();
        techPay = (int)((double)techPay * percentage);
        if (this.getMoney() < techPay) {
            toReturn = this.doFireUnpaidTechnicians(techPay, gamePayAmount);
        } else {
            this.addMoney(-techPay);
            if (techPay > 0) {
                toReturn = "You pay " + CampaignMain.cm.moneyOrFluMessage(true, false, techPay) + " to your techs";
                if (gamePayAmount > 0) {
                    toReturn = toReturn + " (Net Pay: " + CampaignMain.cm.moneyOrFluMessage(true, false, gamePayAmount - techPay, true) + ")";
                }
                toReturn = toReturn + ".";
            } else {
                toReturn = "";
            }
        }
        return toReturn;
    }

    public int doPayTechniciansMath(int techsToPay) {
        if (techsToPay <= 0) {
            this.setCurrentTechPayment(0);
            return 0;
        }
        boolean isAdditive = Boolean.valueOf(CampaignMain.cm.getConfig("UseAdditiveTechCosts"));
        boolean isLogarithmic = Boolean.valueOf(CampaignMain.cm.getConfig("UseLogarithmicTechCosts"));
        boolean isSupplyAndDemand = Boolean.valueOf(CampaignMain.cm.getConfig("UseSupplyAndDemandTechCosts"));
        double amountToPay = 0.0;
        if (isAdditive) {
            double additive = Double.parseDouble(CampaignMain.cm.getConfig("AdditivePerTech"));
            double ceiling = Double.parseDouble(CampaignMain.cm.getConfig("AdditiveCostCeiling"));
            int techCeiling = (int)(ceiling / additive);
            if (techsToPay > techCeiling) {
                int techsPastCeiling = techsToPay - techCeiling;
                amountToPay += ceiling * (double)techsPastCeiling;
            }
            int techsUsingAdditive = 0;
            techsUsingAdditive = techsToPay > techCeiling ? techCeiling : techsToPay;
            int totalAdditions = 0;
            for (int i = 1; i <= techsUsingAdditive; ++i) {
                totalAdditions += i;
            }
            amountToPay += (double)totalAdditions * additive;
        }
        if (isLogarithmic) {
            // empty if block
        }
        if (isSupplyAndDemand) {
            // empty if block
        }
        this.setCurrentTechPayment((int)amountToPay);
        return (int)amountToPay;
    }

    public int doPayTechniciansMath() {
        return this.doPayTechniciansMath(this.getTechnicians());
    }

    public String doFireUnpaidTechnicians(int amountToPay, int gamePayAmount) {
        int currentTechs;
        String toReturn = "";
        this.setCurrentTechPayment(-1);
        double additive = Double.parseDouble(CampaignMain.cm.getConfig("AdditivePerTech"));
        double ceiling = Double.parseDouble(CampaignMain.cm.getConfig("AdditiveCostCeiling"));
        double doubleAmountToPay = amountToPay;
        int techCeiling = (int)(ceiling / additive);
        for (currentTechs = this.getTechnicians(); amountToPay > this.getMoney() && currentTechs > techCeiling; --currentTechs) {
            amountToPay = (int)(doubleAmountToPay -= ceiling);
        }
        while (amountToPay > this.getMoney()) {
            double costOfCurrentTech = (double)currentTechs * additive;
            amountToPay = (int)(doubleAmountToPay -= costOfCurrentTech);
            if (--currentTechs != 0) continue;
            doubleAmountToPay = 0.0;
            amountToPay = 0;
        }
        int numberOfTechsFired = this.getTechnicians() - currentTechs;
        this.addMoney(-amountToPay);
        this.addTechnicians(-numberOfTechsFired);
        int numberUnmaintained = this.setRandomUnmaintained();
        toReturn = "You pay " + CampaignMain.cm.moneyOrFluMessage(true, false, amountToPay) + " to your techs";
        if (gamePayAmount > 0) {
            toReturn = toReturn + " (Net Pay: " + CampaignMain.cm.moneyOrFluMessage(true, false, gamePayAmount - amountToPay, true) + ").";
        }
        toReturn = toReturn + "<br>You weren't able to pay all of your technicians ... ";
        toReturn = numberOfTechsFired == 1 ? toReturn + "one" : toReturn + numberOfTechsFired;
        toReturn = toReturn + " quit in protest.";
        if (numberUnmaintained > 0) {
            toReturn = "<br><i><u>WARNING:</u></i> ";
            toReturn = numberUnmaintained == 1 ? toReturn + "a unit is now" : toReturn + numberUnmaintained + " units are now";
            toReturn = toReturn + " unmaintained. You must [<a href=\"MEKWARS/c deactivate\">DEACTIVATE</a>] in order to prevent";
            toReturn = numberUnmaintained == 1 ? toReturn + " an autoscrap." : toReturn + " autoscraps.";
        }
        return toReturn;
    }

    public int setRandomUnmaintained() {
        int numUnmaintained = 0;
        Enumeration e = this.getUnitsData().elements();
        Vector<SUnitData> okUnitsData = new Vector<SUnitData>();
        while (e.hasMoreElements()) {
            SUnitData currUnitData = (SUnitData)e.nextElement();
            if (currUnitData.getStatus() != 1) continue;
            okUnitsData.add(currUnitData);
        }
        while (this.getFreeBays() < 0) {
            if (okUnitsData.size() == 0) {
                return numUnmaintained;
            }
            int rnd = CampaignMain.cm.getR().nextInt(okUnitsData.size());
            SUnit unit = new SUnit((SUnitData)okUnitsData.elementAt(rnd));
            unit.setUnmaintainedStatus();
            ++numUnmaintained;
            CampaignMain.cm.toUser("PL|UU|" + unit.getId() + "|" + unit.toString(true), this.getName(), false);
            okUnitsData.remove(rnd);
        }
        this.getMyHouse().fireStatusEvent("SetUnmaintained called", this.getName());
        this.setSave(true);
        return numUnmaintained;
    }

    public void doMaintainance() {
        Vector allUnits = this.getUnitsData();
        Enumeration e = allUnits.elements();
        int increase = Integer.parseInt(CampaignMain.cm.getConfig("MaintainanceIncrease"));
        int decrease = Integer.parseInt(CampaignMain.cm.getConfig("MaintainanceDecrease"));
        while (e.hasMoreElements()) {
            SUnit currUnit = new SUnit((SUnitData)e.nextElement());
            if (currUnit.getStatus() == 1) {
                currUnit.addToMaintainanceLevel(increase);
                continue;
            }
            if (currUnit.getStatus() != 3) continue;
            int rnd = CampaignMain.cm.getR().nextInt(100) + 1;
            long currTime = System.currentTimeMillis();
            if (this.getImmunetill() > currTime || currUnit.getPassesMaintainanceUntil() > currTime) {
                currUnit.addToMaintainanceLevel(-decrease);
                continue;
            }
            if (rnd > currUnit.getMaintainanceLevel()) {
                if (this.getMyHouse().isNewbieHouse()) {
                    CampaignMain.cm.toUser("Your " + currUnit.getModelName() + " is badly maintained and failed a survival roll. In a normal faction, " + "failing these rolls <b>destroys</b> the unit. In the training faction you simply get this warning. Take heed.", this.getName(), true);
                    return;
                }
                int currId = currUnit.getId();
                int mechscrapprice = 0;
                if (new Boolean(CampaignMain.cm.getConfig("ScrappingCostsBills")).booleanValue()) {
                    mechscrapprice = this.getMyHouse().getPriceForUnit(currUnit.getWeightclass(), currUnit.getType(), null) / 3;
                    if (this.getMoney() < mechscrapprice) {
                        mechscrapprice = this.getMoney();
                    }
                    this.addMoney(-mechscrapprice);
                }
                int flutolose = this.getInfluence();
                this.addInfluence(-flutolose);
                String toSend = "Lack of maintainance has forced your techs to scrap " + currUnit.getPilot().getName() + "'s " + currUnit.getModelName() + " for parts. HQ is displeased (";
                if (mechscrapprice > 0) {
                    toSend = toSend + CampaignMain.cm.moneyOrFluMessage(true, false, -mechscrapprice, true) + ", ";
                }
                toSend = toSend + CampaignMain.cm.moneyOrFluMessage(false, false, -flutolose, true) + ").";
                CampaignMain.cm.toUser(toSend, this.getName(), true);
                this.getMyHouse().addDispossessedPilot(currUnit);
                this.removeUnit(currId, false);
                continue;
            }
            currUnit.addToMaintainanceLevel(-decrease);
        }
    }

    public boolean hasUnmaintainedUnit() {
        Enumeration e = this.getUnitsData().elements();
        while (e.hasMoreElements()) {
            if (new SUnit((SUnitData)e.nextElement()).getStatus() != 3) continue;
            return true;
        }
        return false;
    }

    public int getNumberOfVotesAllowed() {
        int voteTotal = Integer.parseInt(CampaignMain.cm.getConfig("StartingVotes"));
        int xpForVote = Integer.parseInt(CampaignMain.cm.getConfig("XPForAdditionalVote"));
        int maxVotes = Integer.parseInt(CampaignMain.cm.getConfig("MaximumVotes"));
        for (int pExperience = this.getExperience(); pExperience >= xpForVote && voteTotal < maxVotes; pExperience -= xpForVote, ++maxVotes) {
        }
        return voteTotal;
    }

    public int getTechsRequiredForProtos(int totalProtos) {
        if (totalProtos == 0) {
            return 0;
        }
        double points = (double)totalProtos / 5.0;
        int techRatio = Integer.parseInt(CampaignMain.cm.getConfig("TechsToProtoPointRatio"));
        double techs = points * (double)techRatio;
        if (techs < 1.0) {
            return 1;
        }
        return (int)techs;
    }

    public int getFreeBays() {
        int free = this.TotalMechBays();
        int totalProtos = 0;
        Vector m = this.getAllUnitsData();
        Enumeration e = m.elements();
        while (e.hasMoreElements()) {
            SUnit unit = new SUnit((SUnitData)e.nextElement());
            if (unit.getStatus() != 1) continue;
            int space = unit.getHangarSpaceRequired();
            free -= space;
            if (!(unit.getEntity() instanceof Protomech) || unit.getPilot().getSkills().has(2)) continue;
            ++totalProtos;
        }
        return free -= this.getTechsRequiredForProtos(totalProtos);
    }

    @Override
    public boolean hasRoom(SUnit m) {
        return this.getFreeBays() > m.getHangarSpaceRequired();
    }

    public void clearCache() {
        this.setArmyCache(new TreeMap());
    }

    @Override
    public boolean equals(Object o) {
        try {
            SPlayer p = (SPlayer)o;
            return p.getName().equals(this.getName());
        }
        catch (Exception ex) {
            return false;
        }
    }

    public int getHangarBV() {
        int bv = 0;
        Vector units = this.getUnitsData();
        for (int i = 0; i < units.size(); ++i) {
            SUnit unit = new SUnit((SUnitData)units.elementAt(i));
            bv += unit.getBV();
        }
        return bv;
    }

    public String getStatus(boolean adminStatus) {
        DecimalFormat myFormatter = new DecimalFormat("####.##");
        String s = "<font Color =\"black\"><br><b>Status for: " + this.getColoredName() + " (" + this.getMyHouse().getColoredName() + ")</b><br>";
        s = s + "  " + CampaignMain.cm.moneyOrFluMessage(true, false, this.getMoney()) + " //  " + CampaignMain.cm.moneyOrFluMessage(false, false, this.getInfluence()) + " // " + this.getExperience() + " Experience<br>";
        s = s + "Technicians (Idle/Total): " + this.getFreeBays() + "/" + this.TotalMechBays() + "<br>";
        s = s + "Paid Technicians: " + this.getTechnicians() + " (Cost: ";
        s = this.doPayTechniciansMath() < 0 ? s + CampaignMain.cm.moneyOrFluMessage(true, true, 0) + "/Game<br>" : s + CampaignMain.cm.moneyOrFluMessage(true, false, this.doPayTechniciansMath()) + "/Game)<br>";
        if (this.getUnitsOnMarket().size() > 0) {
            s = s + "<b>Units on Market:</b> " + this.getUnitsOnMarket().size() + "<br>";
        }
        if (Double.parseDouble(CampaignMain.cm.getConfig("PercentPerMezzo")) != 0.0) {
            double penalty = Double.parseDouble(CampaignMain.cm.getConfig("PercentPerMezzo")) * (double)this.getPricePenalty();
            s = s + "Price Modifier: " + this.getPricePenalty();
            s = this.getPricePenalty() > 0 ? s + " (" + myFormatter.format(penalty) + "% penalty to new unit costs.)<br>" : s + "<br>";
        }
        if (Boolean.valueOf(CampaignMain.cm.getConfig("VotingEnabled")).booleanValue()) {
            int votesCast = CampaignMain.cm.getVoteManager().getAllVotesBy(this).size();
            int votesAllowed = this.getNumberOfVotesAllowed();
            s = votesAllowed == votesCast ? s + "Votes: All votes cast (" + votesCast + "/" + votesAllowed + ").<br>" : s + "Votes: " + votesCast + " votes cast. " + votesAllowed + " votes allowed. (" + votesCast + "/" + votesAllowed + ").<br>";
        }
        if (!Boolean.valueOf(CampaignMain.cm.getConfig("HideELO")).booleanValue()) {
            s = s + "Rating: " + myFormatter.format(this.getRating()) + "<br>";
        }
        if (Boolean.valueOf(CampaignMain.cm.getConfig("ShowReward")).booleanValue()) {
            s = s + "Current Reward Points: " + this.getReward() + " (Maximum  of " + Integer.parseInt(CampaignMain.cm.getConfig("XPRewardCap")) + ")<br>";
        }
        s = s + "Game Options: ";
        Enumeration e = this.getGameoptions().elements();
        while (e.hasMoreElements()) {
            PlayerOptionHelper po = (PlayerOptionHelper)e.nextElement();
            s = s + po.getDescription() + " (" + po.getSetting() + ") ";
        }
        s = s + "<br><br>";
        if (Integer.parseInt(CampaignMain.cm.getConfig("NoPlayListSize")) > 0 || this.myData.getExclusionList().getAdminExcludes().size() > 0) {
            s = s + "<b>No-Play List:</b> ";
            Enumeration en = this.myData.getExclusionList().getPlayerExcludes().elements();
            s = en.hasMoreElements() ? s + (String)en.nextElement() : s + "empty";
            while (en.hasMoreElements()) {
                s = s + ", " + (String)en.nextElement();
            }
            s = s + "<br>";
            s = s + "<b>No-Play (Admin):</b> ";
            en = this.myData.getExclusionList().getAdminExcludes().elements();
            s = en.hasMoreElements() ? s + (String)en.nextElement() : s + "empty";
            while (en.hasMoreElements()) {
                s = s + ", " + (String)en.nextElement();
            }
            s = s + "<br><br>";
        }
        s = s + "<b>Current Armies:<br></b>";
        Vector<SArmy> armies = this.getArmies();
        if (armies.size() == 0) {
            s = s + "(No armies constructed)<br>";
        } else {
            for (int i = 0; i < armies.size(); ++i) {
                SArmy l = armies.elementAt(i);
                s = adminStatus ? s + l.getDescription(true, true, false) + "<br>" : s + l.getDescription(true, true, true) + "<br>";
            }
        }
        Vector units = this.getUnitsData();
        s = s + "<br><b>Contents of Hangar:</b><br>";
        for (int i = 0; i < units.size(); ++i) {
            SUnit tmpMech = new SUnit((SUnitData)units.elementAt(i));
            s = adminStatus ? s + tmpMech.getDescription(false) + "<br>" : s + tmpMech.getDescription(true) + "<br>";
        }
        s = s + "<br></font>";
        return s;
    }

    public String getMercStatus() {
        String s = "";
        SHouse myHouse = this.getMyHouse();
        if (myHouse.isMercHouse()) {
            s = "<font Color =\"black\"> Mercenary information for " + this.getName() + ": <br>";
            s = s + "Currently fighting for: " + ((MercHouse)myHouse).getHouseFightingFor(this).getName() + "<br>";
            ContractInfo contract = ((MercHouse)myHouse).getContractInfo(this);
            if (contract != null) {
                int duration = contract.getContractDuration();
                int startXP = contract.getStartingExperience();
                int performedXP = this.getExperience() - startXP;
                s = s + "Contract Status: " + performedXP + " of " + duration + "XP performed<br>";
            } else {
                s = s + "Contract Status: Currently avaliable for hire <br>";
            }
            s = s + "</font><br>";
        }
        return s;
    }

    public void addInfluence(int i) {
        this.setInfluence(this.getInfluence() + i);
    }

    @Override
    public void addMoney(int i) {
        this.setMoney(this.getMoney() + i);
        if (this.getMoney() < 0) {
            this.setMoney(0);
        }
    }

    @Override
    public int getMoney() {
        return this.myData.getMoney();
    }

    @Override
    public boolean isHuman() {
        return true;
    }

    public boolean isUnitOnMarket(SUnit m) {
        Vector unitsOnMarket = this.getUnitsOnMarket();
        for (int i = 0; i < unitsOnMarket.size(); ++i) {
            SUnitData mech = (SUnitData)unitsOnMarket.elementAt(i);
            if (!m.getMySData().equals(mech)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setMoney(int money) {
        if (this.getName().startsWith("[Coach]")) {
            return;
        }
        int moneyToSet = money;
        if (this.getMyHouse().isNewbieHouse() && moneyToSet > Integer.parseInt(CampaignMain.cm.getConfig("MaxSOLCBills"))) {
            moneyToSet = Integer.parseInt(CampaignMain.cm.getConfig("MaxSOLCBills"));
        }
        if (moneyToSet < 0) {
            this.myData.setMoney(0);
        } else {
            this.myData.setMoney(moneyToSet);
        }
        this.getMyHouse().fireStatusEvent("Money changed", this.getName());
        this.setSave(true);
    }

    public void addExperience(int i) {
        this.setExperience(this.getExperience() + i);
        this.checkXPReward(i);
    }

    public void addExperience(int i, boolean modAdded) {
        this.setExperience(this.getExperience() + i);
        if (!modAdded) {
            this.checkXPReward(i);
        }
    }

    public boolean countsForTick() {
        if (this.isActive() && this.isAbleToFight() && System.currentTimeMillis() - this.getOnlineSince() > (long)Integer.parseInt(CampaignMain.cm.getConfig("TickTime"))) {
            return true;
        }
        return this.isBusy();
    }

    public double getTickWorth() {
        return this.getWeightedArmyNumber();
    }

    public int getExperience() {
        return this.myData.getExperience();
    }

    public void setExperience(int experience) {
        int newExp = experience;
        if (newExp < 0) {
            newExp = 0;
        }
        if (this.getMyHouse().isNewbieHouse() && experience > Integer.parseInt(CampaignMain.cm.getConfig("MaxSOLExp")) && !this.getName().startsWith("[Coach]")) {
            newExp = Integer.parseInt(CampaignMain.cm.getConfig("MaxSOLExp"));
        }
        this.myData.setExperience(newExp);
        this.getMyHouse().fireStatusEvent("Experience changed", this.getName());
        SmallPlayer smallp = (SmallPlayer)this.getMyHouse().getSmallPlayers().get(this.getName().toLowerCase());
        if (smallp != null) {
            smallp.setExperience(newExp);
        }
        this.updateSQLPlayerEntry();
        CampaignMain.cm.toUser("PL|SB|" + this.TotalMechBays(), this.getName(), false);
        CampaignMain.cm.toUser("PL|SF|" + this.getFreeBays(), this.getName(), false);
        this.setSave(true);
    }

    public void setBusySlices(int i) {
        this.myData.setBusySlices(i);
    }

    public int getBusySlices() {
        return this.myData.getBusySlices();
    }

    public void addBusySlices(int i) {
        this.setBusySlices(this.getBusySlices() + i);
    }

    public void setLastCheckAttack(long l) {
        this.myData.setLastCheckAttack(l);
    }

    public long getLastCheckAttack() {
        return this.myData.getLastCheckAttack();
    }

    @Override
    public int getCurrentTechPayment() {
        return this.myData.getCurrentTechPayment();
    }

    @Override
    public void setCurrentTechPayment(int i) {
        this.myData.setCurrentTechPayment(i);
        this.setSave(true);
    }

    @Override
    public int getTechnicians() {
        return this.myData.getTechnicians();
    }

    @Override
    public void setTechnicians(int t) {
        if (t < 0) {
            t = 0;
        }
        this.myData.setTechnicians(t);
        this.getMyHouse().fireStatusEvent("Technicians Changed", this.getName());
        CampaignMain.cm.sendPlayerUpdate(this);
        this.setCurrentTechPayment(-1);
        CampaignMain.cm.toUser("PL|SB|" + this.TotalMechBays(), this.getName(), false);
        CampaignMain.cm.toUser("PL|SF|" + this.getFreeBays(), this.getName(), false);
        this.setSave(true);
    }

    @Override
    public void addTechnicians(int t) {
        this.setTechnicians(this.getTechnicians() + t);
    }

    @Override
    public String getName() {
        return this.myData.getName();
    }

    public String getColoredName() {
        return "<font color=\"" + this.getHouseFightingFor().getHouseColor() + "\">" + this.getName() + "</font>";
    }

    public void setName(String name) {
        this.myData.setName(name);
        this.setSave(true);
    }

    public SHouse getMyHouse() {
        return SHouse.getHouse(this.myData.getMyHouseData());
    }

    public SHouse getHouseFightingFor() {
        return this.getMyHouse().getHouseFightingFor(this);
    }

    public void setMyHouse(SHouse h) {
        this.myData.setMyHouseData(h.getMySHouseData());
        this.setSave(true);
    }

    public SArmy getArmy(int id) {
        Vector<SArmy> armies = this.getArmies();
        Enumeration<SArmy> e = armies.elements();
        while (e.hasMoreElements()) {
            SArmy l = e.nextElement();
            if (l.getID() != id) continue;
            return l;
        }
        return null;
    }

    public Vector<SArmy> getArmies() {
        return new Vector<SArmy>(this.myData.getArmies());
    }

    public double getWeightedArmyNumber() {
        if (this.weightedArmyNumber <= 0.0) {
            Vector<SArmy> orderedArmies = new Vector<SArmy>();
            int MinCount = Integer.parseInt(CampaignMain.cm.getConfig("MinCountForTick"));
            int MaxCount = Integer.parseInt(CampaignMain.cm.getConfig("MaxCountForTick"));
            int MaxFlatDiff = Integer.parseInt(CampaignMain.cm.getConfig("MaxBVDifference"));
            double MaxPercentDiff = Double.parseDouble(CampaignMain.cm.getConfig("MaxBVPercent"));
            for (SArmy currentArmy : this.getArmies()) {
                int forceBV = currentArmy.getOperationsBV(null);
                if (forceBV <= MinCount || forceBV >= MaxCount) continue;
                if (orderedArmies.size() == 0) {
                    orderedArmies.add(currentArmy);
                    continue;
                }
                Enumeration f = orderedArmies.elements();
                int forceNumber = 0;
                boolean forceSorted = false;
                while (f.hasMoreElements() && !forceSorted) {
                    if (currentArmy.getOperationsBV(null) < ((SArmy)f.nextElement()).getOperationsBV(null)) {
                        orderedArmies.add(forceNumber, currentArmy);
                        forceSorted = true;
                        continue;
                    }
                    ++forceNumber;
                }
                if (forceSorted) continue;
                orderedArmies.add(currentArmy);
            }
            this.weightedArmyNumber = orderedArmies.size();
            if (this.weightedArmyNumber > 0.0) {
                int overlap;
                SArmy currentArmy;
                Enumeration e = orderedArmies.elements();
                currentArmy = (SArmy)e.nextElement();
                int currentBV = currentArmy.getOperationsBV(null);
                double currentMaxDiff = 0.0;
                double caPercentDiff = (double)currentBV * MaxPercentDiff / 100.0;
                currentMaxDiff = (double)MaxFlatDiff >= caPercentDiff ? (double)MaxFlatDiff : caPercentDiff;
                if ((double)(currentBV - MinCount) < currentMaxDiff) {
                    this.weightedArmyNumber -= Double.parseDouble(CampaignMain.cm.getConfig("FloorPenalty"));
                    int overlap2 = currentBV - MinCount;
                    this.weightedArmyNumber -= (currentMaxDiff - (double)overlap2) / currentMaxDiff;
                }
                SArmy nextArmy = null;
                int nextBV = 0;
                while (e.hasMoreElements()) {
                    nextArmy = (SArmy)e.nextElement();
                    nextBV = nextArmy.getOperationsBV(null);
                    if (MaxPercentDiff <= 0.0) {
                        currentMaxDiff = MaxFlatDiff;
                    } else {
                        caPercentDiff = currentBV > nextBV ? (double)currentBV * MaxPercentDiff / 100.0 : (double)nextBV * MaxPercentDiff / 100.0;
                        currentMaxDiff = (double)MaxFlatDiff >= caPercentDiff ? (double)MaxFlatDiff : caPercentDiff;
                    }
                    if ((double)(nextBV - currentBV) < currentMaxDiff) {
                        this.weightedArmyNumber -= Double.parseDouble(CampaignMain.cm.getConfig("OverlapPenalty"));
                        overlap = nextBV - currentBV;
                        this.weightedArmyNumber -= (currentMaxDiff - (double)overlap) / currentMaxDiff;
                    }
                    currentArmy = nextArmy;
                    currentBV = nextBV;
                }
                caPercentDiff = (double)currentBV * MaxPercentDiff / 100.0;
                currentMaxDiff = (double)MaxFlatDiff >= caPercentDiff ? (double)MaxFlatDiff : caPercentDiff;
                if ((double)(MaxCount - currentBV) < currentMaxDiff) {
                    this.weightedArmyNumber -= Double.parseDouble(CampaignMain.cm.getConfig("CeilingPenalty"));
                    overlap = MaxCount - currentBV;
                    this.weightedArmyNumber -= (currentMaxDiff - (double)overlap) / currentMaxDiff;
                }
                for (SArmy currA : orderedArmies) {
                    if (currA.getLegalOperations().size() > 0) continue;
                    this.weightedArmyNumber -= 1.0;
                }
                if (this.weightedArmyNumber < 1.0) {
                    this.weightedArmyNumber = 1.0;
                }
            }
        }
        return this.weightedArmyNumber;
    }

    public void resetWeightedArmyNumber() {
        this.weightedArmyNumber = -1.0;
    }

    public void RemoveArmy(int armyID) {
        Vector<SArmy> armies = this.getArmies();
        for (int i = 0; i < armies.size(); ++i) {
            SArmy l = armies.elementAt(i);
            if (l.getID() != armyID) continue;
            armies.remove(i);
        }
        this.setArmies(armies);
        CampaignMain.cm.toUser("PL|RA|" + armyID, this.getName(), false);
        this.fireStatusEvent("Army Removed");
    }

    public void setArmies(Vector v) {
        this.myData.setArmies(v);
        this.setSave(true);
    }

    public void setArmyCache(Map v) {
        this.myData.setArmyCache(v);
        this.setSave(true);
    }

    public void stripOfAllUnits() {
        this.myData.setUnits(new Vector());
        this.setArmies(new Vector());
        this.myData.setArmyCache(new TreeMap());
        CampaignMain.cm.toUser("PS|" + this.toClientString(), this.getName(), false);
    }

    public boolean hasEmptyArmies() {
        Vector<SArmy> v = this.getArmies();
        for (int i = 0; i < v.size(); ++i) {
            SArmy l = v.elementAt(i);
            if (l.getUnits().size() != 0) continue;
            return true;
        }
        return false;
    }

    public Vector getUnitsData() {
        return new Vector(this.myData.getUnits());
    }

    public Vector getUnitsOnMarket() {
        return new Vector(this.myData.getUnitsOnMarket());
    }

    public Vector getAllUnitsData() {
        Vector result = new Vector();
        result.addAll(this.getUnitsData());
        result.addAll(this.getUnitsOnMarket());
        return result;
    }

    @Override
    public void increaseUnitsOnMarket(SUnit m) {
        Vector unitsOnMarket = this.getUnitsOnMarket();
        unitsOnMarket.add(m.getMySData());
        this.setUnitsOnMarket(unitsOnMarket);
        this.checkRemoveable();
    }

    @Override
    public void decreaseUnitsOnMarket(SUnit m) {
        Vector unitsOnMarket = this.getUnitsOnMarket();
        for (int i = 0; i < unitsOnMarket.size(); ++i) {
            SUnitData mech = (SUnitData)unitsOnMarket.elementAt(i);
            if (!m.getMySData().equals(mech)) continue;
            unitsOnMarket.removeElementAt(i);
            this.setUnitsOnMarket(unitsOnMarket);
            CampaignMain.cm.toUser("PL|RBM|" + m.getId(), this.getName(), false);
            CampaignMain.cm.toUser("PL|SB|" + this.TotalMechBays(), this.getName(), false);
            CampaignMain.cm.toUser("PL|SF|" + this.getFreeBays(), this.getName(), false);
            this.checkRemoveable();
            return;
        }
    }

    public void addPricePenalty(int x) {
        this.setPricePenalty(x + this.getPricePenalty());
    }

    public int compareTo(Object o) {
        SPlayer p = (SPlayer)o;
        if (this.getRating() > p.getRating()) {
            return 1;
        }
        if (this.getRating() < p.getRating()) {
            return -1;
        }
        return p.getName().compareTo(this.getName());
    }

    public void addStatusListener(StatusChangeListener l) {
        EventListenerList list = this.getStatusChangeList();
        list.add(StatusChangeListener.class, l);
        this.setStatusChangeList(list);
    }

    public void removeStatusListener(StatusChangeListener l) {
        EventListenerList list = this.getStatusChangeList();
        list.remove(StatusChangeListener.class, l);
        this.setStatusChangeList(list);
    }

    public EventListenerList getStatusChangeList() {
        return this.myData.getStatusChangeList();
    }

    public void setStatusChangeList(EventListenerList l) {
        this.myData.setStatusChangeList(l);
    }

    protected void fireStatusEvent(String text) {
        UserEvent e = new UserEvent(this, text, this.getName());
        Object[] listeners = this.getStatusChangeList().getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != StatusChangeListener.class) continue;
            ((StatusChangeListener)listeners[i + 1]).statusChanged(e);
        }
    }

    public int getIdle() {
        return this.myData.getIdle();
    }

    public void setIdle(int idle) {
        this.myData.setIdle(idle);
    }

    public int getScrapsThisTick() {
        return this.myData.getScrapsThisTick();
    }

    public void addScrapThisTick() {
        this.myData.setScrapsThisTick(this.myData.getScrapsThisTick() + 1);
    }

    public void setScrapsThisTick(int scraps) {
        this.myData.setScrapsThisTick(scraps);
    }

    public int getDonationsThisTick() {
        return this.myData.getDonationsThisTick();
    }

    public void addDonationThisTick() {
        this.myData.setDonationsThisTick(this.myData.getDonationsThisTick() + 1);
    }

    public void setDonatonsThisTick(int donations) {
        this.myData.setDonationsThisTick(donations);
    }

    public Date getLastOnlineDate() {
        return new Date(this.myData.getLastOnline());
    }

    public String getLogo() {
        MMNetPasswdRecord r = MMNetPasswd.getRecord(this.getName());
        if (r == null) {
            return this.getMyHouse().getLogo();
        }
        if (r.getPlayerLogo() == null) {
            return this.getMyHouse().getLogo();
        }
        return r.getPlayerLogo();
    }

    public void setActive(boolean newStatus) {
        if (!newStatus) {
            this.setOnlineSince(0L);
            this.setImmunetill(0L);
            this.setLastOnline(System.currentTimeMillis());
            this.clearCache();
            OpponentListHelper olh = new OpponentListHelper(this, 1);
            olh.sendInfoToOpponents("left the front lines and may no longer be attacked");
            CampaignMain.cm.getOpsManager().removePlayerFromAllPossibleDefenderLists(this, true);
            CampaignMain.cm.getOpsManager().removePlayerFromAllAttackerLists(this, null, true);
        } else {
            OpponentListHelper olh = new OpponentListHelper(this, 0);
            olh.sendInfoToOpponents("is headed to the front lines. You may attack it with ");
        }
        this.setActiveSince(System.currentTimeMillis());
        this.myData.setActive(newStatus);
    }

    public void setActiveNoOpplist() {
        this.setOnlineSince(0L);
        this.setImmunetill(0L);
        this.setLastOnline(System.currentTimeMillis());
        this.clearCache();
        this.setActiveSince(System.currentTimeMillis());
        this.myData.setActive(true);
    }

    public boolean isActive() {
        SHouse myHouse = this.getMyHouse();
        if (myHouse.isLoggedIn(this.getName())) {
            return this.myData.isActive();
        }
        return false;
    }

    public long getLastOnline() {
        return this.myData.getLastOnline();
    }

    public void setLastOnline(long lastOnline) {
        this.myData.setLastOnline(lastOnline);
        SmallPlayer smallp = (SmallPlayer)this.getMyHouse().getSmallPlayers().get(this.getName().toLowerCase());
        smallp.setLastOnline(lastOnline);
    }

    public long getAttackRestrictionUntil() {
        return this.myData.getAttackRestrictionUntil();
    }

    public void setAttackRestrictionUntil(long attackRestrictionUntil) {
        this.myData.setAttackRestrictionUntil(attackRestrictionUntil);
    }

    public double getRating() {
        return this.myData.getRating();
    }

    public void setRating(double rating) {
        this.myData.setRating(rating);
        SmallPlayer smallp = (SmallPlayer)this.getMyHouse().getSmallPlayers().get(this.getName().toLowerCase());
        smallp.setRating(rating);
        this.updateSQLPlayerEntry();
        this.setSave(true);
    }

    public long getImmunetill() {
        return this.myData.getImmunetill();
    }

    public void setImmunetill(long immunetill) {
        this.myData.setImmunetill(immunetill);
        if (immunetill > 0L) {
            int immunityLength = Integer.parseInt(CampaignMain.cm.getConfig("ImmunityTime")) * 1000;
            ImmunityThread ithread = new ImmunityThread(this, immunityLength);
            ithread.start();
        }
    }

    public String getFluffText() {
        String result = "";
        String fluffText = this.myData.getFluffText();
        if (fluffText.length() > 0 && !fluffText.equals(" ") && !fluffText.equals("0")) {
            result = result + fluffText;
        }
        return result;
    }

    public void setFluffText(String fluffText) {
        this.myData.setFluffText(fluffText);
        SmallPlayer smallp = (SmallPlayer)this.getMyHouse().getSmallPlayers().get(this.getName().toLowerCase());
        smallp.setFluffText(fluffText);
        this.setSave(true);
    }

    public Hashtable getGameoptions() {
        return new Hashtable(this.myData.getGameoptions());
    }

    public String getOption(String s) {
        PlayerOptionHelper POH = (PlayerOptionHelper)this.getGameoptions().get(s);
        if (POH == null) {
            return "";
        }
        return POH.getSetting();
    }

    public int getPricePenalty() {
        return this.myData.getPricePenalty();
    }

    public void setPricePenalty(int pricePenalty) {
        int oldPenalty = this.getPricePenalty();
        if (oldPenalty > 0 && pricePenalty < 0) {
            this.setPricePenalty(0);
            return;
        }
        if (pricePenalty < Integer.parseInt(CampaignMain.cm.getConfig("MezzoNegMax"))) {
            pricePenalty = Integer.parseInt(CampaignMain.cm.getConfig("MezzoNegMax"));
        }
        if (oldPenalty != pricePenalty) {
            int change = pricePenalty - oldPenalty;
            double penalty = Double.parseDouble(CampaignMain.cm.getConfig("PercentPerMezzo")) * (double)this.getPricePenalty();
            if (penalty <= 0.0) {
                return;
            }
            if (change < 0) {
                CampaignMain.cm.toUser("Your new Pricemodifier is: " + pricePenalty + " (" + change + ")", this.getName(), true);
            } else {
                CampaignMain.cm.toUser("Your new Pricemodifier is: " + pricePenalty + " (+" + change + ")", this.getName(), true);
            }
        }
        this.myData.setPricePenalty(pricePenalty);
        this.setSave(true);
    }

    public void setGameoptions(Hashtable gameoptions) {
        this.myData.setGameoptions(gameoptions);
        StringBuffer result = new StringBuffer();
        result.append(gameoptions.size());
        Enumeration e = gameoptions.elements();
        while (e.hasMoreElements()) {
            PlayerOptionHelper POH = (PlayerOptionHelper)e.nextElement();
            result.append("~");
            result.append(POH.getDescription());
            result.append("~");
            result.append(POH.getSetting());
        }
        this.setSave(true);
    }

    public String getLastSentStatus() {
        return this.myData.getLastSentStatus();
    }

    public void setLastSentStatus(String lastSentStatus) {
        this.myData.setLastSentStatus(lastSentStatus);
    }

    public long getActiveSince() {
        return this.myData.getActiveSince();
    }

    public void setActiveSince(long activeSince) {
        this.myData.setActiveSince(activeSince);
    }

    public void setUnitsOnMarket(Vector unitsOnMarket) {
        this.myData.setUnitsOnMarket(unitsOnMarket);
        this.setSave(true);
    }

    public int getAmountOfTimesUnitExistsInArmies(int unitID) {
        int result = 0;
        Vector<SArmy> v = this.getArmies();
        for (int i = 0; i < v.size(); ++i) {
            SArmy a = v.elementAt(i);
            if (a.getUnit(unitID) == null) continue;
            ++result;
        }
        return result;
    }

    public boolean HasVacantUnitsInArmies() {
        Vector<SArmy> v = this.getArmies();
        for (int i = 0; i < v.size(); ++i) {
            SArmy a = v.elementAt(i);
            Enumeration<Unit> units = a.getUnits().elements();
            while (units.hasMoreElements()) {
                SUnit unit = (SUnit)units.nextElement();
                if (!unit.getPilot().getName().equals("Vacant")) continue;
                return true;
            }
        }
        return false;
    }

    public void checkAmmoForUnit(SUnit u) {
        Entity en = u.getEntity();
        Enumeration e = en.getAmmo();
        boolean wasChanged = false;
        while (e.hasMoreElements()) {
            Mounted mAmmo = (Mounted)e.nextElement();
            AmmoType at = (AmmoType)mAmmo.getType();
            String munition = Long.toString(at.getMunitionType());
            if (CampaignMain.cm.getData().getServerBannedAmmo().get(munition) == null && this.getMyHouse().getBannedAmmo().get(munition) == null) continue;
            Vector types = AmmoType.getMunitionsFor(at.getAmmoType());
            Enumeration allTypes = types.elements();
            boolean defaultFound = false;
            while (allTypes.hasMoreElements() && !defaultFound) {
                AmmoType currType = (AmmoType)allTypes.nextElement();
                if (currType.getTechLevel() > at.getTechLevel() || currType.getMunitionType() != 0L) continue;
                mAmmo.changeAmmoType(currType);
                mAmmo.setShotsLeft(at.getShots());
                defaultFound = true;
                wasChanged = true;
            }
        }
        if (wasChanged) {
            u.setEntity(en);
        }
    }

    public int getChickenCount() {
        return this.myData.getChickenCount();
    }

    public void setChickenCount(int count) {
        this.myData.setChickenCount(count);
    }

    public long getOnlineSince() {
        return this.myData.getOnlineSince();
    }

    public void setOnlineSince(long i) {
        this.myData.setOnlineSince(i);
    }

    public int getInfluence() {
        return this.myData.getInfluence();
    }

    public void setInfluence(int i) {
        int influence = i;
        if (influence > Integer.parseInt(CampaignMain.cm.getConfig("InfluenceCeiling"))) {
            influence = Integer.parseInt(CampaignMain.cm.getConfig("InfluenceCeiling"));
        }
        if (influence < 0) {
            influence = 0;
        }
        this.myData.setInfluence(influence);
        this.getMyHouse().fireStatusEvent("Influence changed", this.getName());
        this.setSave(true);
    }

    public Integer getGroupAllowance() {
        return new Integer(this.myData.getGroupAllowance());
    }

    public void setGroupAllowance(Integer a) {
        this.myData.setGroupAllowance(a);
    }

    public void checkXPReward(int newXP) {
        int rollOver;
        if (newXP < 0) {
            return;
        }
        int currentXP = this.getXPToReward() + newXP;
        if (currentXP >= (rollOver = Integer.parseInt(CampaignMain.cm.getConfig("XPRollOverCap")))) {
            while (currentXP >= rollOver) {
                currentXP -= rollOver;
                this.addReward(1);
            }
            this.setXPToReward(currentXP);
            CampaignMain.cm.toUser("Your reward points have increased [<a href=\"MWUSERP\">Use RP</a>].", this.getName(), true);
        } else {
            this.setXPToReward(currentXP);
        }
    }

    public int getReward() {
        return this.myData.getCurrentReward();
    }

    public void setReward(int reward) {
        if (reward > Integer.parseInt(CampaignMain.cm.getConfig("XPRewardCap"))) {
            reward = Integer.parseInt(CampaignMain.cm.getConfig("XPRewardCap"));
        }
        this.myData.setCurrentReward(reward);
        this.setSave(true);
    }

    public void addReward(int toAdd) {
        this.setReward(this.getReward() + toAdd);
    }

    public int getXPToReward() {
        return this.myData.getXPToReward();
    }

    public void setXPToReward(int xp) {
        this.myData.setXPToReward(xp);
        this.setSave(true);
    }

    public boolean isSaveable() {
        return this.myData.isSaveable();
    }

    public void setSave(boolean save) {
        this.checkRemoveable();
        if (save && !this.isSaveable()) {
            CampaignMain.cm.addSavePlayers(this);
        }
        if (!this.isRemoveable()) {
            this.myData.setSave(true);
        } else {
            this.myData.setSave(save);
        }
    }

    public boolean isRemoveable() {
        return this.myData.isRemoveable();
    }

    public void setRemoveable(boolean save) {
        this.myData.setRemoveable(save);
    }

    public void checkRemoveable() {
        String name = this.getName();
        if (this.getUnitsOnMarket().size() > 0) {
            this.setRemoveable(false);
            return;
        }
        if (CampaignMain.cm.getMarket().getNumberOfBidsFor(name) > 0) {
            this.setRemoveable(false);
            return;
        }
        this.setRemoveable(true);
    }

    public void setPlayerSellingto(String selling) {
        this.sellingto = selling;
    }

    public String getPlayerSellingto() {
        return this.sellingto;
    }

    public void setPlayerClientVersion(String version) {
        this.myData.setPlayerClientVersion(version);
    }

    public String getPlayerClientVersion() {
        return this.myData.getPlayerClientVersion();
    }

    public void setPlayerPersonalPilotQueue(SPersonalPilotQueues PPQ) {
        this.myData.setPlayerPersonalPilotQueue(PPQ);
    }

    public SPersonalPilotQueues getPlayerPersonalPilotQueue() {
        return this.myData.getPlayerPersonalPilotQueue();
    }

    public void setExclusionList(ExclusionList el) {
        this.myData.setExclusionList(el);
    }

    public ExclusionList getExclusionList() {
        return this.myData.getExclusionList();
    }

    public void setLastTimeCommandSent(long time) {
        this.myData.setLastTimeCommandSent(time);
    }

    public long getLastTimeCommandSent() {
        return this.myData.getLastTimeCommandSent();
    }

    public boolean hasEnginedUnits() {
        if (!Boolean.valueOf(CampaignMain.cm.getConfig("UseAdvanceRepair")).booleanValue()) {
            return false;
        }
        Vector<SArmy> armies = this.getArmies();
        for (SArmy army : armies) {
            for (SUnit sUnit : army.getUnits()) {
                if (UnitUtils.canStartUp(sUnit.getEntity())) continue;
                return true;
            }
        }
        return false;
    }
}

