/*
 * Decompiled with CFR 0.152.
 */
package server.campaign;

import common.MegaMekPilotOption;
import common.Unit;
import common.util.UnitUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import java.util.StringTokenizer;
import megamek.common.AmmoType;
import megamek.common.Entity;
import megamek.common.Mech;
import megamek.common.MechFileParser;
import megamek.common.Mounted;
import megamek.common.Pilot;
import megamek.common.WeaponType;
import server.MMServ;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.dataFiles.SUnitData;
import server.campaign.pilot.SPilot;
import server.campaign.pilot.skills.SPilotSkill;
import server.campaign.pilot.skills.WeaponSpecialistSkill;
import server.campaign.util.UnitEntry;
import server.campaign.util.UnitEntryKeeper;
import server.campaign.util.UnitHistoryKeeper;

public final class SUnit
extends Unit
implements Serializable {
    private long passesMaintainanceUntil = 0L;
    private Entity unitEntity;

    public String toString(boolean toPlayer) {
        StringBuffer result = new StringBuffer();
        result.append("CM$");
        if (toPlayer) {
            result.append(this.getEntity().getChassis() + " " + this.getEntity().getModel());
        } else {
            result.append(this.getUnitFilename());
        }
        result.append("$");
        result.append(this.getPosId());
        result.append("$");
        result.append(this.getStatus());
        result.append("$");
        result.append(this.getProducer());
        result.append("$");
        result.append(((SPilot)this.getPilot()).toFileFormat("#", toPlayer));
        result.append("$");
        if (toPlayer) {
            LinkedList mmoptions = this.getPilot().getMegamekOptions();
            result.append(mmoptions.size());
            result.append("$");
            for (MegaMekPilotOption mmo : mmoptions) {
                result.append(mmo.getMmname());
                result.append("$");
                result.append(mmo.isValue());
                result.append("$");
            }
            result.append(this.getType());
            result.append("$");
            result.append(this.getBV());
            result.append("$");
        }
        result.append(this.getWeightclass());
        result.append("$");
        result.append(this.getId());
        result.append("$");
        if (this.getModelName().equals("OMG-UR-FD")) {
            return result.toString();
        }
        if (this.getEntity() instanceof Mech) {
            this.unitEntity = this.getEntity();
            result.append(((Mech)this.unitEntity).isAutoEject());
            result.append("$");
        }
        Enumeration en_Ammo = this.unitEntity.getAmmo();
        result.append(CampaignMain.cm.getEnumerationCount(en_Ammo));
        result.append("$");
        en_Ammo = this.unitEntity.getAmmo();
        while (en_Ammo.hasMoreElements()) {
            Mounted mAmmo = (Mounted)en_Ammo.nextElement();
            AmmoType at = (AmmoType)mAmmo.getType();
            result.append(at.getAmmoType());
            result.append("$");
            result.append(at.getInternalName());
            result.append("$");
            result.append(mAmmo.getShotsLeft());
            result.append("$");
        }
        Enumeration en_Weapon = this.unitEntity.getWeapons();
        result.append(CampaignMain.cm.getMachineGunCount(en_Weapon));
        result.append("$");
        en_Weapon = this.unitEntity.getWeapons();
        int location = 0;
        while (en_Weapon.hasMoreElements()) {
            Mounted mWeapon = (Mounted)en_Weapon.nextElement();
            WeaponType weapon = (WeaponType)mWeapon.getType();
            if (weapon.hasFlag(512)) {
                result.append(location);
                result.append("$");
                result.append(mWeapon.isRapidfire());
                result.append("$");
            }
            ++location;
        }
        result.append(this.unitEntity.hasSpotlight());
        result.append("$");
        result.append(this.unitEntity.isUsingSpotlight());
        result.append("$");
        if (toPlayer) {
            result.append(this.getPilotSkillBV());
            result.append("$");
        }
        result.append(this.getEntity().getTargSysType());
        result.append("$");
        result.append(this.getScrappableFor());
        result.append("$");
        if (Boolean.valueOf(CampaignMain.cm.getConfig("UseAdvanceRepair")).booleanValue()) {
            result.append(UnitUtils.unitBattleDamage(this.getEntity(), false));
        } else {
            result.append("%%-%%-%%-");
        }
        result.append("$");
        return result.toString();
    }

    public String fromString(String s) {
        try {
            Mounted mWeapon;
            s = s.substring(3);
            StringTokenizer ST = new StringTokenizer(s, "$");
            this.setUnitFilename((String)ST.nextElement());
            this.setPosId(Integer.parseInt(ST.nextToken()));
            int newstate = Integer.parseInt(ST.nextToken());
            this.setProducer((String)ST.nextElement());
            SPilot p = new SPilot();
            p.fromFileFormat(ST.nextToken(), "#");
            if (ST.hasMoreElements()) {
                this.setWeightclass(Integer.parseInt(ST.nextToken()));
            } else {
                this.setWeightclass(0);
            }
            if (ST.hasMoreElements()) {
                this.setId(Integer.parseInt(ST.nextToken()));
                if (CampaignMain.cm.getCurrentUnitID() <= this.getId()) {
                    CampaignMain.cm.setCurrentUnitID(this.getId() + 1);
                }
            } else {
                this.setId(CampaignMain.cm.getAndUpdateCurrentUnitID(this));
            }
            if (this.getId() == 0) {
                this.setId(CampaignMain.cm.getAndUpdateCurrentUnitID(this));
            }
            this.setStatus(newstate);
            this.unitEntity = this.loadMech(this.getUnitFilename());
            this.setEntity(this.unitEntity);
            this.setPilot(p, false);
            this.init();
            if (this.getModelName().equals("OMG-UR-FD")) {
                return s;
            }
            if (ST.hasMoreElements() && this.unitEntity instanceof Mech) {
                ((Mech)this.unitEntity).setAutoEject(Boolean.valueOf(ST.nextToken()));
            }
            if (ST.hasMoreElements()) {
                Entity en = this.getEntity();
                int maxCrits = Integer.parseInt(ST.nextToken());
                Enumeration e = en.getAmmo();
                for (int count = 0; count < maxCrits; ++count) {
                    int weaponType = Integer.parseInt(ST.nextToken());
                    String ammoName = ST.nextToken();
                    int shots = Integer.parseInt(ST.nextToken());
                    mWeapon = (Mounted)e.nextElement();
                    AmmoType at = this.getEntityAmmo(weaponType, ammoName);
                    if (at == null) continue;
                    String munition = Long.toString(at.getMunitionType());
                    if (CampaignMain.cm.getData().getServerBannedAmmo().get(munition) != null) continue;
                    mWeapon.changeAmmoType(at);
                    mWeapon.setShotsLeft(shots);
                }
                this.setEntity(en);
            }
            if (ST.hasMoreElements()) {
                int maxMachineGuns = Integer.parseInt(ST.nextToken());
                int currentLocation = 0;
                Entity en = this.getEntity();
                Enumeration enWeapons = en.getWeapons();
                block3: for (int count = 0; count < maxMachineGuns; ++count) {
                    int location = Integer.parseInt(ST.nextToken());
                    boolean selection = Boolean.valueOf(ST.nextToken());
                    while (enWeapons.hasMoreElements()) {
                        mWeapon = (Mounted)enWeapons.nextElement();
                        if (currentLocation == location) {
                            mWeapon.setRapidfire(selection);
                            ++currentLocation;
                            continue block3;
                        }
                        ++currentLocation;
                    }
                }
                this.setEntity(en);
            }
            if (ST.hasMoreElements()) {
                this.unitEntity.setSpotlight(Boolean.valueOf(ST.nextToken()));
            }
            if (ST.hasMoreElements()) {
                this.unitEntity.setSpotlightState(Boolean.valueOf(ST.nextToken()));
            }
            if (ST.hasMoreElements()) {
                this.unitEntity.setTargSysType(Integer.parseInt(ST.nextToken()));
            }
            if (!this.unitEntity.hasTargComp() && CampaignMain.cm.getMegaMekClient().game.getOptions().booleanOption("allow_level_3_targsys") && this.unitEntity instanceof Mech) {
                this.unitEntity.setTargSysType(0);
            }
            if (ST.hasMoreElements()) {
                this.setScrappableFor(new Integer(ST.nextToken()));
            }
            if (ST.hasMoreTokens()) {
                if (Boolean.valueOf(CampaignMain.cm.getConfig("UseAdvanceRepair")).booleanValue()) {
                    UnitUtils.applyBattleDamage(this.unitEntity, ST.nextToken());
                } else {
                    ST.nextToken();
                }
            }
            return s;
        }
        catch (Exception ex) {
            MMServ.mmlog.errLog(ex);
            MMServ.mmlog.errLog("Unable to Load SUnit: " + s);
            return s;
        }
    }

    public SUnit() {
        super(new SUnitData());
        this.setScrappableFor(new Integer(-1));
    }

    public String getDescription(boolean showLink) {
        String status = "";
        status = this.getStatus() == 2 ? "Destroyed" : (this.getStatus() == 3 ? "Unmaintained" : "Maintained");
        String idToShow = "";
        idToShow = showLink ? "<a href=\"MEKWARS/c sth#u#" + this.getId() + "\">#" + this.getId() + "</a>" : "#" + this.getId();
        if (this.getType() == 0 || this.getType() == 1) {
            return idToShow + " " + this.getModelName() + " (" + this.getPilot().getGunnery() + "/" + this.getPilot().getPiloting() + ") [" + this.getPilot().getExperience() + " EXP " + this.getPilot().getSkillString(false) + "] Kills: " + this.getPilot().getKills() + " " + this.getProducer() + ". BV: " + this.getBV() + " " + status + " (" + this.getMaintainanceLevel() + "%)";
        }
        return idToShow + " " + this.getModelName() + " (" + this.getPilot().getGunnery() + ") [" + this.getPilot().getExperience() + " EXP " + this.getPilot().getSkillString(false) + "] Kills: " + this.getPilot().getKills() + " " + this.getProducer() + ". BV: " + this.getBV() + " " + status + " (" + this.getMaintainanceLevel() + "%)";
    }

    public String getSmallDescription() {
        String result = this.getType() == 0 || this.getType() == 1 ? this.getModelName() + " [" + this.getPilot().getGunnery() + "/" + this.getPilot().getPiloting() : this.getModelName() + " [" + this.getPilot().getGunnery();
        if (!this.getPilot().getSkillString(true).equals(" ")) {
            result = result + this.getPilot().getSkillString(true);
        }
        result = result + "]";
        return result;
    }

    public static String getRandomPilotName(Random r) {
        String result = "John Doe";
        try {
            File configFile = new File("./data/pilotnames/Pilotnames.txt");
            FileInputStream fis = new FileInputStream(configFile);
            BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
            int names = Integer.parseInt(dis.readLine());
            int pilotid = r.nextInt(names);
            while (dis.ready()) {
                String line = dis.readLine();
                if (pilotid <= 0) {
                    return line;
                }
                --pilotid;
            }
        }
        catch (Exception e) {
            MMServ.mmlog.errLog("A problem occured with your Pilotnames File!");
        }
        return result;
    }

    public String getModelName() {
        if (this.getModelname() == null) {
            this.unitEntity = this.loadMech(this.getUnitFilename());
            this.init();
        }
        return this.getModelname();
    }

    public String getVerboseModelName() {
        if (this.getType() == 0 || this.getType() == 1) {
            return this.getModelName() + " (" + this.getPilot().getGunnery() + "/" + this.getPilot().getPiloting() + ")";
        }
        return this.getModelName() + " (" + this.getPilot().getGunnery() + ")";
    }

    public int getUnmoddedBV() {
        return this.getOriginalBV();
    }

    public int calcBV(boolean zeroWithDestroyed) {
        return this.calcBV(zeroWithDestroyed, false);
    }

    public int calcBV(boolean zeroWithDestroyed, boolean C3Network) {
        int BV = this.getOriginalBV(C3Network);
        if (zeroWithDestroyed && this.getStatus() == 2) {
            return 0;
        }
        int FastHoverBVMod = 0;
        try {
            FastHoverBVMod = Integer.parseInt(CampaignMain.cm.getConfig("FastHoverBVMod"));
        }
        catch (Exception ex) {
            System.err.print("There seems to be a problem with the FastHoverBVMod Setting in the config!");
        }
        if (FastHoverBVMod > 0 && this.getType() == 1 && this.getEntity().getMovementMode() == 5 && this.getEntity().getWalkMP() >= 8) {
            BV += FastHoverBVMod;
        }
        if (Boolean.valueOf(CampaignMain.cm.getConfig("ElitePilotsBVMod")).booleanValue()) {
            if (this.getPilot().getGunnery() < 3) {
                BV = (int)((double)BV * Math.pow(1.1, 3 - this.getPilot().getGunnery()));
            }
            if (this.getPilot().getPiloting() < 3) {
                BV = (int)((double)BV * Math.pow(1.05, 3 - this.getPilot().getPiloting()));
            }
        }
        return BV += this.getPilotSkillBV();
    }

    public boolean equals(Object o) {
        SUnit m = (SUnit)o;
        return m.getId() == this.getId() && m.getUnitFilename().equals(this.getUnitFilename()) && m.getPilot().getGunnery() == this.getPilot().getGunnery() && m.getPilot().getPiloting() == this.getPilot().getPiloting();
    }

    public void setPilot(SPilot p, boolean isNew) {
        if (p == null) {
            this.setBV(new Integer(0));
            return;
        }
        Pilot mPilot = new Pilot(p.getName(), p.getGunnery(), p.getPiloting());
        Entity entity = this.getEntity();
        entity.setCrew(mPilot);
        this.setEntity(entity);
        if (p.getSkills().has(12)) {
            Iterator ski = p.getSkills().getSkillIterator();
            while (ski.hasNext()) {
                SPilotSkill skill = (SPilotSkill)ski.next();
                if (!skill.getName().equals("Weapon Specialist") || !p.getWeapon().equals("Default")) continue;
                p.getSkills().remove(skill);
                ((WeaponSpecialistSkill)skill).assignWeapon(this.getEntity(), p);
                skill.addToPilot(p);
                skill.modifyPilot(p);
                break;
            }
        }
        p.setUnitType(this.getType());
        super.setPilot(p);
        if (isNew) {
            UnitHistoryKeeper.addaddPilotEntry(this.getId(), p.getName(), p.getGunnery(), p.getPiloting(), p.getSkillString(false));
            this.updateSQLEntry();
        }
        this.setBV(new Integer(0));
    }

    public SUnit(SUnitData data) {
        super(data);
    }

    public SUnit(String p, String Filename, int weightclass) {
        super(new SUnitData());
        this.setUnitFilename(Filename);
        Entity ent = this.loadMech(this.getUnitFilename());
        this.setEntity(ent);
        this.setPilot(new SPilot(SUnit.getRandomPilotName(CampaignMain.cm.getR()), 4, 5), false);
        this.setOriginalBV(ent.calculateBattleValue());
        this.setWeightclass(weightclass);
        if (ent != null) {
            this.setProducer(p);
            this.setPosId(-1);
            this.unitEntity = ent;
            this.setPilot(new SPilot(SUnit.getRandomPilotName(CampaignMain.cm.getR()), 4, 5), false);
            this.init();
        }
        this.setId(CampaignMain.cm.getAndUpdateCurrentUnitID(this));
    }

    public SUnit(String p, String Filename, int weightclass, int replaceId) {
        super(new SUnitData());
        this.setUnitFilename(Filename);
        Entity ent = this.loadMech(this.getUnitFilename());
        this.setEntity(ent);
        this.setPilot(new SPilot(SUnit.getRandomPilotName(CampaignMain.cm.getR()), 4, 5), false);
        this.setOriginalBV(ent.calculateBattleValue());
        if (ent != null) {
            this.setProducer(p);
            this.setPosId(-1);
            this.unitEntity = ent;
            this.setPilot(new SPilot(SUnit.getRandomPilotName(CampaignMain.cm.getR()), 4, 5), false);
            this.init();
        }
        this.setId(replaceId);
    }

    public boolean mayBeSoldOnMarket() {
        return this.getType() != 2;
    }

    private void init() {
        this.setType(this.getEntityType(this.getEntity()));
        if (this.getType() == 0 || this.getType() == 1) {
            this.setWeightclass(this.getEntityWeight(this.getEntity()));
        }
        if (this.getType() == 3 || this.getType() == 4 || this.getType() == 2 || this.getType() == 1 || this.getEntity().isOmni()) {
            this.setModelname(this.unitEntity.getChassis() + " " + this.unitEntity.getModel());
        } else {
            this.setModelname(this.unitEntity.getModel());
        }
        this.getC3Type(this.unitEntity);
        this.setOriginalBV(this.unitEntity.calculateBattleValue());
        if (this.getModelName().equals("OMG-UR-FD")) {
            this.setProducer("Error file was suppose to be " + this.getUnitFilename());
        }
    }

    public void setUnmaintainedStatus() {
        int baseUnmaintained = Integer.parseInt(CampaignMain.cm.getConfig("BaseUnmaintainedLevel"));
        int unmaintPenalty = Integer.parseInt(CampaignMain.cm.getConfig("UnmaintainedPenalty"));
        this.setStatus(3);
        if (this.getMaintainanceLevel() >= baseUnmaintained + unmaintPenalty) {
            this.setMaintainanceLevel(baseUnmaintained);
        } else {
            this.addToMaintainanceLevel(-unmaintPenalty);
        }
    }

    public int getBV() {
        int bv = this.getBV(true, false);
        if (bv < 0) {
            return 0;
        }
        return bv;
    }

    public int getBV(boolean C3Network) {
        return this.getBV(true, C3Network);
    }

    public int getBV(boolean zeroWithDestroyed, boolean C3Network) {
        if (C3Network) {
            return this.calcBV(false, C3Network);
        }
        if (this.getMySData().getBV() == 0 || !zeroWithDestroyed) {
            return this.calcBV(false);
        }
        return this.getMySData().getBV();
    }

    public static int getPrice(int weight) {
        switch (weight) {
            case 0: {
                return 10;
            }
            case 1: {
                return 20;
            }
            case 2: {
                return 30;
            }
            case 3: {
                return 40;
            }
        }
        return 10;
    }

    public Entity getEntity() {
        this.unitEntity = this.getMySData().getUnitEntity();
        if (this.unitEntity != null) {
            return this.unitEntity;
        }
        this.unitEntity = this.loadMech(this.getUnitFilename());
        this.setEntity(this.unitEntity);
        return this.unitEntity;
    }

    public void setEntity(Entity unitEntity) {
        this.unitEntity = unitEntity;
        this.getMySData().setUnitEntity(unitEntity);
    }

    public int getHangarSpaceRequired() {
        if (this == null) {
            return -1;
        }
        return CampaignMain.cm.getHangarSpaceRequired(this.getType(), this.getWeightclass(), this.getPilot().getBayModifier(), this.getModelName());
    }

    public Entity loadMech(String Filename) {
        if (Filename == null) {
            return null;
        }
        Entity ent = null;
        try {
            ent = new MechFileParser(new File("./data/unitfiles/Meks.zip"), Filename).getEntity();
        }
        catch (Exception ex) {
            try {
                ent = new MechFileParser(new File("./data/unitfiles/Vehicles.zip"), Filename).getEntity();
            }
            catch (Exception exe) {
                try {
                    ent = new MechFileParser(new File("./data/unitfiles/Infantry.zip"), Filename).getEntity();
                }
                catch (Exception exei) {
                    MMServ.mmlog.errLog("Error while trying to load: " + Filename);
                    try {
                        ent = new MechFileParser(new File("./data/unitfiles/Meks.zip"), "Error OMG-UR-FD.hmp").getEntity();
                    }
                    catch (Exception exep) {
                        MMServ.mmlog.errLog(exep);
                        MMServ.mmlog.errLog("Unable to find default unit file. Server Exiting");
                        System.exit(1);
                    }
                }
            }
        }
        return ent;
    }

    public void setPassesMaintainanceUntil(long l) {
        this.passesMaintainanceUntil = l;
    }

    public long getPassesMaintainanceUntil() {
        return this.passesMaintainanceUntil;
    }

    public void setBV(Integer BV) {
        this.getMySData().setBV(BV);
    }

    public String checkForPilotSkillImprovement(SPlayer owner) {
        return ((SPilot)this.getPilot()).checkForPilotSkillImprovement(this, owner);
    }

    public int getMapSizeModification() {
        if (this.getType() == 1) {
            return Integer.parseInt(CampaignMain.cm.getConfig("VehicleMapSizeFactor"));
        }
        if (this.getType() == 2) {
            return Integer.parseInt(CampaignMain.cm.getConfig("InfantryMapSizeFactor"));
        }
        if (this.getType() == 0) {
            return Integer.parseInt(CampaignMain.cm.getConfig("MekMapSizeFactor"));
        }
        if (this.getType() == 4) {
            return Integer.parseInt(CampaignMain.cm.getConfig("BattleArmorMapSizeFactor"));
        }
        if (this.getType() == 3) {
            return Integer.parseInt(CampaignMain.cm.getConfig("ProtoMekMapSizeFactor"));
        }
        return 0;
    }

    public Integer getUnitID() {
        return this.getMySData().getUnitID();
    }

    public void setUnitID(Integer id) {
        this.getMySData().setUnitID(id);
    }

    public Integer getScrappableFor() {
        return this.getMySData().getScrappableFor();
    }

    public void setScrappableFor(Integer i) {
        this.getMySData().setScrappableFor(i);
    }

    public Integer getExperience() {
        return new Integer(this.getPilot().getExperience());
    }

    public void setExperience(Integer experience) {
        this.getPilot().setExperience(experience);
    }

    public int getOriginalBV() {
        return this.getOriginalBV(false);
    }

    public int getOriginalBV(boolean C3Network) {
        int piloting = this.getEntity().getCrew().getPiloting();
        int gunnery = this.getEntity().getCrew().getGunnery();
        if (gunnery == 99 || piloting == 99) {
            this.getEntity().getCrew().setGunnery(4);
            this.getEntity().getCrew().setPiloting(5);
        }
        this.getMySData().setOriginalBV(this.getEntity().calculateBattleValue(C3Network));
        this.getEntity().getCrew().setGunnery(gunnery);
        this.getEntity().getCrew().setPiloting(piloting);
        return this.getMySData().getOriginalBV();
    }

    public void updateSQLEntry() {
        if (!CampaignMain.cm.useHibernate()) {
            return;
        }
        UnitEntry entry = UnitEntryKeeper.getUnitEntry(this.getId());
        entry.setPilotName(this.getPilot().getName());
        entry.setPilotGunnery(this.getPilot().getGunnery());
        entry.setPilotPiloting(this.getPilot().getPiloting());
        entry.setPilotSkill(this.getPilot().getSkillString(false));
        UnitEntryKeeper.addUnitEntry(entry);
    }

    public void setOriginalBV(int BV) {
        this.getMySData().setOriginalBV(BV);
    }

    public SUnitData getMySData() {
        return (SUnitData)this.getMyData();
    }

    public boolean isOmni() {
        boolean isOmni = false;
        String targetChassis = this.getEntity().getChassis();
        if (this.getType() == 1) {
            try {
                FileInputStream fis = new FileInputStream("./data/buildtables/omnivehiclelist.txt");
                BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
                while (dis.ready()) {
                    String chassie = dis.readLine();
                    if (!targetChassis.equalsIgnoreCase(chassie)) continue;
                    isOmni = true;
                    break;
                }
                dis.close();
                fis.close();
            }
            catch (Exception exception) {}
        } else {
            isOmni = this.getEntity().isOmni();
        }
        return isOmni;
    }

    public boolean hasTAG() {
        return this.getEntity().hasTAG();
    }

    public boolean hasHoming() {
        return this.getEntity().hasHomingRounds();
    }

    public int getPilotSkillBV() {
        int BV = 0;
        Iterator pilotSkills = this.getPilot().getSkills().getSkillIterator();
        while (pilotSkills.hasNext()) {
            SPilotSkill skill = (SPilotSkill)pilotSkills.next();
            if (skill instanceof WeaponSpecialistSkill) {
                BV += skill.getBVMod(this.getEntity(), (SPilot)this.getPilot());
                continue;
            }
            BV += skill.getBVMod(this.getEntity());
        }
        return BV;
    }
}

