/*
 * Decompiled with CFR 0.152.
 */
package server.campaign;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import server.MMServ;
import server.campaign.SUnit;

public class UnitCosts {
    Vector<Vector> minCostUnitList = new Vector();
    Vector<Vector> maxCostUnitList = new Vector();

    public UnitCosts() {
        for (int weight = 0; weight <= 3; ++weight) {
            Vector<Double> maxVector = new Vector<Double>();
            Vector<Double> minVector = new Vector<Double>();
            for (int type = 0; type <= 4; ++type) {
                maxVector.add(0.0);
                minVector.add(0.0);
            }
            this.maxCostUnitList.add(maxVector);
            this.minCostUnitList.add(minVector);
        }
    }

    public void addMaxCost(int weight, int type, double amount) {
        Vector maxCost = new Vector();
        maxCost = this.getMaxCost(weight);
        maxCost.removeElementAt(type);
        maxCost.add(type, amount);
        this.setMaxCost(weight, maxCost);
    }

    public void addMinCost(int weight, int type, double amount) {
        Vector minCost = new Vector();
        minCost = this.getMinCost(weight);
        minCost.removeElementAt(type);
        minCost.add(type, amount);
        this.setMinCost(weight, minCost);
    }

    public Vector getMaxCost(int weight) {
        return this.maxCostUnitList.get(weight);
    }

    public Vector getMinCost(int weight) {
        return this.minCostUnitList.get(weight);
    }

    public Double getMaxCostValue(int weight, int type) {
        Vector maxCostVector = this.maxCostUnitList.get(weight);
        return (Double)maxCostVector.get(type);
    }

    public Double getMinCostValue(int weight, int type) {
        Vector minCostVector = this.minCostUnitList.get(weight);
        return (Double)minCostVector.get(type);
    }

    public void setMaxCost(int weight, Vector cost) {
        this.maxCostUnitList.removeElementAt(weight);
        this.maxCostUnitList.add(weight, cost);
    }

    public void setMinCost(int weight, Vector cost) {
        this.minCostUnitList.removeElementAt(weight);
        this.minCostUnitList.add(weight, cost);
    }

    public void loadUnitCosts() {
        double minCost;
        double maxCost;
        double cost;
        SUnit unit;
        ZipEntry entry;
        ZipInputStream zipFile;
        FileInputStream in;
        String entityName = "";
        try {
            in = new FileInputStream("./data/unitfiles/Meks.zip");
            zipFile = new ZipInputStream(in);
            while (zipFile.available() == 1) {
                entry = zipFile.getNextEntry();
                entityName = entry.getName();
                if (entityName.startsWith("Error")) continue;
                unit = new SUnit("null", entityName, 0);
                cost = unit.getEntity().getCost();
                if (cost > (maxCost = this.getMaxCostValue(unit.getWeightclass(), unit.getType()).doubleValue())) {
                    this.addMaxCost(unit.getWeightclass(), unit.getType(), cost);
                    continue;
                }
                minCost = this.getMinCostValue(unit.getWeightclass(), unit.getType());
                if (minCost != 0.0 && !(cost < minCost)) continue;
                this.addMinCost(unit.getWeightclass(), unit.getType(), cost);
            }
        }
        catch (FileNotFoundException fnf) {
            MMServ.mmlog.errLog("Unable to load Meks.zip for UnitCosts.loadUnitCosts");
        }
        catch (Exception ex) {
            MMServ.mmlog.errLog("Error with Meks.zip file " + entityName);
            MMServ.mmlog.errLog(ex);
        }
        try {
            in = new FileInputStream("./data/unitfiles/Vehicles.zip");
            zipFile = new ZipInputStream(in);
            while (zipFile.available() == 1) {
                entry = zipFile.getNextEntry();
                entityName = entry.getName();
                unit = new SUnit("null", entityName, 0);
                cost = unit.getEntity().getCost();
                if (cost > (maxCost = this.getMaxCostValue(unit.getWeightclass(), unit.getType()).doubleValue())) {
                    this.addMaxCost(unit.getWeightclass(), unit.getType(), cost);
                    continue;
                }
                minCost = this.getMinCostValue(unit.getWeightclass(), unit.getType());
                if (minCost != 0.0 && !(cost < minCost)) continue;
                this.addMinCost(unit.getWeightclass(), unit.getType(), cost);
            }
        }
        catch (FileNotFoundException fnf) {
            MMServ.mmlog.errLog("Unable to load Vehicles.zip for UnitCosts.loadUnitCosts");
        }
        catch (Exception ex) {
            MMServ.mmlog.errLog("Error with Vehicles.zip file " + entityName);
            MMServ.mmlog.errLog(ex);
        }
        try {
            in = new FileInputStream("./data/unitfiles/Infantry.zip");
            zipFile = new ZipInputStream(in);
            while (zipFile.available() == 1) {
                entry = zipFile.getNextEntry();
                entityName = entry.getName();
                unit = new SUnit("null", entityName, 0);
                cost = unit.getEntity().getCost();
                if (cost > (maxCost = this.getMaxCostValue(unit.getWeightclass(), unit.getType()).doubleValue())) {
                    this.addMaxCost(unit.getWeightclass(), unit.getType(), cost);
                    continue;
                }
                minCost = this.getMinCostValue(unit.getWeightclass(), unit.getType());
                if (minCost != 0.0 && !(cost < minCost)) continue;
                this.addMinCost(unit.getWeightclass(), unit.getType(), cost);
            }
        }
        catch (FileNotFoundException fnf) {
            MMServ.mmlog.errLog("Unable to load Infantry.zip for UnitCosts.loadUnitCosts");
        }
        catch (Exception ex) {
            MMServ.mmlog.errLog("Error with Infantry.zip file " + entityName);
            MMServ.mmlog.errLog(ex);
        }
    }

    public String displayUnitCostsLists() {
        String result = "<b>Max Costs</b><br>";
        for (int weight = 0; weight <= 3; ++weight) {
            for (int type = 0; type <= 4; ++type) {
                result = result + SUnit.getWeightClassDesc(weight) + " " + SUnit.getTypeClassDesc(type) + " MaxCost: " + this.getMaxCostValue(weight, type) + " MinCost: " + this.getMinCostValue(weight, type) + ".<br>";
            }
        }
        return result;
    }
}

