/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SArmy;
import server.campaign.SPlayer;
import server.campaign.commands.Command;
import server.campaign.operations.Operation;

public class CheckArmyEligibilityCommand
implements Command {
    int accessLevel = 0;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlayer p = CampaignMain.cm.getPlayer(Username);
        int armyid = -1;
        String opName = "";
        try {
            armyid = Integer.parseInt(command.nextToken());
            opName = command.nextToken();
        }
        catch (Exception e) {
            CampaignMain.cm.toUser("Improper command. Try: /c checkarmyeligibility#id#operation", Username, true);
            return;
        }
        SArmy currA = p.getArmy(armyid);
        if (currA == null) {
            CampaignMain.cm.toUser("Could not find Army #" + armyid + ".", Username, true);
            return;
        }
        Operation currO = CampaignMain.cm.getOpsManager().getOperation(opName);
        if (currO == null) {
            CampaignMain.cm.toUser("Operation Type: " + opName + " does not exist.", Username, true);
            return;
        }
        String s = CampaignMain.cm.getOpsManager().validateShortAttack(p, currA, currO, null, -1);
        if (s != null && !s.trim().equals("")) {
            CampaignMain.cm.toUser(opName + " is illegal for Army #" + armyid + " " + s, Username, true);
            return;
        }
        CampaignMain.cm.toUser(opName + " is legal for Army #" + armyid + ".", Username, true);
    }
}

