/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SArmy;
import server.campaign.SPlayer;
import server.campaign.commands.Command;
import server.campaign.operations.Operation;
import server.campaign.operations.OpsChickenThread;
import server.campaign.operations.ShortOperation;

public class DefendCommand
implements Command {
    int accessLevel = 0;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        Operation o;
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        int opID = -1;
        int armyID = -1;
        try {
            opID = Integer.parseInt(command.nextToken());
            armyID = Integer.parseInt(command.nextToken());
        }
        catch (Exception e) {
            CampaignMain.cm.toUser("Improper format. Try: /c defend#attack number#army number", Username, true);
            return;
        }
        SPlayer dp = CampaignMain.cm.getPlayer(Username);
        if (dp == null) {
            CampaignMain.cm.toUser("Null player. Report this immediately!", Username, true);
            return;
        }
        ShortOperation so = CampaignMain.cm.getOpsManager().getRunningOps().get(opID);
        if (so == null) {
            CampaignMain.cm.toUser("Defend failed. Attack #" + opID + " does not exist.", Username, true);
            return;
        }
        SArmy da = dp.getArmy(armyID);
        if (da == null) {
            CampaignMain.cm.toUser("Defend failed. Army #" + armyID + " does not exist.", Username, true);
            return;
        }
        if (dp.getActivityStatus() == 4) {
            CampaignMain.cm.toUser("You are already fighting!", Username, true);
            return;
        }
        if (!dp.isActive()) {
            CampaignMain.cm.toUser("Defend failed. You must be active to defend against an attack.", Username, true);
            return;
        }
        if (so.getStatus() != ShortOperation.STATUS_WAITING) {
            if (so.getStatus() == ShortOperation.STATUS_FINISHED) {
                CampaignMain.cm.toUser("Defend failed. Attack #" + opID + " is finished.", Username, true);
                return;
            }
            CampaignMain.cm.toUser("Defend failed. Attack #" + opID + " is already defended.", Username, true);
            return;
        }
        OpsChickenThread pThread = so.getChickenThreads().get(dp.getName().toLowerCase());
        if (pThread == null || !pThread.getArmies().contains(da)) {
            o = CampaignMain.cm.getOpsManager().getOperation(so.getName());
            String s = CampaignMain.cm.getOpsManager().validateShortDefense(dp, da, o);
            if (s != null && !s.trim().equals("")) {
                CampaignMain.cm.toUser("Defend failed " + s, Username, true);
                return;
            }
        }
        CampaignMain.cm.getOpsManager().removePlayerFromAllAttackerLists(dp, so, true);
        CampaignMain.cm.getOpsManager().removePlayerFromAllDefenderLists(dp, so, true);
        so.addDefender(dp, da, "");
        o = CampaignMain.cm.getOpsManager().getOperation(so.getName());
        int money = Integer.parseInt(o.getValue("DefenderCostMoney"));
        int flu = Integer.parseInt(o.getValue("DefenderCostInfluence"));
        int rp = Integer.parseInt(o.getValue("DefenderCostReward"));
        String toSend = "You are now defending Attack #" + opID;
        boolean hasCost = false;
        if (money > 0) {
            dp.addMoney(-money);
            toSend = toSend + "(" + CampaignMain.cm.moneyOrFluMessage(true, true, money);
            hasCost = true;
        }
        if (flu > 0) {
            dp.addInfluence(-flu);
            toSend = hasCost ? toSend + ", " : toSend + "(";
            toSend = toSend + CampaignMain.cm.moneyOrFluMessage(false, true, flu);
            hasCost = true;
        }
        if (rp > 0) {
            dp.addReward(-rp);
            toSend = hasCost ? toSend + ", " : toSend + "(";
            toSend = toSend + "-" + rp + " RP";
            hasCost = true;
        }
        toSend = hasCost ? toSend + ")." : toSend + ".";
        CampaignMain.cm.toUser(toSend, Username, true);
    }
}

