/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import common.util.AorAn;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SArmy;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.commands.Command;
import server.campaign.util.UnitHistoryKeeper;

public class DirectSellUnitCommand
implements Command {
    int accessLevel = 2;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlayer p = CampaignMain.cm.getPlayer(Username);
        if (p.mayAcquireWelfareUnits()) {
            CampaignMain.cm.toUser("You may not sell any of you units while you are on welfare.", Username, true);
            return;
        }
        String buyer = command.nextToken();
        String seller = command.nextToken();
        int unitid = Integer.parseInt((String)command.nextElement());
        int sellPrice = Integer.parseInt(command.nextToken());
        SPlayer pBuyer = CampaignMain.cm.getPlayer(buyer);
        SPlayer pSeller = CampaignMain.cm.getPlayer(seller);
        boolean usesTechs = Boolean.valueOf(CampaignMain.cm.getConfig("UseTechnicians"));
        if (!Boolean.valueOf(CampaignMain.cm.getConfig("UseDirectSell")).booleanValue()) {
            CampaignMain.cm.toUser("Direct Sell is not allowed on this server!", Username, true);
            return;
        }
        if (pSeller.getMyHouse().isNewbieHouse()) {
            CampaignMain.cm.toUser("Players in SOL may not direct sell units.", Username, true);
            return;
        }
        if (pBuyer != null && pSeller != null) {
            int transferPayment;
            SUnit m = pSeller.getUnit(unitid);
            if (m == null) {
                return;
            }
            if (!pBuyer.hasRoom(m) && !usesTechs) {
                CampaignMain.cm.toUser(pBuyer.getName() + " has no room for that unit.", seller, true);
                return;
            }
            if (!pBuyer.getMyHouse().isLoggedIn(buyer)) {
                CampaignMain.cm.toUser(pBuyer.getName() + " is not logged in. You may only transfer to pSellers who are online.", Username, true);
                return;
            }
            if (Boolean.valueOf(CampaignMain.cm.getConfig("IPCheck")).booleanValue()) {
                if (CampaignMain.cm.getServer().getIP(pSeller.getName()).toString().equals(CampaignMain.cm.getServer().getIP(pBuyer.getName()).toString())) {
                    CampaignMain.cm.toUser(pBuyer.getName() + " has the same IP as you do. You can't send him units.", Username, true);
                    return;
                }
            } else {
                if (m.getStatus() == 3) {
                    CampaignMain.cm.toUser("You may not sell unmaintained mechs.", Username, true);
                    return;
                }
                if (pSeller.getAmountOfTimesUnitExistsInArmies(m.getId()) > 0 && pSeller.getActivityStatus() == 3) {
                    CampaignMain.cm.toUser("You may not sell units which are in active armies.", Username, true);
                    return;
                }
            }
            for (SArmy currA : pSeller.getArmies()) {
                if (!currA.isLocked() || currA.getUnit(m.getId()) == null) continue;
                CampaignMain.cm.toUser("You may not sell units which are in fighting armies.", pSeller.getName(), true);
                return;
            }
            boolean confirmedSend = false;
            if (command.hasMoreElements() && ((String)command.nextElement()).equals("CONFIRM")) {
                confirmedSend = true;
            }
            String basePayment = "SellDirect" + SUnit.getWeightClassDesc(m.getWeightclass()) + SUnit.getTypeClassDesc(m.getType()) + "Price";
            int costToRecipient = transferPayment = Integer.parseInt(CampaignMain.cm.getConfig(basePayment));
            costToRecipient += sellPrice;
            if (!confirmedSend) {
                if (Username.equals(buyer)) {
                    CampaignMain.cm.toUser("Illegal transaction the staff has been alerted!", buyer, true);
                    CampaignMain.cm.doSendModMail("NOTE", Username + " tried to illegally buy a unit from another player<br>Username: " + Username + " Buyer: " + buyer + " Seller: " + seller + " Unitid: " + m.getId());
                    pSeller.setPlayerSellingto("");
                    pBuyer.setPlayerSellingto("");
                    return;
                }
                pSeller.setPlayerSellingto(buyer);
                CampaignMain.cm.toUser(seller + " is trying to sell you " + AorAn.check(m.getModelName(), true) + " " + m.getModelName() + " for " + CampaignMain.cm.moneyOrFluMessage(true, true, costToRecipient) + "<br><a href=\"MEKWARS/c directsellunit#" + pBuyer.getName() + "#" + pSeller.getName() + "#" + unitid + "#" + sellPrice + "#CONFIRM\">Click here to buy</a>", buyer, true);
                return;
            }
            if (!pSeller.getPlayerSellingto().equalsIgnoreCase(buyer)) {
                CampaignMain.cm.toUser("Illegal transaction the staff has been alerted!", buyer, true);
                CampaignMain.cm.doSendModMail("NOTE", Username + " tried to illegally buy a unit from another player<br>Username: " + Username + " Buyer: " + buyer + " Seller: " + seller + " Unitid: " + m.getId());
                pSeller.setPlayerSellingto("");
                pBuyer.setPlayerSellingto("");
                return;
            }
            if (pBuyer.getMoney() < costToRecipient + 1) {
                CampaignMain.cm.toUser("You tried to sell " + AorAn.check(m.getModelName(), true) + " " + m.getModelName() + " to " + pBuyer.getName() + ", but they " + "cannot afford the payment. Transaction aborted.", seller, true);
                CampaignMain.cm.toUser(seller + " tried to sell you " + AorAn.check(m.getModelName(), true) + " " + m.getModelName() + "; however, you could not " + "afford the payment (" + CampaignMain.cm.moneyOrFluMessage(true, true, costToRecipient) + ").", pBuyer.getName(), true);
                pSeller.setPlayerSellingto("");
                pBuyer.setPlayerSellingto("");
                return;
            }
            pBuyer.addMoney(-costToRecipient);
            pSeller.addMoney(sellPrice);
            String result = "The " + m.getModelName() + " has been sold to " + pBuyer.getName() + " for " + CampaignMain.cm.moneyOrFluMessage(true, true, costToRecipient);
            if (costToRecipient - sellPrice > 0) {
                result = result + ".  However your contacts took " + CampaignMain.cm.moneyOrFluMessage(true, true, costToRecipient - sellPrice) + " for themselves.";
            }
            CampaignMain.cm.toUser(result, seller, true);
            CampaignMain.cm.toUser(pSeller.getName() + " has sold you " + AorAn.check(m.getModelName(), true) + " " + m.getModelName() + " for " + CampaignMain.cm.moneyOrFluMessage(true, true, costToRecipient) + ".", pBuyer.getName(), true);
            pSeller.removeUnit(m.getId(), true);
            pBuyer.addUnit(m, true);
            UnitHistoryKeeper.addSentEntry(m.getId(), pSeller.getName(), pSeller.getMyHouse().getName(), pBuyer.getName(), pBuyer.getMyHouse().getName());
            pSeller.setPlayerSellingto("");
            pBuyer.setPlayerSellingto("");
            if (p.mayAcquireWelfareUnits()) {
                CampaignMain.cm.doSendModMail("NOTE", Username + " has used the Direct Sell Command and sent themself into welfare.");
            }
        }
    }
}

