/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SArmy;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.commands.Command;
import server.campaign.util.UnitHistoryKeeper;

public class DonateCommand
implements Command {
    int accessLevel = 0;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        int donationsAllowed = Integer.parseInt(CampaignMain.cm.getConfig("DonationsAllowed"));
        if (donationsAllowed <= 0) {
            CampaignMain.cm.toUser("Donations are not allowed on this server.", Username, true);
            return;
        }
        SPlayer p = CampaignMain.cm.getPlayer(Username);
        if (p.getMyHouse().isNewbieHouse()) {
            CampaignMain.cm.toUser("SOL Players are not allowed to donate units, sorry!", Username, true);
            return;
        }
        if (p.mayAcquireWelfareUnits()) {
            CampaignMain.cm.toUser("You may not donate any of your units while you are on welfare.", Username, true);
            return;
        }
        int mechid = Integer.parseInt((String)command.nextElement());
        SUnit m = p.getUnit(mechid);
        if (p.isUnitOnMarket(m)) {
            CampaignMain.cm.toUser("You cannot donate units which are on the Black Market.", Username, true);
            return;
        }
        if (p.getAmountOfTimesUnitExistsInArmies(mechid) > 0 && p.getActivityStatus() == 3) {
            CampaignMain.cm.toUser("You may not donate units which are in active armies.", Username, true);
            return;
        }
        for (SArmy currA : p.getArmies()) {
            if (!currA.isLocked() || currA.getUnit(mechid) == null) continue;
            CampaignMain.cm.toUser("You may not donate units which are in fighting armies.", Username, true);
            return;
        }
        if (p.getDonationsThisTick() >= donationsAllowed) {
            CampaignMain.cm.toUser("You may only donate " + donationsAllowed + " units each tick.", Username, true);
            return;
        }
        int mechdonateprize = 0;
        if (new Boolean(CampaignMain.cm.getConfig("DonatingCostsBills")).booleanValue() && m.getScrappableFor() < 0) {
            mechdonateprize = p.getMyHouse().getPriceForUnit(m.getWeightclass(), m.getType(), null) / 6;
            int infToDonate = m.getWeightclass() * 2;
            if (p.getMoney() >= mechdonateprize && p.getInfluence() >= infToDonate) {
                p.addMoney(-mechdonateprize);
                p.addInfluence(-infToDonate);
            } else if (p.getUnitsData().size() < 4 && m.getWeightclass() != 0) {
                CampaignMain.cm.toUser("HQ has allowed you to donate this unit, at a reduced rate, due to your current situation.", Username, true);
                if (p.getMoney() >= mechdonateprize) {
                    p.addMoney(-mechdonateprize);
                } else {
                    mechdonateprize = p.getMoney();
                    p.addMoney(-mechdonateprize);
                }
                p.addInfluence(-infToDonate);
            } else {
                CampaignMain.cm.toUser("You can't afford to donate this unit. You need " + CampaignMain.cm.moneyOrFluMessage(true, true, mechdonateprize) + " and " + CampaignMain.cm.moneyOrFluMessage(false, false, infToDonate) + ".", Username, true);
                return;
            }
        }
        String toUser = "You donated the " + m.getModelName().trim();
        if (mechdonateprize > 0) {
            toUser = toUser + ". Your faction charges you " + CampaignMain.cm.moneyOrFluMessage(true, true, mechdonateprize) + " for the transfer";
        }
        toUser = toUser + ".";
        p.addDonationThisTick();
        CampaignMain.cm.toUser(toUser, Username, true);
        CampaignMain.cm.doSendHouseMail(p.getMyHouse(), "NOTE", p.getName() + " has donated a " + m.getVerboseModelName().trim() + " to the faction bay!");
        p.removeUnit(mechid, true);
        UnitHistoryKeeper.addDonateEntry(m.getId(), p.getName(), p.getMyHouse().getName());
        if (m.getPilot().getName().equals("Vacant")) {
            m.setPilot(p.getMyHouse().getNewPilot(m.getType()), true);
        }
        p.getMyHouse().addUnit(m, true);
        if (p.mayAcquireWelfareUnits()) {
            CampaignMain.cm.doSendModMail("NOTE", Username + " has used the Donate Command and sent themself into welfare.");
        }
    }
}

