/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.commands.Command;

public class FireTechsCommand
implements Command {
    int accessLevel = 0;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlayer p = CampaignMain.cm.getPlayer(Username);
        int numtofire = 1;
        try {
            numtofire = Integer.parseInt(command.nextToken());
        }
        catch (NumberFormatException ex) {
            CampaignMain.cm.toUser("Couldn't tell how many techs to fire. Check your input. It should be something like this: /c firetechs#3", Username, true);
            return;
        }
        if (p.getTechnicians() < numtofire) {
            CampaignMain.cm.toUser("You tried to fire " + numtofire + " technicians, but you only have " + p.getTechnicians() + " independent techs " + "on your payroll. The rest were assigned to your force by your faction and can't be dismissed.", Username, true);
            return;
        }
        if (p.getMyHouse().isBusy(Username)) {
            CampaignMain.cm.toUser("You may not fire technicians while you are engaged! Wait until your units are out of battle and fully repaired!", Username, true);
            return;
        }
        if (p.isActive()) {
            CampaignMain.cm.toUser("You may not fire technicians while you are active! Withdraw from the front lines before reducing your support levels!", Username, true);
            return;
        }
        p.addTechnicians(-numtofire);
        if (numtofire == 1) {
            CampaignMain.cm.toUser("You fire 1 technician.", Username, true);
        } else {
            CampaignMain.cm.toUser("You fired " + numtofire + " technicians.", Username, true);
        }
        if (p.getFreeBays() < 0) {
            p.setRandomUnmaintained();
            CampaignMain.cm.toUser("There are no longer enough technicians to maintain all of your equipment. Some units have been pulled from the active rotation. (Some units are now unmaintained! Check your status!)", Username, true);
        }
    }
}

