/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.commands.Command;

public class HireTechsCommand
implements Command {
    int accessLevel = 0;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        int numtohire = 1;
        SPlayer p = CampaignMain.cm.getPlayer(Username);
        int techCost = 0;
        try {
            numtohire = Integer.parseInt(command.nextToken());
        }
        catch (NumberFormatException ex) {
            CampaignMain.cm.toUser("Hire command failed. Check your input. It should be something like this: /c hiretechs#3", Username, true);
            return;
        }
        techCost = p.getTechHiringFee();
        if ((techCost *= numtohire) > p.getMoney()) {
            CampaignMain.cm.toUser("Hiring " + numtohire + " techs will cost you " + CampaignMain.cm.moneyOrFluMessage(true, false, techCost) + ". You only have " + p.getMoney() + " " + CampaignMain.cm.moneyOrFluMessage(true, false, p.getMoney()) + ".", Username, true);
            return;
        }
        p.addTechnicians(numtohire);
        if (numtohire == 1) {
            CampaignMain.cm.toUser("You've hired a technician! (-" + CampaignMain.cm.moneyOrFluMessage(true, false, techCost) + ")", Username, true);
        } else {
            CampaignMain.cm.toUser("You've hired " + numtohire + " technicians! (-" + CampaignMain.cm.moneyOrFluMessage(true, false, techCost) + ")", Username, true);
        }
        p.addMoney(-techCost);
    }
}

