/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.Collections;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlanet;
import server.campaign.commands.Command;
import server.campaign.operations.ShortOperation;
import server.campaign.util.PlanetNameComparator;

public class HouseCommand
implements Command {
    int accessLevel = 0;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        SPlanet currPlanet;
        int ownedWorldsSize;
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        if (!command.hasMoreElements()) {
            CampaignMain.cm.toUser("Improper format. Try: /c faction#name", Username, false);
            return;
        }
        String Name2 = (String)command.nextElement();
        SHouse h = (SHouse)CampaignMain.cm.getData().getHouseByName(Name2);
        if (h == null) {
            CampaignMain.cm.toUser("Could not find faction. Command fails.", Username, false);
            return;
        }
        String s = "<font Color =\"black\"><br><b><u>Status for: " + h.getColoredName() + "</u></b><br>";
        int totalOnline = h.getActMembers().size() + h.getFightingMembers().size();
        int sinceLastRestart = h.getSmallPlayers().size();
        s = s + "Players: " + totalOnline + " online, " + sinceLastRestart + " logins since last restart.<br>";
        Vector<SPlanet> ownedWorlds = new Vector<SPlanet>();
        Vector<SPlanet> contestedWorlds = new Vector<SPlanet>();
        int totalOwnership = 0;
        for (SPlanet p : CampaignMain.cm.getData().getAllPlanets()) {
            int ownership = p.getInfluence().getInfluence(h.getId());
            totalOwnership += ownership;
            if (p.getOwner() != null && p.getOwner().equals(h)) {
                ownedWorlds.add(p);
                continue;
            }
            if (ownership <= 0) continue;
            contestedWorlds.add(p);
        }
        String rankString = "";
        int diff = totalOwnership - h.getInitialHouseRanking();
        rankString = diff > 0 ? rankString + "+" + diff : rankString + diff;
        rankString = rankString + "/" + h.getInitialHouseRanking();
        s = s + "Ranking: " + rankString + "<br>";
        if (sinceLastRestart < 1) {
            sinceLastRestart = 1;
        }
        if ((ownedWorldsSize = ownedWorlds.size()) < 1) {
            ownedWorldsSize = 1;
        }
        s = s + "Total Economic Value: " + h.getComponentProduction() + "<br>" + "  - Avg. Planet: " + h.getComponentProduction() / ownedWorldsSize + "<br>" + "  - Per Capita: " + h.getComponentProduction() / sinceLastRestart + "<br><br>";
        Collections.sort(ownedWorlds, new PlanetNameComparator());
        Collections.sort(contestedWorlds, new PlanetNameComparator());
        Iterator i = ownedWorlds.iterator();
        s = s + "<b>Planets (Owned):</b>";
        s = !i.hasNext() ? s + " none<br>" : s + "<br>";
        while (i.hasNext()) {
            int amtOwned;
            currPlanet = (SPlanet)i.next();
            s = s + currPlanet.getNameAsColoredLink();
            if (currPlanet.getFactoryCount() > 0) {
                s = s + "*";
            }
            if ((amtOwned = currPlanet.getInfluence().getInfluence(h.getId())) < 100) {
                s = s + " (" + amtOwned + "%)";
            }
            if (i.hasNext()) {
                s = s + ", ";
                continue;
            }
            s = s + "<br>";
        }
        s = s + "<br><b>Planets (Contested):</b>";
        i = contestedWorlds.iterator();
        s = !i.hasNext() ? s + " none<br>" : s + "<br>";
        while (i.hasNext()) {
            SHouse owner;
            currPlanet = (SPlanet)i.next();
            s = s + currPlanet.getNameAsColoredLink();
            if (currPlanet.getFactoryCount() > 0) {
                s = s + "*";
            }
            s = (owner = currPlanet.getOwner()) != null ? s + " (" + currPlanet.getInfluence().getInfluence(h.getId()) + "%, " + owner.getColoredAbbreviation() + " " + currPlanet.getInfluence().getInfluence(owner.getId()) + "%)" : s + "(" + currPlanet.getInfluence().getInfluence(h.getId()) + "%, No Owner)";
            if (i.hasNext()) {
                s = s + ", ";
                continue;
            }
            s = s + "<br>";
        }
        s = s + "<br><b>Current Games: </b>";
        String gameStrings = "";
        for (ShortOperation so : CampaignMain.cm.getOpsManager().getRunningOps().values()) {
            if (!so.hasPlayerWhoseHouseBeginsWith(h.getName())) continue;
            gameStrings = gameStrings + "<br>" + so.getInfo(false);
        }
        s = gameStrings.trim().equals("") ? s + "none.<br>" : s + gameStrings + "<br>";
        CampaignMain.cm.toUser("SM|" + s, Username, false);
    }
}

