/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.commands.Command;
import server.campaign.pilot.SPilot;
import server.campaign.util.UnitHistoryKeeper;

public class NamePilotCommand
implements Command {
    int accessLevel = 0;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        if (command.hasMoreElements()) {
            int mechid = Integer.parseInt((String)command.nextElement());
            if (command.hasMoreElements()) {
                String name = (String)command.nextElement();
                if (name.length() > 30) {
                    name = name.substring(0, 30);
                }
                if (name.indexOf("|") != -1 || name.indexOf("~") != -1 || name.indexOf("$") != -1 || name.indexOf("%") != -1 || name.equals("Vacant")) {
                    CampaignMain.cm.toUser("That pilot name is illegal! change it!", Username, true);
                    return;
                }
                SPlayer p = CampaignMain.cm.getPlayer(Username);
                if (p != null) {
                    if (p.getName().equalsIgnoreCase("Vacant")) {
                        CampaignMain.cm.toUser("There is no pilot in that unit! It is vacant!", Username, true);
                        return;
                    }
                    SUnit m = p.getUnit(mechid);
                    if (m != null) {
                        SPilot pilot = (SPilot)m.getPilot();
                        UnitHistoryKeeper.addPilotChangeNameEntry(m.getId(), m.getPilot().getName(), name);
                        pilot.setName(name);
                        CampaignMain.cm.toUser("The pilot of the " + m.getModelName() + " has been renamed to " + name, Username, true);
                        p.getMyHouse().fireStatusEvent("Pilot name changed", Username);
                        CampaignMain.cm.toUser("PL|UU|" + m.getId() + "|" + m.toString(true), Username, false);
                    }
                }
            }
        }
    }
}

