/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import common.UnitFactory;
import java.util.StringTokenizer;
import server.MMServ;
import server.campaign.CampaignMain;
import server.campaign.SPlanet;
import server.campaign.SPlayer;
import server.campaign.commands.Command;

public class RefreshFactoryCommand
implements Command {
    int accessLevel = 2;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        if (!Boolean.valueOf(CampaignMain.cm.getConfig("AllowFactoryRefreshForRewards")).booleanValue()) {
            return;
        }
        int rpCost = Integer.parseInt(CampaignMain.cm.getConfig("RewardPointToRefreshFactory"));
        try {
            SPlayer player = CampaignMain.cm.getPlayer(Username);
            SPlanet p = (SPlanet)CampaignMain.cm.getData().getPlanetByName(command.nextToken());
            if (p == null) {
                CampaignMain.cm.toUser("Unknown planet!", Username, true);
                return;
            }
            String factory = command.nextToken();
            UnitFactory uf = CampaignMain.cm.getData().getFactoryByName(p, factory);
            if (uf == null) {
                CampaignMain.cm.toUser("Unknown factory!", Username, true);
                return;
            }
            if (player.getReward() < rpCost) {
                CampaignMain.cm.toUser("You do not have enough reward points to refresh " + uf.getName() + " Reward Points: " + rpCost + "rp", Username, true);
                return;
            }
            player.addReward(-rpCost);
            uf.setTicksUntilRefresh(0);
            CampaignMain.cm.toUser("You've refreshed " + uf.getName() + " on planet " + p.getName() + " for " + rpCost + "rp.", Username, true);
            CampaignMain.cm.doSendHouseMail(player.getMyHouse(), "NOTE", player.getName() + " has refreshed " + uf.getName() + " on planet " + p.getName());
        }
        catch (Exception ex) {
            CampaignMain.cm.toUser("Command failed. Try again.", Username, true);
            MMServ.mmlog.errLog(ex);
        }
    }
}

