/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.commands.Command;
import server.campaign.mercenaries.ContractInfo;

public class RefuseContractCommand
implements Command {
    int accessLevel = 0;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        boolean contractCancelled = false;
        String receivingPlayerName = "";
        boolean offeringPlayerFound = false;
        String offeringPlayerName = (String)command.nextElement();
        SPlayer offeringPlayer = CampaignMain.cm.getPlayer(offeringPlayerName);
        for (int i = 0; i < CampaignMain.cm.getUnresolvedContracts().size(); ++i) {
            ContractInfo info = (ContractInfo)CampaignMain.cm.getUnresolvedContracts().get(i);
            if (info.getOfferingPlayer() != offeringPlayer) continue;
            offeringPlayerFound = true;
            receivingPlayerName = info.getPlayerName();
            if (CampaignMain.cm.getPlayer(receivingPlayerName) != CampaignMain.cm.getPlayer(Username)) continue;
            CampaignMain.cm.getUnresolvedContracts().remove(i);
            contractCancelled = true;
            CampaignMain.cm.toUser("You refused the contract offered by " + offeringPlayerName, Username, true);
            CampaignMain.cm.toUser(Username + " refused your contract offer", offeringPlayerName, true);
        }
        if (!contractCancelled) {
            if (!offeringPlayerFound) {
                CampaignMain.cm.toUser("This player has no outstanding contracts", Username, true);
            } else {
                CampaignMain.cm.toUser("This player has not offered you a contract.", Username, true);
            }
        }
    }
}

