/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import common.util.UnitUtils;
import java.util.StringTokenizer;
import megamek.common.CriticalSlot;
import megamek.common.Entity;
import megamek.common.Mech;
import megamek.common.Mounted;
import server.MMServ;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.commands.Command;
import server.util.RepairTrackingThread;

public class RepairUnitCommand
implements Command {
    int accessLevel = 0;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        try {
            int unitID = Integer.parseInt(command.nextToken());
            int location = Integer.parseInt(command.nextToken());
            int slot = Integer.parseInt(command.nextToken());
            boolean armor = Boolean.valueOf(command.nextToken());
            SPlayer player = CampaignMain.cm.getPlayer(Username);
            SUnit unit = player.getUnit(unitID);
            Entity entity = unit.getEntity();
            String repairMessage = "";
            if (location == 4 && entity.getInternal(2) != entity.getOInternal(2) || location == 5 && entity.getInternal(3) != entity.getOInternal(3)) {
                CampaignMain.cm.toUser("You may not repair your " + entity.getShortNameRaw() + "'s " + entity.getLocationName(location) + " until the adjacent toro's internal armor is fully repaired.", Username, true);
                return;
            }
            if (armor) {
                int armorRepaired = 0;
                boolean rear = false;
                int realLocation = location;
                if (slot == 0) {
                    switch (location) {
                        case 8: {
                            realLocation = 1;
                            rear = true;
                            break;
                        }
                        case 10: {
                            realLocation = 3;
                            rear = true;
                            break;
                        }
                        case 9: {
                            realLocation = 2;
                            rear = true;
                            break;
                        }
                        default: {
                            rear = false;
                        }
                    }
                    armorRepaired = entity.getOArmor(realLocation, rear) - entity.getArmor(realLocation, rear);
                    if (armorRepaired == 0) {
                        if (rear) {
                            CampaignMain.cm.toUser("All external armor(" + entity.getLocationAbbr(location) + "r) has already been repaired.", Username, true);
                        } else {
                            CampaignMain.cm.toUser("All external armor(" + entity.getLocationAbbr(location) + ") has already been repaired.", Username, true);
                        }
                        return;
                    }
                    repairMessage = rear ? "Repairs have begun on the external armor(" + entity.getLocationAbbr(location) + "r) of your " + entity.getShortNameRaw() + "." : "Repairs have begun on the external armor(" + entity.getLocationAbbr(location) + ") of your " + entity.getShortNameRaw() + ".";
                } else {
                    armorRepaired = entity.getOInternal(location) - entity.getInternal(location);
                    if (armorRepaired == 0) {
                        CampaignMain.cm.toUser("All internal armor(" + entity.getLocationAbbr(location) + ") has already been repaired.", Username, true);
                        return;
                    }
                    repairMessage = "Repairs have begun on the internal armor(" + entity.getLocationAbbr(location) + ") of your " + entity.getShortNameRaw() + ".";
                }
            } else {
                if (entity.getInternal(location) != entity.getOInternal(location)) {
                    CampaignMain.cm.toUser("You may not make any repairs to the until the internal armor(" + entity.getLocationAbbr(location) + ") is fully repaired!", Username, true);
                    return;
                }
                CriticalSlot cs = entity.getCritical(location, slot);
                if (cs == null) {
                    CampaignMain.cm.toUser("There is no critical in that location please select another critical slot to repair!", Username, true);
                    return;
                }
                if (!cs.isDamaged() && !cs.isBreached()) {
                    CampaignMain.cm.toUser("That critical is not damaged.", Username, true);
                    return;
                }
                if (cs.getType() == 1) {
                    Mounted mounted = entity.getEquipment(cs.getIndex());
                    repairMessage = "Work has begun on The " + mounted.getName() + "(" + entity.getLocationAbbr(location) + ") for your " + entity.getShortNameRaw() + ".";
                } else if (UnitUtils.isEngineCrit(cs)) {
                    repairMessage = "Work on your " + entity.getShortNameRaw() + "'s engine has begun.";
                } else if (entity instanceof Mech) {
                    repairMessage = "Work has begun on the " + ((Mech)entity).getSystemName(cs.getIndex()) + "(" + entity.getLocationAbbr(location) + ") for your " + entity.getShortName() + ".";
                }
            }
            if (CampaignMain.cm.getRTT().isBeingRepaired(unitID, location, slot)) {
                CampaignMain.cm.toUser("That section is already being repaired wait for the work to finish before starting again.", Username, true);
                return;
            }
            CampaignMain.cm.getRTT().getRepairList().add(RepairTrackingThread.Repair(player, unitID, armor, location, slot));
            CampaignMain.cm.toUser(repairMessage, Username, true);
        }
        catch (Exception ex) {
            MMServ.mmlog.errLog("Unable to Process Repair Unit Command!");
            MMServ.mmlog.errLog(ex);
        }
    }
}

