/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.commands.Command;
import server.campaign.pilot.SPilot;
import server.campaign.util.UnitHistoryKeeper;

public class RequestDonatedCommand
implements Command {
    int accessLevel = 0;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int spaceTaken;
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlayer p = CampaignMain.cm.getPlayer(Username);
        SHouse ph = p.getMyHouse();
        int weightclass = 0;
        int type_id = 0;
        String result = "";
        String weightstring = command.nextToken().toUpperCase();
        try {
            weightclass = Integer.parseInt(weightstring);
        }
        catch (Exception ex) {
            weightclass = SUnit.getWeightIDForName(weightstring);
        }
        String typestring = command.nextToken();
        try {
            type_id = Integer.parseInt(typestring);
        }
        catch (Exception ex) {
            type_id = SUnit.getTypeIDForName(typestring);
        }
        if (p.getMyHouse().isNewbieHouse()) {
            result = "Players in the training faction may not purchase used/donated units; however, they may reset their units.";
            result = result + "<br><a href=\"MEKWARS/c request#resetunits\">Click here to request a reset of your units.</a>";
            CampaignMain.cm.toUser(result, Username, true);
            return;
        }
        if (p.mayAcquireWelfareUnits()) {
            SHouse house = p.getHouseFightingFor();
            SUnit unit = CampaignMain.cm.buildWelfareMek(house.getName());
            SPilot pilot = house.getNewPilot(unit.getType());
            unit.setPilot(pilot);
            p.addUnit(unit, true);
            CampaignMain.cm.toUser("High Command has given you a Mek from its welfare rolls to help you get back on your feet!", Username, true);
            return;
        }
        if (p.getExperience() < SHouse.getMinEXPForMechClass(weightclass)) {
            result = "You are not experienced enough to use " + SUnit.getWeightClassDesc(weightclass) + " units.";
            CampaignMain.cm.toUser(result, Username, true);
            return;
        }
        SUnit mech = ph.getEntity(weightclass, type_id);
        if (mech == null) {
            result = "There is no unit of the given weight class/type avaliable";
            CampaignMain.cm.toUser(result, Username, true);
            return;
        }
        if (p.hasUnmaintainedUnit()) {
            result = "Your faction refuses to assign additional units to you force while existing resources are not being properly maintained!";
            ph.addUnit(mech, false);
            CampaignMain.cm.toUser(result, Username, true);
            return;
        }
        int unitCbills = ph.getPriceForUnit(mech.getWeightclass(), mech.getType(), null) / 2;
        int unitInfluence = ph.getInfluenceForUnit(mech.getWeightclass(), mech.getType(), null) / 2;
        if (Boolean.valueOf(CampaignMain.cm.getConfig("UseCalculatedCosts")).booleanValue()) {
            unitCbills = (int)(ph.getHighestUnitCost(mech.getWeightclass(), mech.getType()) * Double.valueOf(CampaignMain.cm.getConfig("CostModifier"))) / 2;
        }
        if (unitCbills > p.getMoney()) {
            ph.addUnit(mech, false);
            CampaignMain.cm.toUser("You cannot afford to buy a " + SUnit.getWeightClassDesc(mech.getWeightclass()) + " " + SUnit.getTypeClassDesc(mech.getType()) + " right now " + CampaignMain.cm.moneyOrFluMessage(true, false, unitCbills) + " needed.", Username, true);
            return;
        }
        if (unitInfluence > p.getInfluence()) {
            ph.addUnit(mech, false);
            CampaignMain.cm.toUser("You do not have enough " + CampaignMain.cm.moneyOrFluMessage(false, false, -unitInfluence) + " to request a " + SUnit.getWeightClassDesc(mech.getWeightclass()) + " " + SUnit.getTypeClassDesc(mech.getType()) + ". " + CampaignMain.cm.moneyOrFluMessage(false, false, unitInfluence) + " needed.", Username, true);
            return;
        }
        if (Boolean.valueOf(CampaignMain.cm.getConfig("UseCalculatedCosts")).booleanValue()) {
            unitCbills = (int)(mech.getEntity().getCost() * Double.valueOf(CampaignMain.cm.getConfig("CostModifier"))) / 2;
        }
        if ((spaceTaken = CampaignMain.cm.getHangarSpaceRequired(type_id, weightclass, 0, "null")) > p.getFreeBays()) {
            int techCost = p.getTechHiringFee();
            int numTechs = spaceTaken - p.getFreeBays();
            int totalCost = unitCbills + (techCost *= numTechs);
            if (totalCost > p.getMoney()) {
                result = "Command will not assign the requested unit to your force unless support is in place; however, you cannot afford to buy the unit *and* hire technicians. Total cost would be " + CampaignMain.cm.moneyOrFluMessage(true, false, totalCost) + " and you only have " + p.getMoney() + ".";
                ph.addUnit(mech, false);
                CampaignMain.cm.toUser(result, Username, true);
                return;
            }
            result = "Quartermaster command will not release the requested unit to your force unless support resources are in place. You will need to hire " + numTechs + " more technicians (total tech cost: " + CampaignMain.cm.moneyOrFluMessage(true, true, techCost) + "). Combined cost of the requested unit and necessary " + "technicians is " + CampaignMain.cm.moneyOrFluMessage(true, true, totalCost) + " and " + CampaignMain.cm.moneyOrFluMessage(false, true, unitInfluence) + ".";
            result = result + "<br><a href=\"MEKWARS/c hireandrequestused#" + numTechs + "#" + SUnit.getWeightClassDesc(weightclass) + "#" + type_id + "\">Click here to hire the technicians and purchase the unit.</a>";
            ph.addUnit(mech, false);
            CampaignMain.cm.toUser(result, Username, true);
            return;
        }
        UnitHistoryKeeper.addBoughtFromBayEntry(mech.getId(), p.getName(), p.getMyHouse().getName());
        p.addUnit(mech, true);
        p.addMoney(-unitCbills);
        p.addInfluence(-unitInfluence);
        result = "You've been granted a " + mech.getModelName() + ". (-" + CampaignMain.cm.moneyOrFluMessage(true, false, unitCbills) + " / -" + CampaignMain.cm.moneyOrFluMessage(false, true, unitInfluence) + ") ";
        CampaignMain.cm.toUser(result, Username, true);
        CampaignMain.cm.toUser(p.getMyHouse().getAutoStatus(), p.getName(), false);
        CampaignMain.cm.doSendHouseMail(ph, "NOTE", p.getName() + " has bought a " + mech.getVerboseModelName() + " from the faction bay!");
    }
}

