/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.Enumeration;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SArmy;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.commands.Command;
import server.campaign.pilot.SPilot;

public class RetirePilotCommand
implements Command {
    int accessLevel = 0;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        if (command.hasMoreElements()) {
            SPlayer p = CampaignMain.cm.getPlayer(Username);
            int mechid = -1;
            try {
                mechid = Integer.parseInt((String)command.nextElement());
            }
            catch (Exception e) {
                CampaignMain.cm.toUser("Improper format. Try: /c retirepilot#UnitID", Username, true);
                return;
            }
            SUnit m = p.getUnit(mechid);
            if (m == null) {
                CampaignMain.cm.toUser("You do not have unit #" + mechid + ".", Username, true);
                return;
            }
            if (!new Boolean(CampaignMain.cm.getConfig("PilotRetirementAllowed")).booleanValue()) {
                CampaignMain.cm.toUser("Pilot retirement is not allowed.", Username, true);
                return;
            }
            if (p.getActivityStatus() != 2) {
                Enumeration<SArmy> f = p.getArmies().elements();
                while (f.hasMoreElements()) {
                    SArmy currArmy = f.nextElement();
                    if (currArmy.getUnit(m.getId()) == null) continue;
                    CampaignMain.cm.toUser("You may not dismiss/retire a pilot while his unit is part of an active army.", Username, true);
                    return;
                }
            }
            boolean commandConfirmed = false;
            if (command.hasMoreElements() && command.nextToken().equals("CONFIRM")) {
                commandConfirmed = true;
            }
            int totalSkill = m.getPilot().getGunnery() + m.getPilot().getPiloting();
            int skillForFree = Integer.parseInt(CampaignMain.cm.getConfig("TotalSkillForFreeRetirement"));
            int retirementCost = -1;
            if (totalSkill <= skillForFree) {
                if (!commandConfirmed) {
                    String toReturn = "<br>Are you sure you want to retire " + m.getPilot().getName() + "?<br><a href=\"MEKWARS/c retirepilot#" + mechid + "#CONFIRM\">Click here to confirm the retirment order.</a>";
                    CampaignMain.cm.toUser(toReturn, Username, true);
                    return;
                }
            } else {
                int numLevelsNeeded = totalSkill - skillForFree;
                int costPerLevelNeeded = Integer.parseInt(CampaignMain.cm.getConfig("CostPerLevelToRetireEarly"));
                retirementCost = costPerLevelNeeded * numLevelsNeeded;
                boolean earlyAllowed = new Boolean(CampaignMain.cm.getConfig("EarlyRetirementAllowed"));
                if (!earlyAllowed) {
                    String toReturn = m.getPilot().getName() + " may not retire yet. He needs to " + "level up " + numLevelsNeeded + " more time";
                    if (numLevelsNeeded > 1) {
                        toReturn = toReturn + "s";
                    }
                    toReturn = toReturn + " before he can call it quits.";
                    CampaignMain.cm.toUser(toReturn, Username, true);
                    return;
                }
                if (p.getMoney() < retirementCost) {
                    CampaignMain.cm.toUser("You don't have enough money to dismiss " + m.getPilot().getName() + ". Bribing HQ to reassign him would cost " + CampaignMain.cm.moneyOrFluMessage(true, true, retirementCost) + ".", Username, true);
                    return;
                }
                if (!commandConfirmed) {
                    String toReturn = "You can get " + m.getPilot().getName() + " transfered out of your unit, but you'll have " + "to bribe someone at HQ. Are you willing to spend " + CampaignMain.cm.moneyOrFluMessage(true, true, retirementCost) + " to make an \"accident\" happen?<br>" + "<a href=\"MEKWARS/c retirepilot#" + mechid + "#CONFIRM\">Click here to pay the " + CampaignMain.cm.moneyOrFluMessage(true, true, retirementCost) + ".</a>";
                    CampaignMain.cm.toUser(toReturn, Username, true);
                    return;
                }
            }
            String toReturn = "";
            toReturn = retirementCost <= 0 ? m.getPilot().getName() + " retired, went home to his family, and lived happily ever after." : "You dismissed " + m.getPilot().getName() + " (-" + CampaignMain.cm.moneyOrFluMessage(true, true, retirementCost) + ").";
            if (retirementCost > 0) {
                p.addMoney(-retirementCost);
            }
            CampaignMain.cm.toUser(toReturn, Username, true);
            boolean allowPPQs = new Boolean(CampaignMain.cm.getConfig("AllowPersonalPilotQueues"));
            if (allowPPQs && (m.getType() == 0 || m.getType() == 3)) {
                SPilot pilot = new SPilot("Vacant", 99, 99);
                m.setPilot(pilot, true);
            } else {
                SPilot p2 = p.getMyHouse().getNewPilot(m.getType());
                m.setPilot(p2, true);
                m.setExperience(new Integer(0));
            }
            p.getMyHouse().fireStatusEvent("Pilot retired", Username);
            CampaignMain.cm.toUser("PL|UU|" + m.getId() + "|" + m.toString(true), Username, false);
            Enumeration<SArmy> f = p.getArmies().elements();
            while (f.hasMoreElements()) {
                SArmy currArmy = f.nextElement();
                if (currArmy.getUnit(m.getId()) == null) continue;
                currArmy.setBV(0);
                CampaignMain.cm.toUser("PL|SAD|" + currArmy.toString(true, "%"), Username, false);
                CampaignMain.cm.getOpsManager().checkOperations(currArmy, true);
            }
        }
    }
}

