/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SArmy;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.commands.Command;
import server.campaign.util.UnitHistoryKeeper;

public class ScrapCommand
implements Command {
    int accessLevel = 0;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        int scrapsAllowed = Integer.parseInt(CampaignMain.cm.getConfig("ScrapsAllowed"));
        if (scrapsAllowed <= 0) {
            CampaignMain.cm.toUser("Scrapping is not allowed on this server.", Username, true);
            return;
        }
        SPlayer p = CampaignMain.cm.getPlayer(Username);
        if (p.getMyHouse().isNewbieHouse()) {
            CampaignMain.cm.toUser("SOL players may not Sell, Scrap or Donate their units!", Username, true);
            return;
        }
        if (p.mayAcquireWelfareUnits()) {
            CampaignMain.cm.toUser("You may not scrap any of your units while you are on welfare.", Username, true);
            return;
        }
        int mechid = -1;
        try {
            mechid = Integer.parseInt((String)command.nextElement());
        }
        catch (Exception e) {
            CampaignMain.cm.toUser("Formatting error. Try: /c scrap#ID Number", Username, true);
            return;
        }
        SUnit m = p.getUnit(mechid);
        if (m == null) {
            CampaignMain.cm.toUser("Could not find a unit with the given ID.", Username, true);
            return;
        }
        if (p.isUnitOnMarket(m)) {
            CampaignMain.cm.toUser("You may not scrap units which being sold on the Black Market.", Username, true);
            return;
        }
        if (p.getAmountOfTimesUnitExistsInArmies(mechid) > 0 && p.getActivityStatus() == 3) {
            CampaignMain.cm.toUser("You may not scrap units which are in active armies.", Username, true);
            return;
        }
        for (SArmy currA : p.getArmies()) {
            if (!currA.isLocked() || currA.getUnit(mechid) == null) continue;
            CampaignMain.cm.toUser("You may not scrap units which are in fighting armies.", Username, true);
            return;
        }
        if (p.getScrapsThisTick() >= scrapsAllowed && m.getScrappableFor() < 0) {
            CampaignMain.cm.toUser("You may only scrap " + scrapsAllowed + " units per tick.", Username, true);
            return;
        }
        int mechscrapprice = 0;
        if (new Boolean(CampaignMain.cm.getConfig("ScrappingCostsBills")).booleanValue() && m.getScrappableFor() < 0) {
            mechscrapprice = p.getMyHouse().getPriceForUnit(m.getWeightclass(), m.getType(), null) / 3;
            int infToScrap = p.getMyHouse().getInfluenceForUnit(m.getWeightclass(), m.getType(), null) / 3;
            if (p.getMoney() >= mechscrapprice && p.getInfluence() >= infToScrap) {
                p.addMoney(-mechscrapprice);
                p.addInfluence(-infToScrap);
            } else {
                CampaignMain.cm.toUser("You cannot afford to scrap this unit. You need " + CampaignMain.cm.moneyOrFluMessage(true, true, mechscrapprice) + " and " + CampaignMain.cm.moneyOrFluMessage(false, true, infToScrap) + ".", Username, true);
                return;
            }
        }
        CampaignMain.cm.doSendHouseMail(p.getMyHouse(), "NOTE", p.getName() + " has scrapped a " + m.getVerboseModelName() + "!");
        if (p.mayAcquireWelfareUnits()) {
            CampaignMain.cm.doSendModMail("NOTE", Username + " has used the Scrap Command and sent themself into welfare.");
        }
        if (m.getScrappableFor() < 0) {
            CampaignMain.cm.toUser("The " + m.getModelName() + " has been scrapped. You pay " + CampaignMain.cm.moneyOrFluMessage(true, true, mechscrapprice) + " for recycling.", Username, true);
            p.addScrapThisTick();
        } else {
            CampaignMain.cm.toUser("The " + m.getModelName() + " has been scrapped. You get " + CampaignMain.cm.moneyOrFluMessage(true, true, m.getScrappableFor()) + " for the parts.", Username, true);
            p.addMoney(m.getScrappableFor());
        }
        p.removeUnit(mechid, true);
        p.getMyHouse().addDispossessedPilot(m);
        UnitHistoryKeeper.addScrapEntry(m.getId(), p.getName(), p.getMyHouse().getName());
        CampaignMain.cm.addMechStat(m.getUnitFilename(), m.getWeightclass(), 0, 0, 1);
        int initialPP = p.getMyHouse().getPPCost(m.getWeightclass(), m.getType());
        p.getMyHouse().addPP(m.getWeightclass(), m.getType(), initialPP / 4);
    }
}

