/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.StringTokenizer;
import server.MMServ;
import server.campaign.CampaignMain;
import server.campaign.SArmy;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.commands.Command;
import server.campaign.market.MarketUnit;

public class SellCommand
implements Command {
    int accessLevel = 0;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlayer p = CampaignMain.cm.getPlayer(Username);
        if (p.getMyHouse().isNewbieHouse()) {
            CampaignMain.cm.toUser("SOL players may not Sell, Scrap or Donate their units!", Username, true);
            return;
        }
        if (p.mayAcquireWelfareUnits()) {
            CampaignMain.cm.toUser("You may not sell any of your units while you are on welfare.", Username, true);
            return;
        }
        int mechid = Integer.parseInt((String)command.nextElement());
        SUnit m = p.getUnit(mechid);
        if (m != null) {
            int sellFluCost = Integer.parseInt(CampaignMain.cm.getConfig("BMSellFlu"));
            sellFluCost += m.getWeightclass() * Integer.parseInt(CampaignMain.cm.getConfig("BMFluSizeCost"));
            if (p.getExperience() < Integer.parseInt(CampaignMain.cm.getConfig("MinEXPforBMSelling"))) {
                CampaignMain.cm.toUser("You are not allowed to sell mechs on the BM. You are too inexperienced to make contact, sorry", Username, true);
                return;
            }
            if (!p.getMyHouse().isMayUseBM()) {
                CampaignMain.cm.toUser("Your faction may not use the Black Market, sorry", Username, true);
                return;
            }
            if (m.getStatus() == 3) {
                CampaignMain.cm.toUser("You may not sell unmaintained mechs on the Black Market.", Username, true);
                return;
            }
            if (!m.mayBeSoldOnMarket()) {
                CampaignMain.cm.toUser("This unit may not be sold on the Black Market.", Username, true);
                return;
            }
            if (p.getInfluence() < sellFluCost) {
                CampaignMain.cm.toUser("You need " + CampaignMain.cm.moneyOrFluMessage(false, true, sellFluCost) + " to sell this unit.", Username, true);
                return;
            }
            if (p.getAmountOfTimesUnitExistsInArmies(mechid) > 0 && p.getActivityStatus() == 3) {
                CampaignMain.cm.toUser("You may not sell units which are in active armies.", Username, true);
                return;
            }
            for (SArmy currA : p.getArmies()) {
                if (!currA.isLocked() || currA.getUnit(mechid) == null) continue;
                CampaignMain.cm.toUser("You may not sell units which are in fighting armies.", Username, true);
                return;
            }
            int mintime = Integer.parseInt(CampaignMain.cm.getConfig("MinBMSalesTicks"));
            int minprice = Integer.parseInt(CampaignMain.cm.getConfig("MinBMSalesPrice"));
            int time = mintime;
            int minbid = minprice;
            String comment = "";
            if (command.hasMoreElements()) {
                time = Integer.parseInt((String)command.nextElement());
            }
            if (time < mintime) {
                CampaignMain.cm.toUser("Units must be offered for at least " + mintime + " ticks.", Username, true);
                return;
            }
            if (time > 100) {
                time = 100;
            }
            if (command.hasMoreElements()) {
                minbid = Integer.parseInt((String)command.nextElement());
            }
            if (minbid < minprice) {
                CampaignMain.cm.toUser("Units cannot be sold for less than " + CampaignMain.cm.moneyOrFluMessage(true, false, minprice) + ".", Username, true);
                return;
            }
            if (command.hasMoreElements()) {
                comment = (String)command.nextElement();
            }
            if (Boolean.valueOf(CampaignMain.cm.getConfig("DisableMarketComments")).booleanValue()) {
                comment = "";
            }
            p.addInfluence(-sellFluCost);
            MarketUnit mm = new MarketUnit(p, time, minbid, comment, m);
            CampaignMain.cm.toUser("The " + m.getModelName() + " has been added to the Black Market. (-" + sellFluCost + " influence.)", Username, true);
            CampaignMain.cm.doSendHouseMail(p.getMyHouse(), "NOTE", p.getName() + " has put a " + m.getVerboseModelName() + " on the Black Market!");
            CampaignMain.cm.toUser("PL|SBM|" + m.getId(), Username, false);
            MMServ.mmlog.bmLog(p.getName() + " is selling a " + m.getVerboseModelName() + " for " + minbid);
            CampaignMain.cm.getMarket().addUnit(mm);
            p.removeUnit(m.getId(), true);
            p.setSave(true);
        }
        if (p.mayAcquireWelfareUnits()) {
            CampaignMain.cm.doSendModMail("NOTE", Username + " has used the Sell Command and sent themself into welfare.");
        }
    }
}

