/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.Enumeration;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.commands.Command;
import server.campaign.util.PlayerOptionHelper;

public class SetPlayerOptionCommand
implements Command {
    int accessLevel = 0;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        String Option2 = command.nextToken();
        String setting = command.nextToken();
        if (!setting.equals("true") && !setting.equals("false")) {
            CampaignMain.cm.toUser("So far you may only use true or false as a setting!", Username, true);
            return;
        }
        String[] allowedOptions = new String[]{"friendly_fire", "push_off_board", "flamer_heat", "fire", "indirect_fire", "double_blind", "team_vision", "floating_crits", "engine_explosions", "maxtech_physical_BTH", "maxtech_physical_psr", "maxtech_round_damage", "maxtech_prone_fire", "maxtech_target_modifiers", "no_tac", "no_immobile_vehicles", "inf_move_last", "inf_move_multi", "blind_drop"};
        boolean found = false;
        for (int i = 0; i < allowedOptions.length; ++i) {
            if (!allowedOptions[i].equals(Option2)) continue;
            found = true;
        }
        if (!found) {
            String infostring = "You may not set that option! Allowed Options are:<br>";
            for (int i = 0; i < allowedOptions.length; ++i) {
                infostring = infostring + allowedOptions[i] + " - ";
            }
            CampaignMain.cm.toUser(infostring, Username, true);
            return;
        }
        SPlayer p = CampaignMain.cm.getPlayer(Username);
        PlayerOptionHelper POH = new PlayerOptionHelper();
        POH.setDescription(Option2);
        POH.setSetting(setting);
        p.getGameoptions().put(POH.getDescription(), POH);
        Enumeration e = p.getGameoptions().elements();
        while (e.hasMoreElements()) {
            POH = (PlayerOptionHelper)e.nextElement();
            if (!POH.getDescription().equals("FlamersDealHeat") || !POH.getSetting().equals("No")) continue;
            p.getGameoptions().remove(POH.getDescription());
        }
        CampaignMain.cm.toUser("Option: " + Option2 + " set. Value: " + setting, Username, true);
    }
}

