/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import megamek.common.AmmoType;
import megamek.common.Entity;
import megamek.common.Mounted;
import server.campaign.CampaignMain;
import server.campaign.SArmy;
import server.campaign.SHouse;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.commands.Command;

public class SetUnitAmmoCommand
implements Command {
    int accessLevel = 0;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int ammoCharge;
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlayer p = CampaignMain.cm.getPlayer(Username);
        int unitid = 0;
        int weaponType = 0;
        String ammoName = "";
        int weaponLocation = 0;
        int shots = 100;
        try {
            unitid = Integer.parseInt(command.nextToken());
        }
        catch (NumberFormatException ex) {
            CampaignMain.cm.toUser("SetUnitAmmo command failed. Check your input. It should be something like this: /c setUnitAmmo#unitid#weaponlocation#weaponType#ammoname#rounds", Username, true);
            return;
        }
        try {
            weaponLocation = Integer.parseInt(command.nextToken());
        }
        catch (Exception ex) {
            CampaignMain.cm.toUser("SetUnitAmmo Command failed. Check your input. It should be something like this: /c setUnitAmmo#unitid#weaponlocation#weaponType#ammoname#rounds", Username, true);
            return;
        }
        try {
            weaponType = Integer.parseInt(command.nextToken());
        }
        catch (Exception ex) {
            CampaignMain.cm.toUser("SetUnitAmmo Command failed. Check your input. It should be something like this: /c setUnitAmmo#unitid#weaponlocation#weaponType#ammoname#rounds", Username, true);
            return;
        }
        try {
            ammoName = command.nextToken();
        }
        catch (Exception ex) {
            CampaignMain.cm.toUser("SetUnitAmmo Command failed. Check your input. It should be something like this: /c setUnitAmmo#unitid#weaponlocation#weaponType#ammoname#rounds", Username, true);
            return;
        }
        try {
            shots = Integer.parseInt(command.nextToken());
        }
        catch (Exception ex) {
            CampaignMain.cm.toUser("SetUnitAmmo Command failed. Check your input. It should be something like this: /c setUnitAmmo#unitid#weaponlocation#weaponType#ammoname#rounds", Username, true);
            return;
        }
        SUnit unit = p.getUnit(unitid);
        SHouse faction = CampaignMain.cm.getHouseFromPartialString(p.getHouseName(), null);
        Entity en = unit.getEntity();
        Enumeration e = en.getAmmo();
        int location = 0;
        Mounted mWeapon = null;
        while (e.hasMoreElements()) {
            mWeapon = (Mounted)e.nextElement();
            if (location == weaponLocation) break;
            ++location;
        }
        AmmoType currAmmo = (AmmoType)mWeapon.getType();
        AmmoType at = unit.getEntityAmmo(weaponType, ammoName);
        if (currAmmo.getInternalName().equalsIgnoreCase(at.getInternalName()) && shots == mWeapon.getShotsLeft()) {
            return;
        }
        if (shots == 0) {
            mWeapon.changeAmmoType(at);
            mWeapon.setShotsLeft(0);
            unit.setEntity(en);
            unit.setBV(new Integer(unit.calcBV(true, false)));
            CampaignMain.cm.toUser("PL|UU|" + unit.getId() + "|" + unit.toString(true), Username, false);
            Vector<SArmy> armies = p.getArmies();
            Enumeration<SArmy> f = armies.elements();
            while (f.hasMoreElements()) {
                SArmy currArmy = f.nextElement();
                if (currArmy.getUnit(unit.getId()) == null) continue;
                currArmy.setBV(0);
                CampaignMain.cm.toUser("PL|SAD|" + currArmy.toString(true, "%"), Username, false);
            }
            CampaignMain.cm.toUser("Ammo dumped. BV Recalculated", Username, true);
            return;
        }
        String munitionType = Long.toString(at.getMunitionType());
        if (CampaignMain.cm.getData().getServerBannedAmmo().get(munitionType) != null || faction.getBannedAmmo().get(munitionType) != null) {
            CampaignMain.cm.toUser("<font color=green>Quartermaster command regretfully informs you that they are out of " + ammoName + " stock.</font>", Username, true);
            return;
        }
        String strConfirm = "";
        if (command.hasMoreTokens()) {
            strConfirm = command.nextToken();
        }
        if ((ammoCharge = Integer.parseInt(CampaignMain.cm.getConfig("AmmoCharge"))) > 0) {
            if (!strConfirm.equals("CONFIRM")) {
                String result = "Quartermaster command will charge you " + CampaignMain.cm.moneyOrFluMessage(true, false, Integer.parseInt(CampaignMain.cm.getConfig("AmmoCharge"))) + " to change the load out on #" + unit.getId() + " " + unit.getModelName() + "<br>from " + currAmmo.getDesc() + " to " + at.getDesc() + ".";
                result = result + "<br><a href=\"MEKWARS/c setunitammo#" + unitid + "#" + weaponLocation + "#" + weaponType + "#" + ammoName + "#" + at.getShots() + "#CONFIRM";
                result = result + "\">Click here to change the ammo.</a>";
                CampaignMain.cm.toUser(result, Username, true);
                return;
            }
            if (p.getMoney() < ammoCharge) {
                CampaignMain.cm.toUser("You do not have enough " + CampaignMain.cm.moneyOrFluMessage(true, false, -2) + " to change the ammo on this unit!", Username, true);
                return;
            }
            p.addMoney(-ammoCharge);
        }
        if (at.getMunitionType() == 0x20000000L && p.getAmountOfTimesUnitExistsInArmies(unit.getId()) > 0) {
            Vector<SArmy> v = p.getArmies();
            for (int i = 0; i < v.size(); ++i) {
                SArmy a = v.elementAt(i);
                if (a.getUnit(unit.getId()) == null) continue;
                a.calcBV();
                CampaignMain.cm.toUser("PL|SAD|" + a.toString(true, "%"), Username, false);
            }
        }
        mWeapon.changeAmmoType(at);
        unit.setEntity(en);
        CampaignMain.cm.toUser("PL|UU|" + unit.getId() + "|" + unit.toString(true), Username, false);
        CampaignMain.cm.toUser("Ammo set for " + unit.getModelName() + " (#" + unit.getId() + ").", Username, true);
    }
}

