/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.commands.Command;
import server.campaign.operations.ShortOperation;

public class TerminateCommand
implements Command {
    int accessLevel = 0;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        int opID = -1;
        ShortOperation so = null;
        SPlayer tp = CampaignMain.cm.getPlayer(Username);
        if (tp == null) {
            CampaignMain.cm.toUser("Null player. Report this immediately!", Username, true);
            return;
        }
        if (command.hasMoreTokens()) {
            try {
                opID = Integer.parseInt(command.nextToken());
                so = CampaignMain.cm.getOpsManager().getRunningOps().get(opID);
            }
            catch (Exception e) {
                CampaignMain.cm.toUser("Improper format. Try: /c terminate#attack number", Username, true);
                return;
            }
        } else {
            so = CampaignMain.cm.getOpsManager().getShortOpForPlayer(tp);
        }
        if (so == null) {
            CampaignMain.cm.toUser("Terminate failed. Attack #" + opID + " does not exist.", Username, true);
            return;
        }
        if (!so.getAllPlayerNames().contains(tp.getName().toLowerCase())) {
            CampaignMain.cm.toUser("Terminate failed. You must be a participant in order to terminate an Attack.", Username, true);
            return;
        }
        if (so.getStatus() == ShortOperation.STATUS_FINISHED || so.getStatus() == ShortOperation.STATUS_REPORTING) {
            CampaignMain.cm.toUser("Terminate failed. You may not terminate a completed game.", Username, true);
            return;
        }
        CampaignMain.cm.getOpsManager().terminateOperation(so, 0, tp);
    }
}

