/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import common.util.AorAn;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SArmy;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.commands.Command;
import server.campaign.util.UnitHistoryKeeper;

public class TransferUnitCommand
implements Command {
    int accessLevel = 0;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        String targetPlayer = (String)command.nextElement();
        int unitid = Integer.parseInt((String)command.nextElement());
        SPlayer targetplayer = CampaignMain.cm.getPlayer(targetPlayer);
        SPlayer player = CampaignMain.cm.getPlayer(Username);
        boolean usesTechs = Boolean.valueOf(CampaignMain.cm.getConfig("UseTechnicians"));
        if (player.getMyHouse().isNewbieHouse()) {
            CampaignMain.cm.toUser("Players in SOL may not transfer units.", Username, true);
            return;
        }
        SPlayer p = CampaignMain.cm.getPlayer(Username);
        if (p.mayAcquireWelfareUnits()) {
            CampaignMain.cm.toUser("You may not transfer any of your units while you are on welfare.", Username, true);
            return;
        }
        if (targetplayer != null && player != null) {
            int rnd;
            SUnit m = player.getUnit(unitid);
            if (m == null) {
                CampaignMain.cm.toUser("You do not own a Unit #" + unitid + ".", Username, true);
                return;
            }
            if (player.getAmountOfTimesUnitExistsInArmies(unitid) > 0 && player.getActivityStatus() >= 3) {
                CampaignMain.cm.toUser("You may not tranfer units which are in active armies.", Username, true);
                return;
            }
            for (SArmy currA : p.getArmies()) {
                if (currA.getUnit(unitid) == null || !currA.isLocked()) continue;
                CampaignMain.cm.toUser("You may not transfer units which are in fighting armies.", Username, true);
                return;
            }
            if (!targetplayer.getMyHouse().equals(player.getMyHouse()) && !targetplayer.getMyHouse().getHouseFightingFor(targetplayer).equals(player.getMyHouse())) {
                CampaignMain.cm.toUser(targetplayer.getName() + " is not in your faction. You cannot send him units.", Username, true);
                return;
            }
            if (!targetplayer.hasRoom(m) && !usesTechs) {
                CampaignMain.cm.toUser(targetplayer.getName() + " has no room for that unit.", Username, true);
                return;
            }
            if (!targetplayer.getMyHouse().isLoggedIn(targetplayer.getName())) {
                CampaignMain.cm.toUser(targetplayer.getName() + " is not logged in. You may only transfer to players who are online.", Username, true);
                return;
            }
            if (Boolean.valueOf(CampaignMain.cm.getConfig("IPCheck")).booleanValue() && CampaignMain.cm.getServer().getIP(player.getName()).toString().equals(CampaignMain.cm.getServer().getIP(targetplayer.getName()).toString())) {
                CampaignMain.cm.toUser(targetplayer.getName() + " has the same IP as you do. You can't send him units.", Username, true);
                return;
            }
            boolean senderPays = Boolean.valueOf(CampaignMain.cm.getConfig("SenderPaysOnTransfer"));
            boolean receiverPays = Boolean.valueOf(CampaignMain.cm.getConfig("ReceiverPaysOnTransfer"));
            double transferPayment = Double.parseDouble(CampaignMain.cm.getConfig("TransferPayment"));
            String modName = m.getModelName();
            if (senderPays) {
                int costToSender = (int)((double)player.getCurrentTechPayment() * transferPayment);
                if (targetplayer.getMoney() < costToSender + 1) {
                    CampaignMain.cm.toUser("You tried to send " + AorAn.check(modName, true) + modName + " to " + targetPlayer + ", but you " + "cannot afford the transfer payment (" + CampaignMain.cm.moneyOrFluMessage(true, true, costToSender) + ").", Username, true);
                    return;
                }
            }
            if (receiverPays) {
                int costToRecipient = (int)((double)targetplayer.getCurrentTechPayment() * transferPayment);
                if (targetplayer.getMoney() < costToRecipient + 1) {
                    CampaignMain.cm.toUser("You tried to send " + AorAn.check(modName, true) + modName + " to " + targetPlayer + ", but he " + "cannot afford the transfer payment. Transfer aborted.", Username, true);
                    CampaignMain.cm.toUser(Username + " tried to send you " + AorAn.check(modName, true) + modName + "; however, you cannot " + "afford the tech payment the transfer would trigger (" + CampaignMain.cm.moneyOrFluMessage(true, true, costToRecipient) + ").", targetPlayer, true);
                    return;
                }
            }
            boolean confirmedSend = false;
            if (command.hasMoreElements() && ((String)command.nextElement()).equals("CONFIRM")) {
                confirmedSend = true;
            }
            int scrapLevel = Integer.parseInt(CampaignMain.cm.getConfig("TransferScrapLevel"));
            if (m.getMaintainanceLevel() <= scrapLevel && !confirmedSend) {
                CampaignMain.cm.toUser("The unit you are trying to tranfer is not well maintained. Equipment which is already in a poor state of repair may be irreparably damaged in transit.<br> <a href=\"MEKWARS/c transferunit#" + targetplayer.getName() + "#" + unitid + "#CONFIRM\">Click here to send the unit anyway</a>", Username, true);
                return;
            }
            if (m.getMaintainanceLevel() <= scrapLevel && confirmedSend && (rnd = CampaignMain.cm.getR().nextInt(100) + 1) > m.getMaintainanceLevel()) {
                CampaignMain.cm.toUser("The " + modName + " didn't survive transit intact.", player.getName(), true);
                CampaignMain.cm.toUser(player.getName() + "tried to send you a " + modName + ", but it didn't survive the trip.", targetplayer.getName(), true);
                player.removeUnit(m.getId(), true);
                return;
            }
            CampaignMain.cm.toUser("The " + modName + " has been transferred to " + targetplayer.getName(), Username, true);
            CampaignMain.cm.toUser(player.getName() + " sends you a " + modName + ".", targetPlayer, true);
            player.removeUnit(m.getId(), true);
            targetplayer.addUnit(m, true);
            UnitHistoryKeeper.addSentEntry(m.getId(), player.getName(), player.getMyHouse().getName(), targetplayer.getName(), targetplayer.getMyHouse().getName());
            if (senderPays) {
                player.doPayTechnicians(transferPayment, 0);
            }
            if (receiverPays) {
                targetplayer.doPayTechnicians(transferPayment, 0);
            }
            if (p.mayAcquireWelfareUnits()) {
                CampaignMain.cm.doSendModMail("NOTE", Username + " has used the Transfer Unit Command and sent themself into welfare.");
            }
        }
    }
}

