/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.StringTokenizer;
import server.MMServ;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlayer;
import server.campaign.commands.Command;
import server.util.MMNetPasswd;

public class UnenrollCommand
implements Command {
    int accessLevel = 0;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        if (Username.startsWith("Nobody")) {
            CampaignMain.cm.toUser("Nobodies can't enroll, hence they can't unenroll. Nice try though.", Username, true);
            return;
        }
        SPlayer p = CampaignMain.cm.getPlayer(Username);
        if (p == null) {
            CampaignMain.cm.toUser("Couldn't find your player to unenroll. Contact an admin immediately.", Username, true);
            return;
        }
        String confirmString = command.nextToken();
        if (!confirmString.equalsIgnoreCase("confirm")) {
            CampaignMain.cm.toUser("You didn't confirm the Unenroll Command", Username, true);
            return;
        }
        if (CampaignMain.cm.getOpsManager().getShortOpForPlayer(p) != null || p.getMyHouse().isBusy(p.getName())) {
            CampaignMain.cm.toUser("You cannot unenroll while in a game.", Username, true);
            return;
        }
        if (p.getExperience() == 0) {
            CampaignMain.cm.toUser("You cannot unenroll with 0 XP. Ask an admin or mod to remove your account.", Username, true);
            return;
        }
        SHouse hisfaction = CampaignMain.cm.getHouseForPlayer(Username);
        if (hisfaction == null) {
            CampaignMain.cm.toUser("Couldn't find faction to unenroll. Contact an admin immediately.", Username, true);
            return;
        }
        hisfaction.removePlayer(Username, true);
        MMNetPasswd.removeRecord(Username);
        try {
            MMNetPasswd.save();
        }
        catch (Exception ex) {
            MMServ.mmlog.errLog(ex);
        }
        CampaignMain.cm.toUser("You've been unenrolled.", Username, true);
    }
}

