/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import java.util.StringTokenizer;
import java.util.Vector;
import server.MMServ;
import server.campaign.CampaignMain;
import server.campaign.commands.Command;

public class AddTraitCommand
implements Command {
    int accessLevel = 200;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        String faction = "common";
        String traitName = "none";
        String skillList = "";
        String confirmString = "";
        try {
            faction = command.nextToken();
            traitName = command.nextToken();
            skillList = command.nextToken();
            confirmString = command.nextToken();
        }
        catch (Exception ex) {
            MMServ.mmlog.errLog(ex);
        }
        if (!confirmString.equals("CONFIRM")) {
            return;
        }
        Vector<String> traits = CampaignMain.cm.getFactionTraits(faction.toLowerCase());
        for (int pos = 0; pos < traits.size(); ++pos) {
            StringTokenizer traitToken = new StringTokenizer(traits.elementAt(pos), "*");
            if (!traitName.equalsIgnoreCase(traitToken.nextToken())) continue;
            traits.removeElementAt(pos);
            traits.add(traitName + "*" + skillList);
            CampaignMain.cm.toUser("Trait " + traitName + " has been added with skills " + skillList + ".", Username, true);
            CampaignMain.cm.doSendModMail("NOTE", Username + " has added trait " + traitName + " with skills " + skillList + ".");
            CampaignMain.cm.saveFactionTraits(faction, traits);
            return;
        }
        traits.add(traitName + "*" + skillList);
        CampaignMain.cm.saveFactionTraits(faction, traits);
        CampaignMain.cm.toUser("Trait " + traitName + " has been added with skills " + skillList + ".", Username, true);
        CampaignMain.cm.doSendModMail("NOTE", Username + " has added trait " + traitName + " with skills " + skillList + ".");
    }
}

