/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import java.util.HashMap;
import java.util.StringTokenizer;
import server.MMServ;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlanet;
import server.campaign.commands.Command;

public class AdminChangePlanetOwnerCommand
implements Command {
    int accessLevel = 200;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlanet p = null;
        SHouse h = null;
        try {
            p = CampaignMain.cm.getPlanetFromPartialString(command.nextToken(), Username);
            h = CampaignMain.cm.getHouseFromPartialString(command.nextToken(), Username);
        }
        catch (Exception e) {
            CampaignMain.cm.toUser("Improper command. Try: /c adminchangeplanetowner#planet#newfaction", Username, true);
            return;
        }
        if (p == null) {
            CampaignMain.cm.toUser("Could not find a matching planet.", Username, true);
            return;
        }
        if (h == null) {
            CampaignMain.cm.toUser("Could not find a matching faction.", Username, true);
            return;
        }
        p.setOwner(h);
        HashMap<Integer, Integer> flu = new HashMap<Integer, Integer>();
        flu.put(h.getId(), 100);
        p.getInfluence().setInfluence(flu);
        MMServ.mmlog.modLog(Username + " has given ownership of " + p.getName() + " to " + h.getName() + ".");
        CampaignMain.cm.toUser(h.getName() + " has been given ownership of " + p.getName() + ".", Username, true);
        CampaignMain.cm.doSendModMail("NOTE", Username + " has given ownership of " + p.getName() + " to " + h.getName() + ".");
    }
}

