/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import common.UnitFactories;
import java.util.Hashtable;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlanet;
import server.campaign.SPlayer;
import server.campaign.SUnitFactory;
import server.campaign.commands.Command;
import server.campaign.util.TimeZoneData;

public class AdminCreateFactoryCommand
implements Command {
    int accessLevel = 200;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlanet planet = CampaignMain.cm.getPlanetFromPartialString(command.nextToken(), Username);
        String name = command.nextToken();
        String size = command.nextToken();
        String faction = command.nextToken();
        int type = Integer.parseInt(command.nextToken());
        Hashtable<String, TimeZoneData> tz = new Hashtable<String, TimeZoneData>();
        while (command.hasMoreElements()) {
            String tzname = command.nextToken();
            int tzprop = Integer.parseInt(command.nextToken());
            TimeZoneData TZData = new TimeZoneData(tzname, tzprop);
            tz.put(TZData.getName(), TZData);
        }
        SUnitFactory fac = new SUnitFactory(name, planet, size, faction, tz, 0, 100, type);
        UnitFactories uf = planet.getUnitFactories();
        uf.add(fac);
        fac.setPlanet(planet);
        if (planet.getOwner() != null) {
            planet.getOwner().removePlanet(planet);
            planet.getOwner().addPlanet(planet);
        }
        CampaignMain.cm.toUser("Factory created!", Username, true);
        SPlayer p = CampaignMain.cm.getPlayer(Username);
        p.getMyHouse().fireStatusEvent("AdminCreateFactory called", Username);
        CampaignMain.cm.doSendModMail("NOTE", Username + " has created factory " + fac.getName() + " on planet " + planet.getName());
    }
}

