/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import common.AdvanceTerrain;
import common.Continent;
import java.util.StringTokenizer;
import server.MMServ;
import server.campaign.CampaignMain;
import server.campaign.SPlanet;
import server.campaign.commands.Command;

public class AdminCreateTerrainCommand
implements Command {
    int accessLevel = 200;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        try {
            SPlanet p = CampaignMain.cm.getPlanetFromPartialString(command.nextToken(), Username);
            String terraintype = command.nextToken();
            int chance = Integer.parseInt(command.nextToken());
            if (p == null) {
                CampaignMain.cm.toUser("Planet not found:", Username, true);
                return;
            }
            Continent cont = new Continent(chance, CampaignMain.cm.getData().getTerrainByName(terraintype));
            p.getEnvironments().add(cont);
            if (new Boolean(CampaignMain.cm.getConfig("UseStaticMaps")).booleanValue()) {
                AdvanceTerrain aTerrain = new AdvanceTerrain();
                p.getAdvanceTerrain().put(new Integer(cont.getEnvironment().getId()), aTerrain);
            }
            p.updated();
            MMServ.mmlog.modLog("Terrain has been added.");
            CampaignMain.cm.toUser("Terrain has been added.", Username, true);
            CampaignMain.cm.doSendModMail("NOTE", Username + " has added terrain to planet " + p.getName());
        }
        catch (Exception ex) {
            MMServ.mmlog.errLog(ex);
        }
    }
}

