/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import java.util.Enumeration;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlayer;
import server.campaign.commands.Command;

public class AdminLockCampaignCommand
implements Command {
    int accessLevel = 200;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        if (new Boolean(CampaignMain.cm.getConfig("CampaignLock")).booleanValue()) {
            CampaignMain.cm.toUser("Campaign is already locked.", Username, true);
            return;
        }
        for (SHouse sHouse : CampaignMain.cm.getData().getAllHouses()) {
            Enumeration f = sHouse.getActMembers().elements();
            while (f.hasMoreElements()) {
                SPlayer p = (SPlayer)f.nextElement();
                if (p.getActivityStatus() != 3) continue;
                p.setActive(false);
                CampaignMain.cm.toUser(Username + " has locked the campaign. You have been deactivated.", p.getName(), true);
                CampaignMain.cm.sendPlayerStatusUpdate(p, new Boolean(CampaignMain.cm.getConfig("HideActiveStatus")) == false);
            }
        }
        CampaignMain.cm.getConfig().setProperty("CampaignLock", "true");
        CampaignMain.cm.toAllUsers(Username + " locked the campaign!");
        CampaignMain.cm.toUser("You have locked the campaign. Players can no longer activate, and all active players were deactivated. Use 'adminunlockcampaign' to release the activity locks.", Username, true);
        CampaignMain.cm.doSendModMail("NOTE", Username + " has locked the campaign.");
    }
}

