/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import common.Unit;
import java.util.StringTokenizer;
import server.MMServ;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.commands.Command;

public class AdminSetHousePriceModCommand
implements Command {
    int accessLevel = 200;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int priceMod;
        int unitWeight;
        int unitType;
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        String HouseName = "";
        String typestring = "";
        String weightstring = "";
        String priceModString = "";
        try {
            HouseName = command.nextToken();
            typestring = command.nextToken();
            weightstring = command.nextToken();
            priceModString = command.nextToken();
        }
        catch (Exception e) {
            CampaignMain.cm.toUser("Improper command. Try: /c adminsetfactionpricemod#faction#type#weight#modifier", Username, true);
            return;
        }
        if (CampaignMain.cm.getHouseFromPartialString(HouseName, Username) == null) {
            return;
        }
        SHouse faction = CampaignMain.cm.getHouseFromPartialString(HouseName, Username);
        try {
            unitType = Integer.parseInt(typestring);
        }
        catch (Exception ex) {
            unitType = Unit.getTypeIDForName(typestring);
        }
        try {
            unitWeight = Integer.parseInt(weightstring);
        }
        catch (Exception ex) {
            unitWeight = Unit.getWeightIDForName(weightstring.toUpperCase());
        }
        try {
            priceMod = Integer.parseInt(priceModString);
        }
        catch (Exception ex) {
            CampaignMain.cm.toUser("Invalid price try using an integer!", Username, true);
            return;
        }
        if (unitType < 0 || unitType > 2) {
            CampaignMain.cm.toUser("Invalid unit type pick a number between 0 and 2 bub!", Username, true);
            return;
        }
        if (unitWeight < 0 || unitWeight > 3) {
            CampaignMain.cm.toUser("Invalid weight pick a number between 0 and 3 bub!", Username, true);
            return;
        }
        MMServ.mmlog.modLog(Username + " has changed the faction price mod for " + weightstring + " " + typestring + " for faction " + HouseName + " to " + priceModString);
        CampaignMain.cm.doSendModMail("NOTE", Username + " has changed the faction price mod for " + weightstring + " " + typestring + " for faction " + HouseName + " to " + priceModString);
        faction.setHouseUnitPriceMod(unitType, unitWeight, priceMod);
    }
}

