/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import java.util.StringTokenizer;
import server.MMServ;
import server.campaign.CampaignMain;
import server.campaign.SPlanet;
import server.campaign.commands.Command;

public class AdminSetPlanetVacuumCommand
implements Command {
    int accessLevel = 200;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        try {
            SPlanet p = (SPlanet)CampaignMain.cm.getData().getPlanetByName(command.nextToken());
            if (p == null) {
                CampaignMain.cm.toUser("Unknown planet!", Username, true);
                return;
            }
            boolean lock = command.hasMoreElements() ? new Boolean(command.nextToken()) : !p.isVacuum();
            p.setVacuum(lock);
            if (lock) {
                CampaignMain.cm.toUser("You've removed the atmosphere from planet " + p.getName(), Username, true);
                MMServ.mmlog.modLog(Username + " removed the atmosphere from planet " + p.getName());
                CampaignMain.cm.doSendModMail("NOTE", Username + " has removed the atmosphere from planet " + p.getName());
            } else {
                CampaignMain.cm.toUser("You've created an atmosphere on planet " + p.getName(), Username, true);
                MMServ.mmlog.modLog(Username + " has created an atmosphere on planet " + p.getName());
                CampaignMain.cm.doSendModMail("NOTE", Username + " has created an atmosphere on planet " + p.getName());
            }
            p.updated();
        }
        catch (Exception ex) {
            MMServ.mmlog.errLog(ex);
        }
    }
}

