/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.admin;

import java.util.StringTokenizer;
import server.MMServ;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlayer;
import server.campaign.commands.Command;
import server.campaign.util.PlayerDefectionEntry;
import server.campaign.util.PlayerDefectionEntryKeeper;

public class ForcedDefectCommand
implements Command {
    int accessLevel = 200;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        PlayerDefectionEntry entry;
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlayer p = null;
        SHouse oldHouse = null;
        SHouse h = null;
        try {
            p = CampaignMain.cm.getPlayer(command.nextToken());
            oldHouse = p.getMyHouse();
            h = CampaignMain.cm.getHouseFromPartialString(command.nextToken(), Username);
        }
        catch (Exception e) {
            CampaignMain.cm.toUser("Improper command. Try: /c forceddefect#player#faction", Username, true);
            return;
        }
        if (p == null) {
            CampaignMain.cm.toUser("Couldn't find a player with that name.", Username, true);
            return;
        }
        if (h == null) {
            CampaignMain.cm.toUser("Couldn't find a faction with that name.", Username, true);
            return;
        }
        p.getMyHouse().removePlayer(p.getName(), false);
        p.setMyHouse(h);
        h.addMember(p);
        CampaignMain.cm.getPlayer(p.getName());
        CampaignMain.cm.doLoginPlayer(p.getName());
        CampaignMain.cm.toUser("You've been forced to defect to House " + h.getName(), p.getName(), true);
        CampaignMain.cm.toUser("You forced " + p.getName() + " to defect to House " + h.getName(), Username, true);
        MMServ.mmlog.modLog(Username + " forced " + p.getName() + " to defect to " + h.getName());
        CampaignMain.cm.doSendModMail("NOTE", Username + " forced " + p.getName() + " to defect to " + h.getName());
        if (CampaignMain.cm.useHibernate() && (entry = PlayerDefectionEntry.getEntry(p.getName(), oldHouse.getName(), h.getName())) != null) {
            PlayerDefectionEntryKeeper.addPlayerDefectionEntry(entry);
        }
    }
}

