/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.mod;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.commands.Command;

public class ListMultiPlayerGroupsCommand
implements Command {
    int accessLevel = 100;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        String toSend = "List of Multiplayergroups:";
        Hashtable allPlayers = CampaignMain.cm.getAllPlayers();
        Hashtable<Integer, Vector> result = new Hashtable<Integer, Vector>();
        Enumeration<Object> e = allPlayers.elements();
        while (e.hasMoreElements()) {
            SPlayer p = (SPlayer)e.nextElement();
            if (p.getGroupAllowance() == 0) continue;
            Vector v = result.get(p.getGroupAllowance()) == null ? new Vector() : (Vector)result.get(p.getGroupAllowance());
            v.add(p);
            result.put(p.getGroupAllowance(), v);
        }
        e = result.keys();
        while (e.hasMoreElements()) {
            Integer GroupID = (Integer)e.nextElement();
            Vector members = (Vector)result.get(GroupID);
            toSend = toSend + "<br>Group #" + GroupID + ":";
            for (int i = 0; i < members.size(); ++i) {
                SPlayer p = (SPlayer)members.elementAt(i);
                toSend = toSend + p.getName() + " + ";
            }
        }
        CampaignMain.cm.toUser(toSend, Username, true);
    }
}

