/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.mod;

import java.util.StringTokenizer;
import server.MMServ;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.commands.Command;

public class ModDeactivateCommand
implements Command {
    int accessLevel = 100;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        String targetPlayerString = (String)command.nextElement();
        SPlayer targetPlayer = CampaignMain.cm.getPlayer(targetPlayerString);
        if (targetPlayer == null) {
            CampaignMain.cm.toUser(targetPlayerString + " cannot be found.", Username, true);
            return;
        }
        if (targetPlayer.getActivityStatus() == 4) {
            CampaignMain.cm.toUser(targetPlayerString + " is fighting. Cancel his game before deactivating.", Username, true);
            return;
        }
        if (targetPlayer.getActivityStatus() != 3) {
            CampaignMain.cm.toUser("Target player is logged out or is already in reserve state. Nice try though.", Username, true);
            return;
        }
        targetPlayer.setActive(false);
        CampaignMain.cm.toUser("You have been forcibly moved to reserve status by " + Username, targetPlayerString, true);
        CampaignMain.cm.toUser("You have forcibly moved " + targetPlayerString + " to reserve status.", Username, true);
        MMServ.mmlog.modLog(Username + " force-deactivated " + targetPlayerString);
        CampaignMain.cm.doSendModMail("NOTE", Username + " has force-deactivated " + targetPlayerString);
        CampaignMain.cm.sendPlayerStatusUpdate(targetPlayer, new Boolean(CampaignMain.cm.getConfig("HideActiveStatus")) == false);
    }
}

