/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.mod;

import java.util.Iterator;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.commands.Command;
import server.campaign.operations.ShortOperation;

public class ModGamesCommand
implements Command {
    int accessLevel = 100;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        boolean factionSort = false;
        String factionName = "";
        if (command.hasMoreElements()) {
            try {
                factionName = new String(command.nextToken()).toString();
                if (!factionName.equals("") && !factionName.startsWith(" ")) {
                    factionSort = true;
                }
            }
            catch (Exception ex) {
                CampaignMain.cm.toUser("ModGames command failed. Check your input. It should be:/c modgames (to get all games) or /c modgames#faction (for a filtered list)", Username, true);
                return;
            }
        }
        String result = "<h2>Games: </h2>";
        Iterator<ShortOperation> i = CampaignMain.cm.getOpsManager().getRunningOps().values().iterator();
        if (!factionSort) {
            while (i.hasNext()) {
                ShortOperation so = i.next();
                result = result + "<br>" + so.getInfo(true);
            }
        } else {
            while (i.hasNext()) {
                ShortOperation so = i.next();
                if (!so.hasPlayerWhoseHouseBeginsWith(factionName)) continue;
                result = result + "<br>" + so.getInfo(true);
            }
        }
        CampaignMain.cm.toUser("SM|" + result, Username, false);
        CampaignMain.cm.doSendModMail("NOTE", Username + " checked the running games.");
    }
}

