/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands.mod;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.commands.Command;
import server.campaign.operations.ShortOperation;

public class ModTerminateCommand
implements Command {
    int accessLevel = 100;

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel = CampaignMain.cm.getServer().getUserLevel(Username);
        if (userLevel < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        int opID = -1;
        try {
            opID = Integer.parseInt(command.nextToken());
        }
        catch (Exception e) {
            CampaignMain.cm.toUser("Improper format. Try: /c modterminate#game number", Username, true);
            return;
        }
        SPlayer tp = CampaignMain.cm.getPlayer(Username);
        if (tp == null) {
            CampaignMain.cm.toUser("Null player. Report this immediately!", Username, true);
            return;
        }
        ShortOperation so = CampaignMain.cm.getOpsManager().getRunningOps().get(opID);
        if (so == null) {
            CampaignMain.cm.toUser("Terminate failed. Attack #" + opID + " does not exist.", Username, true);
            return;
        }
        if (so.getStatus() == ShortOperation.STATUS_FINISHED) {
            CampaignMain.cm.toUser("Terminate failed. You may not terminate a completed game.", Username, true);
            return;
        }
        CampaignMain.cm.getOpsManager().terminateOperation(so, 0, tp);
    }
}

