/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.data;

import common.CampaignData;
import common.House;
import common.persistence.TreeReader;
import common.persistence.TreeWriter;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TimeUpdateHouse
extends House {
    private Date timestamp;

    public TimeUpdateHouse(int id) {
        super(id);
    }

    public TimeUpdateHouse() {
    }

    public Date getLastChanged() {
        return this.timestamp;
    }

    public void updated() {
        this.timestamp = new Date();
    }

    public void binOut(TreeWriter out) {
        super.binOut(out);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        out.write(sdf.format(this.getLastChanged()), "lastChanged");
    }

    public void binIn(TreeReader in, CampaignData data) throws IOException {
        super.binIn(in, data);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        try {
            this.timestamp = sdf.parse(in.readString("lastChanged"));
        }
        catch (ParseException e) {
            throw new IOException("corrupted date format");
        }
    }
}

