/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.data;

import common.CampaignData;
import common.Influences;
import common.Planet;
import common.persistence.TreeReader;
import common.persistence.TreeWriter;
import common.util.Position;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TimeUpdatePlanet
extends Planet {
    private Date timestamp;

    public TimeUpdatePlanet(int id, String name, Position position, Influences flu) {
        super(id, name, position, flu);
    }

    public Date getLastChanged() {
        return this.timestamp;
    }

    public void updated() {
        this.timestamp = new Date();
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public void binOut(TreeWriter out) {
        super.binOut(out);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        out.write(sdf.format(this.getLastChanged()), "lastChanged");
    }

    public void binIn(TreeReader in, CampaignData data) throws IOException {
        super.binIn(in, data);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        try {
            this.timestamp = sdf.parse(in.readString("lastChanged"));
        }
        catch (ParseException e) {
            throw new IOException("corrupted date format");
        }
    }
}

